/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiPageBreak;
import com.stimulsoft.report.components.interfaces.IStiPrintAtBottom;

public abstract class StiDynamicBand
extends StiBand
implements IStiPageBreak,
IStiBreakable,
IStiPrintAtBottom {
    private boolean printAtBottom;
    private boolean newPageBefore = false;
    private boolean newPageAfter = false;
    private boolean newColumnBefore = false;
    private boolean newColumnAfter = false;
    private boolean skipFirst = true;
    private float breakIfLessThan = 100.0f;

    public StiDynamicBand() {
        this(StiRectangle.empty());
    }

    public StiDynamicBand(StiRectangle rect) {
        super(rect);
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getPrintAtBottom() {
        return this.printAtBottom;
    }

    @Override
    public void setPrintAtBottom(boolean value) {
        if (this.printAtBottom != value) {
            this.CheckBlockedException("PrintAtBottom");
            this.printAtBottom = value;
        }
    }

    @Override
    public void setCanBreak(boolean value) {
        super.setCanBreak(value);
    }

    @Override
    public boolean Break(StiComponent dividedComponent, double devideFactor, StiRefObject<Double> divLine) {
        return false;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getNewPageBefore() {
        return this.newPageBefore;
    }

    @Override
    public void setNewPageBefore(boolean value) {
        this.newPageBefore = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getNewPageAfter() {
        return this.newPageAfter;
    }

    @Override
    public void setNewPageAfter(boolean value) {
        this.newPageAfter = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getNewColumnBefore() {
        return this.newColumnBefore;
    }

    @Override
    public void setNewColumnBefore(boolean value) {
        this.newColumnBefore = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getNewColumnAfter() {
        return this.newColumnAfter;
    }

    @Override
    public void setNewColumnAfter(boolean value) {
        this.newColumnAfter = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getSkipFirst() {
        return this.skipFirst;
    }

    @Override
    public void setSkipFirst(boolean value) {
        if (this.skipFirst != value) {
            this.CheckBlockedException("SkipFirst");
            this.skipFirst = value;
        }
    }

    @Override
    @StiDefaulValue(value="100.0")
    @StiSerializable
    public float getBreakIfLessThan() {
        return this.breakIfLessThan;
    }

    @Override
    public void setBreakIfLessThan(float value) {
        if (this.breakIfLessThan != value) {
            if (value < 0.0f || value > 100.0f) {
                throw new IndexOutOfBoundsException("BreakIfLessThan " + String.format("Value of '%1$s' is not valid for 'BreakIfLessThan'. 'BreakIfLessThan' should be between 0%% and 100%%.", Float.valueOf(value)));
            }
            if (value >= 0.0f && value <= 100.0f) {
                this.breakIfLessThan = value;
            }
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("PrintAtBottom", this.getPrintAtBottom());
        jObject.AddPropertyBool("NewPageBefore", this.getNewPageBefore());
        jObject.AddPropertyBool("NewPageAfter", this.getNewPageAfter());
        jObject.AddPropertyBool("NewColumnBefore", this.getNewColumnBefore());
        jObject.AddPropertyBool("NewColumnAfter", this.getNewColumnAfter());
        jObject.AddPropertyBool("SkipFirst", this.getSkipFirst(), true);
        jObject.AddPropertyFloat("BreakIfLessThan", (double)this.getBreakIfLessThan(), 100.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("PrintAtBottom")) {
                this.printAtBottom = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("NewPageBefore")) {
                this.newPageBefore = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("NewPageAfter")) {
                this.newPageAfter = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("NewColumnBefore")) {
                this.newColumnBefore = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("NewColumnAfter")) {
                this.newColumnAfter = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("SkipFirst")) {
                this.skipFirst = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("BreakIfLessThan")) continue;
            this.breakIfLessThan = property.floatValue().floatValue();
        }
    }
}

