/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.conditions;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.report.components.enums.StiFilterCondition;
import com.stimulsoft.report.components.enums.StiFilterDataType;
import com.stimulsoft.report.components.enums.StiFilterItem;
import com.stimulsoft.report.expressions.StiExpression;
import com.stimulsoft.report.expressions.StiFilterExpression;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;

public class StiFilter
implements IStiSerializable,
IStiSerializableToString,
Cloneable,
IStiJsonReportObject {
    public String column = "";
    private StiFilterCondition condition = StiFilterCondition.EqualTo;
    private StiFilterDataType dataType = StiFilterDataType.String;
    private StiExpression expression = new StiFilterExpression();
    private StiFilterItem item = StiFilterItem.Value;
    private String valueObj1 = "";
    private String valueObj2 = "";

    public StiFilter() {
    }

    public StiFilter(StiFilterItem item, String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, String expression) {
        this.item = item;
        this.column = column;
        this.condition = condition;
        this.valueObj1 = value1;
        this.valueObj2 = value2;
        this.dataType = dataType;
        this.expression.setValue(expression);
    }

    public StiFilter(String expression) {
        this.expression.setValue(expression);
        this.item = StiFilterItem.Expression;
    }

    public StiFilter(String column, StiFilterCondition condition, Date date1) {
        this(column, condition, StiFilter.convertData(date1), "", StiFilterDataType.DateTime);
    }

    public StiFilter(String column, StiFilterCondition condition, Date date1, Date date2) {
        this(column, condition, StiFilter.convertData(date1), StiFilter.convertData(date2), StiFilterDataType.DateTime);
    }

    public StiFilter(String column, StiFilterCondition condition, String value, StiFilterDataType dataType) {
        this(column, condition, value, "", dataType);
    }

    public StiFilter(String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType) {
        this(StiFilterItem.Value, column, condition, value1, value2, dataType, "");
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyEnum("Condition", (Enum)this.getCondition(), (Enum)StiFilterCondition.EqualTo);
        jObject.AddPropertyEnum("DataType", (Enum)this.getDataType(), (Enum)StiFilterDataType.String);
        jObject.AddPropertyStringNullOfEmpty("Column", this.getColumn());
        jObject.AddPropertyEnum("Item", (Enum)this.getItem(), (Enum)StiFilterItem.Value);
        jObject.AddPropertyStringNullOfEmpty("Value1", this.getValue1());
        jObject.AddPropertyStringNullOfEmpty("Value2", this.getValue2());
        jObject.AddPropertyJObject("Expression", this.getExpression().SaveToJsonObject(mode));
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Condition")) {
                this.condition = StiFilterCondition.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("DataType")) {
                this.dataType = StiFilterDataType.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("Column")) {
                this.column = property.Value.toString();
                continue;
            }
            if (property.Name.equals("Item")) {
                this.item = StiFilterItem.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("Value1")) {
                this.valueObj1 = property.Value.toString();
                continue;
            }
            if (property.Name.equals("Value2")) {
                this.valueObj2 = property.Value.toString();
                continue;
            }
            if (!property.Name.equals("Expression")) continue;
            this.expression.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public String getColumn() {
        return this.column;
    }

    public StiFilterCondition getCondition() {
        return this.condition;
    }

    public StiFilterDataType getDataType() {
        return this.dataType;
    }

    public StiExpression getExpression() {
        return this.expression;
    }

    public StiFilterItem getItem() {
        return this.item;
    }

    public String getValue1() {
        return this.valueObj1;
    }

    public String getValue2() {
        return this.valueObj2;
    }

    public void setColumn(String value) {
        this.column = value;
    }

    public void setCondition(StiFilterCondition value) {
        this.condition = value;
    }

    public void setDataType(StiFilterDataType value) {
        this.dataType = value;
    }

    public void setExpression(StiExpression value) {
        this.expression = value;
    }

    public void setItem(StiFilterItem value) {
        this.item = value;
    }

    public void setValue1(String value) {
        this.valueObj1 = value;
    }

    public void setValue2(String value) {
        this.valueObj2 = value;
    }

    private static String convertData(Date date) {
        DateFormat formatter = DateFormat.getDateTimeInstance();
        return formatter.format(date);
    }

    public String serialize() {
        String data;
        if (this.item == StiFilterItem.Expression) {
            data = StiXMLConvert.encodeName((String)this.expression.serialize());
        } else {
            String patter = "{0},{1},{2},{3},{4}";
            data = MessageFormat.format(patter, new Object[]{StiXMLConvert.encodeName((String)this.column), this.condition, StiXMLConvert.encodeName((String)this.valueObj1), StiXMLConvert.encodeName((String)this.valueObj2), this.dataType});
        }
        return data;
    }

    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        if (values.length == 1) {
            this.item = StiFilterItem.Expression;
            this.expression.deserializeStr(StiXMLConvert.decodeName((String)values[0]));
        } else {
            this.column = StiXMLConvert.decodeName((String)values[0]);
            this.condition = StiFilterCondition.valueOf(values[1]);
            this.valueObj1 = StiXMLConvert.decodeName((String)values[2]);
            this.valueObj2 = StiXMLConvert.decodeName((String)values[3]);
            this.dataType = StiFilterDataType.valueOf(values[4]);
        }
    }
}

