/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.indicators;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.report.components.enums.StiBrushType;
import com.stimulsoft.report.components.enums.StiDataBarDirection;
import com.stimulsoft.report.components.indicators.StiIndicator;
import com.stimulsoft.report.components.interfaces.IStiDataBarIndicator;

public class StiDataBarIndicator
extends StiIndicator
implements IStiDataBarIndicator {
    private StiBrushType brushType = StiBrushType.Gradient;
    private StiColor positiveColor = StiColorEnum.Green.color();
    private StiColor negativeColor = StiColorEnum.Red.color();
    private StiColor positiveBorderColor = StiColorEnum.DarkGreen.color();
    private StiColor negativeBorderColor = StiColorEnum.DarkRed.color();
    private boolean showBorder = false;
    private float value = 0.0f;
    private float minimum = 0.0f;
    private float maximum = 100.0f;
    private StiDataBarDirection direction = StiDataBarDirection.Default;

    @Override
    @StiSerializable
    public final StiBrushType getBrushType() {
        return this.brushType;
    }

    @Override
    public final void setBrushType(StiBrushType value) {
        this.brushType = value;
    }

    @Override
    @StiSerializable
    public final StiColor getPositiveColor() {
        return this.positiveColor;
    }

    @Override
    public final void setPositiveColor(StiColor value) {
        this.positiveColor = value;
    }

    @Override
    @StiSerializable
    public final StiColor getNegativeColor() {
        return this.negativeColor;
    }

    @Override
    public final void setNegativeColor(StiColor value) {
        this.negativeColor = value;
    }

    @Override
    @StiSerializable
    public final StiColor getPositiveBorderColor() {
        return this.positiveBorderColor;
    }

    @Override
    public final void setPositiveBorderColor(StiColor value) {
        this.positiveBorderColor = value;
    }

    @Override
    @StiSerializable
    public final StiColor getNegativeBorderColor() {
        return this.negativeBorderColor;
    }

    @Override
    public final void setNegativeBorderColor(StiColor value) {
        this.negativeBorderColor = value;
    }

    @Override
    @StiSerializable
    public final boolean getShowBorder() {
        return this.showBorder;
    }

    @Override
    public final void setShowBorder(boolean value) {
        this.showBorder = value;
    }

    @StiSerializable
    public final float getValue() {
        return this.value;
    }

    public final void setValue(float value) {
        this.value = value;
    }

    @StiSerializable
    public final float getMinimum() {
        return this.minimum;
    }

    public final void setMinimum(float value) {
        this.minimum = value;
    }

    @StiSerializable
    public final float getMaximum() {
        return this.maximum;
    }

    public final void setMaximum(float value) {
        this.maximum = value;
    }

    @Override
    @StiSerializable
    public final StiDataBarDirection getDirection() {
        return this.direction;
    }

    @Override
    public final void setDirection(StiDataBarDirection value) {
        this.direction = value;
    }

    public StiDataBarIndicator() {
    }

    public StiDataBarIndicator(StiBrushType brushType, StiColor positiveColor, StiColor negativeColor, boolean showBorder, StiColor positiveBorderColor, StiColor negativeBorderColor, StiDataBarDirection direction, float value, float minimum, float maximum) {
        this.brushType = brushType;
        this.positiveColor = positiveColor;
        this.negativeColor = negativeColor;
        this.showBorder = showBorder;
        this.positiveBorderColor = positiveBorderColor;
        this.negativeBorderColor = negativeBorderColor;
        this.direction = direction;
        this.value = value;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public void deserialize(String strObject) {
        this.deserializeString(strObject);
    }

    @Override
    public String serialize() {
        String data = StiSerializerUtil.serializFormat((String)"DataBar,{0},{1},{2},{3},{4},{5},{6},{7},{8},{9}", (Object[])new Object[]{StiXMLConvert.encodeName((Enum)this.brushType), this.positiveColor.serializeString(), this.negativeColor.serializeString(), this.showBorder, this.positiveBorderColor.serializeString(), this.negativeBorderColor.serializeString(), StiXMLConvert.encodeName((Enum)this.direction), Float.valueOf(this.value), Float.valueOf(this.minimum), Float.valueOf(this.maximum)});
        return data;
    }

    public StiDataBarIndicator deserializeString(String stringValue) {
        String[] values = stringValue.split(",");
        this.brushType = StiBrushType.valueOf(StiXMLConvert.decodeName((String)values[1]));
        this.positiveColor = StiColor.deserializeString((String)values[2]);
        this.negativeColor = StiColor.deserializeString((String)values[3]);
        this.showBorder = StiSerializTypeConverter.stringToBoolean((String)values[4]);
        this.positiveBorderColor = StiColor.deserializeString((String)values[5]);
        this.negativeBorderColor = StiColor.deserializeString((String)values[6]);
        this.direction = StiDataBarDirection.valueOf(StiXMLConvert.decodeName((String)values[7]));
        this.value = StiSerializTypeConverter.stringToFloat((String)values[8]);
        this.minimum = StiSerializTypeConverter.stringToFloat((String)values[9]);
        this.maximum = StiSerializTypeConverter.stringToFloat((String)values[10]);
        return this;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("BrushType", (Enum)this.getBrushType(), (Enum)StiBrushType.Gradient);
        jObject.AddPropertyStringNullOfEmpty("PositiveColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getPositiveColor(), (StiColorEnum)StiColorEnum.Green));
        jObject.AddPropertyStringNullOfEmpty("NegativeColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getNegativeColor(), (StiColorEnum)StiColorEnum.Red));
        jObject.AddPropertyStringNullOfEmpty("PositiveBorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getPositiveBorderColor(), (StiColorEnum)StiColorEnum.DarkGreen));
        jObject.AddPropertyStringNullOfEmpty("NegativeBorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getNegativeBorderColor(), (StiColorEnum)StiColorEnum.DarkRed));
        jObject.AddPropertyBool("ShowBorder", this.getShowBorder());
        jObject.AddPropertyFloat("Value", (double)this.getValue(), 0.0);
        jObject.AddPropertyFloat("Minimum", (double)this.getMinimum(), 0.0);
        jObject.AddPropertyFloat("Maximum", (double)this.getMaximum(), 100.0);
        jObject.AddPropertyEnum("Direction", (Enum)this.getDirection(), (Enum)StiDataBarDirection.Default);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("BrushType")) {
                this.brushType = StiBrushType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("PositiveColor")) {
                this.positiveColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("NegativeColor")) {
                this.negativeColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("PositiveBorderColor")) {
                this.positiveBorderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("NegativeBorderColor")) {
                this.negativeBorderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("ShowBorder")) {
                this.showBorder = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Value")) {
                this.value = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Minimum")) {
                this.minimum = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Maximum")) {
                this.maximum = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Direction")) continue;
            this.direction = StiDataBarDirection.valueOf((String)property.Value);
        }
    }
}

