/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.shapeTypes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.components.shapeTypes.StiShapeTypeService;

public class StiRoundedRectangleShapeType
extends StiShapeTypeService {
    private float round = 0.2f;

    public String getServiceName() {
        return StiLocalization.Get((String)"Shapes", (String)"RoundedRectangle");
    }

    @StiSerializable
    public float getRound() {
        return this.round;
    }

    public void setRound(float value) {
        if (value > 0.0f && (double)value <= 0.5) {
            this.round = value;
        }
    }

    public StiRoundedRectangleShapeType() {
        this(0.2f);
    }

    public StiRoundedRectangleShapeType(float round) {
        this.round = round;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Round", (double)this.getRound(), (double)0.2f);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (!property.Name.equals("Round")) continue;
            this.round = property.floatValue().floatValue();
        }
    }
}

