/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiHideBorderFromDesigner;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiEndPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiStartPointPrimitive;
import com.stimulsoft.report.units.StiUnit;

public class StiRectanglePrimitive
extends StiCrossLinePrimitive
implements IStiHideBorderFromDesigner,
IStiBorder {
    private StiBorder border;
    private boolean topSide = true;
    private boolean leftSide = true;
    private boolean bottomSide = true;
    private boolean rightSide = true;

    public StiRectanglePrimitive() {
        this(StiRectangle.empty());
    }

    public StiRectanglePrimitive(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    @Override
    @StiSerializable(need=false)
    public final StiBorder getBorder() {
        if (this.border == null) {
            this.border = new StiBorder(StiBorderSides.All, this.getColor(), this.getSize(), this.getStyle(), false, 0.0, null);
        }
        return this.border;
    }

    @Override
    public final void setBorder(StiBorder value) {
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.RectanglePrimitive.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.get((String)"Components", (String)"StiRectanglePrimitive");
    }

    @Override
    public double getWidth() {
        StiStartPointPrimitive startPoint = this.getStartPoint();
        StiEndPointPrimitive endPoint = this.getEndPoint();
        if (startPoint == null || endPoint == null) {
            return super.getWidth();
        }
        StiPoint startPos = new StiPoint(startPoint.getLeft(), startPoint.getTop());
        StiPoint endPos = new StiPoint(endPoint.getLeft(), endPoint.getTop());
        startPos = startPoint.ComponentToPage(startPos);
        endPos = endPoint.ComponentToPage(endPos);
        return (double)Math.round((endPos.getX() - startPos.getX()) * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    @Override
    public void setWidth(double value) {
        super.setWidth(value);
        StiStartPointPrimitive startPoint = this.getStartPoint();
        StiEndPointPrimitive endPoint = this.getEndPoint();
        if (startPoint != null && endPoint != null) {
            StiPoint startPos = new StiPoint(startPoint.getLeft(), startPoint.getTop());
            startPos = startPoint.ComponentToPage(startPos);
            StiPoint endPos = new StiPoint(startPos.getX() + value, startPos.getY().doubleValue());
            endPos = endPoint.PageToComponent(endPos);
            endPoint.setLeft(endPos.getX());
        }
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public boolean getTopSide() {
        return this.topSide;
    }

    public void setTopSide(boolean value) {
        this.topSide = value;
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public boolean getLeftSide() {
        return this.leftSide;
    }

    public void setLeftSide(boolean value) {
        this.leftSide = value;
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public boolean getBottomSide() {
        return this.bottomSide;
    }

    public void setBottomSide(boolean value) {
        this.bottomSide = value;
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public boolean getRightSide() {
        return this.rightSide;
    }

    public void setRightSide(boolean value) {
        this.rightSide = value;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("TopSide", this.getTopSide(), true);
        jObject.AddPropertyBool("LeftSide", this.getLeftSide(), true);
        jObject.AddPropertyBool("BottomSide", this.getBottomSide(), true);
        jObject.AddPropertyBool("RightSide", this.getRightSide(), true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("TopSide")) {
                this.topSide = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("LeftSide")) {
                this.leftSide = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("BottomSide")) {
                this.bottomSide = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("RightSide")) continue;
            this.rightSide = (Boolean)property.Value;
        }
    }
}

