/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiNullValuesHelper;
import com.stimulsoft.report.StiRuntimeVariables;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.conditions.StiCondition;
import com.stimulsoft.report.components.enums.StiProcessAt;
import com.stimulsoft.report.components.enums.StiProcessingDuplicatesType;
import com.stimulsoft.report.components.enums.StiSystemTextType;
import com.stimulsoft.report.components.interfaces.IStiEditable;
import com.stimulsoft.report.components.interfaces.IStiGlobalizedName;
import com.stimulsoft.report.components.interfaces.IStiOnlyText;
import com.stimulsoft.report.components.interfaces.IStiProcessAt;
import com.stimulsoft.report.components.interfaces.IStiProcessAtEnd;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiTextInCells;
import com.stimulsoft.report.crossTab.StiCrossCell;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.StiParserParameters;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.events.StiEventsCollection;
import com.stimulsoft.report.events.StiGetValueEvent;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.expressions.StiExpression;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;

public abstract class StiSimpleText
extends StiComponent
implements IStiGlobalizedName,
IStiText,
IStiEditable,
IStiProcessAtEnd,
IStiProcessAt,
IStiOnlyText {
    static Logger LOG = Logger.getLogger("com.stimulsoft.report.components.simplecomponents.StiSimpleText");
    protected static Object PropertyGlobalizedName = new Object();
    private StiPenStyle linesOfUnderline = StiPenStyle.None;
    private boolean hideZeros = false;
    protected static Object PropertyProcessingDuplicates = new Object();
    protected static Object PropertyOnlyText = new Object();
    protected static Object PropertyMaxNumberOfLines = new Object();
    private boolean editable = false;
    protected static Object PropertyProcessAt = new Object();
    public StiExpression text = new StiExpression();
    private String textValue;
    private static final Object EventGetValue = new Object();
    private static final Object EventTextProcess = new Object();
    public String totalValueHelp = null;

    public final void InvokeTextProcess(StiComponent sender, StiValueEventArgs e) {
        Object obj;
        if (this.getReport() != null && this.getReport().getEngine() != null && (obj = this.getReport().getEngine().getParserConversionStore().get("*StiConditionExpression*" + this.getName())) != null) {
            this.getReport().getEngine().lastInvokeTextProcessValueEventArgsValue = e.getValue();
            this.applyConditionsAssignExpression(sender, (List)(obj instanceof List ? obj : null));
            if (this instanceof StiCrossCell) {
                this.applyConditions(sender, (ArrayList)(obj instanceof ArrayList ? obj : null));
            }
        }
    }

    private void applyConditionsAssignExpression(Object sender, List<Hashtable<StiCondition, String>> conditions) {
        if (conditions == null) {
            return;
        }
        for (Hashtable<StiCondition, String> de : conditions) {
            Object result;
            StiCondition condition = de.keys().nextElement();
            if (!condition.getCanAssignExpression() || condition.getAssignExpression() == null || condition.getAssignExpression().trim().length() <= 0 || !((result = StiParser.ParseTextValue(de.get(condition), this)) instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            Object result2 = StiParser.ParseTextValue("{" + condition.getAssignExpression() + "}", this);
            ((StiText)sender).setTextValue(this.getReport().ToString(result2));
        }
    }

    public final void setComponentGuid(String value) {
        this.totalValueHelp = value;
    }

    public StiSimpleText() {
        this(StiRectangle.empty(), "");
    }

    public StiSimpleText(StiRectangle rect) {
        this(rect, "");
    }

    public StiSimpleText(StiRectangle rect, String text) {
        super(rect);
        this.SetTextInternal(text);
        this.setPlaceOnToolbox(false);
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public String getGlobalizedName() {
        Object tempVar = this.properties().get(PropertyGlobalizedName, (Object)"");
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public void setGlobalizedName(String value) {
        this.properties().set(PropertyGlobalizedName, (Object)value, (Object)"");
    }

    @Override
    public void saveState(String stateName) {
        super.saveState(stateName);
        super.getStates().Push(stateName, this, "textValue", this.textValue);
    }

    @Override
    public void RestoreState(String stateName) {
        if (this.getStates().IsExist(stateName, this)) {
            this.textValue = (String)super.getStates().Pop(stateName, this, "textValue");
        }
        super.RestoreState(stateName);
    }

    @Override
    public Object clone() {
        StiSimpleText textBox = (StiSimpleText)super.clone();
        textBox.text = this.text != null ? (StiExpression)this.text.clone() : null;
        return textBox;
    }

    public final String GetTextWithoutZero(String text) {
        if (!this.getHideZeros()) {
            return text;
        }
        Double dVal = null;
        try {
            dVal = Double.parseDouble(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dVal != null && dVal == 0.0) {
            if (this.canShrink) {
                return "";
            }
            return " ";
        }
        return text;
    }

    @Override
    @StiSerializable(shortName="lu")
    @StiDefaulValue(value="None")
    public StiPenStyle getLinesOfUnderline() {
        return this.linesOfUnderline;
    }

    @Override
    public void setLinesOfUnderline(StiPenStyle value) {
        this.linesOfUnderline = value;
    }

    public boolean getLinesOfUnderlining() {
        return this.getLinesOfUnderline() != StiPenStyle.None;
    }

    public void setLinesOfUnderlining(boolean value) {
        if (value) {
            this.setLinesOfUnderline(StiPenStyle.Solid);
        } else {
            this.setLinesOfUnderline(StiPenStyle.None);
        }
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getHideZeros() {
        return this.hideZeros;
    }

    @Override
    public void setHideZeros(boolean value) {
        this.hideZeros = value;
    }

    @Override
    @StiDefaulValue(value="None")
    @StiSerializable
    public StiProcessingDuplicatesType getProcessingDuplicates() {
        return (StiProcessingDuplicatesType)((Object)this.properties().get(PropertyProcessingDuplicates, (Object)StiProcessingDuplicatesType.None));
    }

    @Override
    public void setProcessingDuplicates(StiProcessingDuplicatesType value) {
        this.properties().set(PropertyProcessingDuplicates, (Object)value, (Object)StiProcessingDuplicatesType.None);
    }

    @Override
    @StiDefaulValue(value="0")
    @StiSerializable
    public int getMaxNumberOfLines() {
        return this.properties().getInt(PropertyMaxNumberOfLines, 0);
    }

    @Override
    public void setMaxNumberOfLines(int value) {
        this.properties().setInt(PropertyMaxNumberOfLines, value, 0);
    }

    public String ProcessText(String text) {
        return text;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getOnlyText() {
        return this.properties().getBool(PropertyOnlyText, false);
    }

    @Override
    public void setOnlyText(boolean value) {
        this.properties().setBool(PropertyOnlyText, value, false);
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable(shortName="ed")
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
    }

    private String saveState() {
        return this.getTextInternal();
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getProcessAtEnd() {
        return this.getProcessAt() == StiProcessAt.EndOfReport;
    }

    @Override
    public void setProcessAtEnd(boolean value) {
        if (value) {
            this.setProcessAt(StiProcessAt.EndOfReport);
        } else {
            this.setProcessAt(StiProcessAt.None);
        }
    }

    @Override
    @StiDefaulValue(value="None")
    @StiSerializable
    public StiProcessAt getProcessAt() {
        return (StiProcessAt)((Object)this.properties().get(PropertyProcessAt, (Object)StiProcessAt.None));
    }

    @Override
    public void setProcessAt(StiProcessAt value) {
        this.properties().set(PropertyProcessAt, (Object)value, (Object)StiProcessAt.None);
    }

    public void InvokeRenderTo(StiSimpleText textBox) {
    }

    private String GetFields() {
        if (this.getText() == null || this.getTextInternal() == null) {
            return "";
        }
        int startIndex = this.getTextInternal().lastIndexOf(46);
        if (startIndex == -1) {
            return "";
        }
        int endIndex = this.getTextInternal().lastIndexOf(125);
        if (endIndex == -1) {
            return "";
        }
        if (endIndex - startIndex - 1 < 1) {
            return "";
        }
        if (this.getTextInternal().length() <= startIndex + 1) {
            return "";
        }
        if (this.getTextInternal().length() <= endIndex - startIndex - 1) {
            return "";
        }
        if (startIndex + 1 < 0) {
            return "";
        }
        if (endIndex - startIndex - 1 < 0) {
            return "";
        }
        return this.getTextInternal().substring(startIndex + 1, startIndex + 1 + endIndex - startIndex - 1);
    }

    @Override
    public String getQuickInfo() {
        switch (this.getReport().getInfo().getQuickInfoType()) {
            case ShowAliases: {
                if (this.getAlias() != null && this.getAlias().length() > 0) {
                    return this.getAlias();
                }
                return this.getTextInternal();
            }
            case ShowFields: {
                String fields = this.GetFields();
                if (fields.length() == 0) {
                    return this.getText().getValue();
                }
                return fields;
            }
            case ShowFieldsOnly: {
                return this.GetFields();
            }
            case ShowContent: {
                return this.getTextInternal();
            }
        }
        return super.getQuickInfo();
    }

    @Override
    public StiEventsCollection getEvents() {
        StiEventsCollection events = super.getEvents();
        if (this.getGetValueEvent() != null) {
            events.add(this.getGetValueEvent());
        }
        return events;
    }

    @Override
    @StiSerializable(shortName="text")
    public StiExpression getText() {
        return this.text;
    }

    @Override
    public void setText(StiExpression value) {
        this.text = value;
        if (this.text != null) {
            this.text.ParentComponent = this;
        }
    }

    public void setText(String value) {
        this.text = new StiExpression(value);
        if (this.text != null) {
            this.text.ParentComponent = this;
        }
    }

    public void SetText(Object getValue, String value) {
        if (this.text != null) {
            String name = this.getName();
            ArrayList renderedComponents = (ArrayList)(this.getReport().getTotals().get(this.getName()) instanceof ArrayList ? this.getReport().getTotals().get(name) : null);
            if (renderedComponents != null && renderedComponents.size() > 0) {
                for (StiRuntimeVariables runtime : renderedComponents) {
                    int pageIndex = runtime.PageIndex;
                    if (this.getReport().getEngine() != null) {
                        this.getReport().getEngine().IndexPageForPageTotal = pageIndex - 1;
                    }
                    if (this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
                        --pageIndex;
                    }
                    if (this.getReport().getRenderedPages().getCacheMode() && pageIndex < this.getReport().getRenderedPages().size()) {
                        StiPage page = (StiPage)this.getReport().getRenderedPages().get(pageIndex);
                        this.getReport().getRenderedPages().GetPage(page);
                        if (this.getReport().getRenderedPages().IsNotSavedPage(page)) {
                            this.SetTextTo(runtime.TextBox, runtime, getValue, value);
                            continue;
                        }
                        StiComponentsCollection comps = page.GetComponents();
                        for (StiComponent comp : comps) {
                            StiSimpleText compText = (StiSimpleText)(comp instanceof StiSimpleText ? comp : null);
                            if (compText == null || comp.getName() != this.getName() || compText.getTotalValueHelp() != null) continue;
                            this.SetTextTo(comp, runtime, getValue, value);
                        }
                        if (this.getReport().getRenderedPages().IsNotSavedPage(page)) continue;
                        this.getReport().getRenderedPages().SavePage(page);
                        continue;
                    }
                    this.SetTextTo(runtime.TextBox, runtime, getValue, value);
                }
                renderedComponents.clear();
            } else if (value != null) {
                this.setText(value);
            }
        }
    }

    private void SetTextTo(StiComponent comp, StiRuntimeVariables runtime, Object getValue, String value) {
        IStiText textComp = (IStiText)((Object)(comp instanceof IStiText ? comp : null));
        if (textComp != null) {
            ((StiSimpleText)comp).setTotalValueHelp("1");
            int pageNumber = this.getReport().getPageNumber();
            StiRuntimeVariables storedVariables = new StiRuntimeVariables(this.getReport());
            runtime.SetVariables(this.getReport());
            String txt = "";
            String valueExcel = "-";
            boolean isCompilationMode = true;
            if (this.getReport() != null) {
                boolean bl = isCompilationMode = this.getReport().getCalculationMode() == StiCalculationMode.Compilation;
            }
            if (value != null) {
                this.setText(value);
            } else if (!isCompilationMode) {
                try {
                    StiText stiText = (StiText)(comp instanceof StiText ? comp : null);
                    boolean hasExcelValue = stiText != null && stiText.getExcelValue().getValue() != null && stiText.getExcelValue().getValue().length() > 0;
                    String textExpression = stiText.getText().getValue();
                    if (this.getReport().getTotals().containsKey("#%#" + comp.getName())) {
                        textExpression = (String)(this.getReport().getTotals().get("#%#" + comp.getName()) instanceof String ? this.getReport().getTotals().get("#%#" + comp.getName()) : null);
                    }
                    boolean storeToPrint = false;
                    StiParserParameters param = new StiParserParameters(textExpression, stiText, stiText, false, true);
                    Object parserResult = StiParser.ParseTextValue(param);
                    storeToPrint = param.storeToPrint;
                    txt = stiText != null && stiText.getFormat() != null && !stiText.getFormat().equals("G") ? (!hasExcelValue ? stiText.getTextFormat().Format(this.getReport().CheckExcelValue(comp, parserResult)) : stiText.getTextFormat().Format(parserResult)) : this.getReport().ToString(comp, parserResult, !hasExcelValue);
                }
                catch (Exception ex) {
                    if (this.getReport() != null) {
                        String.format(String.format("Expression in parameters of '%s' can't be evaluated! %s", this.getName(), ex.getMessage()), new Object[0]);
                    }
                    LOG.warning(String.format("Expression in parameters of '%s' can't be evaluated! %s", this.getName(), ex.getMessage()));
                }
            }
            storedVariables.SetVariables(this.getReport());
            this.getReport().setPageNumber(pageNumber);
            StiGetValueEventArgs args = new StiGetValueEventArgs();
            args.setValue(txt);
            ((StiSimpleText)textComp).InvokeGetValue((StiText)(textComp instanceof StiText ? textComp : null), args);
            if (args.getStoreToPrinted() && (StiValidationUtil.isNullOrEmpty((String)args.getValue()) || args.getValue().startsWith("#%#"))) {
                args.setValue(txt);
            }
            StiValueEventArgs e = new StiValueEventArgs(args.getValue());
            this.InvokeTextProcess(comp, e);
            String textString = this.ProcessText(this.GetTextWithoutZero((String)(e.getValue() instanceof String ? e.getValue() : null)));
            if (textComp instanceof StiTextInCells) {
                int compIndex = comp.getParent().getComponents().indexOf(comp);
                StiContainer cont = StiTextInCells.splitByCells((StiTextInCells)(this instanceof StiTextInCells ? this : null), comp, textString);
                comp.getParent().getComponents().set(compIndex, cont);
            } else {
                textComp.setTextInternal(textString);
            }
        }
    }

    @Override
    public String getTextInternal() {
        return this.getText().getValue();
    }

    public void SetTextInternal(String value) {
        this.getText().setValue(value);
    }

    @Override
    public void setTextInternal(String value) {
        this.getText().setValue(value);
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String value) {
        this.textValue = value;
    }

    protected void OnGetValue(StiGetValueEventArgs e) {
    }

    @StiSerializable
    public final StiGetValueEvent getGetValueEvent() {
        return new StiGetValueEvent(this);
    }

    public final void setGetValueEvent(StiGetValueEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument, shortName="tvh")
    public String getTotalValueHelp() {
        return this.totalValueHelp;
    }

    public void setTotalValueHelp(String value) {
        this.totalValueHelp = value;
    }

    public final String getComponentGuid() {
        return this.totalValueHelp;
    }

    public void InvokeGetValue(StiComponent sender, StiGetValueEventArgs e) {
        try {
            StiRichText richText;
            StiText stiText = (StiText)(sender instanceof StiText ? sender : null);
            boolean hasExcelValue = stiText != null && !StiValidationUtil.isNullOrEmpty((String)stiText.getExcelValue().getValue());
            Object parserResult = null;
            StiParserParameters param = new StiParserParameters(null, null, sender, false, false);
            StiRichText stiRichText = richText = sender instanceof StiRichText ? (StiRichText)sender : null;
            if (richText != null) {
                if (richText.getOnlyText()) {
                    parserResult = StiXMLConvert.DecodeName((String)richText.getText().getValue()).replace('\u0000', ' ');
                } else if (this.getReport().getEngine() != null) {
                    param = new StiParserParameters(this.fixRtf(richText.getDecodeText().trim()), richText, sender, false, false);
                    parserResult = StiParser.ParseTextValue(param);
                }
            } else if (stiText.getOnlyText()) {
                parserResult = stiText.getText().getValue();
            } else if (sender instanceof StiText) {
                StiText textComp = this instanceof StiText ? (StiText)this : null;
                param = new StiParserParameters(stiText.getText().getValue(), stiText, stiText, false, false);
                if (textComp != null && textComp.getType() == StiSystemTextType.DataColumn && textComp.getNullValue() != null && textComp.getNullValue().length() > 0) {
                    String expression = stiText.getText().getValue();
                    if (expression.startsWith("{") && expression.endsWith("}") && expression.length() > 2) {
                        expression = expression.substring(1, expression.length() - 1);
                        parserResult = StiNullValuesHelper.isNull(this.getReport(), expression) ? textComp.getNullValue() : StiParser.ParseTextValue(param);
                    }
                } else {
                    parserResult = StiParser.ParseTextValue(param);
                }
            }
            if (param != null) {
                if (param.storeToPrint) {
                    e.setStoreToPrinted(true);
                    parserResult = "#%#" + stiText.getText().getValue();
                }
                if (stiText != null && stiText.getFormat() != null && !stiText.getFormat().equals("G")) {
                    if (!hasExcelValue) {
                        e.setValue(stiText.getTextFormat().Format(this.getReport().CheckExcelValue(sender, parserResult)));
                    } else {
                        e.setValue(stiText.getTextFormat().Format(parserResult));
                    }
                } else {
                    e.setValue(this.getReport().ToString(sender, parserResult, !hasExcelValue));
                }
            }
        }
        catch (RuntimeException r) {
            if (this.getReport() != null) {
                String.format("Component: " + sender.getName() + " value: " + e.getValue(), r);
            }
            LOG.warning(String.format("Component: " + sender.getName() + " value: " + e.getValue(), r));
            if (StiLoggingUtil.getLogLevel() >= 10) {
                r.printStackTrace();
            }
            StiLoggingUtil.showWarning((String)("Component: " + sender.getName() + " value: " + e.getValue()), (Exception)r);
        }
    }

    public void checkDuplicates(StiComponent sender, StiGetValueEventArgs e) {
        try {
            StiText text;
            String tag;
            StiText comp = (StiText)sender;
            StiProcessingDuplicatesType processingDuplicates = this.getProcessingDuplicates();
            if (processingDuplicates == StiProcessingDuplicatesType.BasedOnValueAndTagMerge || processingDuplicates == StiProcessingDuplicatesType.BasedOnValueAndTagHide || processingDuplicates == StiProcessingDuplicatesType.BasedOnValueRemoveText) {
                String string = tag = processingDuplicates == StiProcessingDuplicatesType.BasedOnValueAndTagMerge || processingDuplicates == StiProcessingDuplicatesType.BasedOnValueAndTagHide ? comp.getTagValue() : null;
                if (this.getReport().getEngine().checkForDuplicate(this.getName(), e.getValue(), tag)) {
                    e.setValue("");
                    StiText stiText = text = sender instanceof StiText ? (StiText)sender : null;
                    if (text != null && !StiValidationUtil.isNullOrWhiteSpace((String)text.getFormat()) && !"G".equals(text.getFormat())) {
                        text.setExcelDataValue(null);
                    }
                }
            }
            if (processingDuplicates == StiProcessingDuplicatesType.GlobalBasedOnValueAndTagMerge || processingDuplicates == StiProcessingDuplicatesType.GlobalBasedOnValueAndTagHide || processingDuplicates == StiProcessingDuplicatesType.GlobalBasedOnValueRemoveText) {
                String string = tag = processingDuplicates == StiProcessingDuplicatesType.GlobalBasedOnValueAndTagMerge || processingDuplicates == StiProcessingDuplicatesType.GlobalBasedOnValueAndTagHide ? comp.getTagValue() : null;
                if (this.getReport().getEngine().checkForDuplicate(String.format("%s_%s", this.getLeft(), this.width), e.getValue(), tag)) {
                    e.setValue("");
                    StiText stiText = text = sender instanceof StiText ? (StiText)sender : null;
                    if (text != null && !StiValidationUtil.isNullOrWhiteSpace((String)text.getFormat()) && !"G".equals(text.getFormat())) {
                        text.setExcelDataValue(null);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String fixRtf(String text) {
        StringBuilder sb = new StringBuilder(text);
        int from = 0;
        int pos = sb.indexOf("{", from);
        while (pos > 0) {
            int i;
            for (i = pos - 1; i > 0 && Character.isLetterOrDigit(sb.charAt(i)); --i) {
            }
            if ('\\' == sb.charAt(i)) {
                sb.replace(pos, pos, " ");
                ++pos;
            }
            from = pos + 1;
            pos = sb.indexOf("{", from);
        }
        return sb.toString();
    }

    @Override
    public String SaveState() {
        return this.getTextInternal();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("GlobalizedName", this.getGlobalizedName());
        jObject.AddPropertyEnum("LinesOfUnderline", (Enum)this.getLinesOfUnderline(), (Enum)StiPenStyle.None);
        jObject.AddPropertyBool("HideZeros", this.getHideZeros());
        jObject.AddPropertyEnum("ProcessingDuplicates", (Enum)this.getProcessingDuplicates(), (Enum)StiProcessingDuplicatesType.None);
        jObject.AddPropertyInt("MaxNumberOfLines", this.getMaxNumberOfLines());
        jObject.AddPropertyBool("OnlyText", this.getOnlyText());
        jObject.AddPropertyBool("Editable", this.getEditable());
        jObject.AddPropertyBool("ProcessAtEnd", this.getProcessAtEnd());
        jObject.AddPropertyEnum("ProcessAt", (Enum)this.getProcessAt(), (Enum)StiProcessAt.None);
        jObject.AddPropertyJObject("Text", this.getText().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetValueEvent", this.getGetValueEvent().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("TotalValueHelp", this.getTotalValueHelp());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("GlobalizedName")) {
                this.setGlobalizedName((String)property.Value);
                continue;
            }
            if (property.Name.equals("LinesOfUnderline")) {
                this.linesOfUnderline = StiPenStyle.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("HideZeros")) {
                this.hideZeros = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ProcessingDuplicates")) {
                this.setProcessingDuplicates(StiProcessingDuplicatesType.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("MaxNumberOfLines")) {
                this.setMaxNumberOfLines((Integer)property.Value);
                continue;
            }
            if (property.Name.equals("OnlyText")) {
                this.setOnlyText((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Editable")) {
                this.editable = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ProcessAtEnd")) {
                this.setProcessAtEnd((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("ProcessAt")) {
                this.setProcessAt(StiProcessAt.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("Text")) {
                StiExpression _expression = new StiExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.text = _expression;
                continue;
            }
            if (property.Name.equals("GetValueEvent")) {
                StiGetValueEvent _event = new StiGetValueEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetValueEvent(_event);
                continue;
            }
            if (!property.Name.equals("TotalValueHelp")) continue;
            this.totalValueHelp = (String)property.Value;
        }
    }
}

