/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.textFormats;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.textFormats.StiCurrencyFormatService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class StiPercentageFormatService
extends StiCurrencyFormatService {
    public StiPercentageFormatService() {
    }

    public StiPercentageFormatService(int positivePattern, int negativePattern, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, String symbol, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay) {
        this(positivePattern, negativePattern, 0, decimalSeparator, decimalDigits, groupSeparator, groupSize, symbol, useGroupSeparator, useLocalSetting, nullDisplay);
    }

    public StiPercentageFormatService(int positivePattern, int negativePattern, int decimalPlaces, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, String symbol, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay) {
        super(positivePattern, negativePattern, decimalSeparator, decimalDigits, groupSeparator, groupSize, symbol, useGroupSeparator, useLocalSetting, nullDisplay);
    }

    @Override
    public String getServiceName() {
        return StiLocalization.Get((String)"FormFormatEditor", (String)"Percentage");
    }

    @Override
    public int getPosition() {
        return 6;
    }

    @Override
    @StiSerializable(need=false)
    public String getStringFormat() {
        return super.getStringFormat();
    }

    @Override
    public void setStringFormat(String value) {
        super.setStringFormat(value);
    }

    @Override
    public Object getSample() {
        return -1.2312;
    }

    @Override
    public String getNativeFormatString() {
        return "{0:P2}";
    }

    @Override
    public String format(String stringFormat, Object value) {
        if (value == null || value instanceof DBNull) {
            return this.getNullDisplay();
        }
        if (StiValidationUtil.isNotNumber((Object)value)) {
            return value.toString();
        }
        DecimalFormat form = (DecimalFormat)DecimalFormat.getPercentInstance();
        if (!this.getUseLocalSetting()) {
            form.setGroupingUsed(this.getUseGroupSeparator());
            form.setGroupingSize(this.getGroupSize());
            form.setDecimalFormatSymbols(this.getDecimalFormatSymbols(form));
            form.setPositiveSuffix(this.getSymbol());
            form.setNegativeSuffix(this.getSymbol());
            form.setMaximumFractionDigits(this.getDecimalDigits());
        }
        BigDecimal decimal = new BigDecimal(value.toString());
        return form.format(decimal);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("StringFormat");
        return jObject;
    }
}

