/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.report.components.enums.StiGroupSortDirection;
import com.stimulsoft.report.dictionary.StiDataSort;
import com.stimulsoft.report.dictionary.StiSort;
import com.stimulsoft.report.dictionary.data.DataRow;
import java.util.Comparator;
import java.util.Hashtable;

public class StiDataSortConditions
implements Comparator<DataRow> {
    private final Hashtable<DataRow, Integer> rowToConditions;
    private final Object[][][] conditions;
    private DataRow row1;
    private DataRow row2;

    public StiDataSortConditions(Hashtable<DataRow, Integer> rowToConditions, Object[][][] conditions) {
        this.rowToConditions = rowToConditions;
        this.conditions = conditions;
    }

    @Override
    public int compare(DataRow row1, DataRow row2) {
        if (this.existRowConditions()) {
            this.row1 = row1;
            this.row2 = row2;
            return this.groupCompare();
        }
        return 0;
    }

    private int groupCompare() {
        int indexCond1 = this.rowToConditions.get(this.row1);
        int indexCond2 = this.rowToConditions.get(this.row2);
        int groupCount = this.conditions[0].length;
        for (int groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
            Object value1 = this.conditions[indexCond1][groupIndex][0];
            Object value2 = this.conditions[indexCond2][groupIndex][0];
            StiGroupSortDirection direction = (StiGroupSortDirection)((Object)this.conditions[indexCond1][groupIndex][1]);
            StiSort.Order order = direction == StiGroupSortDirection.Ascending ? StiSort.Order.Asc : StiSort.Order.Desc;
            int groupResult = StiDataSort.CompareValues(value1, value2, order);
            if (groupResult == 0) continue;
            return groupResult;
        }
        return 0;
    }

    private boolean existRowConditions() {
        return this.rowToConditions != null && this.conditions != null;
    }

    public int getRowPositionConditions(DataRow row) {
        return this.rowToConditions.get(row);
    }
}

