/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.adapters;

import com.stimulsoft.base.utils.StiLoggingUtil;
import java.net.URLDecoder;
import java.util.Map;

public class StiJDBCParameters {
    private final String driverName;
    private final String connectionURL;
    private final String user;
    private final String password;
    private final Map<String, String> other;

    public StiJDBCParameters(String driverName, String connectionURL, String user, String password, Map<String, String> other) {
        this.driverName = driverName;
        this.connectionURL = connectionURL;
        this.user = user;
        this.password = password;
        this.other = other;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        try {
            return URLDecoder.decode(this.password, "UTF-8");
        }
        catch (Exception e) {
            if (StiLoggingUtil.getLogLevel() >= 10) {
                e.printStackTrace();
            }
            return this.password;
        }
    }

    public boolean isDefaultEncoding() {
        return !this.connectionURL.contains("Encoding") && !this.connectionURL.contains("encoding") || this.other.containsKey("characterEncoding");
    }

    public Map<String, String> getOther() {
        return this.other;
    }

    public String getUser(String defUser) {
        return defUser != null ? defUser : this.user;
    }

    public String getPassword(String defPassword) {
        return defPassword != null ? defPassword : this.password;
    }

    public String toString() {
        return "Connection {driverName=" + this.driverName + ",connectionURL=" + this.connectionURL + ",user=" + this.user + ",password=***}";
    }
}

