/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.adapters;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiSqlSource;
import java.util.Arrays;
import java.util.List;

public class StiMsSqlAdapter
extends StiAbstractAdapter {
    private static final String DRIVER_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DEFAULT_PORT = "1433";
    private static final String URL = "jdbc:sqlserver://%s:%s;databaseName=%s";
    private static final List<String> HOST_KEY = Arrays.asList("host", "server", "data source", "datasource");
    private static final List<String> DATABASE_KEY = Arrays.asList("database", "database name", "databaseName", "initial catalog", "initialcatalog");
    private static final List<String> INSTANCE_KEY = Arrays.asList("instancename", "instance", "instanceName");

    public StiMsSqlAdapter(String connectionString) {
        super(connectionString);
    }

    @Override
    protected String getConnectionURL() {
        String instance = this.getInstance();
        if (StiValidationUtil.isNotNullOrEmpty((String)instance)) {
            return String.format(URL, this.getHost(), this.getPort(), this.getDataBase()) + ";instanceName=" + instance;
        }
        return String.format(URL, this.getHost(), this.getPort(), this.getDataBase());
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    protected String getDefaultPort() {
        return DEFAULT_PORT;
    }

    @Override
    public List<String> getHostKey() {
        return HOST_KEY;
    }

    @Override
    public List<String> getDatabaseName() {
        return DATABASE_KEY;
    }

    public String getInstance() {
        return this.getLeastOne(INSTANCE_KEY);
    }

    @Override
    public Class<? extends StiDataSource> getDataSourceClass() {
        return StiSqlSource.class;
    }
}

