/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.adapters;

import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiOracleSource;

public class StiOracleAdapter
extends StiAbstractAdapter {
    private static final String DRIVER_NAME = "oracle.jdbc.OracleDriver";
    private static final String DEFAULT_PORT = "1521";
    private static final String URL = "jdbc:oracle:thin:@%s:%s:%s";

    public StiOracleAdapter(String connectionString) {
        super(connectionString);
    }

    @Override
    protected String getConnectionURL() {
        String database = this.getDataBase();
        if (database == null) {
            return this.getLeastOne(URL_KEYS);
        }
        return String.format(URL, this.getHost(), this.getPort(), database);
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    protected String getDefaultPort() {
        return DEFAULT_PORT;
    }

    @Override
    public Class<? extends StiDataSource> getDataSourceClass() {
        return StiOracleSource.class;
    }
}

