/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.math.BigDecimal;

public class StiAvgDecimalFunctionService
extends StiAggregateFunctionService {
    private BigDecimal summary;
    private long count;

    public StiAvgDecimalFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    public StiAvgDecimalFunctionService() {
    }

    public String getServiceName() {
        return "Avg";
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.summary = BigDecimal.ZERO;
            this.count = 0L;
        }
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        this.summary = this.summary.add(new BigDecimal(value.toString()));
        ++this.count;
    }

    @Override
    public Object GetValue() {
        if (this.count == 0L) {
            return 0L;
        }
        return this.summary.divide(new BigDecimal(this.count), 1);
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to Avg function!");
    }

    @Override
    public Class GetResultType() {
        return BigDecimal.class;
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }
}

