/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import java.util.Date;

public class StiMinDateFunctionService
extends StiAggregateFunctionService {
    private Date minimum = new Date(0L);
    private boolean valueProcessed = false;

    public StiMinDateFunctionService() {
    }

    public StiMinDateFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value instanceof Date) {
            Date dateTimeValue = (Date)value;
            if (this.valueProcessed) {
                if (this.minimum.compareTo(dateTimeValue) > 0) {
                    this.minimum = dateTimeValue;
                }
            } else {
                this.minimum = dateTimeValue;
                this.valueProcessed = true;
            }
        }
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return Date.class;
    }

    public String getServiceName() {
        return "MinDate";
    }

    @Override
    public Object GetValue() {
        return this.minimum;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.valueProcessed = false;
        }
    }

    @Override
    public void SetValue(Object value) {
        this.minimum = (Date)value;
    }
}

