/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.dataSources;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.type.StiSystemObject;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.dictionary.StiDataParametersCollection;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.enums.StiSqlSourceType;

public class StiSqlSource
extends StiDataTableSource {
    private boolean allowExpressions = true;
    private StiSqlSourceType type = StiSqlSourceType.Table;
    private int commandTimeout = 3000;
    private boolean reconnectOnEachRow;
    private String sqlCommand = "";

    public StiSqlSource() {
        this("", "", "");
    }

    public StiSqlSource(String nameInSource, String name) {
        this(nameInSource, name, name);
    }

    public StiSqlSource(String nameInSource, String name, String alias) {
        this(nameInSource, name, alias, "");
    }

    public StiSqlSource(String nameInSource, String name, String alias, String sqlCommand) {
        this(nameInSource, name, alias, sqlCommand, true);
    }

    public StiSqlSource(String nameInSource, String name, String alias, String sqlCommand, boolean connectOnStart) {
        this(nameInSource, name, alias, sqlCommand, connectOnStart, false);
    }

    public StiSqlSource(String nameInSource, String name, String alias, String sqlCommand, boolean connectOnStart, boolean reconnectOnEachRow) {
        this(nameInSource, name, alias, sqlCommand, connectOnStart, reconnectOnEachRow, 30);
    }

    public StiSqlSource(String nameInSource, String name, String alias, String sqlCommand, boolean connectOnStart, boolean reconnectOnEachRow, int commandTimeout) {
        super(nameInSource, name, alias);
        this.sqlCommand = sqlCommand;
        this.setConnectOnStart(connectOnStart);
        this.reconnectOnEachRow = reconnectOnEachRow;
        this.commandTimeout = commandTimeout;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getConnectOnStart() {
        return super.getConnectOnStart();
    }

    @Override
    public void setConnectOnStart(boolean value) {
        super.setConnectOnStart(value);
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowExpressions() {
        return this.allowExpressions;
    }

    public final void setAllowExpressions(boolean value) {
        this.allowExpressions = value;
    }

    @StiSerializable
    public final StiSqlSourceType getType() {
        return this.type;
    }

    public final void setType(StiSqlSourceType value) {
        this.type = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final int getCommandTimeout() {
        return this.commandTimeout;
    }

    public final void setCommandTimeout(int value) {
        this.commandTimeout = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getReconnectOnEachRow() {
        return this.reconnectOnEachRow;
    }

    public final void setReconnectOnEachRow(boolean value) {
        this.reconnectOnEachRow = value;
    }

    @StiSerializable
    public final String getSqlCommand() {
        if (StiOptions.Dictionary.isIgnoreLastSemicolonQuery() && this.sqlCommand != null && this.sqlCommand.endsWith(";")) {
            return this.sqlCommand.substring(0, this.sqlCommand.length() - 1);
        }
        return this.sqlCommand;
    }

    public final void setSqlCommand(String value) {
        this.sqlCommand = value;
    }

    @Override
    @StiSerializable
    public StiDataParametersCollection getParameters() {
        return super.getParameters();
    }

    @Override
    public void setParameters(StiDataParametersCollection value) {
        super.setParameters(value);
    }

    public void UpdateParameters() {
    }

    @Override
    public String getQuery() {
        return this.getSqlCommand();
    }

    public String getFinalSqlCommand() {
        String methodName = String.format("Get%s_SqlCommand", this.getName());
        Class<?> type = this.getDictionary().getReport().getClass();
        Object method = null;
        return null;
    }

    public StiSystemType getNetType(int dbType) {
        return new StiSystemObject();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("ConnectOnStart", this.getConnectOnStart(), true);
        jObject.AddPropertyBool("AllowExpressions", this.getAllowExpressions(), true);
        jObject.AddPropertyEnum("Type", (Enum)this.getType(), (Enum)StiSqlSourceType.Table);
        jObject.AddPropertyInt("CommandTimeout", this.getCommandTimeout(), 30);
        jObject.AddPropertyBool("ReconnectOnEachRow", this.getReconnectOnEachRow());
        jObject.AddPropertyStringNullOfEmpty("SqlCommand", this.getSqlCommand());
        jObject.AddPropertyJObject("Parameters", this.getParameters().SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ConnectOnStart")) {
                this.setConnectOnStart((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("AllowExpressions")) {
                this.allowExpressions = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Type")) {
                this.type = StiSqlSourceType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("CommandTimeout")) {
                this.commandTimeout = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("ReconnectOnEachRow")) {
                this.reconnectOnEachRow = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("SqlCommand")) {
                this.sqlCommand = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("Parameters")) continue;
            this.getParameters().LoadFromJsonObject((JSONObject)property.Value);
        }
    }
}

