/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.databases;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.services.StiService;
import com.stimulsoft.base.system.StiEventHandlerArgs;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDatabaseInformation;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.events.StiConnectedEvent;
import com.stimulsoft.report.events.StiConnectingEvent;
import com.stimulsoft.report.events.StiDisconnectedEvent;
import com.stimulsoft.report.events.StiDisconnectingEvent;
import java.sql.Connection;
import java.util.Iterator;

public abstract class StiDatabase
extends StiService
implements IStiInherited,
IStiName,
IStiJsonReportObject {
    private String name;
    private String alias;
    private boolean inherited;
    private StiConnectingEvent connectingEvent = new StiConnectingEvent();
    private StiDisconnectedEvent disconnectedEvent = new StiDisconnectedEvent();
    private StiConnectedEvent connectedEvent = new StiConnectedEvent();
    private StiDisconnectingEvent disconnectingEvent = new StiDisconnectingEvent();
    private String key;

    public void createDataSources(StiDictionary dictionary) throws Exception {
        StiDatabaseInformation information = this.getDatabaseInformation(null, null, dictionary.getReport());
        for (DataTable table : information.getTables()) {
            StiDataTableSource source = new StiDataTableSource(String.format("%s.%s", this.getName(), table.getTableName()), table.getTableName(), table.getTableName());
            source.setDictionary(dictionary);
            source.setColumns(new StiDataColumnsCollection());
            Iterator i$ = table.getColumns().iterator();
            while (i$.hasNext()) {
                StiDataColumn column = (StiDataColumn)i$.next();
                source.getColumns().add(column);
            }
            dictionary.getDataSources().add(source);
        }
    }

    public StiDatabase() {
        this("");
    }

    public StiDatabase(String name) {
        this(name, name);
    }

    public StiDatabase(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getInherited() {
        return this.inherited;
    }

    @Override
    public final void setInherited(boolean value) {
        this.inherited = value;
    }

    @StiSerializable
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public final String getServiceCategory() {
        return StiLocalization.getValue((String)"PropertyMain", (String)"CategoryConnections");
    }

    @StiSerializable
    public final StiConnectingEvent getConnectingEvent() {
        return this.connectingEvent;
    }

    public final void setConnectingEvent(StiConnectingEvent value) {
        if (this.connectingEvent != value) {
            this.connectingEvent = value;
        }
    }

    protected void onConnected(StiEventHandlerArgs e) {
    }

    @StiSerializable
    public final StiConnectedEvent getConnectedEvent() {
        return this.connectedEvent;
    }

    public final void setConnectedEvent(StiConnectedEvent value) {
        if (this.connectedEvent != value) {
            this.connectedEvent = value;
        }
    }

    protected void onDisconnecting(StiEventHandlerArgs e) {
    }

    @StiSerializable
    public final StiDisconnectingEvent getDisconnectingEvent() {
        return this.disconnectingEvent;
    }

    public final void setDisconnectingEvent(StiDisconnectingEvent value) {
        if (this.disconnectingEvent != value) {
            this.disconnectingEvent = value;
        }
    }

    protected void onDisconnected(StiEventHandlerArgs e) {
    }

    @StiSerializable
    public final StiDisconnectedEvent getDisconnectedEvent() {
        return this.disconnectedEvent;
    }

    public final void setDisconnectedEvent(StiDisconnectedEvent value) {
        if (this.disconnectedEvent != value) {
            this.disconnectedEvent = value;
        }
    }

    @StiSerializable
    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    @StiSerializable
    public final String getAlias() {
        return this.alias;
    }

    public final void setAlias(String value) {
        this.alias = value;
    }

    public StiDatabaseInformation getDatabaseInformation(Connection con, StiAbstractAdapter adapter, StiReport report) throws Exception {
        return new StiDatabaseInformation();
    }

    public void applyDatabaseInformation(StiDatabaseInformation info, StiReport report, StiDatabaseInformation allInfo) {
    }

    public int edit(boolean newDatabase) {
        return 0;
    }

    public void regData(StiDictionary dictionary, boolean loadData) {
    }

    public Class<?> getServiceType() {
        return this.getClass();
    }

    public abstract void connect(StiDataStoreSource var1, StiReport var2) throws StiException;

    public abstract void connect(StiDataStoreSource var1, Boolean var2, StiReport var3) throws StiException;

    public abstract void disconnect();

    public String getServiceName() {
        return "";
    }

    public String toString() {
        if (!StiOptions.Dictionary.getShowOnlyAliasForDatabase()) {
            if (StiValidationUtil.equals((Object)this.getName(), (Object)this.getAlias()) || StiValidationUtil.isEmpty((String)this.getAlias())) {
                return String.format("%s [%s] ", this.getName(), this.getServiceName());
            }
            return String.format("%s [%s] ", this.getName(), this.getAlias());
        }
        if (!StiValidationUtil.isNullOrEmpty((String)this.getAlias())) {
            return this.getAlias();
        }
        return this.getName();
    }

    public String getString() {
        if (!StiOptions.Dictionary.getShowOnlyAliasForDatabase()) {
            if (StiValidationUtil.equals((Object)this.getName(), (Object)this.getAlias()) || StiValidationUtil.isEmpty((String)this.getAlias())) {
                return String.format("%s [%s] ", this.getName(), this.getServiceName());
            }
            return String.format("%s [%s] ", this.getName(), this.getAlias());
        }
        if (!StiValidationUtil.isNullOrEmpty((String)this.getAlias())) {
            return this.getAlias();
        }
        return this.getName();
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("Inherited", this.getInherited());
        jObject.AddPropertyJObject("ConnectingEvent", this.getConnectingEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ConnectedEvent", this.getConnectedEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("DisconnectingEvent", this.getDisconnectingEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("DisconnectedEvent", this.getDisconnectedEvent().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("Name", this.getName());
        jObject.AddPropertyStringNullOfEmpty("Alias", this.getAlias());
        jObject.AddPropertyStringNullOfEmpty("Key", this.getKey());
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Inherited")) {
                this.inherited = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ConnectingEvent")) {
                this.getConnectingEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("ConnectedEvent")) {
                this.getConnectedEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("DisconnectingEvent")) {
                this.getDisconnectingEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("DisconnectedEvent")) {
                this.getDisconnectedEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Name")) {
                this.name = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Alias")) {
                this.alias = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("Key")) continue;
            this.key = (String)property.Value;
        }
    }
}

