/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.databases;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.data.StiDataLoaderHelper;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.lib.io.StiUnicodeBOMInputStream;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDatabaseInformation;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.helpers.StiUniversalDataLoader;
import com.stimulsoft.report.utils.data.StiDataColumnsUtil;
import com.stimulsoft.report.utils.data.StiSqlField;
import com.stimulsoft.report.utils.data.StiXmlTable;
import com.stimulsoft.report.utils.data.StiXmlTableFieldsRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StiXmlDatabase
extends StiDatabase {
    private String pathSchema = null;
    private String pathData = null;
    private InputStream schemaIS = null;
    private InputStream dataIS = null;
    private Document document = null;
    private String embeddedData;

    public StiXmlDatabase() {
        this("", "", "");
    }

    public StiXmlDatabase(String name, String pathData) {
        super(name);
        this.pathData = pathData;
        this.pathSchema = "";
    }

    public StiXmlDatabase(String name, File pathData) {
        super(name);
        this.pathData = pathData.getAbsolutePath();
        this.pathSchema = "";
    }

    public StiXmlDatabase(String name, InputStream dataIS) {
        super(name);
        this.dataIS = dataIS;
    }

    public StiXmlDatabase(String name, InputStream schemeIS, InputStream dataIS) {
        super(name);
        this.dataIS = dataIS;
        this.schemaIS = schemeIS;
    }

    public StiXmlDatabase(String name, String pathSchema, String pathData) {
        super(name);
        this.pathSchema = pathSchema;
        this.pathData = pathData;
    }

    @Override
    public String getServiceName() {
        return "XML";
    }

    @StiSerializable
    public final String getPathSchema() {
        return this.pathSchema;
    }

    public final void setPathSchema(String value) {
        this.pathSchema = value;
    }

    @StiSerializable
    public final String getPathData() {
        return this.pathData;
    }

    public final void setPathData(String value) {
        this.pathData = value;
    }

    @Override
    public void connect(StiDataStoreSource source, StiReport report) {
        this.connect(source, true, report);
    }

    @Override
    public void connect(StiDataStoreSource source, Boolean fillTable, StiReport report) {
        if (this.document == null) {
            this.document = StiXmlUtil.parseXmlInputStream((InputStream)this.getDataInputStream(report));
            StiXmlUtil.processRelations((Element)((Element)this.document.getFirstChild()), (String)"", (Integer)0, new HashMap());
        }
        if (fillTable.booleanValue()) {
            this.fillTable(source);
        }
    }

    public InputStream getSchemaInputStream(StiReport report) {
        try {
            if (StiValidationUtil.isNotNullOrEmpty((String)this.pathSchema)) {
                StiDataLoaderHelper.Data schema = StiUniversalDataLoader.loadSingle(report, this.pathSchema);
                return new ByteArrayInputStream(schema.array);
            }
            return this.schemaIS;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getDataInputStream(StiReport report) {
        try {
            InputStream result = null;
            if (StiValidationUtil.isNotNullOrEmpty((String)this.pathData)) {
                StiDataLoaderHelper.Data schema = StiUniversalDataLoader.loadSingle(report, this.pathData);
                result = new ByteArrayInputStream(schema.array);
            } else {
                result = this.dataIS;
            }
            StiUnicodeBOMInputStream bis = new StiUnicodeBOMInputStream(result);
            if (bis.getBOM() != StiUnicodeBOMInputStream.BOM.NONE) {
                bis.skipBOM();
            }
            return bis;
        }
        catch (Exception e) {
            try {
                return new ByteArrayInputStream(this.embeddedData.getBytes("UTF-8"));
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void disconnect() {
        this.document = null;
    }

    private Node findNode(Node parent, String nodeName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equals(nodeName)) continue;
            return children.item(i);
        }
        return null;
    }

    private NodeList getElementsByTagName(String tagName, Node node) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression xPathExpression = xPath.compile("/" + tagName.replaceAll("_", "/"));
            return (NodeList)xPathExpression.evaluate(this.document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void fillTable(StiDataStoreSource source) {
        DataTable dataTable = source.createNewTable();
        String nameTable = dataTable.getName();
        NodeList xmlRows = this.document.getElementsByTagName(nameTable = StiXMLConvert.encodeName((String)nameTable));
        if (xmlRows.getLength() == 0) {
            xmlRows = this.getElementsByTagName(nameTable, this.document);
        }
        int length = xmlRows != null ? xmlRows.getLength() : 0;
        for (int i = 0; i < length; ++i) {
            String value;
            String columnName;
            Node node;
            int index;
            Node xmlRow = xmlRows.item(i);
            NodeList xmlCell = xmlRow.getChildNodes();
            DataRow dataRow = dataTable.createNewRow();
            for (index = 0; index < xmlCell.getLength(); ++index) {
                node = xmlCell.item(index);
                if (!StiXmlUtil.isElementNode((Node)node)) continue;
                columnName = StiXMLConvert.decodeName((String)node.getNodeName());
                if (!dataTable.existColumn(columnName = StiNameValidator.CorrectName(columnName))) continue;
                value = node.getTextContent();
                dataRow.addCell(columnName, value);
            }
            for (index = 0; index < xmlRow.getAttributes().getLength(); ++index) {
                node = xmlRow.getAttributes().item(index);
                columnName = StiXMLConvert.decodeName((String)node.getNodeName());
                if (!dataTable.existColumn(columnName = StiNameValidator.CorrectName(columnName))) {
                    columnName = "@" + columnName;
                }
                if (!dataTable.existColumn(columnName)) continue;
                value = node.getNodeValue();
                dataRow.addCell(columnName, value);
            }
        }
        source.setDataTable(dataTable);
    }

    @Override
    public StiDatabaseInformation getDatabaseInformation(Connection con, StiAbstractAdapter adapter, StiReport report) throws Exception {
        StiDatabaseInformation info = new StiDatabaseInformation();
        InputStream is = this.getSchemaInputStream(report);
        StiXmlTableFieldsRequest request = is != null ? StiDataColumnsUtil.parceXSDSchema(is) : StiDataColumnsUtil.parceXMLSchema(this.getDataInputStream(report), true);
        for (StiXmlTable table : request.getTables()) {
            DataTable dTable = new DataTable(table.getName(), new StiDataColumnsCollection());
            for (StiSqlField field : table.getColumns()) {
                dTable.getColumns().add(new StiDataColumn(field.getName(), field.getName(), field.getSystemType()));
            }
            info.getTables().add(dTable);
        }
        if (is != null) {
            is.close();
        }
        return info;
    }

    @Override
    public void applyDatabaseInformation(StiDatabaseInformation information, StiReport report, StiDatabaseInformation informationAll) {
        for (DataTable dataTable : information.getTables()) {
            StiDataTableSource source = new StiDataTableSource(this.getName() + "." + dataTable.getTableName(), StiNameCreation.createName(report, dataTable.getTableName(), false, false, true));
            Iterator i$ = dataTable.getColumns().iterator();
            while (i$.hasNext()) {
                StiDataColumn dataColumn = (StiDataColumn)i$.next();
                StiDataColumn column = new StiDataColumn(dataColumn.getName(), dataColumn.getName(), dataColumn.getSystemType());
                source.getColumns().add(column);
                column.setDataSource(source);
            }
            report.getDictionary().getDataSources().add(source);
            source.setDictionary(report.getDictionary());
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("PathSchema", this.getPathSchema());
        jObject.AddPropertyStringNullOfEmpty("PathData", this.getPathData());
        jObject.AddPropertyStringNullOfEmpty("EmbeddedData", this.getEmbeddedData());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("PathSchema")) {
                this.pathSchema = (String)property.Value;
                continue;
            }
            if (property.Name.equals("PathData")) {
                this.setPathData((String)property.Value);
                continue;
            }
            if (property.Name.equals("XmlType") || !property.Name.equals("EmbeddedData")) continue;
            this.setEmbeddedData((String)property.Value);
        }
    }

    @StiSerializable
    public String getEmbeddedData() {
        return this.embeddedData;
    }

    public void setEmbeddedData(String embeddedData) {
        this.embeddedData = embeddedData;
    }
}

