/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiEventHandlerArgs;
import com.stimulsoft.base.system.StiEventHandlerListener;
import com.stimulsoft.base.system.StiEventObject;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteraction;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiDataHelper;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiSubReport;
import com.stimulsoft.report.components.conditions.StiBaseCondition;
import com.stimulsoft.report.components.conditions.StiCondition;
import com.stimulsoft.report.components.conditions.StiFilter;
import com.stimulsoft.report.components.conditions.StiMultiCondition;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.enums.StiProcessAt;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.table.IStiTableCell;
import com.stimulsoft.report.components.table.StiColumnSize;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.components.table.StiTableCell;
import com.stimulsoft.report.components.table.StiTableCellImage;
import com.stimulsoft.report.components.table.enums.StiTableAutoWidth;
import com.stimulsoft.report.dialogs.StiForm;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiSqlSource;
import com.stimulsoft.report.engine.StiRenderState;
import com.stimulsoft.report.engine.StiVariableHelper;
import com.stimulsoft.report.engine.engineV2.StiBookmarksV2Helper;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiPageHelper;
import com.stimulsoft.report.engine.engineV2.StiPostProcessProviderV2;
import com.stimulsoft.report.engine.engineV2.StiReportRenderingStopException;
import com.stimulsoft.report.engine.engineV2.StiStopBeforePageException;
import com.stimulsoft.report.engine.engineV2.StiStopBeforePrintException;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.enums.StiNumberOfPass;
import com.stimulsoft.report.enums.StiReportCacheMode;
import com.stimulsoft.report.enums.StiReportPass;
import com.stimulsoft.report.options.EngineOptions;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public final class StiRenderProviderV2 {
    public static void Render(StiReport report, StiRenderState state) {
        StiComponentsCollection comps2 = report.getComponents();
        for (StiComponent comp : comps2) {
            StiText text = (StiText)(comp instanceof StiText ? comp : null);
            if (text == null || text.getProcessAt() != StiProcessAt.EndOfPage) continue;
            report.engine.AllowEndOfPageProcessing = true;
            break;
        }
        StiRenderProviderV2.InitReport(report);
        if (report.SubReportsMasterReport == null) {
            report.getRenderedPages().clear();
        }
        StiNumberOfPass numberOfPass = StiRenderProviderV2.GetNumberOfPass(report);
        boolean dialogsOnStartExist = StiRenderProviderV2.IsDialogsOnStartExist(report);
        if (!dialogsOnStartExist) {
            StiRenderProviderV2.RenderFirstPass(report, numberOfPass);
        }
        StiReport masterReport = report.SubReportsMasterReport;
        Hashtable newTableComponents = new Hashtable();
        Hashtable<StiComponent, 1> eventsHandlers = null;
        try {
            Hashtable guidToPage = StiRenderProviderV2.PrepareSubReportsAndDrillDownPages(report);
            if (masterReport == null) {
                report.getRenderedPages().clear();
            }
            report.invokeBeginRender();
            StiRenderProviderV2.ClearTotals(report);
            StiRenderProviderV2.ConnectToData(report);
            StiVariableHelper.FillItemsOfVariables(report);
            StiVariableHelper.setDefaultValueForRequestFromUserVariables(report);
            if (dialogsOnStartExist) {
                StiRenderProviderV2.DisconnectFromData(report);
                StiRenderProviderV2.RenderFirstPass(report, numberOfPass);
                StiRenderProviderV2.ConnectToData(report);
            }
            report.getBookmark().getBookmarks().clear();
            report.getBookmark().text = report.getReportAlias();
            if (report.progress != null) {
                report.progress.showProgressBar();
            }
            StiRenderProviderV2.InitCacheMode(report);
            StiComponentsCollection comps = report.GetComponents();
            ArrayList<StiTable> listTable = new ArrayList<StiTable>();
            for (StiComponent cont : comps) {
                StiTable table = (StiTable)(cont instanceof StiTable ? cont : null);
                if (table == null || !table.getEnabled()) continue;
                listTable.add(table);
            }
            boolean bl = report.containsTables = !listTable.isEmpty();
            if (listTable.size() > 0) {
                Hashtable<String, StiDataBand> tableMasterComponent = new Hashtable<String, StiDataBand>();
                boolean TableAutoWidth = false;
                for (int i = 0; i < listTable.size(); ++i) {
                    StiDataBand newDataBand;
                    StiTable table = (StiTable)listTable.get(i);
                    if (table.getAutoWidth() != StiTableAutoWidth.None) {
                        TableAutoWidth = true;
                    }
                    if ((newDataBand = table.StartRenderTableBand(newTableComponents)) == null) continue;
                    tableMasterComponent.put(newDataBand.getName(), newDataBand);
                }
                if (tableMasterComponent.size() != 0) {
                    for (StiDataBand band : tableMasterComponent.values()) {
                        if (band.getMasterComponent() == null || !(band.getMasterComponent() instanceof StiTable)) continue;
                        StiDataBand dataBand = (StiDataBand)tableMasterComponent.get(band.getMasterComponent().getName() + "_DB");
                        band.setMasterComponent(dataBand instanceof StiDataBand ? dataBand : null);
                    }
                }
                tableMasterComponent = null;
                comps.clear();
                comps = report.getComponents();
                report.containsTables = TableAutoWidth;
            }
            report.engine.setParserConversionStore(new Hashtable());
            report.engine.anchorsArguments = new Hashtable();
            boolean isCompilationMode = report.getCalculationMode() == StiCalculationMode.Compilation;
            eventsHandlers = new Hashtable<StiComponent, 1>();
            for (StiComponent comp : comps) {
                Object eh;
                String args;
                int endPos;
                String eventText;
                int pos;
                StiText stiText;
                comp.Prepare();
                if (isCompilationMode) continue;
                if (!isCompilationMode && comp.conditions.size() > 0) {
                    ArrayList conditionList = new ArrayList();
                    for (StiBaseCondition cond : comp.conditions) {
                        StiCondition condition = (StiCondition)(cond instanceof StiCondition ? cond : null);
                        String expression = null;
                        if (cond instanceof StiMultiCondition) {
                            StiMultiCondition multiCondition = (StiMultiCondition)(cond instanceof StiMultiCondition ? cond : null);
                            if (!multiCondition.getFilterOn() || multiCondition.filters.size() <= 0) continue;
                            StringBuilder conditionExpression = new StringBuilder("{");
                            for (int index = 0; index < multiCondition.filters.size(); ++index) {
                                StiFilter filter = (StiFilter)multiCondition.filters.get(index);
                                conditionExpression.append("(");
                                conditionExpression.append(StiDataHelper.GetFilterExpression(filter, filter.column));
                                conditionExpression.append(")");
                                if (index >= multiCondition.filters.size() - 1) continue;
                                conditionExpression.append(multiCondition.getFilterMode() == StiFilterMode.And ? " && " : " || ");
                            }
                            conditionExpression.append("}");
                            Hashtable<StiMultiCondition, String> de = new Hashtable<StiMultiCondition, String>();
                            de.put(multiCondition, conditionExpression.toString());
                            conditionList.add(de);
                            continue;
                        }
                        if (condition == null) continue;
                        expression = "{" + StiDataHelper.GetFilterExpression(condition, condition.column) + "}";
                        Hashtable<StiCondition, String> de = new Hashtable<StiCondition, String>();
                        de.put(condition, expression);
                        conditionList.add(de);
                    }
                    if (conditionList.size() > 0) {
                        report.engine.getParserConversionStore().put("*StiConditionExpression*" + comp.getName(), conditionList);
                    }
                }
                if ((stiText = (StiText)(comp instanceof StiText ? comp : null)) != null) {
                    StiParser.checkForDataBandsUsedInPageTotals(stiText);
                }
                if (comp instanceof StiDataBand && ((StiDataBand)comp).getRenderingEvent() != null && !StiValidationUtil.isNullOrEmpty((String)((StiDataBand)comp).getRenderingEvent().getScript()) && (pos = (eventText = ((StiDataBand)comp).getRenderingEvent().getScript()).indexOf("AddAnchor(")) != -1 && (endPos = eventText.indexOf(")", pos)) != -1) {
                    args = eventText.substring(pos += 10, endPos);
                    report.getEngine().anchorsArguments.put(comp.getName(), args);
                    eh = new StiEventHandlerListener(){

                        public void invoke(StiEventObject myEvent) {
                            StiRenderProviderV2.StiRenderProviderV2_AddAnchor_Rendering(myEvent.getSource(), myEvent.getArgs());
                        }
                    };
                    ((StiDataBand)comp).handlerRendering.add(eh);
                    eventsHandlers.put(comp, eh);
                }
                if (!(comp instanceof StiPage) || ((StiPage)comp).getRenderingEvent() == null || StiValidationUtil.isNullOrEmpty((String)((StiPage)comp).getRenderingEvent().getScript()) || (pos = (eventText = ((StiPage)comp).getRenderingEvent().getScript()).indexOf("AddAnchor(")) == -1 || (endPos = eventText.indexOf(")", pos)) == -1) continue;
                args = eventText.substring(pos += 10, endPos);
                report.getEngine().anchorsArguments.put(comp.getName(), args);
                eh = new StiEventHandlerListener(){

                    public void invoke(StiEventObject myEvent) {
                        StiRenderProviderV2.StiRenderProviderV2_AddAnchor_Rendering(myEvent.getSource(), myEvent.getArgs());
                    }
                };
                ((StiPage)comp).handlerRendering.add(eh);
                eventsHandlers.put(comp, eh);
            }
            StiRenderProviderV2.RenderReport(report, masterReport, state);
            if (!report.getStop() && !report.getStop()) {
                StiRenderProviderV2.RenderFormsOnEnd(report);
                report.isRendered = true;
            }
            if (newTableComponents.size() > 0) {
                for (StiPage pageKey : newTableComponents.keySet()) {
                    ArrayList list = newTableComponents.get(pageKey) instanceof ArrayList ? (ArrayList)newTableComponents.get(pageKey) : null;
                    for (int indexComp = 0; indexComp < list.size(); ++indexComp) {
                        StiComponent comp = list.get(indexComp) instanceof StiComponent ? list.get(indexComp) : null;
                        if (comp.parent == null) continue;
                        comp.parent.components.remove(comp);
                    }
                }
            }
            for (StiTable table : listTable) {
                table.setEnabled(true);
            }
        }
        catch (RuntimeException e) {
            try {
                report.isStopped = true;
                if (!StiOptions.Engine.getHideExceptions()) {
                    // empty if block
                }
                throw e;
            }
            catch (Throwable throwable) {
                StiRenderProviderV2.FinishProgressForm(report);
                report.currentPage = 0;
                if (masterReport == null) {
                    report.currentPrintPage = 0;
                }
                if (masterReport == null && report.reportPass != StiReportPass.First) {
                    if (!report.getRenderedPages().getCacheMode()) {
                        StiPostProcessProviderV2.PostProcessPages(report.getRenderedPages());
                    } else if (report.getRenderedPages().NotCachedPages != null) {
                        int index = 0;
                        for (StiPage page : report.getRenderedPages().NotCachedPages) {
                            StiPostProcessProviderV2.PostProcessPage(page, false, index == report.getRenderedPages().NotCachedPages.size() - 1);
                            ++index;
                        }
                    }
                }
                StiRenderProviderV2.FinishAllPagesInNotCachedPagesArray(report);
                StiRenderProviderV2.RemoveAllPagesLessThenFromPageAndGreaterThenToPage(report, state);
                StiRenderProviderV2.MadeCollate(report);
                StiRenderProviderV2.MadeMirrorMargins(report);
                StiBookmarksV2Helper.PrepareBookmark(report.getBookmark());
                StiBookmarksV2Helper.Pack(report.getBookmark());
                StiRenderProviderV2.DisconnectFromData(report);
                if (masterReport == null) {
                    if (report.getRenderedPages().size() == 0) {
                        StiPage page = new StiPage(report);
                        page.setName("PageEmpty");
                        report.getRenderedPages().add(page);
                    }
                    report.engine.pageNumbers.ProcessPageNumbers();
                    report.InvokeEndRender();
                    report.engine.pageNumbers.clear();
                    if (!report.getRenderedPages().getCacheMode()) {
                        for (StiPage page : report.getRenderedPages()) {
                            StiComponentsCollection components = page.GetComponents();
                            for (StiComponent component : components) {
                                StiContainer cont = (StiContainer)(component instanceof StiContainer ? component : null);
                                if (cont == null || cont.getContainerInfoV2() == null || cont.getContainerInfoV2().DataSourceRow == null) continue;
                                cont.getContainerInfoV2().DataSourceRow = null;
                            }
                        }
                    }
                }
                newTableComponents = null;
                if (masterReport != null || report.getReportPass() != StiReportPass.First) {
                    // empty if block
                }
                if (report.getReportPass() == StiReportPass.Second) {
                    report.reportPass = StiReportPass.None;
                }
                if (masterReport == null) {
                    StiRenderProviderV2.ClearTotals(report);
                    if (report.getReportPass() != StiReportPass.First) {
                        report.parentReport = null;
                    }
                }
                StiComponentsCollection comps = report.getComponents();
                for (StiComponent comp : comps) {
                    comp.UnPrepare();
                }
                throw throwable;
            }
        }
        StiRenderProviderV2.FinishProgressForm(report);
        report.currentPage = 0;
        if (masterReport == null) {
            report.currentPrintPage = 0;
        }
        if (masterReport == null && report.reportPass != StiReportPass.First) {
            if (!report.getRenderedPages().getCacheMode()) {
                StiPostProcessProviderV2.PostProcessPages(report.getRenderedPages());
            } else if (report.getRenderedPages().NotCachedPages != null) {
                int index = 0;
                for (StiPage page : report.getRenderedPages().NotCachedPages) {
                    StiPostProcessProviderV2.PostProcessPage(page, false, index == report.getRenderedPages().NotCachedPages.size() - 1);
                    ++index;
                }
            }
        }
        StiRenderProviderV2.FinishAllPagesInNotCachedPagesArray(report);
        StiRenderProviderV2.RemoveAllPagesLessThenFromPageAndGreaterThenToPage(report, state);
        StiRenderProviderV2.MadeCollate(report);
        StiRenderProviderV2.MadeMirrorMargins(report);
        StiBookmarksV2Helper.PrepareBookmark(report.getBookmark());
        StiBookmarksV2Helper.Pack(report.getBookmark());
        StiRenderProviderV2.DisconnectFromData(report);
        if (masterReport == null) {
            if (report.getRenderedPages().size() == 0) {
                StiPage page = new StiPage(report);
                page.setName("PageEmpty");
                report.getRenderedPages().add(page);
            }
            report.engine.pageNumbers.ProcessPageNumbers();
            report.InvokeEndRender();
            report.engine.pageNumbers.clear();
            if (!report.getRenderedPages().getCacheMode()) {
                for (StiPage page : report.getRenderedPages()) {
                    StiComponentsCollection components = page.GetComponents();
                    for (StiComponent component : components) {
                        StiContainer cont = (StiContainer)(component instanceof StiContainer ? component : null);
                        if (cont == null || cont.getContainerInfoV2() == null || cont.getContainerInfoV2().DataSourceRow == null) continue;
                        cont.getContainerInfoV2().DataSourceRow = null;
                    }
                }
            }
        }
        newTableComponents = null;
        if (masterReport != null || report.getReportPass() != StiReportPass.First) {
            // empty if block
        }
        if (report.getReportPass() == StiReportPass.Second) {
            report.reportPass = StiReportPass.None;
        }
        if (masterReport == null) {
            StiRenderProviderV2.ClearTotals(report);
            if (report.getReportPass() != StiReportPass.First) {
                report.parentReport = null;
            }
        }
        StiComponentsCollection comps = report.getComponents();
        for (StiComponent comp : comps) {
            comp.UnPrepare();
        }
    }

    static void StiRenderProviderV2_AddAnchor_Rendering(Object sender, StiEventHandlerArgs e) {
        StiContainer comp;
        StiContainer stiContainer = comp = sender instanceof StiContainer ? (StiContainer)sender : null;
        if (comp == null || comp.getReport() == null || comp.getReport().getEngine() == null || !comp.getReport().getEngine().anchorsArguments.containsKey(comp.getName())) {
            return;
        }
        String arg = comp.getReport().getEngine().anchorsArguments.get(comp.getName());
        if (StiValidationUtil.isNullOrEmpty((String)arg)) {
            return;
        }
        StiText tempText = new StiText();
        tempText.setName("**AddAnchor**");
        tempText.setPage((StiPage)comp.getReport().getPages().get(0));
        Object result = StiParser.ParseTextValue("{" + arg + "}", (StiComponent)tempText);
        comp.getReport().addAnchor(result);
    }

    private static void RenderFormsOnEnd(StiReport report) {
    }

    private static boolean RenderFormsOnStart(StiReport report) {
        return false;
    }

    private static void ConnectToData(StiReport report) {
        report.dictionary.connect();
        Iterator i$ = report.dictionary.dataSources.iterator();
        while (i$.hasNext()) {
            StiSqlSource sqlSource;
            StiDataSource dataSource = (StiDataSource)i$.next();
            dataSource.ResetData();
            dataSource.ResetDetailsRows();
            if (!StiOptions.Dictionary.getEnableConnectOnStartOnSecondPass() || (sqlSource = (StiSqlSource)(dataSource instanceof StiSqlSource ? dataSource : null)) == null) continue;
            sqlSource.connectOnStart = true;
        }
        report.dictionary.ConnectVirtualDataSources();
        report.dictionary.ConnectCrossTabDataSources();
        report.dictionary.RegRelations(true);
    }

    private static void DisconnectFromData(StiReport report) {
        report.dictionary.Disconnect();
    }

    private static boolean IsDialogsOnStartExist(StiReport report) {
        for (StiPage page : report.pages) {
            StiForm stiForm = (StiForm)(page instanceof StiForm ? page : null);
        }
        return false;
    }

    public static void ClearPagesWhichLessThenFromPageAndGreaterThenToPage(StiReport report, StiRenderState state) {
        if (report.getRenderedPages().size() > 1 && report.reportPass != StiReportPass.First) {
            int indexLastPage = report.getRenderedPages().size() - 2;
            if (state.getFromPage() > 0 && state.getFromPage() > indexLastPage || state.getToPage() > 0 && state.getToPage() < indexLastPage) {
                ((StiPage)report.getRenderedPages().get((int)indexLastPage)).components.clear();
            }
            if (state.getToPage() > 0 && state.getToPage() < indexLastPage && state.getRenderOnlyPagesFromRange()) {
                report.isStopped = true;
            }
        }
    }

    private static void InitCacheMode(StiReport report) {
        if (report.getReportCacheMode() != StiReportCacheMode.Off) {
            report.getRenderedPages().cacheMode = report.reportCacheMode == StiReportCacheMode.On;
            report.getRenderedPages().canUseCacheMode = true;
            EngineOptions.GlobalEvents.InvokeReportCacheCreated(report, StiEventHandlerArgs.Empty);
        }
    }

    private static void RemoveAllPagesLessThenFromPageAndGreaterThenToPage(StiReport report, StiRenderState state) {
        if (state.getDestroyPagesWhichNotInRange() && report.getReportPass() != StiReportPass.First) {
            if (state.getToPage() > 0) {
                while (state.getToPage() < report.getRenderedPages().size() - 1) {
                    report.getRenderedPages().remove(report.getRenderedPages().size() - 1);
                }
            }
            for (int fromPage = state.getFromPage(); fromPage > 0 && report.getRenderedPages().size() > 0; --fromPage) {
                report.getRenderedPages().remove(0);
            }
        }
    }

    private static void FinishAllPagesInNotCachedPagesArray(StiReport report) {
        if (report.getRenderedPages().getCacheMode() && report.getRenderedPages().NotCachedPages() != null && report.reportPass != StiReportPass.First) {
            report.getRenderedPages().NotCachedPages.clear();
            report.getRenderedPages().NotCachedPages = null;
        }
    }

    public static void ProcessPageToCache(StiReport report, StiPage page, boolean isFinal) {
        if (report.getRenderedPages().getCacheMode() && report.reportPass != StiReportPass.First) {
            if (report.getRenderedPages().NotCachedPages == null) {
                report.getRenderedPages().NotCachedPages = new StiPagesCollection();
            }
            if (report.getRenderedPages().NotCachedPages.indexOf(page) == -1) {
                report.getRenderedPages().NotCachedPages.add(page);
            }
            StiPostProcessProviderV2.PostProcessPage(page, report.getPageNumber() == 1, true, isFinal);
            if (isFinal) {
                StiPostProcessProviderV2.PostProcessPrimitives(page);
            }
        }
    }

    private static void RenderFirstPass(StiReport report, StiNumberOfPass numberOfPass) {
        if (numberOfPass == StiNumberOfPass.DoublePass && report.reportPass == StiReportPass.None) {
            report.reportPass = StiReportPass.First;
            StiEngine storedEngine = report.engine;
            report.engine = null;
            int pagesCounter = report.getRenderedPages().size();
            StiPagesCollection pagesStore = null;
            if (pagesCounter > 0) {
                pagesStore = new StiPagesCollection(report);
                pagesStore.addAll(report.getRenderedPages());
                StiPage tempPage = new StiPage(report);
                for (int index = 0; index < report.getRenderedPages().size(); ++index) {
                    report.getRenderedPages().add(index, tempPage);
                }
            }
            int storedCurrentPrintPage = report.getCurrentPrintPage();
            StiEngine tempEngine = new StiEngine(report);
            tempEngine.getPageNumbers().setClearPageNumbersOnFinish(false);
            tempEngine.getPageNumbers().setPageNumbers(storedEngine.getPageNumbers().getPageNumbers());
            tempEngine.setparserConversionStore((Hashtable)storedEngine.getparserConversionStore().clone());
            report.engine = tempEngine;
            report.Render();
            report.engine = storedEngine;
            tempEngine.setparserConversionStore(null);
            report.engine.pageNumbers.ProcessPageNumbers();
            report.reportPass = StiReportPass.Second;
            report.isRendering = true;
            report.isRendered = false;
            report.getRenderedPages().clear();
            if (pagesCounter > 0) {
                report.getRenderedPages().AddRange(pagesStore);
                pagesStore.clear();
            }
            report.currentPrintPage = storedCurrentPrintPage;
        }
        report.ResetAggregateFunctions();
    }

    public static void ClearPagesForFirstPass(StiReport report) {
        if (report.reportPass == StiReportPass.First && report.getRenderedPages().size() >= 2) {
            ((StiPage)report.getRenderedPages().get((int)(report.getRenderedPages().size() - 2))).components.clear();
        }
    }

    private static StiNumberOfPass GetNumberOfPass(StiReport report) {
        StiNumberOfPass numberOfPass = report.getNumberOfPass();
        if (report.reportPass == StiReportPass.None && numberOfPass == StiNumberOfPass.SinglePass) {
            if (!StiOptions.Engine.getUseAdvancedPrintOnEngineV2()) {
                return StiNumberOfPass.SinglePass;
            }
            StiComponentsCollection comps = report.getComponents();
            for (StiComponent comp : comps) {
                if (comp.getPrintOn() == StiPrintOnType.AllPages || comp.getPrintOn() == StiPrintOnType.OnlyFirstPage || comp.getPrintOn() == StiPrintOnType.ExceptFirstPage) continue;
                return StiNumberOfPass.DoublePass;
            }
        }
        return numberOfPass;
    }

    private static void MadeCollate(StiReport report) {
        if (report.getRenderedPages().size() < 3 || report.getCollate() < 2) {
            return;
        }
        ArrayList list = new ArrayList();
        if (StiOptions.Engine.getUseCollateOldMode()) {
            for (int index = 0; index < report.getCollate(); ++index) {
                for (int pageIndex = index; pageIndex < report.getRenderedPages().size(); pageIndex += report.getCollate()) {
                    list.add(report.getRenderedPages().get(pageIndex));
                }
            }
        } else {
            int range = report.getRenderedPages().size() / report.getCollate();
            if (range * report.getCollate() < report.getRenderedPages().size()) {
                ++range;
            }
            for (int index = 0; index < range; ++index) {
                for (int pageIndex = index; pageIndex < report.getRenderedPages().size(); pageIndex += range) {
                    list.add(report.getRenderedPages().get(pageIndex));
                }
            }
        }
        report.getRenderedPages().clear();
        for (StiPage page : list) {
            report.getRenderedPages().add(page);
        }
    }

    private static void MadeMirrorMargins(StiReport report) {
        if (report.getRenderedPages().size() < 2) {
            return;
        }
        for (int index = 1; index < report.getRenderedPages().size(); index += 2) {
            StiPage page = (StiPage)report.getRenderedPages().get(index);
            if (!page.getMirrorMargins().booleanValue()) continue;
            page.setMargins(new StiMargins(page.getMargins().getRight(), page.getMargins().getLeft(), page.getMargins().getTop(), page.getMargins().getBottom()));
        }
    }

    private static void InitReport(StiReport report) {
        report.currentPage = 0;
        if (report.SubReportsMasterReport == null) {
            report.currentPrintPage = 0;
        }
        report.stop = false;
        report.ResetAggregateFunctions();
    }

    private static void ClearTotals(StiReport report) {
        report.getTotals().clear();
        if (report.parentReport != null) {
            report.parentReport.getTotals().clear();
        }
    }

    private static Hashtable PrepareSubReportsAndDrillDownPages(StiReport report) {
        Hashtable<String, StiPage> guidToPage = new Hashtable<String, StiPage>();
        StiComponentsCollection comps = report.getComponents();
        for (StiPage page : report.pages) {
            page.skip = false;
            guidToPage.put(page.getGuid(), page);
        }
        block1: for (StiComponent comp : comps) {
            StiPage pg;
            StiSubReport subReport = (StiSubReport)(comp instanceof StiSubReport ? comp : null);
            if (subReport != null && subReport.subReportPageGuid != null && (pg = (StiPage)(guidToPage.get(subReport.subReportPageGuid) instanceof StiPage ? guidToPage.get(subReport.subReportPageGuid) : null)) != null) {
                pg.skip = true;
            }
            if (comp.interaction != null && comp.interaction.drillDownPageGuid != null && (pg = (StiPage)(guidToPage.get(comp.interaction.drillDownPageGuid) instanceof StiPage ? guidToPage.get(comp.interaction.drillDownPageGuid) : null)) != null && !pg.drillDownPageGuid) {
                pg.skip = true;
            }
            if (!(comp instanceof StiChart)) continue;
            for (IStiSeries series : ((StiChart)comp).getSeries()) {
                if (series.getInteraction() == null || ((StiSeriesInteraction)series.getInteraction()).getDrillDownPageGuid() == null) continue;
                StiPage pg2 = guidToPage.get(((StiSeriesInteraction)series.getInteraction()).getDrillDownPageGuid()) instanceof StiPage ? guidToPage.get(((StiSeriesInteraction)series.getInteraction()).getDrillDownPageGuid()) : null;
                if (pg2 == null) continue block1;
                pg2.skip = true;
                continue block1;
            }
        }
        return guidToPage;
    }

    private static void RenderReport(StiReport report, StiReport masterReport, StiRenderState state) {
        try {
            int pageIndex = 0;
            for (StiPage page : report.pages) {
                try {
                    report.engine.templatePage = page;
                    report.engine.templateContainer = page;
                    ++report.currentPrintPage;
                    page.InvokeBeforePrint(page, StiEventHandlerArgs.Empty);
                    report.engine.skipFirstPageBeforePrintEvent = true;
                    --report.currentPrintPage;
                    if (!page.getEnabled() || page.skip) {
                        report.engine.skipFirstPageBeforePrintEvent = false;
                        page.InvokeAfterPrint(page, StiEventHandlerArgs.Empty);
                        continue;
                    }
                    if (report.engine.masterEngine != null) {
                        report.engine.masterEngine.templatePage = page;
                        report.engine.masterEngine.templateContainer = page;
                    }
                    for (int indexPage = 0; indexPage < page.getNumberOfCopies(); ++indexPage) {
                        if (indexPage > 0) {
                            page.pageInfoV2.RenderedCount = 0;
                        }
                        page.pageInfoV2.IndexOfStartRenderedPages = report.getRenderedPages().size();
                        StiPageHelper.PrepareBookmark(page);
                        if (report.getRenderedPages().size() == 0 || !page.getPrintOnPreviousPage()) {
                            report.engine.FirstCallNewPage = true;
                            report.engine.NewPage();
                        } else if (page.getPrintOnPreviousPage() && pageIndex != 0) {
                            StiPage mainPage = (StiPage)report.getRenderedPages().get(report.getRenderedPages().size() - 1);
                            StiComponent cont = null;
                            String str = "TAG##" + report.engine.getColumnsOnPanel().currentColumn;
                            for (StiComponent comp : mainPage.components) {
                                if (!str.equals(comp.getName())) continue;
                                cont = (StiContainer)(comp instanceof StiContainer ? comp : null);
                            }
                            if (cont != null) {
                                cont.setHeight(report.engine.getPositionY() - ((StiContainer)cont).top);
                            } else {
                                StiContainer tagMainContainer = new StiContainer();
                                tagMainContainer.setName("TAG##" + report.engine.columnsOnPanel.currentColumn);
                                tagMainContainer.top = 0.0;
                                tagMainContainer.setHeight(report.engine.getPositionY());
                                tagMainContainer.setLeft((double)(report.engine.columnsOnPanel.currentColumn - 1) * mainPage.getColumnWidthM());
                                tagMainContainer.setWidth(mainPage.getColumns() > 0 ? mainPage.getColumnWidthM() : mainPage.getWidth());
                                tagMainContainer.setTagValue(mainPage.getTagValue());
                                tagMainContainer.setBookmarkValue(mainPage.getBookmarkValue());
                                tagMainContainer.setHyperlinkValue(mainPage.getHyperlinkValue());
                                tagMainContainer.setToolTipValue(mainPage.getToolTipValue());
                                tagMainContainer.setGuid(mainPage.getGuid());
                                mainPage.setTagValue(null);
                                mainPage.setBookmarkValue(null);
                                mainPage.setHyperlinkValue(null);
                                mainPage.setToolTipValue(null);
                                mainPage.setGuid(null);
                                report.engine.AddContainerToDestination(tagMainContainer);
                            }
                            StiContainer tagContainer = new StiContainer();
                            tagContainer.setName("TAG##" + report.engine.columnsOnPanel.currentColumn);
                            tagContainer.top = report.engine.getPositionY();
                            tagContainer.setHeight(report.engine.positionBottomY - report.engine.getPositionY());
                            tagContainer.setLeft((double)(report.engine.columnsOnPanel.currentColumn - 1) * page.getColumnWidthM());
                            tagContainer.setWidth(page.getColumns() > 0 ? page.getColumnWidthM() : page.getWidth());
                            tagContainer.setTagValue(page.getTagValue());
                            tagContainer.setBookmarkValue(page.getBookmarkValue());
                            tagContainer.setHyperlinkValue(page.getHyperlinkValue());
                            tagContainer.setToolTipValue(page.getToolTipValue());
                            tagContainer.setGuid(page.getGuid());
                            page.setTagValue(null);
                            page.setBookmarkValue(null);
                            page.setHyperlinkValue(null);
                            page.setToolTipValue(null);
                            report.engine.AddContainerToDestination(tagContainer);
                        }
                        StiPageHelper.RenderPage(page);
                    }
                }
                catch (StiStopBeforePrintException e) {
                    // empty catch block
                }
                report.engine.ProcessLastPageAfterRendering();
                StiContainer tempCont = null;
                report.engine.RenderFootersOnAllPages(null, 0, tempCont);
                report.engine.RenderPrintAtBottom(null, 0, null);
                report.engine.RenderEmptyBands(report.engine.containerForRender, null);
                report.engine.emptyBands.Clear();
                ++pageIndex;
            }
            report.engine.InvokePageAfterPrint();
            StiRenderProviderV2.RenderTable(report);
            report.engine.FinalClear();
        }
        catch (StiReportRenderingStopException e2) {
        }
        catch (StiStopBeforePageException e3) {
            report.engine.pageNumbers.pageNumbers.remove(report.engine.pageNumbers.pageNumbers.size() - 1);
        }
    }

    private static void RenderTable(StiReport report) {
        if (!report.containsTables) {
            return;
        }
        Hashtable ReportPageCollection = new Hashtable();
        Hashtable<Object, StiColumnSize> ReportHashWidths = new Hashtable<Object, StiColumnSize>();
        Hashtable ReportPageListForTalbes = new Hashtable();
        ArrayList<StiTable> ReportTableList = new ArrayList<StiTable>();
        StiGraphics g = null;
        double GridSize = 0.2;
        for (StiPage page : report.getRenderedPages()) {
            GridSize = page.getGridSize();
            Hashtable PageCollection = new Hashtable();
            Hashtable<Object, StiColumnSize> HashWidths = new Hashtable<Object, StiColumnSize>();
            ArrayList<StiTable> TableList = new ArrayList<StiTable>();
            g = page.getMeasureGraphics();
            StiComponentsCollection coll = page.GetComponents();
            for (int indexEl = 0; indexEl < coll.size(); ++indexEl) {
                IStiTableCell cell = (IStiTableCell)((Object)(coll.get(indexEl) instanceof IStiTableCell ? (StiComponent)coll.get(indexEl) : null));
                if (cell == null) continue;
                Hashtable tableCollection = null;
                StiTable table = (StiTable)(cell.getTableTag() instanceof StiTable ? cell.getTableTag() : null);
                if (table.getAutoWidth() == StiTableAutoWidth.None) continue;
                if (table.getAutoWidth() == StiTableAutoWidth.Table) {
                    if (!ReportPageCollection.containsKey(table)) {
                        tableCollection = new Hashtable();
                        ReportPageCollection.put(table, tableCollection);
                        ReportTableList.add(table);
                    } else {
                        Hashtable hashtable = tableCollection = ReportPageCollection.get(table) instanceof Hashtable ? (Hashtable)ReportPageCollection.get(table) : null;
                    }
                    if (!ReportPageListForTalbes.containsKey(table.getName())) {
                        ArrayList<StiPage> pagesForTableCollection = new ArrayList<StiPage>();
                        pagesForTableCollection.add(page);
                        ReportPageListForTalbes.put(table.getName(), pagesForTableCollection);
                    } else if (!((ArrayList)ReportPageListForTalbes.get(table.getName())).contains(page)) {
                        ((ArrayList)ReportPageListForTalbes.get(table.getName())).add(page);
                    }
                } else if (!PageCollection.containsKey(table)) {
                    tableCollection = new Hashtable();
                    PageCollection.put(table, tableCollection);
                    TableList.add(table);
                } else {
                    Hashtable hashtable = tableCollection = PageCollection.get(table) instanceof Hashtable ? (Hashtable)PageCollection.get(table) : null;
                }
                if (!tableCollection.containsKey(cell.getColumn())) {
                    ArrayList array = new ArrayList();
                    tableCollection.put(cell.getColumn(), array);
                }
                ((ArrayList)tableCollection.get(cell.getColumn())).add(cell);
            }
            for (Hashtable hashTable : PageCollection.values()) {
                StiColumnSize widths = new StiColumnSize(hashTable.size());
                for (int indexCol = 0; indexCol < hashTable.size(); ++indexCol) {
                    ArrayList list = hashTable.get(indexCol) instanceof ArrayList ? hashTable.get(indexCol) : null;
                    if (list == null) continue;
                    double maxWidth = 0.0;
                    for (StiComponent comp : list) {
                        if (((IStiTableCell)((Object)comp)).getFixedWidth()) {
                            widths.SetFixedColumn(indexCol, comp.getWidth());
                            maxWidth = -1.0;
                            break;
                        }
                        switch (((IStiTableCell)((Object)comp)).getCellType()) {
                            case CheckBox: 
                            case RichText: {
                                if (!(comp.getWidth() > maxWidth)) break;
                                maxWidth = comp.getWidth();
                                break;
                            }
                            case Image: {
                                StiTableCellImage image = (StiTableCellImage)(comp instanceof StiTableCellImage ? comp : null);
                                boolean canShrink = image.getCanShrink();
                                image.canShrink = true;
                                double imageWidth = image.getRealSize().getWidth();
                                image.canShrink = canShrink;
                                if (!(imageWidth > maxWidth)) break;
                                maxWidth = imageWidth;
                                break;
                            }
                            case Text: {
                                StiTableCell cellText = (StiTableCell)(comp instanceof StiTableCell ? comp : null);
                                if (cellText.getWordWrap()) {
                                    if (!(cellText.getWidth() > maxWidth)) break;
                                    maxWidth = cellText.getWidth();
                                    break;
                                }
                                if (cellText.text.getValue() == null || cellText.text.getValue().length() == 0) break;
                                StiSize size = cellText.measureString();
                                double lengthMargin = cellText.getMargins().getLeft() + cellText.getMargins().getRight();
                                double cellTextWidth = (double)Math.round(report.getUnit().ConvertFromHInches(size.width + lengthMargin) * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
                                if (!(cellTextWidth > maxWidth)) break;
                                maxWidth = cellTextWidth;
                            }
                        }
                    }
                    if (maxWidth == -1.0) continue;
                    widths.SetWidth(indexCol, maxWidth);
                }
                ArrayList _list = hashTable.get(0) instanceof ArrayList ? hashTable.get(0) : null;
                HashWidths.put(((IStiTableCell)_list.get(0)).getTableTag(), widths);
            }
            block25: for (int indexKey = 0; indexKey < TableList.size(); ++indexKey) {
                StiTable table = TableList.get(indexKey) instanceof StiTable ? TableList.get(indexKey) : null;
                if (table == null) continue;
                StiColumnSize tableWidths = (StiColumnSize)HashWidths.get(table);
                double sumWidth = 0.0;
                for (int indexWidth = 0; indexWidth < tableWidths.getLength(); ++indexWidth) {
                    sumWidth += tableWidths.GetWidth(indexWidth);
                }
                switch (table.getAutoWidthType()) {
                    case None: {
                        if (!(page.getWidth() < sumWidth)) continue block25;
                        int segmentCount = (int)(sumWidth / page.getWidth()) + 1;
                        page.segmentPerWidth = segmentCount;
                        continue block25;
                    }
                    case FullTable: {
                        int index;
                        if (sumWidth < table.getWidth()) {
                            double rest2 = table.getWidth() - sumWidth;
                            rest2 /= (double)tableWidths.GetCountNotFixedColumn();
                            for (index = 0; index < tableWidths.getLength(); ++index) {
                                tableWidths.Add(index, rest2);
                            }
                        }
                        if (!(sumWidth > table.getWidth())) continue block25;
                        double rest3 = sumWidth - table.getWidth();
                        rest3 /= (double)tableWidths.GetCountNotFixedColumn();
                        for (index = 0; index < tableWidths.getLength(); ++index) {
                            tableWidths.Subtract(index, rest3);
                        }
                        continue block25;
                    }
                    case LastColumns: {
                        double rest = Math.abs(table.getWidth() - sumWidth);
                        int numberColumn = tableWidths.getLength() - 1;
                        boolean finish = false;
                        double minSizeCell = GridSize * 3.0;
                        if (sumWidth > table.getWidth()) {
                            while (!finish) {
                                if (tableWidths.GetFixed(numberColumn)) {
                                    if (numberColumn == 0) {
                                        finish = true;
                                        continue;
                                    }
                                    --numberColumn;
                                    continue;
                                }
                                if (tableWidths.GetWidth(numberColumn) - minSizeCell < rest) {
                                    double widthREST = tableWidths.GetWidth(numberColumn) - minSizeCell;
                                    tableWidths.Subtract(numberColumn, widthREST);
                                    rest -= widthREST;
                                    if (numberColumn == 0) {
                                        finish = true;
                                        continue;
                                    }
                                    --numberColumn;
                                    continue;
                                }
                                tableWidths.Subtract(numberColumn, rest);
                                finish = true;
                            }
                            continue block25;
                        }
                        tableWidths.AddLastNotFixed(rest);
                    }
                }
            }
            for (Object key : PageCollection.keySet()) {
                Hashtable hashTable = PageCollection.get(key) instanceof Hashtable ? (Hashtable)PageCollection.get(key) : null;
                StiColumnSize widths = (StiColumnSize)HashWidths.get(key);
                double posX = 0.0;
                for (int indexCol = 0; indexCol < hashTable.size(); ++indexCol) {
                    ArrayList list = hashTable.get(indexCol) instanceof ArrayList ? hashTable.get(indexCol) : null;
                    if (list == null) {
                        return;
                    }
                    for (StiComponent comp : list) {
                        comp.setWidth(widths.GetWidth(indexCol));
                        comp.setLeft(posX);
                    }
                    posX += widths.GetWidth(indexCol);
                }
            }
        }
        if (ReportTableList.size() > 0) {
            for (Hashtable hashTable : ReportPageCollection.values()) {
                StiColumnSize widths = new StiColumnSize(hashTable.size());
                for (int indexCol = 0; indexCol < hashTable.size(); ++indexCol) {
                    ArrayList list = hashTable.get(indexCol) instanceof ArrayList ? hashTable.get(indexCol) : null;
                    if (list == null) continue;
                    double maxWidth = 0.0;
                    for (StiComponent comp : list) {
                        if (((IStiTableCell)((Object)comp)).getFixedWidth()) {
                            widths.SetFixedColumn(indexCol, comp.getWidth());
                            maxWidth = -1.0;
                            break;
                        }
                        switch (((IStiTableCell)((Object)comp)).getCellType()) {
                            case CheckBox: 
                            case RichText: {
                                if (!(comp.getWidth() > maxWidth)) break;
                                maxWidth = comp.getWidth();
                                break;
                            }
                            case Image: {
                                StiTableCellImage image = (StiTableCellImage)(comp instanceof StiTableCellImage ? comp : null);
                                boolean canShrink = image.getCanShrink();
                                image.canShrink = true;
                                double imageWidth = image.getRealSize().getWidth();
                                image.canShrink = canShrink;
                                if (!(imageWidth > maxWidth)) break;
                                maxWidth = imageWidth;
                                break;
                            }
                            case Text: {
                                StiTableCell cellText = (StiTableCell)(comp instanceof StiTableCell ? comp : null);
                                if (cellText.getWordWrap()) {
                                    if (!(cellText.getWidth() > maxWidth)) break;
                                    maxWidth = cellText.getWidth();
                                    break;
                                }
                                if (cellText.text.getValue() == null || cellText.text.getValue().length() == 0) break;
                                StiSize size = StiTextUtil.measureString((StiFont)cellText.font, (String)cellText.text.getValue());
                                double lengthMargin = cellText.getMargins().getLeft() + cellText.getMargins().getRight();
                                double cellTextWidth = (double)Math.round(report.getUnit().ConvertFromHInches(size.width + lengthMargin) * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
                                if (!(cellTextWidth > maxWidth)) break;
                                maxWidth = cellTextWidth;
                            }
                        }
                    }
                    if (maxWidth == -1.0) continue;
                    widths.SetWidth(indexCol, maxWidth);
                }
                ArrayList _list = hashTable.get(0) instanceof ArrayList ? hashTable.get(0) : null;
                ReportHashWidths.put(((IStiTableCell)_list.get(0)).getTableTag(), widths);
            }
            block36: for (int indexKey = 0; indexKey < ReportTableList.size(); ++indexKey) {
                StiTable table = ReportTableList.get(indexKey) instanceof StiTable ? ReportTableList.get(indexKey) : null;
                if (table == null) continue;
                StiColumnSize tableWidths = (StiColumnSize)ReportHashWidths.get(table);
                double sumWidth = 0.0;
                for (int indexWidth = 0; indexWidth < tableWidths.getLength(); ++indexWidth) {
                    sumWidth += tableWidths.GetWidth(indexWidth);
                }
                switch (table.autoWidthType) {
                    case None: {
                        ArrayList tablePages = ReportPageListForTalbes.get(table.getName()) instanceof ArrayList ? ReportPageListForTalbes.get(table.getName()) : null;
                        if (tablePages == null || !(((StiPage)tablePages.get(0)).getWidth() < sumWidth)) continue block36;
                        int segmentCount = (int)(sumWidth / ((StiPage)tablePages.get(0)).getWidth()) + 1;
                        for (StiPage tablePage : tablePages) {
                            tablePage.segmentPerWidth = segmentCount;
                        }
                        continue block36;
                    }
                    case FullTable: {
                        int index;
                        if (sumWidth < table.getWidth()) {
                            double rest2 = table.getWidth() - sumWidth;
                            rest2 /= (double)tableWidths.GetCountNotFixedColumn();
                            for (index = 0; index < tableWidths.getLength(); ++index) {
                                tableWidths.Add(index, rest2);
                            }
                        }
                        if (!(sumWidth > table.getWidth())) continue block36;
                        double rest3 = sumWidth - table.getWidth();
                        rest3 /= (double)tableWidths.GetCountNotFixedColumn();
                        for (index = 0; index < tableWidths.getLength(); ++index) {
                            tableWidths.Subtract(index, rest3);
                        }
                        continue block36;
                    }
                    case LastColumns: {
                        double rest = Math.abs(table.getWidth() - sumWidth);
                        int numberColumn = tableWidths.getLength() - 1;
                        boolean finish = false;
                        double minSizeCell = GridSize * 3.0;
                        if (sumWidth > table.getWidth()) {
                            while (!finish) {
                                if (tableWidths.GetFixed(numberColumn)) {
                                    if (numberColumn == 0) {
                                        finish = true;
                                        continue;
                                    }
                                    --numberColumn;
                                    continue;
                                }
                                if (tableWidths.GetWidth(numberColumn) - minSizeCell < rest) {
                                    double widthREST = tableWidths.GetWidth(numberColumn) - minSizeCell;
                                    tableWidths.Subtract(numberColumn, widthREST);
                                    rest -= widthREST;
                                    if (numberColumn == 0) {
                                        finish = true;
                                        continue;
                                    }
                                    --numberColumn;
                                    continue;
                                }
                                tableWidths.Subtract(numberColumn, rest);
                                finish = true;
                            }
                            continue block36;
                        }
                        tableWidths.AddLastNotFixed(rest);
                    }
                }
            }
            for (Object key : ReportPageCollection.keySet()) {
                Hashtable hashTable = ReportPageCollection.get(key) instanceof Hashtable ? (Hashtable)ReportPageCollection.get(key) : null;
                StiColumnSize widths = (StiColumnSize)ReportHashWidths.get(key);
                double posX = 0.0;
                for (int indexCol = 0; indexCol < hashTable.size(); ++indexCol) {
                    ArrayList list = hashTable.get(indexCol) instanceof ArrayList ? hashTable.get(indexCol) : null;
                    if (list == null) {
                        return;
                    }
                    for (StiComponent comp : list) {
                        comp.setWidth(widths.GetWidth(indexCol));
                        comp.setLeft(posX);
                    }
                    posX += widths.GetWidth(indexCol);
                }
            }
        }
    }

    private static void FinishProgressForm(StiReport report) {
        if (report.isShowProgress() && report.getReportPass() != StiReportPass.First) {
            if (StiLocalization.getLocalization().getCultureName().equals("en")) {
                report.setStatusString("Finishing Report");
            } else {
                report.setStatusString(StiLocalization.getValue((String)"Report", (String)"FinishingReport"));
            }
            if (report.progress != null) {
                report.progress.hideProgressBar();
            }
            if (report.progress != null) {
                report.progress.setAllowClose(false);
            }
        }
    }
}

