/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiCrossHeaderInteraction;
import com.stimulsoft.report.components.StiFilterHelper;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.crossTab.StiCrossColumn;
import com.stimulsoft.report.crossTab.StiCrossHeader;
import com.stimulsoft.report.crossTab.StiCrossRow;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.crossTab.StiCrossTabHelper;
import com.stimulsoft.report.crossTab.StiCrossTabParams;
import com.stimulsoft.report.crossTab.core.enums.StiSummaryDirection;
import com.stimulsoft.report.crossTab.enums.StiCrossHorAlignment;
import com.stimulsoft.report.engine.engineV2.StiSubReportsHelper;
import com.stimulsoft.report.engine.engineV2.builders.StiContainerV2Builder;
import java.util.HashMap;

public class StiCrossTabV2Builder
extends StiContainerV2Builder {
    public static String getCollapsingName(StiCrossHeader header) {
        return StiCrossTabV2Builder.getCollapsingName(header.getName(), header.getHeaderLevel(), header.getHeaderValue());
    }

    public static String getCollapsingName(String componentName, int level, String value) {
        return String.format("%s.%s.%s", componentName, level, value);
    }

    public static boolean isCollapsed(StiCrossHeader masterHeader) {
        return StiCrossTabV2Builder.isCollapsed(masterHeader, masterHeader.getHeaderLevel(), masterHeader.getHeaderValue());
    }

    public static boolean isCollapsed(StiCrossHeader masterHeader, int level, Object textValue) {
        if (StiOptions.Engine.forceDisableCollapsing) {
            return false;
        }
        if (masterHeader.getInteraction() == null || masterHeader.getInteraction() instanceof StiCrossHeaderInteraction && !((StiCrossHeaderInteraction)masterHeader.getInteraction()).getCollapsingEnabled()) {
            return false;
        }
        boolean isCollapsed = true;
        if (masterHeader.getReport().getInteractionCollapsingStates() == null) {
            return isCollapsed;
        }
        Object value = masterHeader.getReport().getInteractionCollapsingStates().get(StiCrossTabV2Builder.getCollapsingName(masterHeader.getName(), level, textValue != null ? textValue.toString() : ""));
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public static void setCollapsed(StiCrossHeader masterHeader, boolean isCollapsed) {
        if (StiOptions.Engine.forceDisableCollapsing) {
            return;
        }
        if (masterHeader.getInteraction() == null || masterHeader.getInteraction() instanceof StiCrossHeaderInteraction && !((StiCrossHeaderInteraction)masterHeader.getInteraction()).getCollapsingEnabled()) {
            return;
        }
        if (masterHeader.getReport().getInteractionCollapsingStates() == null) {
            masterHeader.getReport().setInteractionCollapsingStates(new HashMap<String, Object>());
        }
        masterHeader.getReport().getInteractionCollapsingStates().put(StiCrossTabV2Builder.getCollapsingName(masterHeader), isCollapsed);
    }

    public static void MakeHorAlignment(StiCrossTab masterCrossTab, StiContainer outContainer, int startIndex, double parentWidth) {
        if (masterCrossTab.getWrap()) {
            return;
        }
        if (masterCrossTab.getHorAlignment() == StiCrossHorAlignment.Width) {
            outContainer.setLeft(0.0);
            outContainer.setWidth(parentWidth);
            StiCrossTabHelper.MakeHorAlignmentByWidth(outContainer, startIndex);
        } else if (masterCrossTab.getHorAlignment() != StiCrossHorAlignment.None) {
            outContainer.setLeft(0.0);
            outContainer.setWidth(parentWidth);
            StiRefObject maxLeft = new StiRefObject((Object)0.0);
            StiRefObject maxRight = new StiRefObject((Object)0.0);
            StiCrossTabHelper.CalculateMaxAndMin(outContainer, (StiRefObject<Double>)maxLeft, (StiRefObject<Double>)maxRight, startIndex);
            for (int index = startIndex; index < outContainer.components.size(); ++index) {
                StiComponent comp = (StiComponent)outContainer.components.get(index);
                if (masterCrossTab.getHorAlignment() == StiCrossHorAlignment.Left) {
                    comp.setLeft(comp.getLeft() - (Double)maxLeft.argvalue);
                    continue;
                }
                if (masterCrossTab.getHorAlignment() == StiCrossHorAlignment.Right) {
                    comp.setLeft(comp.getLeft() + (outContainer.getWidth() - (Double)maxRight.argvalue));
                    continue;
                }
                if (masterCrossTab.getHorAlignment() != StiCrossHorAlignment.Center) continue;
                double newLeft = (outContainer.getWidth() - ((Double)maxRight.argvalue - (Double)maxLeft.argvalue)) / 2.0;
                comp.setLeft(comp.getLeft() - ((Double)maxLeft.argvalue - newLeft));
            }
        }
    }

    public final StiComponent RenderCrossTabOnDataBand(StiCrossTabParams pars, StiCrossTab masterCrossTab, StiContainer renderedComponent) {
        double pageWidthStep;
        StiRectangle rect = pars.getDestinationRectangle();
        rect.x = 0.0;
        rect.y = 0.0;
        rect.width = masterCrossTab.parent.getWidth() - rect.getLeft();
        rect.height = Double.MAX_VALUE;
        int endRow = pars.getStartRow();
        int endCol = pars.getStartColumn();
        pars.startColumn = 0;
        StiPage page = masterCrossTab.page;
        double pageWidth = pageWidthStep = page.getPageWidth() - page.margins.getLeft() - page.margins.getRight();
        int pageSegment = 1;
        if (!page.getUnlimitedBreakable()) {
            rect.width = 1.0E9;
            pageWidth = 1.0E9;
            pageWidthStep = 1.0E9;
        }
        int startIndex = renderedComponent.components.size();
        boolean crossTitleVisible = masterCrossTab.crossTabInfo.Cross.leftCrossTitle != null && masterCrossTab.crossTabInfo.Cross.leftCrossTitle.getEnabled() && masterCrossTab.crossTabInfo.Cross.rightCrossTitle != null && masterCrossTab.crossTabInfo.Cross.rightCrossTitle.getEnabled();
        boolean crossTitlePrintOnAllPages = masterCrossTab.crossTabInfo.Cross.leftCrossTitle != null && masterCrossTab.crossTabInfo.Cross.leftCrossTitle.getPrintOnAllPages() && masterCrossTab.crossTabInfo.Cross.rightCrossTitle != null && masterCrossTab.crossTabInfo.Cross.rightCrossTitle.getPrintOnAllPages();
        int startRowIndex = 0;
        int pageNumber = 0;
        while (startRowIndex < masterCrossTab.crossTabInfo.Cross.getRowCount()) {
            StiRectangle rectForTab = StiRectangle.empty();
            if (masterCrossTab.getPrintTitleOnAllPages()) {
                if (startRowIndex == 0) {
                    rectForTab.height = masterCrossTab.getReport().engine.getFreeSpace();
                    if (page.getUnlimitedHeight() && !page.getUnlimitedBreakable()) {
                        rectForTab.height = 1.0E9;
                    }
                    rectForTab.height -= masterCrossTab.top;
                } else {
                    rectForTab.height = masterCrossTab.getReport().engine.getStaticBands().getReservedFreeSpace();
                }
            } else {
                rectForTab.height = 1.0E9;
            }
            while (pars.startColumn < masterCrossTab.crossTabInfo.Cross.getColCount()) {
                double offsetOnY = 0.0;
                double offsetOnX = 0.0;
                rectForTab.width = pageWidthStep;
                double widthRowHeader = 0.0;
                int countActualHeaderRowCount = this.GetActualHeaderRowCount(masterCrossTab);
                if (masterCrossTab.getWrap() && masterCrossTab.getRightToLeft()) {
                    for (int index = masterCrossTab.crossTabInfo.Cross.getWidths().length - 1; index > masterCrossTab.crossTabInfo.Cross.getWidths().length - countActualHeaderRowCount - 1; --index) {
                        widthRowHeader += masterCrossTab.crossTabInfo.Cross.getWidths()[index];
                    }
                    rectForTab.width -= widthRowHeader;
                }
                endCol = StiCrossTabHelper.GetEndCol(masterCrossTab, pars.startColumn, rectForTab);
                if (startRowIndex != 0 && masterCrossTab.getPrintTitleOnAllPages()) {
                    if (crossTitleVisible && crossTitlePrintOnAllPages) {
                        StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, 0, endCol, 1, rect);
                    }
                    rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[0];
                    offsetOnY += masterCrossTab.crossTabInfo.Cross.getHeights()[0];
                    rectForTab.height -= masterCrossTab.crossTabInfo.Cross.getHeights()[0];
                    int rowIndexEnd = this.GetActualHeaderRowCount(masterCrossTab);
                    if (rowIndexEnd != 0) {
                        int i;
                        if (crossTitleVisible) {
                            StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, 1, endCol, rowIndexEnd + 1, rect);
                            for (i = 1; i <= rowIndexEnd; ++i) {
                                rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                                offsetOnY += masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                                rectForTab.height -= masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                            }
                        } else {
                            StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, 0, endCol, rowIndexEnd, rect);
                            for (i = 0; i < rowIndexEnd; ++i) {
                                rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                                offsetOnY += masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                                rectForTab.height -= masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                            }
                        }
                    }
                    endCol = StiCrossTabHelper.GetEndCol(masterCrossTab, pars.startColumn, rectForTab);
                }
                endRow = StiCrossTabHelper.GetEndRow(masterCrossTab, startRowIndex, rectForTab);
                StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent, pars.startColumn, startRowIndex, endCol, endRow, rect);
                if (masterCrossTab.getWrap()) {
                    if (masterCrossTab.getRightToLeft() && endCol < masterCrossTab.crossTabInfo.Cross.getColCount() - 1) {
                        double _width = 0.0;
                        for (int index = pars.startColumn; index < endCol; ++index) {
                            _width += masterCrossTab.crossTabInfo.Cross.getWidths()[index];
                        }
                        rect.x += _width;
                        StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent, masterCrossTab.crossTabInfo.Cross.getWidths().length - countActualHeaderRowCount, startRowIndex, masterCrossTab.crossTabInfo.Cross.getWidths().length, endRow, rect);
                        rect.x -= _width;
                    }
                    StiSize sizeCrossTab = StiCrossTabHelper.GetCellsRect(masterCrossTab, pars.startColumn, pars.startRow, endCol, endRow);
                    if (rectForTab.height - sizeCrossTab.height < sizeCrossTab.height + masterCrossTab.getWrapGap()) {
                        rect.y = masterCrossTab.page.getHeight() * (double)(++pageNumber);
                        rect.x = 0.0;
                        rectForTab.height = startRowIndex == 0 ? masterCrossTab.getReport().engine.getFreeSpace() - masterCrossTab.top : masterCrossTab.getReport().engine.staticBands.getReservedFreeSpace();
                    } else {
                        rect.y += sizeCrossTab.height + masterCrossTab.getWrapGap();
                        rectForTab.height -= sizeCrossTab.height + masterCrossTab.getWrapGap();
                        rect.x = 0.0;
                    }
                    pars.startColumn = endCol;
                    continue;
                }
                rect.x += pageWidth - offsetOnX;
                rect.width = pageWidthStep;
                pars.startColumn = endCol;
                if (pars.startColumn < masterCrossTab.crossTabInfo.Cross.getColCount() && startRowIndex == 0) {
                    renderedComponent.getContainerInfoV2().SetSegmentPerWidth = ++pageSegment;
                }
                if (startRowIndex == 0) continue;
                rect.y -= offsetOnY;
                rectForTab.height += offsetOnY;
            }
            if (!masterCrossTab.getWrap()) {
                rect.y += rectForTab.height;
                rect.x = 0.0;
            }
            startRowIndex = endRow;
            pars.startColumn = 0;
        }
        StiCrossTabV2Builder.MakeHorAlignment(masterCrossTab, renderedComponent, startIndex, masterCrossTab.parent.getWidth());
        if (!page.getUnlimitedBreakable()) {
            double maxRight2 = 0.0;
            for (int compIndex = startIndex; compIndex < renderedComponent.components.size(); ++compIndex) {
                StiComponent comp = (StiComponent)renderedComponent.components.get(compIndex);
                maxRight2 = Math.max(comp.getRight(), maxRight2);
            }
            int pageSegmentPerWidth = page.segmentPerWidth;
            for (double pageWidth2 = page.getWidth(); pageWidth2 < maxRight2; pageWidth2 += page.getWidth()) {
                renderedComponent.getContainerInfoV2().SetSegmentPerWidth = 1;
                renderedComponent.getContainerInfoV2().SetSegmentPerWidth = ++pageSegmentPerWidth;
            }
        }
        return renderedComponent;
    }

    public final StiComponent RenderCrossTab(StiCrossTabParams pars, StiCrossTab masterCrossTab) {
        boolean placedOnBand = StiSubReportsHelper.GetParentBand(masterCrossTab) != null;
        StiContainer renderedComponent = pars.getDestinationContainer();
        if (renderedComponent == null) {
            StiComponent tempVar = super.InternalRender(masterCrossTab);
            renderedComponent = (StiContainer)(tempVar instanceof StiContainer ? tempVar : null);
            renderedComponent.components.Clear();
        }
        renderedComponent.setDockStyle(StiDockStyle.None);
        if (!masterCrossTab.page.getUnlimitedHeight() || masterCrossTab.page.getUnlimitedBreakable()) {
            renderedComponent.setCanBreak(true);
        }
        if (!pars.getAllowRendering()) {
            return renderedComponent;
        }
        if ((masterCrossTab.getDataSource() == null || masterCrossTab.getDataSource().getIsEmpty()) && !masterCrossTab.getPrintIfEmpty()) {
            pars.setRenderingIsFinished(true);
            return renderedComponent;
        }
        if (placedOnBand) {
            return this.RenderCrossTabOnDataBand(pars, masterCrossTab, renderedComponent);
        }
        StiRectangle rect = pars.getDestinationRectangle().clone();
        if (masterCrossTab.page.getUnlimitedHeight()) {
            rect.height = 1.0E8;
        }
        rect.x = 0.0;
        rect.y = 0.0;
        int endRow = pars.startRow;
        int endCol = pars.startColumn;
        if (masterCrossTab.getWrap()) {
            StiContainer cont;
            StiContainer stiContainer = cont = renderedComponent instanceof StiContainer ? renderedComponent : null;
            while (pars.startColumn < masterCrossTab.crossTabInfo.Cross.getColCount()) {
                endRow = StiCrossTabHelper.GetEndRow(masterCrossTab, pars.startRow, rect);
                endCol = StiCrossTabHelper.GetEndCol(masterCrossTab, pars.startColumn, rect);
                int startIndex = renderedComponent.components.size();
                StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent, pars.startColumn, pars.startRow, endCol, endRow, rect);
                StiSize sizeRenderTab = StiCrossTabHelper.GetCellsRect(masterCrossTab, pars.startColumn, pars.startRow, endCol, endRow);
                if (endCol == masterCrossTab.crossTabInfo.Cross.getColCount() && endRow == masterCrossTab.crossTabInfo.Cross.getRowCount()) {
                    pars.renderingIsFinished = true;
                    return renderedComponent;
                }
                if (endCol == masterCrossTab.crossTabInfo.Cross.getColCount()) {
                    pars.startRow = endRow;
                    pars.startColumn = 0;
                } else {
                    pars.startColumn = endCol;
                }
                if (rect.height - masterCrossTab.getWrapGap() - sizeRenderTab.height > sizeRenderTab.height) {
                    rect.y = sizeRenderTab.height + masterCrossTab.getWrapGap();
                    rect.height -= sizeRenderTab.height + masterCrossTab.getWrapGap();
                    continue;
                }
                pars.renderingIsFinished = false;
                return renderedComponent;
            }
            pars.renderingIsFinished = true;
            return renderedComponent;
        }
        rect.x = 0.0;
        rect.y = 0.0;
        endCol = StiCrossTabHelper.GetEndCol(masterCrossTab, pars.startColumn, rect);
        endRow = StiCrossTabHelper.GetEndRow(masterCrossTab, pars.startRow, rect);
        endRow = StiCrossTabHelper.checkMergedRowCells(masterCrossTab, pars.startRow, endRow, pars.startColumn, endCol);
        boolean crossTitleVisible = masterCrossTab.crossTabInfo.Cross.leftCrossTitle != null && masterCrossTab.crossTabInfo.Cross.leftCrossTitle.getEnabled() && masterCrossTab.crossTabInfo.Cross.rightCrossTitle != null && masterCrossTab.crossTabInfo.Cross.rightCrossTitle.getEnabled();
        boolean crossTitlePrintOnAllPages = masterCrossTab.crossTabInfo.Cross.leftCrossTitle != null && masterCrossTab.crossTabInfo.Cross.leftCrossTitle.getPrintOnAllPages() && masterCrossTab.crossTabInfo.Cross.rightCrossTitle != null && masterCrossTab.crossTabInfo.Cross.rightCrossTitle.getPrintOnAllPages();
        double stX = rect.x;
        double stY = rect.y;
        double resX = rect.x;
        double resY = rect.y;
        if (pars.startColumn != 0) {
            for (int rowIndex = 0; rowIndex < masterCrossTab.crossTabInfo.Cross.getRowFields().size(); ++rowIndex) {
                if (!((StiCrossHeader)masterCrossTab.crossTabInfo.Cross.getRowFields().get(rowIndex)).getPrintOnAllPages() || masterCrossTab.getRightToLeft()) continue;
                double colWidth = masterCrossTab.crossTabInfo.Cross.getWidths()[rowIndex];
                stX += colWidth;
                rect.width -= colWidth;
            }
        }
        if (pars.startRow != 0) {
            for (int colIndex = 0; colIndex < masterCrossTab.crossTabInfo.Cross.getColFields().size(); ++colIndex) {
                if (!((StiCrossHeader)masterCrossTab.crossTabInfo.Cross.getColFields().get(colIndex)).getPrintOnAllPages()) continue;
                stY += masterCrossTab.crossTabInfo.Cross.getHeights()[colIndex];
                rect.height -= masterCrossTab.crossTabInfo.Cross.getHeights()[colIndex];
            }
        }
        if (crossTitleVisible && crossTitlePrintOnAllPages && pars.startRow != 0) {
            stY += masterCrossTab.crossTabInfo.Cross.getHeights()[masterCrossTab.crossTabInfo.Cross.getColFields().size()];
            rect.height -= masterCrossTab.crossTabInfo.Cross.getHeights()[masterCrossTab.crossTabInfo.Cross.getColFields().size()];
        }
        if (pars.startColumn != 0 && !StiCrossTabHelper.IsRowFieldsEmpty(masterCrossTab)) {
            rect.x = resX;
            rect.y = stY;
            double ht = rect.height;
            int endRW = pars.startRow;
            for (int rwIndex = pars.startRow; rwIndex < endRow && !((ht -= masterCrossTab.crossTabInfo.Cross.getHeights()[rwIndex]) < 0.0); ++rwIndex) {
                ++endRW;
            }
            endRow = endRW;
            int rowIndex = 0;
            while (rowIndex < masterCrossTab.crossTabInfo.Cross.getRowFields().size()) {
                int rowIndexEnd;
                for (rowIndexEnd = rowIndex; rowIndexEnd < masterCrossTab.crossTabInfo.Cross.getRowFields().size() && ((StiCrossHeader)masterCrossTab.crossTabInfo.Cross.getRowFields().get(rowIndexEnd)).getPrintOnAllPages() && !masterCrossTab.getRightToLeft(); ++rowIndexEnd) {
                }
                if (rowIndex != rowIndexEnd) {
                    if (pars.startRow > 0) {
                        StiRectangle rectTitle = rect.clone();
                        rectTitle.y = 0.0;
                        StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, 0, 0, masterCrossTab.crossTabInfo.Cross.getRowFields().size(), 2, rectTitle);
                    }
                    StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, rowIndex, pars.startRow, rowIndexEnd, endRow, rect);
                    rect.x += masterCrossTab.crossTabInfo.Cross.getWidths()[rowIndex];
                }
                rowIndex = rowIndexEnd + 1;
            }
        }
        if (pars.startRow != 0) {
            rect.x = stX;
            rect.y = resY;
            double wd = rect.width;
            int endColumn = pars.startColumn;
            for (int clIndex = pars.startColumn; clIndex < endCol && !((wd -= masterCrossTab.crossTabInfo.Cross.getWidths()[clIndex]) < 0.0); ++clIndex) {
                ++endColumn;
            }
            endCol = endColumn;
            if (crossTitleVisible && crossTitlePrintOnAllPages) {
                StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, 0, endCol, 1, rect);
                rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[0];
            }
            int colIndex = 0;
            while (colIndex < masterCrossTab.crossTabInfo.Cross.colFields.size()) {
                int colIndexEnd;
                for (colIndexEnd = colIndex; colIndexEnd < masterCrossTab.crossTabInfo.Cross.colFields.size() && ((StiCrossHeader)masterCrossTab.crossTabInfo.Cross.colFields.get(colIndexEnd)).getPrintOnAllPages(); ++colIndexEnd) {
                }
                if (colIndex != colIndexEnd) {
                    if (crossTitleVisible) {
                        StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, colIndex + 1, endCol, colIndexEnd + 1, rect);
                        rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[colIndex + 1];
                    } else {
                        StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, colIndex, endCol, colIndexEnd, rect);
                        rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[colIndex];
                    }
                }
                colIndex = colIndexEnd + 1;
            }
        }
        rect.x = stX;
        rect.y = stY;
        boolean flag = true;
        while (flag) {
            flag = false;
            endCol = StiCrossTabHelper.GetEndCol(masterCrossTab, pars.startColumn, rect);
            endRow = StiCrossTabHelper.GetEndRow(masterCrossTab, pars.startRow, rect);
            if (pars.startRow < (endRow = StiCrossTabHelper.checkMergedRowCells(masterCrossTab, pars.startRow, endRow, pars.startColumn, endCol))) {
                StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, pars.startRow, endCol, endRow, rect);
            }
            pars.renderingIsFinished = endCol == masterCrossTab.crossTabInfo.Cross.getColCount() && endRow == masterCrossTab.crossTabInfo.Cross.getRowCount();
            pars.startColumn = endCol;
            if (endCol == masterCrossTab.crossTabInfo.Cross.getColCount()) {
                pars.startColumn = 0;
                pars.startRow = endRow;
            }
            if (!placedOnBand) {
                StiCrossTabV2Builder.MakeHorAlignment(masterCrossTab, renderedComponent, 0, pars.getDestinationContainer() != null ? pars.getDestinationContainer().getWidth() : masterCrossTab.parent.getWidth());
            }
            if (masterCrossTab.canGrow) {
                renderedComponent.canGrow = false;
                renderedComponent.canShrink = true;
                StiSize size = renderedComponent.getActualSize();
                renderedComponent.setWidth(size.width);
                renderedComponent.setHeight(size.height);
                renderedComponent.canGrow = true;
            }
            if (!masterCrossTab.page.getUnlimitedHeight()) continue;
            double sumHeight = 0.0;
            for (int indexLine = 0; indexLine < masterCrossTab.crossTabInfo.Cross.getRowCount(); ++indexLine) {
                sumHeight += masterCrossTab.crossTabInfo.Cross.getHeights()[indexLine];
            }
            rect.y += sumHeight;
            if (pars.renderingIsFinished) {
                pars.getDestinationContainer().getContainerInfoV2().SetSegmentPerWidth = (int)(rect.y / pars.getDestinationRectangle().height);
                continue;
            }
            flag = true;
        }
        return renderedComponent;
    }

    private int GetActualHeaderRowCount(StiCrossTab masterCrossTab) {
        int headerRowCount = 0;
        int summaryCount = 0;
        for (StiComponent comp : masterCrossTab.components) {
            if (comp instanceof StiCrossSummary && ((StiCrossSummary)comp).getEnabled()) {
                ++summaryCount;
            }
            if (!(comp instanceof StiCrossColumn) || !((StiCrossColumn)comp).getEnabled()) continue;
            ++headerRowCount;
        }
        if (summaryCount > 1 && masterCrossTab.getSummaryDirection() == StiSummaryDirection.LeftToRight) {
            ++headerRowCount;
        }
        return headerRowCount;
    }

    private int GetActualHeaderColumnCount(StiCrossTab masterCrossTab) {
        int headerColumnCount = 0;
        int summaryCount = 0;
        for (StiComponent comp : masterCrossTab.components) {
            if (comp instanceof StiCrossSummary && ((StiCrossSummary)comp).getEnabled()) {
                ++summaryCount;
            }
            if (!(comp instanceof StiCrossRow) || !((StiCrossRow)comp).getEnabled()) continue;
            ++headerColumnCount;
        }
        if (summaryCount > 1 && masterCrossTab.getSummaryDirection() == StiSummaryDirection.UpToDown) {
            ++headerColumnCount;
        }
        return headerColumnCount;
    }

    @Override
    public void Prepare(StiComponent masterComp) {
        super.Prepare(masterComp);
        StiFilterHelper.SetFilter(masterComp);
    }

    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiCrossTab masterCrossTab = (StiCrossTab)(masterComp instanceof StiCrossTab ? masterComp : null);
        StiCrossTabParams pars = new StiCrossTabParams();
        boolean placedOnBand = StiSubReportsHelper.GetParentBand(masterCrossTab) != null;
        pars.setAllowRendering(placedOnBand);
        StiDataBand band = (StiDataBand)(masterComp.parent instanceof StiDataBand ? masterComp.parent : null);
        if (band != null) {
            pars.setDestinationRectangle(band.parent.getClientRectangle());
        } else {
            pars.setDestinationRectangle(masterCrossTab.getClientRectangle());
        }
        if (placedOnBand) {
            StiCrossTabHelper.CreateCross(masterCrossTab);
            return this.RenderCrossTab(pars, masterCrossTab);
        }
        StiComponent tempVar = super.InternalRender(masterComp);
        StiContainer cont = (StiContainer)(tempVar instanceof StiContainer ? tempVar : null);
        if (cont != null) {
            cont.setWidth(masterComp.getWidth());
            cont.setHeight(masterComp.getHeight());
            cont.components.Clear();
        }
        return cont;
    }
}

