/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiHtmlState;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.StiTextRendererParseHtml;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiRtfHelper;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.base.utils.StiZipWriter20;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.StiTextRenderer;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiExcel2007ExportService
extends StiExportService {
    private static final ArrayList<Integer> WRONG_URL_SYMBOLS = new ArrayList();
    private static final double TWIPS_TO_COL_INFO = 0.17343964980045;
    private StiMatrix matrix = null;
    private ArrayList<DataFont> fontList = null;
    private ArrayList<DataFill> fillList = null;
    private ArrayList<DataBorder> borderList = null;
    private ArrayList<DataXF> xfList = null;
    private ArrayList<String> sstList = null;
    private Hashtable<String, Integer> sstHash = null;
    private ArrayList<ExcelImageData> imageList = null;
    private ArrayList<String> formatList = null;
    private int sstCount = 0;
    private ArrayList<String> sheetNameList = null;
    private int imageListOffset = 0;
    private ArrayList<StiSize> printAreasList = null;
    private ArrayList<StiMatrix> matrixList = null;
    private ArrayList<Integer> firstPageIndexList = null;
    private ArrayList<String> hyperlinkList = null;
    private ArrayList<Integer> minRowList = null;
    private ArrayList<Integer> maxRowList = null;
    private boolean useOnePageHeaderAndFooter = false;
    private boolean exportDataOnly = false;
    private boolean exportObjectFormatting = true;
    private boolean exportEachPageToSheet = false;
    private boolean exportHorizontalPageBreaks = false;
    private float imageResolution = 1.0f;
    private float imageQuality = 0.75f;
    private StiImageCache imageCache = null;
    private String docCompanyString = null;
    private String docLastModifiedString = null;
    private StiReport report;
    private Hashtable<Integer, StiText> sstHashIsTags = null;

    private String getLineStyle(StiBorderSide border) {
        StiPenStyle penStyle = StiPenStyle.None;
        double width = 0.0;
        double mediumWidth = 1.5;
        double thickWidth = 3.0;
        if (border != null) {
            penStyle = border.getStyle();
            width = border.getSize();
        }
        switch (penStyle) {
            case Solid: {
                if (width > thickWidth) {
                    return "thick";
                }
                if (width > mediumWidth) {
                    return "medium";
                }
                return "thin";
            }
            case Dot: {
                if (width > mediumWidth) {
                    return "dotted";
                }
                return "hair";
            }
            case Dash: {
                if (width > mediumWidth) {
                    return "mediumDashed";
                }
                return "dashed";
            }
            case DashDot: {
                if (width > mediumWidth) {
                    return "mediumDashDot";
                }
                return "dashDot";
            }
            case DashDotDot: {
                if (width > mediumWidth) {
                    return "mediumDashDotDot";
                }
                return "dashDotDot";
            }
            case Double: {
                return "double";
            }
        }
        return null;
    }

    private String getRefString(int column, int row) {
        int columnHigh = column / 26;
        int columnLow = column % 26;
        StringBuilder output = new StringBuilder();
        if (columnHigh > 0) {
            output.append((char)(65 + columnHigh - 1));
        }
        output.append((char)(65 + columnLow));
        output.append(String.valueOf(row + 1));
        return output.toString();
    }

    private String getRefAbsoluteString(int column, int row) {
        int columnHigh = column / 26;
        int columnLow = column % 26;
        StringBuilder output = new StringBuilder();
        output.append("$");
        if (columnHigh > 0) {
            output.append((char)(65 + columnHigh - 1));
        }
        output.append((char)(65 + columnLow));
        output.append("$");
        output.append(String.valueOf(row + 1));
        return output.toString();
    }

    private String floatToString(double number) {
        String output = String.valueOf(number).replace(',', '.');
        return output;
    }

    private String stringToUrl(String input) throws UnsupportedEncodingException {
        byte[] buf = input.getBytes("UTF8");
        StringBuilder output = new StringBuilder();
        for (byte byt : buf) {
            if (byt < 32 || WRONG_URL_SYMBOLS.indexOf(byt) != -1) {
                output.append(String.format("%%%02x", byt));
                continue;
            }
            output.append((char)byt);
        }
        return output.toString();
    }

    private int getFontNumber(DataFont dataIn) {
        if (this.fontList.size() > 0) {
            for (int index = 0; index < this.fontList.size(); ++index) {
                if (!this.fontList.get(index).equals(dataIn)) continue;
                return index;
            }
        }
        this.fontList.add(dataIn);
        int temp = this.fontList.size() - 1;
        return temp;
    }

    private int getFillNumber(DataFill dataIn) {
        if (this.fillList.size() > 0) {
            for (int index = 0; index < this.fillList.size(); ++index) {
                if (!this.fillList.get(index).equals(dataIn)) continue;
                return index;
            }
        }
        this.fillList.add(dataIn);
        int temp = this.fillList.size() - 1;
        return temp;
    }

    private int getBorderNumber(DataBorder dataIn) {
        if (this.borderList.size() > 0) {
            for (int index = 0; index < this.borderList.size(); ++index) {
                if (!this.borderList.get(index).equals(dataIn)) continue;
                return index;
            }
        }
        this.borderList.add(dataIn);
        int temp = this.borderList.size() - 1;
        return temp;
    }

    private int getXFNumber(DataXF dataIn) {
        if (this.xfList.size() > 0) {
            for (int index = 0; index < this.xfList.size(); ++index) {
                if (!this.xfList.get(index).equals(dataIn)) continue;
                return index;
            }
        }
        this.xfList.add(dataIn);
        int temp = this.xfList.size() - 1;
        return temp;
    }

    private int getSSTNumber(String dataIn) {
        ++this.sstCount;
        if (this.sstList.size() > 0 && this.sstHash.containsKey(dataIn)) {
            return this.sstHash.get(dataIn);
        }
        this.sstList.add(dataIn);
        int temp = this.sstList.size() - 1;
        this.sstHash.put(dataIn, temp);
        return temp;
    }

    private int getFormatNumber(String dataIn) {
        if (this.formatList.size() > 0) {
            for (int index = 0; index < this.formatList.size(); ++index) {
                if (!this.formatList.get(index).equals(dataIn)) continue;
                return index + 164;
            }
        }
        this.formatList.add(dataIn);
        int temp = this.formatList.size() - 1;
        return temp + 164;
    }

    private static double getHiToTwips() {
        return 0.74016;
    }

    private boolean compareExcellSheetNames(String name1, String name2) {
        String st2;
        String st1 = name1;
        if (StiValidationUtil.isNullOrEmpty((String)st1)) {
            st1 = "";
        }
        if (StiValidationUtil.isNullOrEmpty((String)(st2 = name2))) {
            st2 = "";
        }
        return st1.equals(st2);
    }

    private double convert(double x) {
        return x * StiExcel2007ExportService.getHiToTwips();
    }

    private void prepareData() {
        this.fontList = new ArrayList();
        this.fillList = new ArrayList();
        this.borderList = new ArrayList();
        this.xfList = new ArrayList();
        this.sstList = new ArrayList();
        this.sstHash = new Hashtable();
        this.imageList = new ArrayList();
        this.formatList = new ArrayList();
        this.sheetNameList = new ArrayList();
        this.sstCount = 0;
        this.printAreasList = new ArrayList();
        this.matrixList = new ArrayList();
        this.firstPageIndexList = new ArrayList();
        this.minRowList = new ArrayList();
        this.maxRowList = new ArrayList();
        this.sstHashIsTags = new Hashtable();
        this.imageCache = new StiImageCache(ExportOptions.Excel2007.getAllowImageComparer(), StiImageFormat.Jpeg, this.imageQuality);
        DataFont tempFont = new DataFont("Arial", false, false, false, false, 10, StiColorEnum.Black.color(), 1, 0);
        this.getFontNumber(tempFont);
        DataFill tempFill = new DataFill("none", StiColorEnum.Transparent.color(), StiColorEnum.Black.color());
        this.getFillNumber(tempFill);
        tempFill = new DataFill("gray125", StiColorEnum.Transparent.color(), StiColorEnum.Black.color());
        this.getFillNumber(tempFill);
        DataBorder tempBorder = new DataBorder(null, null, null, null);
        this.getBorderNumber(tempBorder);
        DataXF tempXF = new DataXF(0, 0, 0, 0, 0, StiTextHorAlignment.Left, StiVertAlignment.Bottom, 0, false, false);
        this.getXFNumber(tempXF);
    }

    private Document writeContentTypes() throws ParserConfigurationException {
        int index;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element typesEl = doc.createElement("Types");
        doc.appendChild(typesEl);
        typesEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/content-types");
        Element defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "rels");
        defaultEl.setAttribute("ContentType", "application/vnd.openxmlformats-package.relationships+xml");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "xml");
        defaultEl.setAttribute("ContentType", "application/xml");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "jpeg");
        defaultEl.setAttribute("ContentType", "image/jpeg");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "png");
        defaultEl.setAttribute("ContentType", "image/png");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "vml");
        defaultEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.vmlDrawing");
        Element overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/docProps/app.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.extended-properties+xml");
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/docProps/core.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-package.core-properties+xml");
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/xl/workbook.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml");
        for (index = 0; index < this.sheetNameList.size(); ++index) {
            overrideEl = doc.createElement("Override");
            typesEl.appendChild(overrideEl);
            overrideEl.setAttribute("PartName", String.format("/xl/worksheets/sheet%s.xml", index + 1));
            overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml");
        }
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/xl/styles.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml");
        for (index = 0; index < this.sheetNameList.size(); ++index) {
            overrideEl = doc.createElement("Override");
            typesEl.appendChild(overrideEl);
            overrideEl.setAttribute("PartName", String.format("/xl/drawings/drawing%s.xml", index + 1));
            overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.drawing+xml");
        }
        if (this.sstList.size() > 0) {
            overrideEl = doc.createElement("Override");
            typesEl.appendChild(overrideEl);
            overrideEl.setAttribute("PartName", "/xl/sharedStrings.xml");
            overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml");
        }
        return doc;
    }

    private Document writeMainRels() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        Element relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId1");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        relationshipEl.setAttribute("Target", "xl/workbook.xml");
        relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId2");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
        relationshipEl.setAttribute("Target", "docProps/core.xml");
        relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId3");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
        relationshipEl.setAttribute("Target", "docProps/app.xml");
        return doc;
    }

    private Document writeDocPropsApp() throws ParserConfigurationException {
        int index;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element propertiesEl = doc.createElement("Properties");
        doc.appendChild(propertiesEl);
        propertiesEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties");
        propertiesEl.setAttribute("xmlns:vt", "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes");
        StiXmlHelper.writeElementString((Document)doc, (Element)propertiesEl, (String)"Application", (String)"Microsoft Excel");
        StiXmlHelper.writeElementString((Document)doc, (Element)propertiesEl, (String)"DocSecurity", (String)"0");
        StiXmlHelper.writeElementString((Document)doc, (Element)propertiesEl, (String)"ScaleCrop", (String)"false");
        StiXmlHelper.writeElementString((Document)doc, (Element)propertiesEl, (String)"Company", (String)(this.docCompanyString == null ? "" : this.docCompanyString));
        StiXmlHelper.writeElementString((Document)doc, (Element)propertiesEl, (String)"LinksUpToDate", (String)"false");
        StiXmlHelper.writeElementString((Document)doc, (Element)propertiesEl, (String)"SharedDoc", (String)"false");
        StiXmlHelper.writeElementString((Document)doc, (Element)propertiesEl, (String)"HyperlinksChanged", (String)"false");
        StiXmlHelper.writeElementString((Document)doc, (Element)propertiesEl, (String)"AppVersion", (String)"12.0000");
        Element headingPairsEl = doc.createElement("HeadingPairs");
        propertiesEl.appendChild(headingPairsEl);
        Element vectorEl = doc.createElement("vt:vector");
        headingPairsEl.appendChild(vectorEl);
        vectorEl.setAttribute("size", "4");
        vectorEl.setAttribute("baseType", "variant");
        Element variantEl = doc.createElement("vt:variant");
        vectorEl.appendChild(variantEl);
        StiXmlHelper.writeElementString((Document)doc, (Element)variantEl, (String)"vt:lpstr", (String)"Worksheets");
        variantEl = doc.createElement("vt:variant");
        vectorEl.appendChild(variantEl);
        StiXmlHelper.writeElementString((Document)doc, (Element)variantEl, (String)"vt:i4", (String)String.format("%s", this.sheetNameList.size()));
        variantEl = doc.createElement("vt:variant");
        vectorEl.appendChild(variantEl);
        StiXmlHelper.writeElementString((Document)doc, (Element)variantEl, (String)"vt:lpstr", (String)"Named Ranges");
        variantEl = doc.createElement("vt:variant");
        vectorEl.appendChild(variantEl);
        StiXmlHelper.writeElementString((Document)doc, (Element)variantEl, (String)"vt:i4", (String)String.format("%s", this.sheetNameList.size()));
        Element titlesEl = doc.createElement("TitlesOfParts");
        propertiesEl.appendChild(titlesEl);
        vectorEl = doc.createElement("vt:vector");
        titlesEl.appendChild(vectorEl);
        vectorEl.setAttribute("size", String.format("%s", this.sheetNameList.size() * 2));
        vectorEl.setAttribute("baseType", "lpstr");
        for (index = 0; index < this.sheetNameList.size(); ++index) {
            StiXmlHelper.writeElementString((Document)doc, (Element)vectorEl, (String)"vt:lpstr", (String)this.sheetNameList.get(index));
        }
        for (index = 0; index < this.sheetNameList.size(); ++index) {
            StiXmlHelper.writeElementString((Document)doc, (Element)vectorEl, (String)"vt:lpstr", (String)String.format("'%s'!Print_Area", this.sheetNameList.get(index)));
        }
        return doc;
    }

    private Document writeDocPropsCore() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element corePropertiesEl = doc.createElement("cp:coreProperties");
        doc.appendChild(corePropertiesEl);
        corePropertiesEl.setAttribute("xmlns:cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
        corePropertiesEl.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        corePropertiesEl.setAttribute("xmlns:dcterms", "http://purl.org/dc/terms/");
        corePropertiesEl.setAttribute("xmlns:dcmitype", "http://purl.org/dc/dcmitype/");
        corePropertiesEl.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        String dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH).format(new Date());
        String creator = StiExportUtils.getReportVersion();
        StiXmlHelper.writeElementString((Document)doc, (Element)corePropertiesEl, (String)"dc:title", (String)(this.report.getReportName() == null ? "" : this.report.getReportName()));
        StiXmlHelper.writeElementString((Document)doc, (Element)corePropertiesEl, (String)"dc:subject", (String)(this.report.getReportAlias() == null ? "" : this.report.getReportAlias()));
        StiXmlHelper.writeElementString((Document)doc, (Element)corePropertiesEl, (String)"dc:creator", (String)(this.report.getReportAuthor() == null ? "" : this.report.getReportAuthor()));
        StiXmlHelper.writeElementString((Document)doc, (Element)corePropertiesEl, (String)"dc:description", (String)(this.report.getReportDescription() == null ? "" : this.report.getReportDescription()));
        StiXmlHelper.writeElementString((Document)doc, (Element)corePropertiesEl, (String)"cp:lastModifiedBy", (String)(this.docLastModifiedString == null ? "" : this.docLastModifiedString));
        Element createdEl = doc.createElement("dcterms:created");
        corePropertiesEl.appendChild(createdEl);
        createdEl.setAttribute("xsi:type", "dcterms:W3CDTF");
        createdEl.setTextContent(dateTime);
        Element modifierEl = doc.createElement("dcterms:modified");
        corePropertiesEl.appendChild(modifierEl);
        modifierEl.setAttribute("xsi:type", "dcterms:W3CDTF");
        modifierEl.setTextContent(dateTime);
        return doc;
    }

    private Document writeWorkbookRels() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        for (int index = 0; index < this.sheetNameList.size(); ++index) {
            Element relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", index + 1));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet");
            relationshipEl.setAttribute("Target", String.format("worksheets/sheet%s.xml", index + 1));
        }
        Element relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", String.format("rId%s", this.sheetNameList.size() + 2));
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles");
        relationshipEl.setAttribute("Target", "styles.xml");
        if (this.sstCount > 0) {
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", this.sheetNameList.size() + 3));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings");
            relationshipEl.setAttribute("Target", "sharedStrings.xml");
        }
        return doc;
    }

    private Document writeWorkbook() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element workbookEl = doc.createElement("workbook");
        doc.appendChild(workbookEl);
        workbookEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        workbookEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        Element fileVersionEl = doc.createElement("fileVersion");
        workbookEl.appendChild(fileVersionEl);
        fileVersionEl.setAttribute("appName", "xl");
        fileVersionEl.setAttribute("lastEdited", "4");
        fileVersionEl.setAttribute("lowestEdited", "4");
        fileVersionEl.setAttribute("rupBuild", "4505");
        Element worbookPrEl = doc.createElement("workbookPr");
        workbookEl.appendChild(worbookPrEl);
        worbookPrEl.setAttribute("defaultThemeVersion", "124226");
        Element bookViewsEl = doc.createElement("bookViews");
        workbookEl.appendChild(bookViewsEl);
        Element workbookViewEl = doc.createElement("workbookView");
        bookViewsEl.appendChild(workbookViewEl);
        workbookViewEl.setAttribute("xWindow", "120");
        workbookViewEl.setAttribute("yWindow", "15");
        workbookViewEl.setAttribute("windowWidth", "18975");
        workbookViewEl.setAttribute("windowHeight", "11955");
        Element sheetsEl = doc.createElement("sheets");
        workbookEl.appendChild(sheetsEl);
        for (int index = 0; index < this.sheetNameList.size(); ++index) {
            Element sheetEl = doc.createElement("sheet");
            sheetsEl.appendChild(sheetEl);
            sheetEl.setAttribute("name", this.sheetNameList.get(index));
            sheetEl.setAttribute("sheetId", String.format("%s", index + 1));
            sheetEl.setAttribute("r:id", String.format("rId%s", index + 1));
        }
        Element definedNamesEl = doc.createElement("definedNames");
        workbookEl.appendChild(definedNamesEl);
        for (int index = 0; index < this.sheetNameList.size(); ++index) {
            StiSize area = this.printAreasList.get(index);
            if (area.getHeight() > 1048575.0) {
                area.setHeight(1048575.0);
            }
            if (area.getWidth() > 16383.0) {
                area.setWidth(16383.0);
            }
            String sref = this.getRefAbsoluteString((int)area.getWidth(), (int)area.getHeight());
            Element definedNameEl = doc.createElement("definedName");
            definedNamesEl.appendChild(definedNameEl);
            definedNameEl.setAttribute("name", "_xlnm.Print_Area");
            definedNameEl.setAttribute("localSheetId", String.format("%s", index));
            definedNameEl.setTextContent(String.format("'%s'!$A$1:%s", this.sheetNameList.get(index), sref));
        }
        Element calcPrEl = doc.createElement("calcPr");
        workbookEl.appendChild(calcPrEl);
        calcPrEl.setAttribute("calcId", "124519");
        return doc;
    }

    private Document writeSheetRels(int indexSheet) throws ParserConfigurationException {
        Element relationshipEl;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        if (this.imageList.size() - this.imageListOffset > 0) {
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", 1));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing");
            relationshipEl.setAttribute("Target", String.format("../drawings/drawing%s.xml", indexSheet + 1));
        }
        if (this.hyperlinkList.size() > 0) {
            for (int index = 0; index < this.hyperlinkList.size(); ++index) {
                Element relationshipEl2 = doc.createElement("Relationship");
                relationshipsEl.appendChild(relationshipEl2);
                relationshipEl2.setAttribute("Id", String.format("rId%s", 2 + index));
                relationshipEl2.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
                relationshipEl2.setAttribute("Target", this.hyperlinkList.get(index));
                relationshipEl2.setAttribute("TargetMode", "External");
            }
        }
        if (!StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", "dId1");
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing");
            relationshipEl.setAttribute("Target", "../drawings/vmlDrawingAdditional.vml");
        }
        return doc;
    }

    private Document writeSheet(int indexSheet, StiPage page) throws ParserConfigurationException, IOException, TransformerException {
        Element selectionEl;
        Element paneEl;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element worksheetEl = doc.createElement("worksheet");
        doc.appendChild(worksheetEl);
        worksheetEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        worksheetEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        this.matrix = this.matrixList.get(indexSheet);
        int minRowIndex = this.minRowList.get(indexSheet);
        int maxRowIndex = this.maxRowList.get(indexSheet);
        StiSize printAreaSize = new StiSize(this.matrix.getCoordX().size() - 2, maxRowIndex - minRowIndex - 1);
        if (printAreaSize.getWidth() < 0.0) {
            printAreaSize.setWidth(0.0);
        }
        if (printAreaSize.getHeight() < 0.0) {
            printAreaSize.setHeight(0.0);
        }
        this.printAreasList.add(printAreaSize);
        Element dimensionEl = doc.createElement("dimension");
        worksheetEl.appendChild(dimensionEl);
        dimensionEl.setAttribute("ref", String.format("%s:%s", this.getRefString(0, 0), this.getRefString((int)printAreaSize.getWidth(), (int)printAreaSize.getHeight())));
        int paneX = 0;
        int paneY = 0;
        if (ExportOptions.Excel2007.isAllowFreezePanes()) {
            block2: for (int indexRow = minRowIndex; indexRow < maxRowIndex; ++indexRow) {
                for (int indexColumn = 0; indexColumn < this.matrix.getCoordX().size() - 1; ++indexColumn) {
                    String stPlacement;
                    StiCell cell = this.matrix.getCells()[indexRow][indexColumn];
                    if (cell == null || cell.getComponent() == null || !cell.getComponent().getLocked() && (cell.getComponent().getTagValue() == null || !cell.getComponent().getTagValue().contains("excelfreezepanes")) || (stPlacement = cell.getComponent().getComponentPlacement()) == null || stPlacement.length() <= 0 || !stPlacement.startsWith("rt") && !stPlacement.startsWith("ph") && !stPlacement.startsWith("h")) continue;
                    paneX = cell.getLeft();
                    paneY = cell.getTop() + cell.getHeight() + 1;
                    continue block2;
                }
            }
        }
        Element sheetViewsEl = doc.createElement("sheetViews");
        worksheetEl.appendChild(sheetViewsEl);
        Element sheetViewEl = doc.createElement("sheetView");
        sheetViewsEl.appendChild(sheetViewEl);
        if (ExportOptions.Excel2007.getColumnsRightToLeft()) {
            sheetViewEl.setAttribute("rightToLeft", "1");
        }
        if (!ExportOptions.Excel2007.isShowGridLines()) {
            sheetViewEl.setAttribute("showGridLines", "0");
        }
        sheetViewEl.setAttribute("tabSelected", "1");
        sheetViewEl.setAttribute("workbookViewId", "0");
        if (paneX == 0 && paneY == 0) {
            Element selectionEl2 = doc.createElement("selection");
            sheetViewEl.appendChild(selectionEl2);
            selectionEl2.setAttribute("activeCell", "A1");
            selectionEl2.setAttribute("sqref", "A1");
        } else if (paneX == 0) {
            paneEl = doc.createElement("pane");
            sheetViewEl.appendChild(paneEl);
            paneEl.setAttribute("ySplit", String.valueOf(paneY));
            paneEl.setAttribute("topLeftCell", this.getRefString(paneX, paneY));
            paneEl.setAttribute("activePane", "bottomLeft");
            paneEl.setAttribute("state", "frozen");
            selectionEl = doc.createElement("selection");
            sheetViewEl.appendChild(selectionEl);
            selectionEl.setAttribute("pane", "bottomLeft");
            selectionEl.setAttribute("activeCell", this.getRefString(0, paneY));
            selectionEl.setAttribute("sqref", this.getRefString(0, paneY));
        } else {
            paneEl = doc.createElement("pane");
            sheetViewEl.appendChild(paneEl);
            paneEl.setAttribute("xSplit", String.valueOf(paneX));
            paneEl.setAttribute("ySplit", String.valueOf(paneY));
            paneEl.setAttribute("topLeftCell", this.getRefString(paneX, paneY));
            paneEl.setAttribute("activePane", "bottomRight");
            paneEl.setAttribute("state", "frozen");
            selectionEl = doc.createElement("selection");
            sheetViewEl.appendChild(selectionEl);
            selectionEl.setAttribute("pane", "topRight");
            selectionEl.setAttribute("activeCell", this.getRefString(paneX, 0));
            selectionEl.setAttribute("sqref", this.getRefString(paneX, 0));
            selectionEl = doc.createElement("selection");
            sheetViewEl.appendChild(selectionEl);
            selectionEl.setAttribute("pane", "bottomLeft");
            selectionEl.setAttribute("activeCell", this.getRefString(0, paneY));
            selectionEl.setAttribute("sqref", this.getRefString(0, paneY));
            selectionEl = doc.createElement("selection");
            sheetViewEl.appendChild(selectionEl);
            selectionEl.setAttribute("pane", "bottomRight");
            selectionEl.setAttribute("activeCell", this.getRefString(paneX, paneY));
            selectionEl.setAttribute("sqref", this.getRefString(paneX, paneY));
        }
        Element sheetsFormatPrEl = doc.createElement("sheetFormatPr");
        worksheetEl.appendChild(sheetsFormatPrEl);
        sheetsFormatPrEl.setAttribute("defaultRowHeight", String.format("%s", 15));
        if (this.exportObjectFormatting) {
            Element colsEl = doc.createElement("cols");
            worksheetEl.appendChild(colsEl);
            for (int indexCol = 0; indexCol < this.matrix.getCoordX().size() - 1; ++indexCol) {
                double value2 = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexCol + 1);
                double value1 = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexCol);
                double colWidth = this.convert(value2 - value1) * 0.17343964980045;
                Element colEl = doc.createElement("col");
                colsEl.appendChild(colEl);
                colEl.setAttribute("min", String.format("%s", indexCol + 1));
                colEl.setAttribute("max", String.format("%s", indexCol + 1));
                colEl.setAttribute("width", String.format("%s", colWidth));
                colEl.setAttribute("customWidth", "1");
            }
        }
        boolean[][] readyCells = new boolean[maxRowIndex + 1][this.matrix.getCoordX().size()];
        int[][] mergedCellsStyle = new int[maxRowIndex + 1][this.matrix.getCoordX().size()];
        ArrayList<CellRangeAddress> mergedCells = new ArrayList<CellRangeAddress>();
        ArrayList<HlinkData> hlinks = new ArrayList<HlinkData>();
        Element sheetDataEl = doc.createElement("sheetData");
        worksheetEl.appendChild(sheetDataEl);
        for (int indexRow = minRowIndex; indexRow < maxRowIndex; ++indexRow) {
            this.invokeExporting(indexRow, this.matrix.getCoordY().size());
            double height = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow + 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow);
            Element rowEl = doc.createElement("row");
            sheetDataEl.appendChild(rowEl);
            rowEl.setAttribute("r", String.format("%s", indexRow + 1 - minRowIndex));
            rowEl.setAttribute("spans", String.format("%s:%s", 1, this.matrix.getCoordX().size() - 1));
            if (this.exportObjectFormatting) {
                rowEl.setAttribute("ht", String.format("%s", this.convert(height)));
                rowEl.setAttribute("customHeight", "1");
            }
            for (int indexColumn = 0; indexColumn < this.matrix.getCoordX().size() - 1; ++indexColumn) {
                boolean needBorderBottom;
                StiCell cell = this.matrix.getCells()[indexRow][indexColumn];
                if (!readyCells[indexRow][indexColumn] && cell != null) {
                    int posPatternDelimiter;
                    IStiExportImage exportImage;
                    String hyperlink;
                    readyCells[indexRow][indexColumn] = true;
                    StiRichText rtf = cell.getComponent() instanceof StiRichText ? (StiRichText)cell.getComponent() : null;
                    StiText textComp = cell.getComponent() instanceof StiText ? (StiText)cell.getComponent() : null;
                    String str = cell.getText();
                    if (rtf != null && !"".equals(rtf.unpackRTF())) {
                        str = StiRtfHelper.rtfToPlain((String)rtf.unpackRTF());
                    }
                    StiCheckBox checkComp = cell.getComponent() instanceof StiCheckBox ? (StiCheckBox)cell.getComponent() : null;
                    boolean hasCheckBoxExcelDataValue = false;
                    if (checkComp != null && checkComp.getExcelDataValue() != null && checkComp.getExcelDataValue().length() > 0) {
                        hasCheckBoxExcelDataValue = true;
                        str = checkComp.getExcelDataValue();
                    }
                    if (cell.getComponent().getHyperlinkValue() != null && (hyperlink = cell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
                        String description = str;
                        if (description == null || description.length() == 0) {
                            description = hyperlink;
                        }
                        CellRangeAddress range = new CellRangeAddress(indexRow - minRowIndex, indexRow - minRowIndex + cell.getHeight(), indexColumn, indexColumn + cell.getWidth());
                        HlinkData hl = new HlinkData(range, description, hyperlink);
                        hlinks.add(hl);
                    }
                    boolean isImage = false;
                    IStiExportImage iStiExportImage = exportImage = cell.getComponent() instanceof IStiExportImage ? (IStiExportImage)((Object)cell.getComponent()) : null;
                    if (exportImage != null) {
                        IStiExportImageExtended exportImageExtended = exportImage instanceof IStiExportImageExtended ? (IStiExportImageExtended)exportImage : null;
                        float zoom = this.imageResolution;
                        if (!ExportOptions.Excel2007.getUseImageResolution() || !(exportImage instanceof StiImage) || ((StiImage)exportImage).getImageBytesToDraw() != null) {
                            // empty if block
                        }
                        BufferedImage image = null;
                        if (cell.getComponent().isExportAsImage(StiExportFormat.Excel2007)) {
                            image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Excel2007) ? exportImageExtended.getImage(Double.valueOf(zoom), StiExportFormat.Excel) : exportImage.getImage(Double.valueOf(zoom));
                        }
                        if (image != null) {
                            BufferedImage img = this.matrix.getRealImageData(cell, image);
                            if (img != null) {
                                image = img;
                            }
                            int imageIndex = this.imageCache.addImageInt(image);
                            ExcelImageData imageData = new ExcelImageData(indexRow - minRowIndex, 0, indexColumn, 0, indexRow - minRowIndex + 1 + cell.getHeight(), 0, indexColumn + 1 + cell.getWidth(), 0, imageIndex);
                            this.imageList.add(imageData);
                            image.flush();
                            isImage = true;
                        }
                    }
                    boolean isExcelText = false;
                    if (cell.getComponent() != null && cell.getComponent().getTagValue() != null) {
                        String cellTag = cell.getComponent().getTagValue().toLowerCase();
                        isExcelText = cellTag.contains("exceltext");
                    }
                    String inputFormat = "";
                    if (textComp != null) {
                        inputFormat = textComp.getFormat();
                    }
                    boolean isFormatCurrency = false;
                    boolean isFormatNumeric = false;
                    boolean isFormatPercent = false;
                    boolean isFormatDate = false;
                    boolean isFormatTime = false;
                    boolean isFormatCustom = false;
                    boolean isDefaultFormat = false;
                    String outputFormat = "";
                    int decimalDigits = 2;
                    Currency currency = Currency.getInstance(Locale.getDefault());
                    int groupDigits = 0;
                    String currencySymbol = currency.getSymbol();
                    boolean currencyPositionBefore = currency.getDefaultFractionDigits() == 0 || currency.getDefaultFractionDigits() == 2;
                    boolean negativeBraces = false;
                    boolean hideZeros = textComp != null && textComp.getHideZeros();
                    String positivePatternString = null;
                    String negativePatternString = null;
                    int n = posPatternDelimiter = inputFormat != null ? inputFormat.indexOf("|") : -1;
                    if (posPatternDelimiter != -1) {
                        positivePatternString = StiExportUtils.getPositivePattern(inputFormat.charAt(posPatternDelimiter + 1) - 65);
                        negativePatternString = StiExportUtils.getNegativePattern(inputFormat.charAt(posPatternDelimiter + 2) - 65);
                        inputFormat = inputFormat.substring(0, posPatternDelimiter);
                    }
                    if (inputFormat != null && inputFormat.length() > 0) {
                        if (inputFormat.charAt(0) == 'C') {
                            isFormatCurrency = true;
                        } else if (inputFormat.charAt(0) == 'N') {
                            isFormatNumeric = true;
                        } else if (inputFormat.charAt(0) == 'P') {
                            isFormatPercent = true;
                        } else if (inputFormat.charAt(0) == 'D') {
                            isFormatDate = true;
                        } else if (inputFormat.charAt(0) == 'T') {
                            isFormatTime = true;
                        } else if (inputFormat.charAt(0) == 'U') {
                            isFormatCustom = true;
                        }
                        if (inputFormat.length() == 1) {
                            isDefaultFormat = true;
                        } else if (isFormatCurrency || isFormatNumeric || isFormatPercent) {
                            int indexPos = 1;
                            if (Character.isDigit(inputFormat.charAt(indexPos))) {
                                StringBuilder decimalSB = new StringBuilder();
                                while (indexPos < inputFormat.length() && Character.isDigit(inputFormat.charAt(indexPos))) {
                                    decimalSB.append(inputFormat.charAt(indexPos));
                                    ++indexPos;
                                }
                                decimalDigits = Integer.parseInt(decimalSB.toString());
                            }
                            if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == 'G') {
                                ++indexPos;
                                groupDigits = 3;
                            }
                            if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == '(') {
                                ++indexPos;
                                negativeBraces = true;
                            }
                            if (indexPos < inputFormat.length() && (inputFormat.charAt(indexPos) == '.' || inputFormat.charAt(indexPos) == ',')) {
                                ++indexPos;
                            }
                            if (indexPos < inputFormat.length() && (inputFormat.charAt(indexPos) == '+' || inputFormat.charAt(indexPos) == '-')) {
                                if (inputFormat.charAt(indexPos) == '+') {
                                    currencyPositionBefore = true;
                                }
                                currencySymbol = ++indexPos < inputFormat.length() ? inputFormat.substring(indexPos) : "";
                            }
                        }
                    }
                    if (!(isFormatCurrency || isFormatNumeric || isFormatPercent)) {
                        isDefaultFormat = true;
                    }
                    if (isFormatCurrency && isDefaultFormat) {
                        isDefaultFormat = false;
                    }
                    if (textComp != null && textComp.getHideZeros() && inputFormat != null && inputFormat.length() > 0) {
                        isDefaultFormat = false;
                    }
                    if (hideZeros && !StiValidationUtil.isNullOrEmpty((String)inputFormat)) {
                        isDefaultFormat = false;
                    }
                    if (isExcelText) {
                        isDefaultFormat = true;
                    }
                    if (!isDefaultFormat) {
                        if (posPatternDelimiter != -1) {
                            StringBuilder outputSB = new StringBuilder();
                            if (groupDigits > 1) {
                                outputSB.append("#,");
                                outputSB.append(StiStringUtil.repeatString((String)"#", (int)(groupDigits - 1)));
                            }
                            outputSB.append('0');
                            if (decimalDigits > 0) {
                                outputSB.append(".");
                                outputSB.append(StiStringUtil.repeatString((String)"0", (int)decimalDigits));
                            }
                            String nn = outputSB.toString();
                            String positivePattern = positivePatternString.replace("n", nn).replace("$", "\"" + currencySymbol + "\"");
                            String negativePattern = negativePatternString.replace("n", nn).replace("$", "\"" + currencySymbol + "\"");
                            outputFormat = positivePattern + ";" + negativePattern + (hideZeros ? ";" : "");
                        } else {
                            StringBuilder outputSB = new StringBuilder();
                            if (isFormatCurrency && currencyPositionBefore) {
                                outputSB.append("\"");
                                outputSB.append(currencySymbol);
                                outputSB.append("\"");
                            }
                            if (groupDigits > 1) {
                                outputSB.append("#,");
                                outputSB.append(StiStringUtil.repeatString((String)"#", (int)(groupDigits - 1)));
                            }
                            outputSB.append('0');
                            if (decimalDigits > 0) {
                                outputSB.append(".");
                                outputSB.append(StiStringUtil.repeatString((String)"0", (int)decimalDigits));
                            }
                            if (isFormatCurrency && !currencyPositionBefore) {
                                outputSB.append("\"");
                                outputSB.append(currencySymbol);
                                outputSB.append("\"");
                            }
                            if (isFormatPercent) {
                                outputSB.append("%");
                            }
                            outputFormat = outputSB.toString();
                            String negativePattern = (negativeBraces ? "(" : "-") + outputFormat + (negativeBraces ? ")" : "");
                            if (hideZeros) {
                                outputFormat = outputFormat + ";" + negativePattern + ";";
                            } else if (negativeBraces) {
                                outputFormat = outputFormat + ";" + negativePattern;
                            }
                        }
                    }
                    int formatIndex = 0;
                    if (isDefaultFormat) {
                        if (isFormatNumeric) {
                            formatIndex = 4;
                        }
                        if (isFormatPercent) {
                            formatIndex = 10;
                        }
                        if (isFormatDate) {
                            formatIndex = 14;
                        }
                        if (isFormatTime) {
                            formatIndex = 21;
                        }
                        if (isExcelText) {
                            formatIndex = 49;
                        }
                    } else {
                        formatIndex = this.getFormatNumber(outputFormat);
                    }
                    int indexStyle = 0;
                    if (this.exportObjectFormatting) {
                        StiCellStyle style = cell.getCellStyle();
                        DataFont tempFont = new DataFont(style.getFont().getName(), style.getFont().bold(), style.getFont().italic(), style.getFont().underline(), style.getFont().strikeout(), (int)style.getFont().getSize(), style.getTextColor(), 1, 0);
                        if (hasCheckBoxExcelDataValue) {
                            tempFont = new DataFont(ExportOptions.StiCheckBoxExcelValueParameters.getFont().getName(), ExportOptions.StiCheckBoxExcelValueParameters.getFont().bold(), ExportOptions.StiCheckBoxExcelValueParameters.getFont().italic(), ExportOptions.StiCheckBoxExcelValueParameters.getFont().underline(), ExportOptions.StiCheckBoxExcelValueParameters.getFont().strikeout(), (int)ExportOptions.StiCheckBoxExcelValueParameters.getFont().getSize(), style.getTextColor(), 1, 0);
                        }
                        DataFill tempFill = new DataFill("solid", style.getColor(), style.getColor());
                        if (isImage) {
                            tempFill = new DataFill("solid", StiColorEnum.Transparent.color(), StiColorEnum.Transparent.color());
                        }
                        boolean needBorderLeft = true;
                        boolean needBorderRight = true;
                        for (int index = 0; index < cell.getHeight() + 1; ++index) {
                            if (this.matrix.getBordersY()[cell.getTop() + index][cell.getLeft()] == null) {
                                needBorderLeft = false;
                            }
                            if (this.matrix.getBordersY()[cell.getTop() + index][cell.getLeft() + cell.getWidth() + 1] != null) continue;
                            needBorderRight = false;
                        }
                        boolean needBorderTop = true;
                        boolean needBorderBottom2 = true;
                        for (int index = 0; index < cell.getWidth() + 1; ++index) {
                            if (this.matrix.getBordersX()[cell.getTop()][cell.getLeft() + index] == null) {
                                needBorderTop = false;
                            }
                            if (this.matrix.getBordersX()[cell.getTop() + cell.getHeight() + 1][cell.getLeft() + index] != null) continue;
                            needBorderBottom2 = false;
                        }
                        DataBorder tempBorder = new DataBorder(needBorderLeft ? this.matrix.getBordersY()[cell.getTop()][cell.getLeft()] : null, needBorderRight ? this.matrix.getBordersY()[cell.getTop()][cell.getLeft() + cell.getWidth() + 1] : null, needBorderTop ? this.matrix.getBordersX()[cell.getTop()][cell.getLeft()] : null, needBorderBottom2 ? this.matrix.getBordersX()[cell.getTop() + cell.getHeight() + 1][cell.getLeft()] : null);
                        boolean rightToLeft = false;
                        if (style.getTextOptions() != null) {
                            rightToLeft = style.getTextOptions().getRightToLeft();
                        }
                        boolean textWordWrap = false;
                        if (style.getTextOptions() != null) {
                            textWordWrap = style.getTextOptions().getWordWrap();
                        }
                        if (str != null && str.length() > 0 && (str.indexOf("\r") != -1 || str.indexOf("\n") != -1)) {
                            textWordWrap = true;
                            if (textComp != null && textComp.getAllowHtmlTags() && (str.indexOf("<br") != -1 || str.indexOf("<ul") != -1 || str.indexOf("<ol") != -1 || str.indexOf("<p") != -1)) {
                                textWordWrap = true;
                            }
                        }
                        int rotationAngle = 0;
                        if (style.getTextOptions() != null) {
                            int tempAngle = (int)style.getTextOptions().getAngle();
                            if (tempAngle >= 0 && tempAngle <= 90) {
                                rotationAngle = tempAngle;
                            }
                            if (tempAngle >= 270 && tempAngle < 360) {
                                rotationAngle = 360 - tempAngle + 90;
                            }
                        }
                        DataXF tempXF = new DataXF(formatIndex, this.getFontNumber(tempFont), this.getFillNumber(tempFill), this.getBorderNumber(tempBorder), 0, hasCheckBoxExcelDataValue ? ExportOptions.StiCheckBoxExcelValueParameters.getHorAlignment() : style.getHorAlignment(), hasCheckBoxExcelDataValue ? ExportOptions.StiCheckBoxExcelValueParameters.getVertAlignment() : style.getVertAlignment(), rotationAngle, textWordWrap, rightToLeft);
                        indexStyle = this.getXFNumber(tempXF);
                    }
                    Element cEl = doc.createElement("c");
                    rowEl.appendChild(cEl);
                    cEl.setAttribute("r", this.getRefString(indexColumn, indexRow - minRowIndex));
                    cEl.setAttribute("s", String.valueOf(indexStyle));
                    if (this.exportObjectFormatting) {
                        for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                            for (int yy = 0; yy <= cell.getHeight(); ++yy) {
                                readyCells[indexRow + yy][indexColumn + xx] = true;
                                mergedCellsStyle[indexRow + yy][indexColumn + xx] = indexStyle;
                            }
                        }
                        if (cell.getWidth() > 0 || cell.getHeight() > 0) {
                            CellRangeAddress tempCellRange = new CellRangeAddress(indexRow - minRowIndex, indexRow - minRowIndex + cell.getHeight(), indexColumn, indexColumn + cell.getWidth());
                            mergedCells.add(tempCellRange);
                        }
                    } else {
                        readyCells[indexRow][indexColumn] = true;
                        mergedCellsStyle[indexRow][indexColumn] = indexStyle;
                    }
                    if (cell.getComponent().isExportAsImage(StiExportFormat.Excel2007) || (str == null || str.length() <= 0) && (textComp == null || textComp.getExcelDataValue() == null)) continue;
                    boolean isFormula = false;
                    boolean isNumber = false;
                    double number = 0.0;
                    if (textComp != null && textComp.getExcelDataValue() != null && !textComp.getExcelDataValue().equals("-")) {
                        String value = textComp.getExcelDataValue();
                        String value2 = value.replace(",", ".");
                        if (value2 != null && value2.length() > 0) {
                            isNumber = true;
                            try {
                                if (isFormatDate || isFormatTime) {
                                    isNumber = false;
                                } else {
                                    number = Double.parseDouble(value2);
                                }
                            }
                            catch (NumberFormatException e) {
                                isNumber = false;
                            }
                        }
                        if (value != str && value.startsWith("=")) {
                            isFormula = true;
                        }
                        if (!isNumber && str == null) {
                            str = value;
                        }
                    }
                    if (isFormula) {
                        String strs = textComp.getExcelDataValue().replaceAll("\\r", "").replace('\t', ' ').substring(1);
                        if (ExportOptions.Excel2007.getTrimTrailingSpaces()) {
                            strs = StiExportUtils.trimEndWhiteSpace(strs);
                        }
                        StiXmlHelper.writeElementString((Document)doc, (Element)cEl, (String)"f", (String)strs);
                        continue;
                    }
                    if (isNumber) {
                        StiXmlHelper.writeElementString((Document)doc, (Element)cEl, (String)"v", (String)String.valueOf(number).replace(',', '.'));
                        continue;
                    }
                    String strs = str.replaceAll("\\r", "").replace('\t', ' ');
                    if (ExportOptions.Excel2007.getTrimTrailingSpaces()) {
                        strs = StiExportUtils.trimEndWhiteSpace(strs);
                    }
                    int indexSST = 0;
                    if (textComp != null && textComp.getAllowHtmlTags()) {
                        Element si = this.convertAllowHtmlTagsToExcelString(textComp, strs, null, null);
                        strs = StiXmlHelper.serialize((Document)doc, (boolean)false, (Element)si);
                        strs = strs.replaceAll("(<|<\\/)root([^>]*)>", "").replaceAll("<\\?xml([^>]*)>", "");
                        indexSST = this.getSSTNumber(strs);
                        this.sstHashIsTags.put(indexSST, textComp);
                    } else {
                        indexSST = this.getSSTNumber(strs);
                    }
                    cEl.setAttribute("t", "s");
                    StiXmlHelper.writeElementString((Document)doc, (Element)cEl, (String)"v", (String)String.valueOf(indexSST));
                    continue;
                }
                int indexStyle = 0;
                if (readyCells[indexRow][indexColumn]) {
                    indexStyle = mergedCellsStyle[indexRow][indexColumn];
                }
                boolean needBorderLeft = this.matrix.getBordersY()[indexRow + 0][indexColumn + 0] != null;
                boolean needBorderRight = this.matrix.getBordersY()[indexRow + 0][indexColumn + 1] != null;
                boolean needBorderTop = this.matrix.getBordersX()[indexRow + 0][indexColumn + 0] != null;
                boolean bl = needBorderBottom = this.matrix.getBordersX()[indexRow + 1][indexColumn + 0] != null;
                if (!needBorderLeft && !needBorderRight && !needBorderTop && !needBorderBottom && indexStyle == 0) continue;
                DataBorder tempBorder = new DataBorder(needBorderLeft ? this.matrix.getBordersY()[indexRow + 0][indexColumn + 0] : null, needBorderRight ? this.matrix.getBordersY()[indexRow + 0][indexColumn + 1] : null, needBorderTop ? this.matrix.getBordersX()[indexRow + 0][indexColumn + 0] : null, needBorderBottom ? this.matrix.getBordersX()[indexRow + 1][indexColumn + 0] : null);
                DataXF parentXF = this.xfList.get(indexStyle);
                DataXF tempXF = new DataXF(parentXF.FormatIndex, parentXF.FontIndex, parentXF.FillIndex, this.getBorderNumber(tempBorder), parentXF.XFId, parentXF.HorAlign, parentXF.VertAlign, parentXF.TextRotationAngle, parentXF.TextWrapped, parentXF.RightToLeft);
                int newIndexStyle = this.getXFNumber(tempXF);
                if (!this.exportObjectFormatting) {
                    newIndexStyle = 0;
                }
                Element cEl = doc.createElement("c");
                rowEl.appendChild(cEl);
                cEl.setAttribute("r", this.getRefString(indexColumn, indexRow - minRowIndex));
                cEl.setAttribute("s", String.valueOf(newIndexStyle));
            }
        }
        if (mergedCells.size() > 0 && (!this.exportDataOnly || this.exportObjectFormatting)) {
            Element mergeCells = doc.createElement("mergeCells");
            worksheetEl.appendChild(mergeCells);
            mergeCells.setAttribute("count", String.format("%s", mergedCells.size()));
            for (int index = 0; index < mergedCells.size(); ++index) {
                CellRangeAddress tempCellRange = (CellRangeAddress)mergedCells.get(index);
                Element mergeCell = doc.createElement("mergeCell");
                mergeCells.appendChild(mergeCell);
                mergeCell.setAttribute("ref", String.format("%s:%s", this.getRefString(tempCellRange.FirstColumn, tempCellRange.FirstRow), this.getRefString(tempCellRange.LastColumn, tempCellRange.LastRow)));
            }
        }
        if (hlinks.size() > 0) {
            Element hyperlinksEl = doc.createElement("hyperlinks");
            worksheetEl.appendChild(hyperlinksEl);
            for (int indexHlink = 0; indexHlink < hlinks.size(); ++indexHlink) {
                HlinkData hl = (HlinkData)hlinks.get(indexHlink);
                String hyperlink = hl.Bookmark;
                if (hyperlink.startsWith("#")) {
                    hyperlink = hyperlink.substring(1);
                    boolean isFounded = false;
                    for (int indexMatrix = 0; indexMatrix < this.matrixList.size(); ++indexMatrix) {
                        String[][] bookmarks = this.matrixList.get(indexMatrix).getBookmarks();
                        int minRow = this.minRowList.get(indexMatrix);
                        int maxRow = this.maxRowList.get(indexMatrix);
                        int sizeColumn = bookmarks[0].length;
                        for (int indexRow = minRow; indexRow < maxRow; ++indexRow) {
                            for (int indexColumn = 0; indexColumn < sizeColumn; ++indexColumn) {
                                if (!hyperlink.equals(bookmarks[indexRow][indexColumn])) continue;
                                hyperlink = String.format("'%s'!%s", this.sheetNameList.get(indexMatrix), this.getRefString(indexColumn, indexRow - minRow));
                                isFounded = true;
                                break;
                            }
                            if (isFounded) break;
                        }
                        if (isFounded) break;
                    }
                    if (!isFounded) continue;
                    Element hyperlinkEl = doc.createElement("hyperlink");
                    hyperlinksEl.appendChild(hyperlinkEl);
                    hyperlinkEl.setAttribute("ref", this.getRefString(hl.Range.FirstColumn, hl.Range.FirstRow));
                    hyperlinkEl.setAttribute("location", hyperlink);
                    hyperlinkEl.setAttribute("display", hl.Description);
                    continue;
                }
                String display = hyperlink;
                if (hyperlink.startsWith("file:\\\\\\")) {
                    display = hyperlink.substring(8);
                    hyperlink = "file:///" + display;
                }
                if (hyperlink.startsWith("http:")) {
                    hyperlink = hyperlink.replaceAll(" ", "");
                }
                Element hyperlinkEl = doc.createElement("hyperlink");
                hyperlinksEl.appendChild(hyperlinkEl);
                hyperlinkEl.setAttribute("ref", this.getRefString(hl.Range.FirstColumn, hl.Range.FirstRow));
                hyperlinkEl.setAttribute("r:id", String.format("rId%s", 2 + this.hyperlinkList.size()));
                hyperlinkEl.setAttribute("display", display);
                this.hyperlinkList.add(this.stringToUrl(hyperlink));
            }
        }
        Element pageMargins = doc.createElement("pageMargins");
        worksheetEl.appendChild(pageMargins);
        pageMargins.setAttribute("left", this.floatToString(page.getUnit().ConvertToHInches(page.getMargins().getLeft()) / 100.0));
        pageMargins.setAttribute("right", this.floatToString(page.getUnit().ConvertToHInches(page.getMargins().getRight()) / 100.0));
        pageMargins.setAttribute("top", this.floatToString(page.getUnit().ConvertToHInches(page.getMargins().getTop()) / 100.0));
        pageMargins.setAttribute("bottom", this.floatToString(page.getUnit().ConvertToHInches(page.getMargins().getBottom()) / 100.0));
        pageMargins.setAttribute("header", this.floatToString(0.0));
        pageMargins.setAttribute("footer", this.floatToString(0.0));
        Element pageSetupEl = doc.createElement("pageSetup");
        worksheetEl.appendChild(pageSetupEl);
        pageSetupEl.setAttribute("paperSize", String.format("%s", page.getPaperSize().getValue()));
        pageSetupEl.setAttribute("orientation", page.getOrientation() == StiPageOrientation.Portrait ? "portrait" : "landscape");
        int horizontalPageBreaksCount = this.matrix.getHorizontalPageBreaks().size();
        if (this.exportHorizontalPageBreaks && horizontalPageBreaksCount > 0) {
            Element rowBreaksEl = doc.createElement("rowBreaks");
            worksheetEl.appendChild(rowBreaksEl);
            rowBreaksEl.setAttribute("count", String.valueOf(horizontalPageBreaksCount));
            rowBreaksEl.setAttribute("manualBreakCount", String.valueOf(horizontalPageBreaksCount));
            for (int indexBreak = 0; indexBreak < horizontalPageBreaksCount; ++indexBreak) {
                Element brkEl = doc.createElement("brk");
                rowBreaksEl.appendChild(brkEl);
                brkEl.setAttribute("id", String.format("%s", (int)this.matrix.getHorizontalPageBreaks().get(indexBreak)));
                brkEl.setAttribute("max", indexBreak == 0 ? "16383" : "8");
                brkEl.setAttribute("man", "1");
            }
        }
        if (!StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
            Element headerFooterEl = doc.createElement("headerFooter");
            worksheetEl.appendChild(headerFooterEl);
            Element oddHeader = doc.createElement("oddHeader");
            headerFooterEl.appendChild(oddHeader);
            oddHeader.setTextContent("&amp;C\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n&amp;G");
        }
        if (this.imageList.size() > this.imageListOffset) {
            Element drawingEl = doc.createElement("drawing");
            worksheetEl.appendChild(drawingEl);
            drawingEl.setAttribute("r:id", String.format("rId%s", 1));
        }
        return doc;
    }

    private void prepareMatrix(StiPagesCollection pages) {
        this.matrix = new StiMatrix(pages, ExportOptions.Excel2007.getDivideBigCells(), this);
        if (this.isStoped()) {
            return;
        }
        if (this.useOnePageHeaderAndFooter) {
            int tempOffset;
            this.matrix.scanComponentsPlacement(true, this.exportObjectFormatting);
            for (tempOffset = 0; this.matrix.getLinePlacement()[tempOffset] != StiMatrix.StiTableLineInfo.PageHeader && tempOffset < this.matrix.getCoordY().size() - 1; ++tempOffset) {
            }
            if (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageHeader) {
                while (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageHeader && tempOffset < this.matrix.getCoordY().size() - 1) {
                    ++tempOffset;
                }
                while (tempOffset < this.matrix.getCoordY().size() - 1) {
                    if (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageHeader) {
                        this.matrix.getLinePlacement()[tempOffset] = StiMatrix.StiTableLineInfo.Trash;
                    }
                    ++tempOffset;
                }
            }
            for (tempOffset = this.matrix.getCoordY().size() - 1; this.matrix.getLinePlacement()[tempOffset] != StiMatrix.StiTableLineInfo.PageFooter && tempOffset > 0; --tempOffset) {
            }
            if (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageFooter) {
                while (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageFooter && tempOffset > 0) {
                    --tempOffset;
                }
                while (tempOffset > 0) {
                    if (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageFooter) {
                        this.matrix.getLinePlacement()[tempOffset] = StiMatrix.StiTableLineInfo.Trash;
                    }
                    --tempOffset;
                }
            }
            int linesCount = 0;
            for (int rowIndex = 0; rowIndex < this.matrix.getCoordY().size() - 1; ++rowIndex) {
                if (this.matrix.getLinePlacement()[rowIndex] == StiMatrix.StiTableLineInfo.Trash) continue;
                for (int columnIndex = 0; columnIndex < this.matrix.getCoordX().size() - 1; ++columnIndex) {
                    this.matrix.getCells()[linesCount][columnIndex] = this.matrix.getCells()[rowIndex][columnIndex];
                    StiCell cell = this.matrix.getCells()[linesCount][columnIndex];
                    if (cell != null) {
                        cell.setTop(linesCount);
                        if (cell.getExportImage() != null) {
                            StiComponent component = cell.getComponent();
                            StiRectangle objRect = this.matrix.getImagesBaseRect().get(component);
                            if (objRect != null) {
                                double offset = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), linesCount);
                                objRect.setY(objRect.getY() - offset);
                                this.matrix.getImagesBaseRect().put(component, objRect);
                            }
                        }
                    }
                    this.matrix.getBordersX()[linesCount][columnIndex] = this.matrix.getBordersX()[rowIndex][columnIndex];
                    this.matrix.getBordersY()[linesCount][columnIndex] = this.matrix.getBordersY()[rowIndex][columnIndex];
                    this.matrix.getBookmarks()[linesCount][columnIndex] = this.matrix.getBookmarks()[rowIndex][columnIndex];
                }
                this.matrix.getBordersY()[linesCount][this.matrix.getCoordX().size() - 1] = this.matrix.getBordersY()[rowIndex][this.matrix.getCoordX().size() - 1];
                double lineHeight = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex + 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex);
                StiMapUtil.setByIndex(this.matrix.getCoordY(), linesCount + 1, (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), linesCount) + lineHeight);
                ++linesCount;
            }
            for (int columnIndex = 0; columnIndex < this.matrix.getCoordX().size() - 1; ++columnIndex) {
                this.matrix.getBordersX()[linesCount][columnIndex] = this.matrix.getBordersX()[this.matrix.getCoordY().size() - 1][columnIndex];
            }
            int numAbove = this.matrix.getCoordY().size() - 1 - linesCount;
            if (numAbove > 0) {
                for (int tempIndex = 0; tempIndex < numAbove; ++tempIndex) {
                    StiMapUtil.removeAt(this.matrix.getCoordY(), linesCount + 1);
                }
            }
        }
        if (this.exportDataOnly) {
            this.matrix.scanComponentsPlacement(true, this.exportObjectFormatting);
            int linesCount = 0;
            Hashtable<String, String> headerNames = new Hashtable<String, String>();
            String lastParentBandName = null;
            boolean allowExportFooters = ExportOptions.Excel.isAllowExportFootersInDataOnlyMode();
            for (int rowIndex = 0; rowIndex < this.matrix.getCoordY().size() - 1; ++rowIndex) {
                boolean isHeader = false;
                if (this.matrix.getLinePlacement()[rowIndex] == StiMatrix.StiTableLineInfo.HeaderD || this.matrix.getLinePlacement()[rowIndex] == StiMatrix.StiTableLineInfo.HeaderAP) {
                    String parentBandName;
                    String tempSt = this.matrix.getParentBandName()[rowIndex];
                    int symPos = tempSt.indexOf(31);
                    if (symPos != -1 && !(parentBandName = tempSt.substring(0, symPos)).equals(lastParentBandName)) {
                        lastParentBandName = parentBandName;
                        headerNames.clear();
                    }
                    if (!headerNames.containsKey(tempSt)) {
                        isHeader = true;
                        headerNames.put(tempSt, tempSt);
                    }
                }
                if (this.matrix.getLinePlacement()[rowIndex] != StiMatrix.StiTableLineInfo.Data && (!allowExportFooters || this.matrix.getLinePlacement()[rowIndex] != StiMatrix.StiTableLineInfo.FooterD) && !isHeader) continue;
                for (int columnIndex = 0; columnIndex < this.matrix.getCoordX().size() - 1; ++columnIndex) {
                    this.matrix.getCells()[linesCount][columnIndex] = this.matrix.getCells()[rowIndex][columnIndex];
                    StiCell cell = this.matrix.getCells()[linesCount][columnIndex];
                    if (cell != null) {
                        cell.setTop(linesCount);
                        if (cell.getExportImage() != null) {
                            StiComponent component = cell.getComponent();
                            StiRectangle objRect = this.matrix.getImagesBaseRect().get(component);
                            if (objRect != null) {
                                double offset = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), linesCount);
                                objRect.setY(objRect.getY() - offset);
                                this.matrix.getImagesBaseRect().put(component, objRect);
                            }
                        }
                    }
                    if (linesCount == 0 || this.matrix.getBordersX()[rowIndex][columnIndex] != null) {
                        this.matrix.getBordersX()[linesCount][columnIndex] = this.matrix.getBordersX()[rowIndex][columnIndex];
                    }
                    this.matrix.getBordersX()[linesCount + 1][columnIndex] = this.matrix.getBordersX()[rowIndex + 1][columnIndex];
                    this.matrix.getBordersY()[linesCount][columnIndex] = this.matrix.getBordersY()[rowIndex][columnIndex];
                    this.matrix.getBookmarks()[linesCount][columnIndex] = this.matrix.getBookmarks()[rowIndex][columnIndex];
                }
                this.matrix.getBordersY()[linesCount][this.matrix.getCoordX().size() - 1] = this.matrix.getBordersY()[rowIndex][this.matrix.getCoordX().size() - 1];
                double lineHeight = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex + 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex);
                StiMapUtil.setByIndex(this.matrix.getCoordY(), linesCount + 1, (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), linesCount) + lineHeight);
                ++linesCount;
            }
            int numAbove = this.matrix.getCoordY().size() - 1 - linesCount;
            if (numAbove > 0) {
                for (int tempIndex = 0; tempIndex < numAbove; ++tempIndex) {
                    StiMapUtil.removeAt(this.matrix.getCoordY(), linesCount + 1);
                }
            }
        }
    }

    private Element convertAllowHtmlTagsToExcelString(StiText textBox, String input, Document doc, Element root) throws IOException, ParserConfigurationException {
        if (doc == null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
            root = doc.createElement("si");
            doc.appendChild(root);
        }
        StiHtmlTagsState baseTagsState = new StiHtmlTagsState(textBox.getFont().bold(), textBox.getFont().italic(), textBox.getFont().underline(), textBox.getFont().strikeout(), (float)textBox.getFont().getSize(), textBox.getFont().getName(), StiBrush.ToColor((StiBrush)textBox.getTextBrush()), StiBrush.ToColor((StiBrush)textBox.getBrush()), false, false, 0.0, 0.0, 1.0, textBox.getHorAlignment());
        StiHtmlState baseState = new StiHtmlState(baseTagsState, 0);
        List states = StiTextRendererParseHtml.parseHtmlToStates((String)textBox.getTextInternal(), (StiHtmlState)baseState);
        for (StiHtmlState state : states) {
            Element vertAlign;
            Element rEl = doc.createElement("r");
            root.appendChild(rEl);
            Element rPrEl = doc.createElement("rPr");
            rEl.appendChild(rPrEl);
            if (state.getTs().isBold()) {
                StiXmlHelper.writeElementString((Document)doc, (Element)rPrEl, (String)"b", null);
            }
            if (state.getTs().isItalic()) {
                StiXmlHelper.writeElementString((Document)doc, (Element)rPrEl, (String)"i", null);
            }
            if (state.getTs().isUnderline()) {
                StiXmlHelper.writeElementString((Document)doc, (Element)rPrEl, (String)"u", null);
            }
            if (state.getTs().isStrikeout()) {
                StiXmlHelper.writeElementString((Document)doc, (Element)rPrEl, (String)"strike", null);
            }
            if (state.getTs().isSuperscript()) {
                vertAlign = doc.createElement("vertAlign");
                rPrEl.appendChild(vertAlign);
                vertAlign.setAttribute("val", "superscript");
            }
            if (state.getTs().subscript) {
                vertAlign = doc.createElement("vertAlign");
                rPrEl.appendChild(vertAlign);
                vertAlign.setAttribute("val", "subscript");
            }
            Element szEl = doc.createElement("sz");
            rPrEl.appendChild(szEl);
            szEl.setAttribute("val", String.valueOf(state.getTs().getFontSize()));
            Element colorEl = doc.createElement("color");
            rPrEl.appendChild(colorEl);
            colorEl.setAttribute("rgb", state.getTs().getFontColor().toArgbHTML().substring(1));
            Element rFontEl = doc.createElement("rFont");
            rPrEl.appendChild(rFontEl);
            rFontEl.setAttribute("val", state.getTs().getFontName());
            this.convertTextToExcelString(rEl, StiTextRenderer.prepareStateText(state.getText()).toString(), doc);
        }
        return root;
    }

    private void convertTextToExcelString(Element el, String input, Document doc) {
        Element tEl = doc.createElement("t");
        el.appendChild(tEl);
        if (input.length() > 0 && (Character.isWhitespace(input.charAt(input.length() - 1)) || input.indexOf(10) != -1)) {
            tEl.setAttribute("xml:space", "preserve");
        }
        tEl.setTextContent(input);
    }

    private Document writeDrawingRels(int indexSheet) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        for (int index = this.imageListOffset; index < this.imageList.size(); ++index) {
            ExcelImageData image = this.imageList.get(index);
            Element relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", index - this.imageListOffset + 1));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            relationshipEl.setAttribute("Target", String.format("../media/image%05d.jpeg", image.ImageIndex + 1));
        }
        return doc;
    }

    private Document writeDrawing(int indexSheet) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element wsDrEl = doc.createElement("xdr:wsDr");
        doc.appendChild(wsDrEl);
        wsDrEl.setAttribute("xmlns:xdr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
        wsDrEl.setAttribute("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        for (int index = this.imageListOffset; index < this.imageList.size(); ++index) {
            ExcelImageData image = this.imageList.get(index);
            Element twoCellAnchorEl = doc.createElement("xdr:twoCellAnchor");
            wsDrEl.appendChild(twoCellAnchorEl);
            twoCellAnchorEl.setAttribute("editAs", "oneCell");
            Element fromEl = doc.createElement("xdr:from");
            twoCellAnchorEl.appendChild(fromEl);
            StiXmlHelper.writeElementString((Document)doc, (Element)fromEl, (String)"xdr:col", (String)String.format("%s", image.FirstColumnIndex));
            StiXmlHelper.writeElementString((Document)doc, (Element)fromEl, (String)"xdr:colOff", (String)String.format("%s", image.FirstColumnOffset));
            StiXmlHelper.writeElementString((Document)doc, (Element)fromEl, (String)"xdr:row", (String)String.format("%s", image.FirstRowIndex));
            StiXmlHelper.writeElementString((Document)doc, (Element)fromEl, (String)"xdr:rowOff", (String)String.format("%s", image.FirstRowOffset));
            Element toEl = doc.createElement("xdr:to");
            twoCellAnchorEl.appendChild(toEl);
            StiXmlHelper.writeElementString((Document)doc, (Element)toEl, (String)"xdr:col", (String)String.format("%s", image.LastColumnIndex));
            StiXmlHelper.writeElementString((Document)doc, (Element)toEl, (String)"xdr:colOff", (String)String.format("%s", image.LastColumnOffset));
            StiXmlHelper.writeElementString((Document)doc, (Element)toEl, (String)"xdr:row", (String)String.format("%s", image.LastRowIndex));
            StiXmlHelper.writeElementString((Document)doc, (Element)toEl, (String)"xdr:rowOff", (String)String.format("%s", image.LastRowOffset));
            Element picEl = doc.createElement("xdr:pic");
            twoCellAnchorEl.appendChild(picEl);
            Element nvPicPrEl = doc.createElement("xdr:nvPicPr");
            picEl.appendChild(nvPicPrEl);
            Element cNvPrEl = doc.createElement("xdr:cNvPr");
            nvPicPrEl.appendChild(cNvPrEl);
            cNvPrEl.setAttribute("id", String.format("%s", index - this.imageListOffset + 2));
            cNvPrEl.setAttribute("name", String.format("Picture %s", index - this.imageListOffset + 1));
            cNvPrEl.setAttribute("descr", String.format("image%05d", index + 1));
            Element cNvPicPrEl = doc.createElement("xdr:cNvPicPr");
            nvPicPrEl.appendChild(cNvPicPrEl);
            Element picLocksEl = doc.createElement("a:picLocks");
            cNvPicPrEl.appendChild(picLocksEl);
            picLocksEl.setAttribute("noChangeAspect", "1");
            Element blipFillEl = doc.createElement("xdr:blipFill");
            picEl.appendChild(blipFillEl);
            Element blipEl = doc.createElement("a:blip");
            blipFillEl.appendChild(blipEl);
            blipEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            blipEl.setAttribute("r:embed", String.format("rId%s", index - this.imageListOffset + 1));
            Element stretchEl = doc.createElement("a:stretch");
            blipFillEl.appendChild(stretchEl);
            Element fillRectEl = doc.createElement("a:fillRect");
            stretchEl.appendChild(fillRectEl);
            Element spPrEl = doc.createElement("xdr:spPr");
            picEl.appendChild(spPrEl);
            Element xfrmEl = doc.createElement("a:xfrm");
            spPrEl.appendChild(xfrmEl);
            Element offEl = doc.createElement("a:off");
            xfrmEl.appendChild(offEl);
            offEl.setAttribute("x", "1");
            offEl.setAttribute("y", "1");
            Element extEl = doc.createElement("a:ext");
            xfrmEl.appendChild(extEl);
            extEl.setAttribute("cx", "2");
            extEl.setAttribute("cy", "2");
            Element prstGeomEl = doc.createElement("a:prstGeom");
            spPrEl.appendChild(prstGeomEl);
            prstGeomEl.setAttribute("prst", "rect");
            prstGeomEl.appendChild(doc.createElement("a:avLst"));
            twoCellAnchorEl.appendChild(doc.createElement("xdr:clientData"));
        }
        return doc;
    }

    private Document writeStyles() throws ParserConfigurationException {
        int index;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element styleSheetEl = doc.createElement("styleSheet");
        doc.appendChild(styleSheetEl);
        styleSheetEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        if (this.formatList.size() > 0) {
            Element numFmtsEl = doc.createElement("numFmts");
            styleSheetEl.appendChild(numFmtsEl);
            numFmtsEl.setAttribute("count", String.format("%s", this.formatList.size()));
            for (index = 0; index < this.formatList.size(); ++index) {
                Element numFmtEl = doc.createElement("numFmt");
                numFmtsEl.appendChild(numFmtEl);
                numFmtEl.setAttribute("numFmtId", String.format("%s", 164 + index));
                numFmtEl.setAttribute("formatCode", this.formatList.get(index));
            }
        }
        Element fontsEl = doc.createElement("fonts");
        styleSheetEl.appendChild(fontsEl);
        fontsEl.setAttribute("count", String.format("%s", this.fontList.size()));
        for (index = 0; index < this.fontList.size(); ++index) {
            DataFont tempFont = this.fontList.get(index);
            Element fontEl = doc.createElement("font");
            fontsEl.appendChild(fontEl);
            if (tempFont.Bold) {
                StiXmlHelper.writeElementString((Document)doc, (Element)fontEl, (String)"b", (String)"");
            }
            if (tempFont.Italic) {
                StiXmlHelper.writeElementString((Document)doc, (Element)fontEl, (String)"i", (String)"");
            }
            if (tempFont.Underlined) {
                StiXmlHelper.writeElementString((Document)doc, (Element)fontEl, (String)"u", (String)"");
            }
            if (tempFont.Strikeout) {
                StiXmlHelper.writeElementString((Document)doc, (Element)fontEl, (String)"strike", (String)"");
            }
            Element szEl = doc.createElement("sz");
            fontEl.appendChild(szEl);
            szEl.setAttribute("val", String.format("%s", tempFont.Height));
            Element colorEl = doc.createElement("color");
            fontEl.appendChild(colorEl);
            colorEl.setAttribute("rgb", tempFont.Color.toArgbHTML().substring(1));
            Element nameEl = doc.createElement("name");
            fontEl.appendChild(nameEl);
            nameEl.setAttribute("val", tempFont.Name);
            Element charsetEl = doc.createElement("charset");
            fontEl.appendChild(charsetEl);
            charsetEl.setAttribute("val", String.format("%s", tempFont.Charset));
        }
        Element fillsEl = doc.createElement("fills");
        styleSheetEl.appendChild(fillsEl);
        fillsEl.setAttribute("count", String.format("%s", this.fillList.size()));
        for (int index2 = 0; index2 < this.fillList.size(); ++index2) {
            DataFill tempFill = this.fillList.get(index2);
            Element fillEl = doc.createElement("fill");
            fillsEl.appendChild(fillEl);
            Element patternEl = doc.createElement("patternFill");
            fillEl.appendChild(patternEl);
            patternEl.setAttribute("patternType", tempFill.Type);
            if (!"solid".equals(tempFill.Type)) continue;
            Element fgColorEl = doc.createElement("fgColor");
            patternEl.appendChild(fgColorEl);
            fgColorEl.setAttribute("rgb", tempFill.FgColor.toArgbHTML().substring(1));
            Element bgColorEl = doc.createElement("bgColor");
            patternEl.appendChild(bgColorEl);
            bgColorEl.setAttribute("indexed", String.format("%s", 64));
        }
        Element bordersEl = doc.createElement("borders");
        styleSheetEl.appendChild(bordersEl);
        bordersEl.setAttribute("count", String.format("%s", this.borderList.size()));
        for (int index3 = 0; index3 < this.borderList.size(); ++index3) {
            DataBorder tempBorder = this.borderList.get(index3);
            Element borderEl = doc.createElement("border");
            bordersEl.appendChild(borderEl);
            this.writeBorderData(borderEl, "left", tempBorder.BorderLeft, doc);
            this.writeBorderData(borderEl, "right", tempBorder.BorderRight, doc);
            this.writeBorderData(borderEl, "top", tempBorder.BorderTop, doc);
            this.writeBorderData(borderEl, "bottom", tempBorder.BorderBottom, doc);
            this.writeBorderData(borderEl, "diagonal", null, doc);
        }
        Element cellStyleXfs = doc.createElement("cellStyleXfs");
        styleSheetEl.appendChild(cellStyleXfs);
        cellStyleXfs.setAttribute("count", String.format("%s", 1));
        Element xfEl = doc.createElement("xf");
        cellStyleXfs.appendChild(xfEl);
        xfEl.setAttribute("numFmtId", String.format("%s", 0));
        xfEl.setAttribute("fontId", String.format("%s", 0));
        xfEl.setAttribute("fillId", String.format("%s", 0));
        xfEl.setAttribute("borderId", String.format("%s", 0));
        Element cellXfsEl = doc.createElement("cellXfs");
        styleSheetEl.appendChild(cellXfsEl);
        cellXfsEl.setAttribute("count", String.format("%s", this.xfList.size()));
        for (int index4 = 0; index4 < this.xfList.size(); ++index4) {
            DataXF tempXF = this.xfList.get(index4);
            DataFill tempFill = this.fillList.get(tempXF.FillIndex);
            int fillIndex = tempXF.FillIndex;
            if (tempFill.FgColor.getA() == 0) {
                fillIndex = 0;
            }
            xfEl = doc.createElement("xf");
            cellXfsEl.appendChild(xfEl);
            xfEl.setAttribute("numFmtId", String.format("%s", tempXF.FormatIndex));
            xfEl.setAttribute("fontId", String.format("%s", tempXF.FontIndex));
            xfEl.setAttribute("fillId", String.format("%s", fillIndex));
            xfEl.setAttribute("borderId", String.format("%s", tempXF.BorderIndex));
            xfEl.setAttribute("xfId", String.format("%s", tempXF.XFId));
            if (tempXF.FormatIndex != 0) {
                xfEl.setAttribute("applyFormat", "1");
            }
            if (tempXF.FontIndex != 0) {
                xfEl.setAttribute("applyFont", "1");
            }
            if (tempXF.FillIndex != 0) {
                xfEl.setAttribute("applyFill", "1");
            }
            if (tempXF.BorderIndex != 0) {
                xfEl.setAttribute("applyBorder", "1");
            }
            if (tempXF.HorAlign == StiTextHorAlignment.Left && tempXF.VertAlign == StiVertAlignment.Bottom && tempXF.TextRotationAngle == 0 && !tempXF.TextWrapped && !tempXF.RightToLeft) continue;
            xfEl.setAttribute("applyAlignment", "1");
            Element alignmentEl = doc.createElement("alignment");
            xfEl.appendChild(alignmentEl);
            if (tempXF.HorAlign != StiTextHorAlignment.Left) {
                String horAlign = "";
                switch (tempXF.HorAlign) {
                    case Right: {
                        horAlign = "right";
                        break;
                    }
                    case Center: {
                        horAlign = "center";
                        break;
                    }
                    case Width: {
                        horAlign = "justify";
                    }
                }
                alignmentEl.setAttribute("horizontal", horAlign);
            }
            if (tempXF.VertAlign != StiVertAlignment.Bottom) {
                String vertAlign = "";
                switch (tempXF.VertAlign) {
                    case Top: {
                        vertAlign = "top";
                        break;
                    }
                    case Center: {
                        vertAlign = "center";
                    }
                }
                alignmentEl.setAttribute("vertical", vertAlign);
            }
            if (tempXF.TextRotationAngle != 0) {
                alignmentEl.setAttribute("textRotation", String.valueOf(tempXF.TextRotationAngle));
            }
            if (tempXF.TextWrapped) {
                alignmentEl.setAttribute("wrapText", "1");
            }
            if (!tempXF.RightToLeft) continue;
            alignmentEl.setAttribute("readingOrder", "2");
        }
        Element cellStylesEl = doc.createElement("cellStyles");
        styleSheetEl.appendChild(cellStylesEl);
        cellStylesEl.setAttribute("count", String.format("%s", 1));
        Element cellStyleEl = doc.createElement("cellStyle");
        cellStylesEl.appendChild(cellStyleEl);
        cellStyleEl.setAttribute("name", "Normal");
        cellStyleEl.setAttribute("xfId", String.format("%s", 0));
        cellStyleEl.setAttribute("builtinId", String.format("%s", 0));
        Element dxfsEl = doc.createElement("dxfs");
        styleSheetEl.appendChild(dxfsEl);
        dxfsEl.setAttribute("count", String.format("%s", 0));
        Element tableStylesEl = doc.createElement("tableStyles");
        styleSheetEl.appendChild(tableStylesEl);
        tableStylesEl.setAttribute("count", String.format("%s", 0));
        tableStylesEl.setAttribute("defaultTableStyle", "TableStyleMedium9");
        tableStylesEl.setAttribute("defaultPivotStyle", "PivotStyleLight16");
        return doc;
    }

    private void writeBorderData(Element element, String side, StiBorderSide border, Document doc) {
        Element sideEl = doc.createElement(side);
        element.appendChild(sideEl);
        if (border != null) {
            String style = this.getLineStyle(border);
            StiColor color = border.getColor();
            if (!"".equals(style)) {
                sideEl.setAttribute("style", style);
                Element colorEl = doc.createElement("color");
                sideEl.appendChild(colorEl);
                colorEl.setAttribute("rgb", color.toArgbHTML().substring(1));
            }
        }
    }

    private Document writeSST() throws ParserConfigurationException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element sstEl = doc.createElement("sst");
        doc.appendChild(sstEl);
        sstEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        sstEl.setAttribute("count", String.format("%s", this.sstCount));
        sstEl.setAttribute("uniqueCount", String.format("%s", this.sstList.size()));
        for (int index = 0; index < this.sstList.size(); ++index) {
            Element siEl = doc.createElement("si");
            sstEl.appendChild(siEl);
            String st = this.sstList.get(index);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < st.length(); ++i) {
                char ch = st.charAt(i);
                if (ch < ' ' && ch != '\n') continue;
                sb.append(ch);
            }
            st = sb.toString();
            if (this.sstHashIsTags.containsKey(index)) {
                this.convertAllowHtmlTagsToExcelString(this.sstHashIsTags.get(index), null, doc, siEl);
                continue;
            }
            this.convertTextToExcelString(siEl, st, doc);
        }
        return doc;
    }

    private byte[] writeAdditionalData(String st, boolean base64) throws UnsupportedEncodingException {
        if (base64) {
            return StiBase64DecoderUtil.decode((String)st);
        }
        return st.getBytes("US-ASCII");
    }

    private byte[] writeImage(int index) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StiImageHelper.saveWithDPI(this.imageCache.getImageByIndex(index), out, StiImageFormat.Jpeg, (Integer)72, this.imageQuality);
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportExcel(report, outputStream, (StiExcelExportSettings)exportSettings);
    }

    public void exportExcel(StiReport report, OutputStream outputStream, StiExcelExportSettings settings) throws StiException {
        try {
            this.exportExcelException(report, outputStream, settings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcelException(StiReport report, OutputStream outputStream, StiExcelExportSettings settings) throws IOException, ParserConfigurationException, TransformerException {
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        this.useOnePageHeaderAndFooter = settings.isUseOnePageHeaderAndFooter();
        this.exportDataOnly = settings.isExportDataOnly();
        this.exportObjectFormatting = settings.isExportObjectFormatting();
        this.exportEachPageToSheet = settings.isExportEachPageToSheet();
        this.exportHorizontalPageBreaks = settings.isExportPageBreaks();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        this.docCompanyString = settings.getCompanyString();
        this.docLastModifiedString = settings.getLastModifiedString();
        if (this.imageResolution < 10.0f) {
            this.imageResolution = 10.0f;
        }
        this.imageResolution /= 100.0f;
        if (this.exportDataOnly) {
            this.useOnePageHeaderAndFooter = false;
        } else {
            this.exportObjectFormatting = true;
        }
        this.report = report;
        try {
            StiPagesCollection allPages = pageRange.getSelectedPages(report.getRenderedPages());
            if (this.isStoped()) {
                return;
            }
            this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
            this.prepareData();
            for (int indexPage = 0; indexPage < allPages.size(); ++indexPage) {
                String sheetName;
                StiPagesCollection pages = new StiPagesCollection(report);
                pages.add((StiPage)allPages.get(indexPage));
                int firstPageIndex = indexPage;
                if (!this.exportEachPageToSheet) {
                    String pageName = ((StiPage)allPages.get(indexPage)).getExcelSheetValue();
                    while (indexPage < allPages.size() - 1 && this.compareExcellSheetNames(((StiPage)allPages.get(indexPage + 1)).getExcelSheetValue(), pageName)) {
                        pages.add((StiPage)allPages.get(++indexPage));
                    }
                }
                if ((sheetName = ((StiPage)pages.get(0)).getExcelSheetValue()) == null || "".equals(sheetName)) {
                    sheetName = String.format("Page %s", this.sheetNameList.size() + 1);
                }
                String sheetSuffix = "";
                int sheetIndex = 1;
                this.prepareMatrix(pages);
                int minRowIndex = 0;
                do {
                    this.firstPageIndexList.add(firstPageIndex);
                    this.matrixList.add(this.matrix);
                    int maxRowIndex = this.matrix.getCoordY().size() - 1;
                    if (maxRowIndex - minRowIndex > ExportOptions.Excel2007.getMaximumSheetHeight()) {
                        maxRowIndex = minRowIndex + ExportOptions.Excel2007.getMaximumSheetHeight();
                    } else {
                        this.matrix = null;
                    }
                    this.minRowList.add(minRowIndex);
                    this.maxRowList.add(maxRowIndex);
                    minRowIndex = maxRowIndex;
                    if (this.matrix != null || sheetSuffix.length() > 0) {
                        sheetSuffix = String.format(" part%s", sheetIndex++);
                    }
                    this.sheetNameList.add(sheetName + sheetSuffix);
                    if (!this.isStoped()) continue;
                    return;
                } while (this.matrix != null);
            }
            Hashtable<String, String> ht = new Hashtable<String, String>();
            for (int index = 0; index < this.sheetNameList.size(); ++index) {
                String titleString = this.sheetNameList.remove(index);
                if (ht.contains(titleString = titleString.replace('*', '_').replace('\\', '_').replace('/', '_').replace('[', '_').replace(']', '_').replace(':', '_').replace('?', '_'))) {
                    int numVariant = 1;
                    while (ht.contains(titleString + "-" + String.valueOf(numVariant))) {
                        ++numVariant;
                    }
                    titleString = titleString + "-" + String.valueOf(numVariant);
                }
                ht.put(titleString, titleString);
                this.sheetNameList.add(index, titleString);
            }
            StiZipWriter20 zip = new StiZipWriter20(outputStream);
            this.imageListOffset = 0;
            for (int indexSheet = 0; indexSheet < this.matrixList.size(); ++indexSheet) {
                this.hyperlinkList = new ArrayList();
                zip.addFile("xl/worksheets/", String.format("sheet%s.xml", indexSheet + 1), this.writeSheet(indexSheet, (StiPage)allPages.get(this.firstPageIndexList.get(indexSheet))));
                if (this.hyperlinkList.size() > 0 || this.imageList.size() - this.imageListOffset > 0) {
                    zip.addFile("xl/worksheets/_rels/", String.format("sheet%s.xml.rels", indexSheet + 1), this.writeSheetRels(indexSheet));
                }
                if (this.imageList.size() - this.imageListOffset > 0) {
                    zip.addFile("xl/drawings/_rels/", String.format("drawing%s.xml.rels", indexSheet + 1), this.writeDrawingRels(indexSheet));
                    zip.addFile("xl/drawings/", String.format("drawing%s.xml", indexSheet + 1), this.writeDrawing(indexSheet));
                }
                this.imageListOffset = this.imageList.size();
                if (!this.isStoped()) continue;
                return;
            }
            zip.addFile("", "[Content_Types].xml", this.writeContentTypes());
            zip.addFile("_rels/", ".rels", this.writeMainRels());
            zip.addFile("docProps/", "app.xml", this.writeDocPropsApp());
            zip.addFile("docProps/", "core.xml", this.writeDocPropsCore());
            zip.addFile("xl/_rels/", "workbook.xml.rels", this.writeWorkbookRels());
            zip.addFile("xl/", "workbook.xml", this.writeWorkbook());
            zip.addFile("xl/", "styles.xml", this.writeStyles());
            if (this.sstList.size() > 0) {
                zip.addFile("xl/", "sharedStrings.xml", this.writeSST());
            }
            if (this.imageCache.getImageStoreSize() > 0) {
                for (int index = 0; index < this.imageCache.getImageStoreSize(); ++index) {
                    zip.addFile("xl/media/", String.format("image%05d.jpeg", index + 1), this.writeImage(index));
                }
            }
            if (!StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
                zip.addFile("xl/media/", "imageAdditional.png", this.writeAdditionalData(StiExportUtils.AdditionalData, true));
                zip.addFile("xl/drawings/_rels/", "vmlDrawingAdditional.vml.rels", this.writeAdditionalData("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"dId1\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image\" Target=\"../media/imageAdditional.png\"/></Relationships>", false));
                zip.addFile("xl/drawings/", "vmlDrawingAdditional.vml", this.writeAdditionalData("<xml xmlns:v=\"urn:schemas-microsoft-com:vml\"\r\n xmlns:o=\"urn:schemas-microsoft-com:office:office\"\r\n xmlns:x=\"urn:schemas-microsoft-com:office:excel\">\r\n <o:shapelayout v:ext=\"edit\">\r\n  <o:idmap v:ext=\"edit\" data=\"1\"/>\r\n </o:shapelayout><v:shapetype id=\"_x0000_t75\" coordsize=\"21600,21600\" o:spt=\"75\"\r\n  o:preferrelative=\"t\" path=\"m@4@5l@4@11@9@11@9@5xe\" filled=\"f\" stroked=\"f\">\r\n  <v:stroke joinstyle=\"miter\"/>\r\n  <v:formulas>\r\n   <v:f eqn=\"if lineDrawn pixelLineWidth 0\"/>\r\n   <v:f eqn=\"sum @0 1 0\"/>\r\n   <v:f eqn=\"sum 0 0 @1\"/>\r\n   <v:f eqn=\"prod @2 1 2\"/>\r\n   <v:f eqn=\"prod @3 21600 pixelWidth\"/>\r\n   <v:f eqn=\"prod @3 21600 pixelHeight\"/>\r\n   <v:f eqn=\"sum @0 0 1\"/>\r\n   <v:f eqn=\"prod @6 1 2\"/>\r\n   <v:f eqn=\"prod @7 21600 pixelWidth\"/>\r\n   <v:f eqn=\"sum @8 21600 0\"/>\r\n   <v:f eqn=\"prod @7 21600 pixelHeight\"/>\r\n   <v:f eqn=\"sum @10 21600 0\"/>\r\n  </v:formulas>\r\n  <v:path o:extrusionok=\"f\" gradientshapeok=\"t\" o:connecttype=\"rect\"/>\r\n  <o:lock v:ext=\"edit\" aspectratio=\"t\"/>\r\n </v:shapetype><v:shape id=\"CH\" o:spid=\"_x0000_s1027\" type=\"#_x0000_t75\"\r\n  style='position:absolute;margin-left:0;margin-top:0;width:365.25pt;height:339pt;\r\n  z-index:1'>\r\n  <v:imagedata o:relid=\"dId1\" o:title=\"additional\"/>\r\n  <o:lock v:ext=\"edit\" rotation=\"t\"/>\r\n </v:shape></xml>", false));
            }
            zip.finish();
            this.closeProgress();
        }
        finally {
            if (this.matrix != null) {
                this.matrix.clear();
                this.matrix = null;
            }
            this.fontList = null;
            this.fillList = null;
            this.borderList = null;
            this.xfList = null;
            this.sstList = null;
            this.sstHash = null;
            this.formatList = null;
            this.sheetNameList = null;
            this.imageList.clear();
            this.imageList = null;
            this.imageCache.clear();
            this.printAreasList = null;
            this.matrixList = null;
            this.firstPageIndexList = null;
            this.hyperlinkList = null;
            this.minRowList = null;
            this.maxRowList = null;
        }
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Excel2007;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    static {
        WRONG_URL_SYMBOLS.add(32);
        WRONG_URL_SYMBOLS.add(34);
        WRONG_URL_SYMBOLS.add(35);
        WRONG_URL_SYMBOLS.add(39);
        WRONG_URL_SYMBOLS.add(42);
        WRONG_URL_SYMBOLS.add(44);
        WRONG_URL_SYMBOLS.add(59);
        WRONG_URL_SYMBOLS.add(60);
        WRONG_URL_SYMBOLS.add(62);
        WRONG_URL_SYMBOLS.add(91);
        WRONG_URL_SYMBOLS.add(94);
        WRONG_URL_SYMBOLS.add(96);
        WRONG_URL_SYMBOLS.add(123);
        WRONG_URL_SYMBOLS.add(124);
        WRONG_URL_SYMBOLS.add(125);
    }

    private class HlinkData {
        public CellRangeAddress Range;
        public String Description;
        public String Bookmark;

        public HlinkData(CellRangeAddress Range2, String Description, String Bookmark) {
            this.Range = Range2;
            this.Description = Description;
            this.Bookmark = Bookmark;
        }
    }

    private class CellRangeAddress {
        public int FirstRow;
        public int LastRow;
        public int FirstColumn;
        public int LastColumn;

        public CellRangeAddress(int FirstRow, int LastRow, int FirstColumn, int LastColumn) {
            this.FirstRow = FirstRow;
            this.LastRow = LastRow;
            this.FirstColumn = FirstColumn;
            this.LastColumn = LastColumn;
        }
    }

    public class ExcelImageData {
        public int FirstRowIndex;
        public int FirstRowOffset;
        public int FirstColumnIndex;
        public int FirstColumnOffset;
        public int LastRowIndex;
        public int LastRowOffset;
        public int LastColumnIndex;
        public int LastColumnOffset;
        public int ImageIndex;

        public ExcelImageData(int FirstRowIndex, int FirstRowOffset, int FirstColumnIndex, int FirstColumnOffset, int LastRowIndex, int LastRowOffset, int LastColumnIndex, int LastColumnOffset, int ImageIndex) {
            this.FirstRowIndex = FirstRowIndex;
            this.FirstRowOffset = FirstRowOffset;
            this.FirstColumnIndex = FirstColumnIndex;
            this.FirstColumnOffset = FirstColumnOffset;
            this.LastRowIndex = LastRowIndex;
            this.LastRowOffset = LastRowOffset;
            this.LastColumnIndex = LastColumnIndex;
            this.LastColumnOffset = LastColumnOffset;
            this.ImageIndex = ImageIndex;
        }
    }

    private class DataXF {
        public int FormatIndex;
        public int FontIndex;
        public int FillIndex;
        public int BorderIndex;
        public int XFId;
        public StiTextHorAlignment HorAlign;
        public StiVertAlignment VertAlign;
        public int TextRotationAngle;
        public boolean TextWrapped;
        public boolean RightToLeft;

        public DataXF(int FormatIndex, int FontIndex, int FillIndex, int BorderIndex, int XFId, StiTextHorAlignment HorAlign, StiVertAlignment VertAlign, int TextRotationAngle, boolean TextWrapped, boolean RightToLeft) {
            this.FormatIndex = FormatIndex;
            this.FontIndex = FontIndex;
            this.FillIndex = FillIndex;
            this.BorderIndex = BorderIndex;
            this.XFId = XFId;
            this.HorAlign = HorAlign;
            this.VertAlign = VertAlign;
            this.TextRotationAngle = TextRotationAngle;
            this.TextWrapped = TextWrapped;
            this.RightToLeft = RightToLeft;
        }

        public boolean equals(DataXF obj) {
            return this.FormatIndex == obj.FormatIndex && this.FontIndex == obj.FontIndex && this.BorderIndex == obj.BorderIndex && this.FillIndex == obj.FillIndex && this.XFId == obj.XFId && this.HorAlign == obj.HorAlign && this.VertAlign == obj.VertAlign && this.TextRotationAngle == obj.TextRotationAngle && this.TextWrapped == obj.TextWrapped && this.RightToLeft == obj.RightToLeft;
        }
    }

    private class DataBorder {
        public StiBorderSide BorderLeft;
        public StiBorderSide BorderRight;
        public StiBorderSide BorderTop;
        public StiBorderSide BorderBottom;

        public DataBorder(StiBorderSide BorderLeft, StiBorderSide BorderRight, StiBorderSide BorderTop, StiBorderSide BorderBottom) {
            this.BorderLeft = BorderLeft;
            this.BorderRight = BorderRight;
            this.BorderTop = BorderTop;
            this.BorderBottom = BorderBottom;
        }

        public boolean equals(DataBorder obj) {
            return StiValidationUtil.equals((Object)this.BorderLeft, (Object)obj.BorderLeft) && StiValidationUtil.equals((Object)this.BorderRight, (Object)obj.BorderRight) && StiValidationUtil.equals((Object)this.BorderTop, (Object)obj.BorderTop) && StiValidationUtil.equals((Object)this.BorderBottom, (Object)obj.BorderBottom);
        }
    }

    private class DataFill {
        public String Type;
        public StiColor FgColor;
        public StiColor BgColor;

        public DataFill(String Type2, StiColor FgColor, StiColor BgColor) {
            this.Type = Type2;
            this.FgColor = FgColor;
            this.BgColor = BgColor;
        }

        public boolean equals(DataFill obj) {
            return StiStringUtil.stringsEquals((String)this.Type, (String)obj.Type) && this.FgColor.equals(obj.FgColor) && this.BgColor.equals(obj.BgColor);
        }
    }

    private class DataFont {
        public String Name;
        public boolean Bold;
        public boolean Italic;
        public boolean Underlined;
        public boolean Strikeout;
        public int Height;
        public StiColor Color;
        public int Charset;
        public int Family;

        public DataFont(String Name, boolean Bold, boolean Italic, boolean Underlined, boolean Strikeout, int Height, StiColor Color2, int Charset2, int Family) {
            this.Name = Name;
            this.Bold = Bold;
            this.Italic = Italic;
            this.Underlined = Underlined;
            this.Strikeout = Strikeout;
            this.Height = Height;
            this.Color = Color2;
            this.Charset = Charset2;
            this.Family = Family;
        }

        public boolean equals(DataFont obj) {
            return StiStringUtil.stringsEquals((String)this.Name, (String)obj.Name) && this.Bold == obj.Bold && this.Italic == obj.Italic && this.Underlined == obj.Underlined && this.Strikeout == obj.Strikeout && this.Height == obj.Height && this.Color.equals(obj.Color) && this.Charset == obj.Charset && this.Family == obj.Family;
        }
    }
}

