/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service.helper;

import com.stimulsoft.base.context.chart.animation.StiRotationAnimation;
import com.stimulsoft.base.context.chart.animation.StiScaleAnimation;
import com.stimulsoft.base.context.chart.animation.StiTranslationAnimation;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiXmlTextWriter;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.helper.StiBrushSvgHelper;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.StiGdiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.StiGaugeGeomType;
import com.stimulsoft.report.painters.context.gauge.geoms.StiEllipseGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsArcGeometryGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathArcGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLineGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLinesGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiPieGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiPopTranformGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiPushMatrixGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRadialRangeGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRectangleGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRoundedRectangleGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiTextGaugeGeom;
import java.awt.image.BufferedImage;
import java.util.List;

public class StiGaugeSvgHelper {
    static final double PiDiv180 = Math.PI / 180;
    private static final double FourDivThree = 1.3333333333333333;

    private static void addAnimation(StiXmlTextWriter writer, String actions, Integer begin, Integer duration) {
        String animation = String.format("{\"actions\":%s, \"begin\":%s, \"duration\":%s}", actions, begin != null ? begin : 0, duration);
        writer.writeAttributeString("_animation", animation);
    }

    public static void writeGauge(StiXmlTextWriter writer, StiSvgExportService.StiSvgHelper.StiSvgData svgData, double zoom, Boolean needAnimation) {
        StiGauge gauge = svgData.Component instanceof StiGauge ? (StiGauge)svgData.Component : null;
        boolean storeIsAnimation = gauge.getIsAnimation();
        double pageZoom = gauge.getReport().getInfo().getPageZoom();
        gauge.setIsAnimation(needAnimation);
        StiGraphics g = StiGraphics.fromImage((BufferedImage)new BufferedImage(10, 10, 2));
        StiGdiGaugeContextPainter painter = new StiGdiGaugeContextPainter(g, gauge, new StiRectangle(0.0, 0.0, svgData.Width, svgData.Height), zoom, pageZoom);
        painter.gauge = gauge;
        painter.rect = new StiRectangle(svgData.X, svgData.Y, svgData.Width, svgData.Height);
        painter.zoom = zoom;
        painter.geoms.clear();
        StiReport report = gauge.getReport();
        gauge.drawGauge(painter);
        ((StiGaugeContextPainter)painter).render();
        gauge.setIsAnimation(storeIsAnimation);
        double finishTime = 0.0;
        for (StiGaugeGeom ag : painter.geoms) {
            if (ag == null || ag.getAnimation() == null) continue;
            int n = ag.getAnimation().duration;
            int n2 = ag.getAnimation().beginTime != null ? ag.getAnimation().beginTime : 0;
            if (!((double)(n + n2) > finishTime)) continue;
            finishTime = ag.getAnimation().duration + (ag.getAnimation().beginTime != null ? ag.getAnimation().beginTime : 0);
        }
        writer.writeStartElement("g");
        writer.writeAttributeString("transform", String.format("translate(%s,%s)", StiGaugeSvgHelper.p(svgData.X + 0.5), StiGaugeSvgHelper.p(svgData.Y + 0.5)));
        for (StiGaugeGeom rGeom : painter.geoms) {
            StiPoint[] points;
            double endRadius;
            double startRadius;
            StiRectangle rect;
            String stroke;
            String fill;
            String stroke2;
            CharSequence style;
            StiGaugeGeom geom;
            if (rGeom instanceof StiPushMatrixGaugeGeom) {
                StiPushMatrixGaugeGeom tr = (StiPushMatrixGaugeGeom)rGeom;
                writer.writeStartElement("g");
                writer.writeAttributeString("transform", String.format("rotate(%s, %s, %s)", StiGaugeSvgHelper.p(tr.Angle), StiGaugeSvgHelper.p(tr.CenterPoint.x), StiGaugeSvgHelper.p(tr.CenterPoint.y)));
                continue;
            }
            if (rGeom instanceof StiPopTranformGaugeGeom) {
                writer.writeEndElement();
                continue;
            }
            if (rGeom.getType() == StiGaugeGeomType.RoundedRectangle) {
                geom = (StiRoundedRectangleGaugeGeom)rGeom;
                StiRectangle rect2 = ((StiRoundedRectangleGaugeGeom)geom).Rect;
                style = new StringBuilder();
                if (((StiRoundedRectangleGaugeGeom)geom).Background != null) {
                    ((StringBuilder)style).append(StiGaugeSvgHelper.writeFillBrush(writer, ((StiRoundedRectangleGaugeGeom)geom).Background, rect2));
                } else {
                    ((StringBuilder)style).append("fill-opacity:0;");
                }
                stroke2 = String.format("%s", StiGaugeSvgHelper.writeBorderStroke(writer, ((StiRoundedRectangleGaugeGeom)geom).BorderBrush, rect2));
                ((StringBuilder)style).append(String.format("%s;stroke-width:%s;", stroke2, ((StiRoundedRectangleGaugeGeom)geom).BorderWidth));
                writer.writeStartElement("rect");
                writer.writeAttributeString("x", StiGaugeSvgHelper.p(rect2.x));
                writer.writeAttributeString("y", StiGaugeSvgHelper.p(rect2.y));
                writer.writeAttributeString("ry", StiGaugeSvgHelper.p(((StiRoundedRectangleGaugeGeom)geom).LeftTop));
                writer.writeAttributeString("rx", StiGaugeSvgHelper.p(((StiRoundedRectangleGaugeGeom)geom).LeftTop));
                writer.writeAttributeString("height", StiGaugeSvgHelper.p(rect2.height));
                writer.writeAttributeString("width", StiGaugeSvgHelper.p(rect2.width));
                writer.writeAttributeString("shape-rendering", "crispEdges");
                writer.writeAttributeString("style", ((StringBuilder)style).toString());
                writer.writeEndElement();
                continue;
            }
            if (rGeom.getType() == StiGaugeGeomType.Rectangle) {
                geom = (StiRectangleGaugeGeom)rGeom;
                StiRectangle rect3 = ((StiRectangleGaugeGeom)geom).Rect;
                style = new StringBuilder();
                if (((StiRectangleGaugeGeom)geom).Background != null) {
                    ((StringBuilder)style).append(StiGaugeSvgHelper.writeFillBrush(writer, ((StiRectangleGaugeGeom)geom).Background, rect3));
                } else {
                    ((StringBuilder)style).append("fill-opacity:0;");
                }
                stroke2 = String.format("%s", StiGaugeSvgHelper.writeBorderStroke(writer, ((StiRectangleGaugeGeom)geom).BorderBrush, rect3));
                ((StringBuilder)style).append(String.format("%s;stroke-width:%s;", stroke2, ((StiRectangleGaugeGeom)geom).BorderWidth));
                writer.writeStartElement("rect");
                writer.writeAttributeString("x", StiGaugeSvgHelper.p(rect3.x));
                writer.writeAttributeString("y", StiGaugeSvgHelper.p(rect3.y));
                writer.writeAttributeString("height", StiGaugeSvgHelper.p(rect3.height + 1.0));
                writer.writeAttributeString("width", StiGaugeSvgHelper.p(rect3.width + 1.0));
                writer.writeAttributeString("shape-rendering", "crispEdges");
                writer.writeAttributeString("style", ((StringBuilder)style).toString());
                writer.writeEndElement();
                continue;
            }
            if (rGeom.getType() == StiGaugeGeomType.GraphicsPath) {
                geom = (StiGraphicsPathGaugeGeom)rGeom;
                StiRectangle rect4 = ((StiGraphicsPathGaugeGeom)geom).Rect;
                style = "";
                fill = "";
                style = ((StiGraphicsPathGaugeGeom)geom).Background != null ? StiGaugeSvgHelper.writeFillBrush(writer, ((StiGraphicsPathGaugeGeom)geom).Background, rect4) : "fill-opacity:0;";
                stroke = String.format("%s", StiGaugeSvgHelper.writeBorderStroke(writer, ((StiGraphicsPathGaugeGeom)geom).BorderBrush, rect4));
                style = (String)style + String.format("%s;stroke-width:%s;", stroke, StiGaugeSvgHelper.p(((StiGraphicsPathGaugeGeom)geom).BorderWidth));
                String pathData = StiGaugeSvgHelper.getPathData(((StiGraphicsPathGaugeGeom)geom).getGeoms(), ((StiGraphicsPathGaugeGeom)geom).StartPoint);
                writer.writeStartElement("path");
                writer.writeAttributeString("d", pathData);
                writer.writeAttributeString("style", (String)style);
                if (geom.getAnimation() != null) {
                    if (geom.getAnimation() instanceof StiTranslationAnimation) {
                        StiTranslationAnimation translationAnimation = (StiTranslationAnimation)geom.getAnimation();
                        if (translationAnimation.getStartPoint().x != translationAnimation.getEndPoint().x) {
                            double dx = translationAnimation.getStartPoint().x - translationAnimation.getEndPoint().x;
                            StiGaugeSvgHelper.addAnimation(writer, String.format("[[\"transform\", %s, 0,\",0)\", \"translate(\"]]", dx), translationAnimation.beginTime, translationAnimation.duration);
                            writer.writeAttributeString("transform", String.format("translate(%s, 0)", dx));
                        } else {
                            double dy = translationAnimation.getStartPoint().y - translationAnimation.getEndPoint().y;
                            StiGaugeSvgHelper.addAnimation(writer, String.format("[[\"transform\", %s, 0,\")\", \"translate(0,\"]]", dy), translationAnimation.beginTime, translationAnimation.duration);
                            writer.writeAttributeString("transform", String.format("translate(0, %s)", dy));
                        }
                    } else if (geom.getAnimation() instanceof StiRotationAnimation) {
                        StiRotationAnimation rotationAnimation = (StiRotationAnimation)geom.getAnimation();
                        writer.writeAttributeString("transform", String.format("rotate(%s, %s, %s)", StiGaugeSvgHelper.p(rotationAnimation.startAngle), StiGaugeSvgHelper.p(rotationAnimation.centerPoint.x), StiGaugeSvgHelper.p(rotationAnimation.centerPoint.y)));
                        StiGaugeSvgHelper.addAnimation(writer, String.format("[[\"transform\", %s, %s,\", %s, %s)\", \"rotate(\"]]", StiGaugeSvgHelper.p(rotationAnimation.startAngle), StiGaugeSvgHelper.p(rotationAnimation.endAngle), StiGaugeSvgHelper.p(rotationAnimation.centerPoint.x), StiGaugeSvgHelper.p(rotationAnimation.centerPoint.y)), rotationAnimation.beginTime, rotationAnimation.duration);
                    } else if (geom.getAnimation() instanceof StiScaleAnimation) {
                        writer.writeAttributeString("opacity", "0");
                        StiScaleAnimation scaleAnimation = (StiScaleAnimation)geom.getAnimation();
                        StiGaugeSvgHelper.addAnimation(writer, String.format("[[\"scaleCenter\", %s, %s, %s, %s, %s, %s]]", StiGaugeSvgHelper.p(scaleAnimation.getStartScaleX()), StiGaugeSvgHelper.p(scaleAnimation.getEndScaleX()), StiGaugeSvgHelper.p(scaleAnimation.getStartScaleY()), StiGaugeSvgHelper.p(scaleAnimation.getEndScaleY()), Boolean.valueOf(Math.abs(scaleAnimation.getCenterX() - ((StiGraphicsPathGaugeGeom)geom).StartPoint.x) > Math.abs(scaleAnimation.getCenterX() * 0.15)).toString().toLowerCase(), Boolean.valueOf(Math.abs(scaleAnimation.getCenterY() - ((StiGraphicsPathGaugeGeom)geom).StartPoint.y) > Math.abs(scaleAnimation.getCenterY() * 0.15)).toString().toLowerCase()), scaleAnimation.beginTime, scaleAnimation.duration);
                    }
                }
                writer.writeEndElement();
                continue;
            }
            if (rGeom.getType() == StiGaugeGeomType.Pie) {
                geom = (StiPieGaugeGeom)rGeom;
                StiRectangle rect5 = ((StiPieGaugeGeom)geom).rect;
                style = "";
                fill = "";
                style = ((StiPieGaugeGeom)geom).background != null ? StiGaugeSvgHelper.writeFillBrush(writer, ((StiPieGaugeGeom)geom).background, rect5) : "fill-opacity:0;";
                stroke = String.format("%s", StiGaugeSvgHelper.writeBorderStroke(writer, ((StiPieGaugeGeom)geom).borderBrush, rect5));
                style = (String)style + String.format("%s;stroke-width:%s;", stroke, StiGaugeSvgHelper.p(((StiPieGaugeGeom)geom).borderWidth));
                String pathData = StiGaugeSvgHelper.addPiePath((StiPieGaugeGeom)geom, "");
                writer.writeStartElement("path");
                writer.writeAttributeString("d", pathData);
                writer.writeAttributeString("style", (String)style);
                writer.writeEndElement();
                continue;
            }
            if (rGeom.getType() == StiGaugeGeomType.Ellipse) {
                StiEllipseGaugeGeom ellipse = (StiEllipseGaugeGeom)rGeom;
                StiRectangle rect6 = ellipse.Rect;
                style = "";
                fill = "";
                style = ellipse.Background != null ? StiGaugeSvgHelper.writeFillBrush(writer, ellipse.Background, rect6) : "fill-opacity:0;";
                stroke = String.format("%s", StiGaugeSvgHelper.writeBorderStroke(writer, ellipse.BorderBrush, rect6));
                style = (String)style + String.format("%s;stroke-width:%s;", stroke, StiGaugeSvgHelper.p(ellipse.BorderWidth));
                writer.writeStartElement("ellipse");
                writer.writeAttributeString("cx", StiGaugeSvgHelper.p(rect6.x + rect6.width / 2.0));
                writer.writeAttributeString("cy", StiGaugeSvgHelper.p(rect6.y + rect6.height / 2.0));
                writer.writeAttributeString("rx", StiGaugeSvgHelper.p(rect6.width / 2.0));
                writer.writeAttributeString("ry", StiGaugeSvgHelper.p(rect6.height / 2.0));
                writer.writeAttributeString("style", (String)style);
                writer.writeEndElement();
                continue;
            }
            if (rGeom.getType() == StiGaugeGeomType.GraphicsArcGeometry) {
                geom = (StiGraphicsArcGeometryGaugeGeom)rGeom;
                String style2 = "";
                String fill2 = "";
                rect = ((StiGraphicsArcGeometryGaugeGeom)geom).rect;
                style2 = ((StiGraphicsArcGeometryGaugeGeom)geom).background != null ? StiGaugeSvgHelper.writeFillBrush(writer, ((StiGraphicsArcGeometryGaugeGeom)geom).background, rect) : "fill-opacity:0;";
                stroke = String.format("%s", StiGaugeSvgHelper.writeBorderStroke(writer, ((StiGraphicsArcGeometryGaugeGeom)geom).borderBrush, rect));
                style2 = style2 + String.format("%s;stroke-width:%s;", stroke, StiGaugeSvgHelper.p(((StiGraphicsArcGeometryGaugeGeom)geom).borderWidth));
                String pathData = StiGaugeSvgHelper.addArcPath(geom, "");
                writer.writeStartElement("path");
                writer.writeAttributeString("d", pathData);
                writer.writeAttributeString("style", style2);
                writer.writeEndElement();
                continue;
            }
            if (rGeom.getType() == StiGaugeGeomType.Text) {
                StiTextGaugeGeom textGeom = (StiTextGaugeGeom)rGeom;
                StiFont font = new StiFont(textGeom.Font.getName(), textGeom.Font.size, textGeom.Font.getFontStyle(), textGeom.Font.getUnit());
                StiPoint pointF = new StiPoint();
                rect = textGeom.Rect;
                pointF = new StiPoint(rect.x, rect.y);
                StringBuilder style3 = new StringBuilder();
                double size = font.size * 4.0 / 3.0;
                writer.writeStartElement("text");
                style3.append(String.format("text-anchor:%s;", "middle"));
                writer.writeAttributeString("dy", "0.9em");
                writer.writeAttributeString("dx", String.format("%sem", StiGaugeSvgHelper.p(0.3 * (double)textGeom.Text.length())));
                writer.writeAttributeString("transform", String.format("translate(%s, %s) ", StiGaugeSvgHelper.p(pointF.x), StiGaugeSvgHelper.p(pointF.y)));
                writer.writeAttributeString("font-size", StiGaugeSvgHelper.p(size));
                writer.writeAttributeString("font-family", font.getName());
                StiColor textColor = StiBrush.ToColor((StiBrush)textGeom.Foreground);
                style3.append(String.format("fill:%s", textColor.toHTML()));
                if (textColor.a != 255) {
                    style3.append(String.format("fill-opacity:%s", StiGaugeSvgHelper.p(StiMath.round((float)((float)textColor.a / 255.0f), (int)3))));
                }
                writer.writeAttributeString("style", style3.toString());
                writer.writeString(textGeom.Text);
                writer.writeEndElement();
                continue;
            }
            if (rGeom.getType() != StiGaugeGeomType.RadialRange) continue;
            geom = (StiRadialRangeGaugeGeom)rGeom;
            double currentStartAngle = ((StiRadialRangeGaugeGeom)geom).startAngle * (Math.PI / 180);
            StringBuilder path = new StringBuilder();
            StiPoint centerPoint = ((StiRadialRangeGaugeGeom)geom).centerPoint;
            double x1 = centerPoint.x + ((StiRadialRangeGaugeGeom)geom).radius1 * Math.cos(currentStartAngle);
            double y1 = centerPoint.y + ((StiRadialRangeGaugeGeom)geom).radius1 * Math.sin(currentStartAngle);
            StiPoint lastPoint = new StiPoint(x1, y1);
            double steps = Math.round(Math.abs(((StiRadialRangeGaugeGeom)geom).sweepAngle / 10.0));
            double stepAngle = ((StiRadialRangeGaugeGeom)geom).sweepAngle / steps;
            currentStartAngle = ((StiRadialRangeGaugeGeom)geom).startAngle;
            double restRadius = ((StiRadialRangeGaugeGeom)geom).radius1 - ((StiRadialRangeGaugeGeom)geom).radius2;
            double offsetStep = 1.0 / steps;
            double offset = 0.0;
            path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(x1), StiGaugeSvgHelper.p(y1)));
            currentStartAngle = ((StiRadialRangeGaugeGeom)geom).startAngle;
            int indexStep = -1;
            while ((double)(++indexStep) < steps) {
                startRadius = ((StiRadialRangeGaugeGeom)geom).radius1 - restRadius * offset;
                endRadius = ((StiRadialRangeGaugeGeom)geom).radius1 - restRadius * (offset + offsetStep);
                points = StiGaugeSvgHelper.convertArcToCubicBezier(new StiPoint(centerPoint.x, centerPoint.y), startRadius, endRadius, currentStartAngle, stepAngle);
                if (indexStep == 0) {
                    path.append(String.format(" C%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
                } else {
                    path.append(String.format(",%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
                }
                currentStartAngle += stepAngle;
                offset += offsetStep;
                if ((double)indexStep != steps - 1.0) continue;
                lastPoint = points[3];
            }
            stepAngle = ((StiRadialRangeGaugeGeom)geom).sweepAngle / steps;
            restRadius = ((StiRadialRangeGaugeGeom)geom).radius3 - ((StiRadialRangeGaugeGeom)geom).radius4;
            offsetStep = 1.0 / steps;
            offset = steps;
            currentStartAngle = ((StiRadialRangeGaugeGeom)geom).startAngle + ((StiRadialRangeGaugeGeom)geom).sweepAngle;
            indexStep = 0;
            while ((double)indexStep < steps) {
                startRadius = ((StiRadialRangeGaugeGeom)geom).radius3 - restRadius * offset;
                endRadius = ((StiRadialRangeGaugeGeom)geom).radius3 - restRadius * (offset + offsetStep);
                points = StiGaugeSvgHelper.convertArcToCubicBezier(centerPoint, startRadius, endRadius, currentStartAngle, -stepAngle);
                if (indexStep == 0) {
                    path.append(String.format(" L%s,%s", StiGaugeSvgHelper.p(points[0].x), StiGaugeSvgHelper.p(points[0].y)));
                    path.append(String.format(" C%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
                } else {
                    path.append(String.format(",%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
                }
                currentStartAngle -= stepAngle;
                offset -= offsetStep;
                ++indexStep;
            }
            path.append(String.format("z", new Object[0]));
            String style4 = "";
            String fill3 = "";
            StiRectangle rect7 = ((StiRadialRangeGaugeGeom)geom).rect;
            style4 = ((StiRadialRangeGaugeGeom)geom).background != null ? StiGaugeSvgHelper.writeFillBrush(writer, ((StiRadialRangeGaugeGeom)geom).background, rect7) : "fill-opacity:0;";
            String stroke3 = String.format("%s", StiGaugeSvgHelper.writeBorderStroke(writer, ((StiRadialRangeGaugeGeom)geom).borderBrush, rect7));
            style4 = style4 + String.format("%s;stroke-width:%s;", stroke3, StiGaugeSvgHelper.p(((StiRadialRangeGaugeGeom)geom).borderWidth));
            writer.writeStartElement("path");
            writer.writeAttributeString("d", path.toString());
            writer.writeAttributeString("style", style4);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeGauge(StiXmlTextWriter writer, StiSvgExportService.StiSvgHelper.StiSvgData svgData, Boolean needAnimation) {
        StiGaugeSvgHelper.writeGauge(writer, svgData, 1.0, needAnimation);
    }

    private static String getPathData(List<StiGaugeGeom> geoms, StiPoint startPoint) {
        String path = String.format("M%s,%s", StiGaugeSvgHelper.p(startPoint.x), StiGaugeSvgHelper.p(startPoint.y));
        int geomIndex = 0;
        for (StiGaugeGeom gm : geoms) {
            StringBuilder sb;
            if (gm.getType() == StiGaugeGeomType.GraphicsPathArc) {
                StiGraphicsPathArcGaugeGeom arcGeom = (StiGraphicsPathArcGaugeGeom)gm;
                path = path + StiGaugeSvgHelper.getArcPath(new StiRectangle(arcGeom.x, arcGeom.y, arcGeom.width, arcGeom.height), path, arcGeom.startAngle, arcGeom.sweepAngle, geomIndex == 0);
            } else if (gm.getType() == StiGaugeGeomType.GraphicsPathLine) {
                StiGraphicsPathLineGaugeGeom lineGeom = (StiGraphicsPathLineGaugeGeom)gm;
                sb = new StringBuilder();
                if (!path.startsWith("M")) {
                    sb.append(String.format("M%s,%s", StiGaugeSvgHelper.p(lineGeom.p2.x), StiGaugeSvgHelper.p(lineGeom.p2.y)));
                }
                sb.append(String.format("L%s,%s", StiGaugeSvgHelper.p(lineGeom.p2.x), StiGaugeSvgHelper.p(lineGeom.p2.y)));
                path = path + sb;
            } else if (gm.getType() == StiGaugeGeomType.GraphicsPathLines) {
                StiGraphicsPathLinesGaugeGeom linesSegment = (StiGraphicsPathLinesGaugeGeom)gm;
                sb = new StringBuilder();
                if (!path.startsWith("M")) {
                    sb.append(String.format("M%s,%s", StiGaugeSvgHelper.p(linesSegment.points[0].x), StiGaugeSvgHelper.p(linesSegment.points[0].y)));
                }
                for (int index = 0; index < linesSegment.points.length; ++index) {
                    if (index == 0) {
                        sb.append(String.format("L%s,%s", StiGaugeSvgHelper.p(linesSegment.points[index].x), StiGaugeSvgHelper.p(linesSegment.points[index].y)));
                        continue;
                    }
                    sb.append(String.format(",%s,%s", StiGaugeSvgHelper.p(linesSegment.points[index].x), StiGaugeSvgHelper.p(linesSegment.points[index].y)));
                }
                path = path + sb;
            } else if (gm.getType() == StiGaugeGeomType.GraphicsPathCloseFigure) {
                path = path + "z";
            }
            ++geomIndex;
        }
        return path;
    }

    public static String getArcPath(StiRectangle rect, String path_, double startAngle, double sweepAngle, boolean isSetStartPoint) {
        boolean isDraw = false;
        StringBuilder path = new StringBuilder(path_);
        StiPoint centerPoint = new StiPoint(rect.getLeft() + rect.width / 2.0, rect.getTop() + rect.height / 2.0);
        StiPoint leftTopPoint = new StiPoint(centerPoint.x - rect.width / 2.0, centerPoint.y - rect.height / 2.0);
        StiPoint centerTopPoint = new StiPoint(centerPoint.x, centerPoint.y - rect.height / 2.0);
        StiPoint rightTopPoint = new StiPoint(centerPoint.x + rect.width / 2.0, centerPoint.y - rect.height / 2.0);
        StiPoint rightMiddlePoint = new StiPoint(centerPoint.x + rect.width / 2.0, centerPoint.y);
        StiPoint rightBottomPoint = new StiPoint(centerPoint.x + rect.width / 2.0, centerPoint.y + rect.height / 2.0);
        StiPoint centerBottomPoint = new StiPoint(centerPoint.x, centerPoint.y + rect.height / 2.0);
        StiPoint leftBottomPoint = new StiPoint(centerPoint.x - rect.width / 2.0, centerPoint.y + rect.height / 2.0);
        StiPoint leftMiddlePoint = new StiPoint(centerPoint.x - rect.width / 2.0, centerPoint.y);
        if (startAngle == 0.0) {
            if (sweepAngle == 90.0) {
                if (isSetStartPoint) {
                    path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(rightMiddlePoint.x), StiGaugeSvgHelper.p(rightMiddlePoint.y)));
                }
                path.append(String.format("Q%s,%s,%s,%s", StiGaugeSvgHelper.p(rightBottomPoint.x), StiGaugeSvgHelper.p(rightBottomPoint.y), StiGaugeSvgHelper.p(centerBottomPoint.x), StiGaugeSvgHelper.p(centerBottomPoint.y)));
                isDraw = true;
            } else if (sweepAngle == 180.0) {
                if (isSetStartPoint) {
                    path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(rightMiddlePoint.x), StiGaugeSvgHelper.p(rightMiddlePoint.y)));
                }
                path.append(String.format("A%s,%s,90,1,1,%s,%s", StiGaugeSvgHelper.p(rect.height / 2.0), StiGaugeSvgHelper.p(rect.width / 2.0), StiGaugeSvgHelper.p(leftMiddlePoint.x), StiGaugeSvgHelper.p(leftMiddlePoint.y)));
                isDraw = true;
            }
        } else if (startAngle == 90.0) {
            if (sweepAngle == 90.0) {
                if (isSetStartPoint) {
                    path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(centerBottomPoint.x), StiGaugeSvgHelper.p(centerBottomPoint.y)));
                }
                path.append(String.format("Q%s,%s,%s,%s", StiGaugeSvgHelper.p(leftBottomPoint.x), StiGaugeSvgHelper.p(leftBottomPoint.y), StiGaugeSvgHelper.p(leftMiddlePoint.x), StiGaugeSvgHelper.p(leftMiddlePoint.y)));
                isDraw = true;
            } else if (sweepAngle == 180.0) {
                if (isSetStartPoint) {
                    path.append(String.format("M%s, %s", StiGaugeSvgHelper.p(centerBottomPoint.x), StiGaugeSvgHelper.p(centerBottomPoint.y)));
                }
                path.append(String.format("A%s,%s,90,1,1,%s,%s", StiGaugeSvgHelper.p(rect.height / 2.0), StiGaugeSvgHelper.p(rect.width / 2.0), StiGaugeSvgHelper.p(centerTopPoint.x), StiGaugeSvgHelper.p(centerTopPoint.y)));
                isDraw = true;
            }
        } else if (startAngle == 180.0) {
            if (sweepAngle == 90.0) {
                if (isSetStartPoint) {
                    path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(leftMiddlePoint.x), StiGaugeSvgHelper.p(leftMiddlePoint.y)));
                }
                path.append(String.format("Q%s,%s,%s,%s", StiGaugeSvgHelper.p(leftTopPoint.x), StiGaugeSvgHelper.p(leftTopPoint.y), StiGaugeSvgHelper.p(centerTopPoint.x), StiGaugeSvgHelper.p(centerTopPoint.y)));
                isDraw = true;
            } else if (sweepAngle == 180.0) {
                if (isSetStartPoint) {
                    path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(leftMiddlePoint.x), StiGaugeSvgHelper.p(leftMiddlePoint.y)));
                }
                path.append(String.format("A%s,%s,90,1,1,%s,%s", StiGaugeSvgHelper.p(rect.height / 2.0), StiGaugeSvgHelper.p(rect.width / 2.0), StiGaugeSvgHelper.p(rightMiddlePoint.x), StiGaugeSvgHelper.p(rightMiddlePoint.y)));
                isDraw = true;
            }
        } else if (startAngle == 270.0) {
            if (sweepAngle == 90.0) {
                path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(centerTopPoint.x), StiGaugeSvgHelper.p(centerTopPoint.y)));
                path.append(String.format("Q%s,%s,%s,%s", StiGaugeSvgHelper.p(rightTopPoint.x), StiGaugeSvgHelper.p(rightTopPoint.y), StiGaugeSvgHelper.p(rightMiddlePoint.x), StiGaugeSvgHelper.p(rightMiddlePoint.y)));
                isDraw = true;
            } else if (sweepAngle == 180.0) {
                if (isSetStartPoint) {
                    path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(centerTopPoint.x), StiGaugeSvgHelper.p(centerTopPoint.y)));
                }
                path.append(String.format("A%s,%s,90,1,1,%s,%s", StiGaugeSvgHelper.p(rect.height / 2.0), StiGaugeSvgHelper.p(rect.width / 2.0), StiGaugeSvgHelper.p(centerBottomPoint.x), StiGaugeSvgHelper.p(centerBottomPoint.y)));
                isDraw = true;
            }
        }
        if (!isDraw) {
            double radius = Math.min(rect.width / 2.0, rect.height / 2.0);
            double currentStartAngle = startAngle * (Math.PI / 180);
            double x1 = centerPoint.x + radius * Math.cos(currentStartAngle);
            double y1 = centerPoint.y + radius * Math.sin(currentStartAngle);
            StiPoint lastPoint = new StiPoint(x1, y1);
            boolean addLine = false;
            if (path.length() == 0) {
                path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(lastPoint.x), StiGaugeSvgHelper.p(lastPoint.y)));
            } else {
                addLine = true;
            }
            double steps = StiGaugeSvgHelper.round(Math.abs(sweepAngle / 90.0));
            double stepAngle = sweepAngle / steps;
            currentStartAngle = startAngle;
            int indexStep = -1;
            while ((double)(++indexStep) < steps) {
                StiPoint[] points = StiGaugeSvgHelper.convertArcToCubicBezier(centerPoint, radius, currentStartAngle, stepAngle);
                if (addLine) {
                    path.append(String.format("M%s,%s", StiGaugeSvgHelper.p(points[0].x), StiGaugeSvgHelper.p(points[0].y)));
                    addLine = false;
                }
                path.append(String.format(" C%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
                lastPoint = points[3];
                currentStartAngle += stepAngle;
            }
        }
        return path.toString();
    }

    private static StiPoint[] convertArcToCubicBezier(StiPoint centerPoint, double radius, double startAngle, double sweepAngle) {
        double startAngle1 = startAngle * (Math.PI / 180);
        double sweepAngle1 = sweepAngle * (Math.PI / 180);
        double endAngle1 = startAngle1 + sweepAngle1;
        double x1 = centerPoint.x + radius * Math.cos(startAngle1);
        double y1 = centerPoint.y + radius * Math.sin(startAngle1);
        double x2 = centerPoint.x + radius * Math.cos(endAngle1);
        double y2 = centerPoint.y + radius * Math.sin(endAngle1);
        double l = radius * 1.3333333333333333 * Math.tan(0.25 * sweepAngle1);
        double aL = Math.atan(l / radius);
        double radL = radius / Math.cos(aL);
        double ax1 = centerPoint.x + radL * Math.cos(aL += startAngle1);
        double ay1 = centerPoint.y + radL * Math.sin(aL);
        aL = Math.atan(-l / radius);
        double ax2 = centerPoint.x + radL * Math.cos(aL += endAngle1);
        double ay2 = centerPoint.y + radL * Math.sin(aL);
        return new StiPoint[]{new StiPoint(x1, y1), new StiPoint(ax1, ay1), new StiPoint(ax2, ay2), new StiPoint(x2, y2)};
    }

    private static String addArcPath(Object arcSegment, String path) {
        double x = arcSegment instanceof StiGraphicsPathArcGaugeGeom ? ((StiGraphicsPathArcGaugeGeom)arcSegment).x : ((StiGraphicsArcGeometryGaugeGeom)arcSegment).rect.x;
        double y = arcSegment instanceof StiGraphicsPathArcGaugeGeom ? ((StiGraphicsPathArcGaugeGeom)arcSegment).y : ((StiGraphicsArcGeometryGaugeGeom)arcSegment).rect.y;
        double width = arcSegment instanceof StiGraphicsPathArcGaugeGeom ? ((StiGraphicsPathArcGaugeGeom)arcSegment).width : ((StiGraphicsArcGeometryGaugeGeom)arcSegment).rect.width;
        double height = arcSegment instanceof StiGraphicsPathArcGaugeGeom ? ((StiGraphicsPathArcGaugeGeom)arcSegment).height : ((StiGraphicsArcGeometryGaugeGeom)arcSegment).rect.height;
        double startAngle_ = arcSegment instanceof StiGraphicsPathArcGaugeGeom ? ((StiGraphicsPathArcGaugeGeom)arcSegment).startAngle : ((StiGraphicsArcGeometryGaugeGeom)arcSegment).startAngle;
        double sweepAngle = arcSegment instanceof StiGraphicsPathArcGaugeGeom ? ((StiGraphicsPathArcGaugeGeom)arcSegment).sweepAngle : ((StiGraphicsArcGeometryGaugeGeom)arcSegment).sweepAngle;
        StringBuilder sb = new StringBuilder();
        double centerX = x + width / 2.0;
        double centerY = y + height / 2.0;
        double radius = width / 2.0;
        double startAngle = startAngle_ * Math.PI / 180.0;
        double x1 = centerX + radius * Math.cos(startAngle);
        double y1 = centerY + radius * Math.sin(startAngle);
        if (!path.startsWith("M")) {
            sb.append(String.format("M%s,%s", StiGaugeSvgHelper.p(x1), StiGaugeSvgHelper.p(y1)));
        }
        double step = StiGaugeSvgHelper.round(Math.abs(sweepAngle / 10.0));
        double stepAngle = sweepAngle / step;
        startAngle = startAngle_;
        StiPoint lastPoint = new StiPoint(0.0, 0.0);
        int indexStep = 0;
        while ((double)indexStep < step) {
            StiPoint[] points = StiGaugeSvgHelper.convertArcToCubicBezier(new StiRectangle(x, y, width, height), startAngle, stepAngle);
            if (indexStep == 0) {
                sb.append(String.format(" C%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
            } else {
                sb.append(String.format(",%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
            }
            startAngle += stepAngle;
            lastPoint = points[3];
            ++indexStep;
        }
        if (arcSegment instanceof StiGraphicsArcGeometryGaugeGeom) {
            StiGraphicsArcGeometryGaugeGeom geom = (StiGraphicsArcGeometryGaugeGeom)arcSegment;
            step = StiGaugeSvgHelper.round(Math.abs(sweepAngle / 10.0));
            stepAngle = sweepAngle / step;
            double secondStartRadius = radius - width * geom.startWidth;
            double secondEndRadius = radius - width * geom.endWidth;
            if (secondStartRadius <= 0.0 || secondEndRadius <= 0.0) {
                return null;
            }
            double offsetSecondRadius = secondStartRadius - secondEndRadius;
            double offsetStep = 1.0 / step;
            double offset = step;
            startAngle = startAngle_ + sweepAngle;
            int indexStep2 = 0;
            while ((double)indexStep2 < step) {
                double startRadius = secondStartRadius - offsetSecondRadius * offset;
                double endRadius = secondStartRadius - offsetSecondRadius * (offset + offsetStep);
                StiPoint[] points = StiGaugeSvgHelper.convertArcToCubicBezier(new StiPoint(centerX, centerY), startRadius, endRadius, startAngle, -stepAngle);
                if (indexStep2 == 0) {
                    sb.append(String.format(" L%s,%s", StiGaugeSvgHelper.p(points[0].x), StiGaugeSvgHelper.p(points[0].y)));
                    sb.append(String.format(" C%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
                } else {
                    sb.append(String.format(",%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[1].x), StiGaugeSvgHelper.p(points[1].y), StiGaugeSvgHelper.p(points[2].x), StiGaugeSvgHelper.p(points[2].y), StiGaugeSvgHelper.p(points[3].x), StiGaugeSvgHelper.p(points[3].y)));
                }
                startAngle -= stepAngle;
                offset -= offsetStep;
                ++indexStep2;
            }
            sb.append(String.format("z", new Object[0]));
        }
        return sb.toString();
    }

    private static String addPiePath(StiPieGaugeGeom pieSegment, String path) {
        StringBuilder sb = new StringBuilder();
        double centerX = pieSegment.rect.x + pieSegment.rect.width / 2.0;
        double centerY = pieSegment.rect.y + pieSegment.rect.height / 2.0;
        double radius = pieSegment.rect.width / 2.0;
        double startAngle = pieSegment.startAngle * Math.PI / 180.0;
        double x1 = centerX + radius * Math.cos(startAngle);
        double y1 = centerY + radius * Math.sin(startAngle);
        sb.append(String.format("M%s,%s", StiGaugeSvgHelper.p(centerX), StiGaugeSvgHelper.p(centerY)));
        sb.append(String.format("L%s,%s", StiGaugeSvgHelper.p(x1), StiGaugeSvgHelper.p(y1)));
        double step = StiGaugeSvgHelper.round(Math.abs(pieSegment.sweepAngle / 90.0));
        double stepAngle = pieSegment.sweepAngle / step;
        startAngle = pieSegment.startAngle;
        int indexStep = 0;
        while ((double)indexStep < step) {
            StiPoint[] points = StiGaugeSvgHelper.convertArcToCubicBezier(pieSegment.rect, startAngle, stepAngle);
            for (int index = 1; index < points.length - 1; index += 3) {
                if (index == 1) {
                    sb.append(String.format("C%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[index].x), StiGaugeSvgHelper.p(points[index].y), StiGaugeSvgHelper.p(points[index + 1].x), StiGaugeSvgHelper.p(points[index + 1].y), StiGaugeSvgHelper.p(points[index + 2].x), StiGaugeSvgHelper.p(points[index + 2].y)));
                    continue;
                }
                sb.append(String.format(",%s,%s,%s,%s,%s,%s", StiGaugeSvgHelper.p(points[index].x), StiGaugeSvgHelper.p(points[index].y), StiGaugeSvgHelper.p(points[index + 1].x), StiGaugeSvgHelper.p(points[index + 1].y), StiGaugeSvgHelper.p(points[index + 2].x), StiGaugeSvgHelper.p(points[index + 2].y)));
            }
            startAngle += stepAngle;
            ++indexStep;
        }
        sb.append(String.format("L%s,%s", StiGaugeSvgHelper.p(centerX), StiGaugeSvgHelper.p(centerY)));
        return sb.toString();
    }

    private static StiPoint[] convertArcToCubicBezier(StiRectangle rect, double startAngle1, double sweepAngle1) {
        double centerX = rect.x + rect.width / 2.0;
        double centerY = rect.y + rect.height / 2.0;
        double radius = Math.min(rect.width / 2.0, rect.height / 2.0);
        double startAngle = startAngle1 * Math.PI / 180.0;
        double sweepAngle = sweepAngle1 * Math.PI / 180.0;
        double endAngle = (startAngle1 + sweepAngle1) * Math.PI / 180.0;
        double x1 = centerX + radius * Math.cos(startAngle);
        double y1 = centerY + radius * Math.sin(startAngle);
        double x2 = centerX + radius * Math.cos(endAngle);
        double y2 = centerY + radius * Math.sin(endAngle);
        double l = radius * 4.0 / 3.0 * Math.tan(0.25 * sweepAngle);
        double aL = Math.atan(l / radius);
        double radL = radius / Math.cos(aL);
        double ax1 = centerX + radL * Math.cos(aL += startAngle);
        double ay1 = centerY + radL * Math.sin(aL);
        aL = Math.atan(-l / radius);
        double ax2 = centerX + radL * Math.cos(aL += endAngle);
        double ay2 = centerY + radL * Math.sin(aL);
        return new StiPoint[]{new StiPoint(x1, y1), new StiPoint(ax1, ay1), new StiPoint(ax2, ay2), new StiPoint(x2, y2)};
    }

    private static StiPoint[] convertArcToCubicBezier(StiPoint centerPoint, double radius1, double radius2, double startAngle, double sweepAngle) {
        double startAngle1 = startAngle * (Math.PI / 180);
        double sweepAngle1 = sweepAngle * (Math.PI / 180);
        double endAngle = startAngle1 + sweepAngle1;
        double x1 = centerPoint.x + radius1 * Math.cos(startAngle1);
        double y1 = centerPoint.y + radius1 * Math.sin(startAngle1);
        double x2 = centerPoint.x + radius2 * Math.cos(endAngle);
        double y2 = centerPoint.y + radius2 * Math.sin(endAngle);
        double rest = (radius1 - radius2) / 3.0;
        radius2 += rest;
        double l = (radius1 -= rest) * 1.3333333333333333 * Math.tan(0.25 * sweepAngle1);
        double aL = Math.atan(l / radius1);
        double radL = radius1 / Math.cos(aL);
        double ax1 = centerPoint.x + radL * Math.cos(aL += startAngle1);
        double ay1 = centerPoint.y + radL * Math.sin(aL);
        aL = Math.atan(-l / radius1);
        double ax2 = centerPoint.x + radL * Math.cos(aL += endAngle);
        double ay2 = centerPoint.y + radL * Math.sin(aL);
        return new StiPoint[]{new StiPoint(x1, y1), new StiPoint(ax1, ay1), new StiPoint(ax2, ay2), new StiPoint(x2, y2)};
    }

    private static double round(double value) {
        int value1 = (int)value;
        double rest = value - (double)value1;
        return rest > 0.0 ? (double)(value1 + 1) : (double)value1;
    }

    private static StiPoint[] calculateCurveBezier(StiPoint[] points, int index, double tension) {
        double xDiff = points[index + 2].x - points[index + 0].x;
        double yDiff = points[index + 2].y - points[index + 0].y;
        return new StiPoint[]{new StiPoint(points[index + 1].x - tension * xDiff, points[index + 1].y - tension * yDiff), new StiPoint(points[index + 1].x + tension * xDiff, points[index + 1].y + tension * yDiff)};
    }

    private static StiPoint calculateCurveBezierEndPoints(StiPoint end, StiPoint adj, double tension) {
        return new StiPoint(tension * (adj.x - end.x) + end.x, tension * (adj.y - end.y) + end.y);
    }

    public static String writeFillBrush(StiXmlTextWriter writer, Object brush, StiRectangle rect) {
        if (brush instanceof StiColor) {
            StiColor color = (StiColor)brush;
            return String.format("fill:rgb(%s,%s,%s);fill-opacity:%s;", color.r, color.g, color.b, StiGaugeSvgHelper.p(StiMath.round((float)((float)color.a / 255.0f), (int)3)));
        }
        if (brush instanceof StiGradientBrush) {
            String gradientId = StiBrushSvgHelper.writeGradientBrush(writer.getElement(), brush, rect, writer.getDocument());
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiGlareBrush) {
            String gradientId = StiBrushSvgHelper.writeGlareBrush(writer.getElement(), brush, rect, writer.getDocument());
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiGlassBrush) {
            String gradientId = StiBrushSvgHelper.writeGlassBrush(writer.getElement(), brush, rect, writer.getDocument());
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiHatchBrush) {
            String gradientId = StiBrushSvgHelper.writeHatchBrush(writer.getElement(), brush, writer.getDocument());
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiBrush) {
            StiColor color = StiBrush.ToColor((StiBrush)((StiBrush)brush));
            return String.format("fill:rgb(%s,%s,%s);fill-opacity:%s;", color.r, color.g, color.b, StiGaugeSvgHelper.p(StiMath.round((float)((float)color.a / 255.0f), (int)3)));
        }
        return "fill-opacity:0;";
    }

    private static String writeBorderStroke(StiXmlTextWriter writer, Object brush, StiRectangle rect) {
        if (brush instanceof StiColor) {
            StiColor color = (StiColor)brush;
            String result = String.format("stroke:rgb(%s,%s,%s);", color.r, color.g, color.b);
            double alfa = StiMath.round((float)((float)color.a / 255.0f), (int)3);
            if (alfa != 1.0) {
                result = result + String.format("stroke-opacity:%s;", StiGaugeSvgHelper.p(alfa));
            }
            return result;
        }
        if (brush instanceof StiSolidBrush) {
            StiSolidBrush solid = (StiSolidBrush)brush;
            String result = String.format("stroke:rgb(%s,%s,%s);", solid.getColor().r, solid.getColor().g, solid.getColor().b);
            double alfa = StiMath.round((float)((float)solid.getColor().a / 255.0f), (int)3);
            if (alfa != 1.0) {
                result = result + String.format("stroke-opacity:%s;", StiGaugeSvgHelper.p(alfa));
            }
            return result;
        }
        if (brush instanceof StiGradientBrush) {
            String gradientId = StiBrushSvgHelper.writeGradientBrush(writer.getElement(), brush, rect, writer.getDocument());
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiGlareBrush) {
            String gradientId = StiBrushSvgHelper.writeGlareBrush(writer.getElement(), brush, rect, writer.getDocument());
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiGlassBrush) {
            String gradientId = StiBrushSvgHelper.writeGlassBrush(writer.getElement(), brush, rect, writer.getDocument());
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiHatchBrush) {
            String gradientId = StiBrushSvgHelper.writeHatchBrush(writer.getElement(), brush, writer.getDocument());
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiBrush) {
            StiColor color = StiBrush.ToColor((StiBrush)((StiBrush)brush));
            String result = String.format("stroke:rgb(%s,%s,%s)", color.r, color.g, color.b);
            double alfa = StiMath.round((float)((float)color.a / 255.0f), (int)3);
            if (alfa != 1.0) {
                result = result + String.format(";stroke-opacity:%s", StiGaugeSvgHelper.p(alfa));
            }
        }
        return "stroke-opacity:0";
    }

    private static String r(Object o) {
        return String.valueOf(o).replace(',', '.');
    }

    private static String p(Object o) {
        return StiGaugeSvgHelper.r(o);
    }
}

