/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service.helper;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.helper.StiSvgHelper;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiXmlTextWriter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.export.service.helper.HeatmapInfo;
import com.stimulsoft.report.export.service.helper.HeatmapWithGroupInfo;
import com.stimulsoft.report.export.service.helper.NoneInfo;
import com.stimulsoft.report.export.service.helper.StiMapGroup;
import com.stimulsoft.report.export.service.helper.StiStyleColorsContainer;
import com.stimulsoft.report.helpers.StiAbbreviationNumberFormatHelper;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.StiMapData;
import com.stimulsoft.report.maps.StiMapLoader;
import com.stimulsoft.report.maps.StiMapSvg;
import com.stimulsoft.report.maps.StiMapSvgContainer;
import com.stimulsoft.report.maps.enums.StiDisplayNameType;
import com.stimulsoft.report.maps.enums.StiMapType;
import com.stimulsoft.report.maps.helpers.StiMapHelper;
import com.stimulsoft.report.styles.StiMapStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class StiMapSvgHelper {
    private static String r(Object o) {
        return String.valueOf(o).replace(',', '.');
    }

    private static String p(Object o) {
        return StiMapSvgHelper.r(o);
    }

    public static void drawMap(StiXmlTextWriter xmlsWriter, StiMap map, double width, double height, Boolean animated) throws Exception {
        StiMapSvgContainer resource = StiMapLoader.loadResource(map.getMapID().toString());
        double sScale = width / (double)resource.width < height / (double)resource.height ? width / (double)resource.width : height / (double)resource.height;
        xmlsWriter.writeStartElement("rect");
        xmlsWriter.writeAttributeString("width", StiMapSvgHelper.r(width));
        xmlsWriter.writeAttributeString("height", StiMapSvgHelper.r(height));
        StiColor color = ((StiSolidBrush)map.getStyleBackground()).getColor();
        xmlsWriter.writeAttributeString("style", String.format("fill:rgb(%s,%s,%s);fill-opacity:%s;", color.r, color.g, color.b, StiMapSvgHelper.r(StiMath.round((float)((float)color.a / 255.0f), (int)3))));
        xmlsWriter.writeEndElement();
        xmlsWriter.writeStartElement("g");
        xmlsWriter.writeAttributeString("transform", String.format("translate(%s,%s)", StiMapSvgHelper.p(Float.valueOf((float)((width - (double)resource.width * sScale) / 2.0))), StiMapSvgHelper.p(Float.valueOf((float)((height - (double)resource.height * sScale) / 2.0)))));
        StiMapSvgHelper.render(map, xmlsWriter, animated, sScale);
        xmlsWriter.writeEndElement();
    }

    public static void render(StiMap map, StiXmlTextWriter xmlsWriter, Boolean animated, double sScale) throws Exception {
        NoneInfo noneInfo = new NoneInfo();
        List<StiMapData> mapData = map.GetMapData();
        HashMap<String, StiMapGroup> hashGroup = new HashMap<String, StiMapGroup>();
        HeatmapInfo heatmapInfo = null;
        StiStyleColorsContainer colorsContainer = new StiStyleColorsContainer();
        StiMapSvgHelper.initData(mapData, hashGroup);
        if (map.getMapType() == StiMapType.Heatmap) {
            heatmapInfo = new HeatmapInfo(map, mapData);
        }
        if (map.getMapType() == StiMapType.Group) {
            StiMapSvgHelper.fillGroupColors(colorsContainer, map, hashGroup);
        }
        StiMapStyle mapStyle = null;
        if (!StiValidationUtil.isNullOrEmpty((String)map.getComponentStyle())) {
            mapStyle = (StiMapStyle)map.getReport().getStyles().get(map.getComponentStyle());
        }
        if (mapStyle == null) {
            mapStyle = StiMap.getMapStyle(map.getMapStyle());
        }
        StiSolidBrush defaultBrush = new StiSolidBrush(mapStyle.getDefaultColor());
        StiSolidBrush defaultBrush1 = new StiSolidBrush(mapStyle.getDefaultColor());
        HeatmapWithGroupInfo heatmapWithGroupInfo = null;
        if (map.getMapType() == StiMapType.HeatmapWithGroup) {
            heatmapWithGroupInfo = new HeatmapWithGroupInfo((StiBrush)defaultBrush, (StiBrush)defaultBrush1, map, mapData);
        }
        StiMapSvgContainer svgContainer = StiMapLoader.loadResource(map.getMapID().toString());
        HashMap<String, StiMapData> labels = new HashMap<String, StiMapData>();
        if (svgContainer != null) {
            float individualStepValue;
            int count = 0;
            int sCount = svgContainer.hashPaths.keySet().size();
            float individualStep = individualStepValue = 0.5f / (float)sCount;
            ArrayList<String> keys = new ArrayList<String>(svgContainer.hashPaths.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                StiMapData data = mapData.get(0);
                for (StiMapData md : mapData) {
                    if (!StiValidationUtil.equals((Object)md.getKey(), (Object)key)) continue;
                    data = md;
                }
                StiBrush fill = StiMapSvgHelper.getFill(data, map, heatmapInfo, hashGroup, individualStep, mapStyle, heatmapWithGroupInfo, (StiBrush)defaultBrush, noneInfo);
                individualStep += individualStepValue;
                xmlsWriter.writeStartElement("path");
                xmlsWriter.writeAttributeString("d", svgContainer.hashPaths.get((Object)key).data);
                StringBuilder style = new StringBuilder();
                style.append(StiMapSvgHelper.getFillBrush((StiSolidBrush)fill));
                String stroke = StiMapSvgHelper.getBorderStroke(mapStyle.getBorderColor());
                style.append(stroke + ";stroke-width:" + StiMapSvgHelper.p(mapStyle.getBorderSize()) + ";");
                xmlsWriter.writeAttributeString("style", style.toString());
                xmlsWriter.writeAttributeString("transform", "scale(" + StiMapSvgHelper.p(sScale) + ")");
                xmlsWriter.writeAttributeString("_ismap", "true");
                xmlsWriter.writeAttributeString("_text1", key);
                xmlsWriter.writeAttributeString("_text2", data.getValue() != null ? data.getValue().toString() : "");
                StiColor color = ((StiSolidBrush)fill).getColor();
                xmlsWriter.writeAttributeString("_color", color.toHTML());
                if (animated.booleanValue()) {
                    xmlsWriter.writeAttributeString("opacity", "0");
                    xmlsWriter.writeAttributeString("_animation", String.format("{\"actions\":[[\"opacity\", 0, 1, \"\"], [\"scale\", %s, %s,\"\"]], \"begin\":%s, \"duration\":%s}", StiMapSvgHelper.p(sScale), StiMapSvgHelper.p(sScale), StiMapSvgHelper.p(200 / sCount * count), "100"));
                }
                xmlsWriter.writeEndElement();
                if ((map.isShowValue() || map.getDisplayNameType() != StiDisplayNameType.None) && sScale >= 0.2) {
                    labels.put(key, data);
                }
                ++count;
            }
            StiFont typeface = new StiFont("Calibri", 18.0);
            StiColor[] foregrounds = new StiColor[]{StiColor.fromArgb((int)180, (int)251, (int)251, (int)251), StiColor.fromArgb((int)255, (int)37, (int)37, (int)37)};
            for (String key : labels.keySet()) {
                String text = null;
                StiMapData info = (StiMapData)labels.get(key);
                StiMapSvg path = svgContainer.hashPaths.get(key);
                switch (map.getDisplayNameType()) {
                    case Full: {
                        text = info != null ? info.getName() : path.englishName;
                        break;
                    }
                    case Short: {
                        text = StiMapHelper.prepareIsoCode(path.ISOCode);
                    }
                }
                if (map.isShowValue() && info != null && info.getValue() != null) {
                    String valueStr = null;
                    if (map.isShortValue()) {
                        double resValue = 0.0;
                        try {
                            resValue = Double.parseDouble(info.getValue());
                            valueStr = StiAbbreviationNumberFormatHelper.format(resValue);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (valueStr == null) {
                        valueStr = info.getValue();
                    }
                    if (text == null) {
                        text = valueStr;
                    } else {
                        text = text + "\r\n";
                        text = text + valueStr;
                    }
                }
                if (StiValidationUtil.isNullOrEmpty((String)text)) continue;
                StiRectangle bounds = path.rect;
                StiSize textSize = path.setMaxWidth ? StiTextUtil.measureString((double)bounds.width, (StiFont)typeface, (String)text, (float)0.0f) : StiTextUtil.measureString((double)bounds.width, (StiFont)typeface, (String)text, (float)0.0f);
                double x = bounds.x + (double)((int)((bounds.width - textSize.width) / 2.0));
                double y = bounds.y + (double)((int)((bounds.height - textSize.height) / 2.0 + 40.0 * sScale));
                if (path.horAlignment != null) {
                    switch (path.horAlignment == null ? StiTextHorAlignment.Left : path.horAlignment) {
                        case Left: {
                            x = bounds.x;
                            break;
                        }
                        case Right: {
                            x = bounds.getRight() - (double)((int)textSize.width);
                        }
                    }
                }
                if (path.vertAlignment != null) {
                    switch (path.vertAlignment == null ? StiVertAlignment.Top : path.vertAlignment) {
                        case Top: {
                            y = bounds.y;
                            break;
                        }
                        case Bottom: {
                            y = bounds.getBottom() - (double)((int)textSize.height);
                        }
                    }
                }
                for (int step = 0; step < 2; ++step) {
                    StiSize rectTemp;
                    xmlsWriter.writeStartElement("text");
                    xmlsWriter.writeAttributeString("font-size", StiMapSvgHelper.p(26.0 * sScale));
                    xmlsWriter.writeAttributeString("font-family", "Calibri");
                    if (animated.booleanValue()) {
                        xmlsWriter.writeAttributeString("opacity", "0");
                        xmlsWriter.writeAttributeString("_animation", String.format("{\"actions\":[[\"opacity\", 0, 1, \"\"], [\"scale\", %s, %s,\"\"]], \"begin\":%s, \"duration\":%s}", StiMapSvgHelper.p(sScale), StiMapSvgHelper.p(sScale), StiMapSvgHelper.p(200 / sCount * count), "100"));
                    }
                    xmlsWriter.writeAttributeString("transform", String.format("translate(%s, %s)", StiMapSvgHelper.p(x * sScale - (double)step), StiMapSvgHelper.p(y * sScale - (double)step)));
                    xmlsWriter.writeAttributeString("style", "fill:" + foregrounds[step].toHTML() + ";pointer-events:none");
                    if (path.setMaxWidth) {
                        String[] words = text.split("[ ]|\r\n");
                        int index = 0;
                        while (index < words.length) {
                            String txt;
                            rectTemp = new StiSize(0, 0);
                            int length = 1;
                            String fitTxt = txt = words[index];
                            rectTemp = StiTextUtil.measureString((StiFont)typeface, (String)txt);
                            while (rectTemp.width < textSize.width + 20.0 * sScale && index + length < words.length && !fitTxt.endsWith("\r")) {
                                fitTxt = txt;
                                txt = txt + " " + words[index + length];
                                rectTemp = StiTextUtil.measureString((StiFont)typeface, (String)txt);
                                ++length;
                            }
                            xmlsWriter.writeStartElement("tspan");
                            xmlsWriter.writeAttributeString("x", "0");
                            if (index == 0) {
                                xmlsWriter.writeAttributeString("y", "0");
                            } else {
                                xmlsWriter.writeAttributeString("dy", StiMapSvgHelper.p(rectTemp.height * sScale));
                            }
                            xmlsWriter.writeString(fitTxt);
                            xmlsWriter.writeEndElement();
                            index = index + length - (length == 1 ? 0 : 1);
                        }
                    } else {
                        String[] lines = text.split("\r\n");
                        for (int i = 0; i < lines.length; ++i) {
                            rectTemp = StiTextUtil.measureString((StiFont)typeface, (String)lines[i]);
                            xmlsWriter.writeStartElement("tspan");
                            xmlsWriter.writeAttributeString("x", "0");
                            if (i == 0) {
                                xmlsWriter.writeAttributeString("y", "0");
                            } else {
                                xmlsWriter.writeAttributeString("dy", StiMapSvgHelper.p(rectTemp.height * sScale));
                            }
                            xmlsWriter.writeString(lines[i]);
                            xmlsWriter.writeEndElement();
                        }
                    }
                    xmlsWriter.writeEndElement();
                }
            }
        }
        if (mapData != null) {
            mapData.clear();
            mapData = null;
        }
        if (hashGroup != null) {
            hashGroup.clear();
            hashGroup = null;
        }
    }

    private static String getBorderStroke(StiColor color) {
        String result = String.format("stroke:rgb(%s,%s,%s);", color.r, color.g, color.b);
        double alfa = StiMath.round((float)((float)color.a / 255.0f), (int)3);
        if (alfa != 1.0) {
            result = result + String.format("stroke-opacity:%S;", StiMapSvgHelper.r(alfa));
        }
        return result;
    }

    public static String getFillBrush(StiSolidBrush brush) {
        StiColor color = brush.getColor();
        return String.format("fill:rgb(%s,%s,%s);fill-opacity:%s;", color.r, color.g, color.b, StiMapSvgHelper.r(StiMath.round((float)((float)color.a / 255.0f), (int)3)));
    }

    private static StiBrush getFill(StiMapData mapData, StiMap map, HeatmapInfo heatmapInfo, HashMap<String, StiMapGroup> hashGroup, float individualStep, StiMapStyle mapStyle, HeatmapWithGroupInfo heatmapWithGroupInfo, StiBrush defaultBrush, NoneInfo noneInfo) throws Exception {
        StiBrush brush = null;
        if (map.getMapType() == StiMapType.Individual) {
            if (map.isColorEach()) {
                if (mapData == null) {
                    return new StiSolidBrush(mapStyle.getDefaultColor());
                }
                brush = StiMapSvgHelper.parseHexColor(mapData.getColor());
                if (brush != null) {
                    return brush;
                }
                return new StiSolidBrush(noneInfo.getBrush().getColor());
            }
            return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)mapStyle.individualColor, (float)individualStep));
        }
        switch (map.getMapType()) {
            case None: {
                brush = StiMapSvgHelper.getNoneBrush(mapData, map);
                break;
            }
            case Group: {
                return mapData.getGroup() != null && hashGroup.containsKey(mapData.getGroup()) ? hashGroup.get((Object)mapData.getGroup()).Fill : new StiSolidBrush(mapStyle.getDefaultColor());
            }
            case HeatmapWithGroup: {
                if (mapData.getGroup() == null) {
                    return new StiSolidBrush(mapStyle.getDefaultColor());
                }
                return heatmapWithGroupInfo.getBrush(mapData);
            }
            case Heatmap: {
                if (mapData.getValue() == null) {
                    return defaultBrush;
                }
                return heatmapInfo.getBrush(mapData, defaultBrush);
            }
        }
        if (brush != null) {
            return brush;
        }
        return new StiSolidBrush(mapStyle.getBackColor());
    }

    private static StiBrush parseHexColor(String color) {
        try {
            if (!StiValidationUtil.isNullOrEmpty((String)color)) {
                if (color.startsWith("#")) {
                    return new StiSolidBrush(StiColor.fromHtml((String)color));
                }
                Color c = (Color)StiSvgHelper.getColorsTable().get(color);
                StiColor cl = new StiColor(c.getAlpha(), c.getRed(), c.getGreen(), c.getBlue(), color);
                return new StiSolidBrush(cl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static StiBrush getNoneBrush(StiMapData mapData, StiMap map) throws Exception {
        if (!StiValidationUtil.isNullOrEmpty((String)mapData.getColor())) {
            try {
                return new StiSolidBrush(StiColor.fromHtml((String)mapData.getColor()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        StiMapStyle mapStyle = null;
        if (!StiValidationUtil.isNullOrEmpty((String)map.getComponentStyle())) {
            mapStyle = (StiMapStyle)map.getReport().getStyles().get(map.getComponentStyle());
        }
        if (mapStyle != null) {
            mapStyle = StiMap.getMapStyle(map.getMapStyle());
        }
        return new StiSolidBrush(mapStyle.getBackColor());
    }

    private static void fillGroupColors(StiStyleColorsContainer colorsContainer, StiMap map, HashMap<String, StiMapGroup> hashGroup) throws Exception {
        colorsContainer.init(map);
        TreeSet<String> sortedKeys = new TreeSet<String>();
        sortedKeys.addAll(hashGroup.keySet());
        for (String key : sortedKeys) {
            StiMapGroup value = hashGroup.get(key);
            value.Fill = colorsContainer.getColor();
        }
    }

    private static void initData(List<StiMapData> mapData, HashMap<String, StiMapGroup> hashGroup) {
        for (StiMapData item : mapData) {
            if (StiValidationUtil.isNullOrEmpty((String)item.getGroup()) || item.getValue() == null) continue;
            double value = 0.0;
            try {
                value = Double.parseDouble(item.getValue());
            }
            catch (Exception e) {
                continue;
            }
            StiMapGroup group = null;
            if (!hashGroup.containsKey(item.getGroup())) {
                group = new StiMapGroup();
                group.MinValue = value;
                group.MaxValue = value;
                hashGroup.put(item.getGroup(), group);
                continue;
            }
            group = hashGroup.get(item.getGroup());
            if (group.MinValue > value) {
                group.MinValue = value;
                continue;
            }
            if (!(group.MaxValue < value)) continue;
            group.MaxValue = value;
        }
    }
}

