/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiNameValidator;

public class StiCellStyle
implements Cloneable {
    private StiBorderSide border;
    private StiBorderSide borderL;
    private StiBorderSide borderR;
    private StiBorderSide borderB;
    private boolean absolutePosition = false;
    private StiColor color;
    private StiFont font;
    private StiTextHorAlignment horAlignment;
    private StiVertAlignment vertAlignment;
    private StiTextOptions textOptions;
    private StiColor textColor;
    private boolean wordWrap;
    private String format;
    private String styleName = null;
    private String internalStyleName = null;

    public StiCellStyle(StiColor color, StiColor textColor, StiFont font, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment, StiBorderSide border, StiTextOptions textOptions, boolean wordWrap, String format) {
        this(color, textColor, font, horAlignment, vertAlignment, border, textOptions, wordWrap, format, null);
    }

    public StiCellStyle(StiColor color, StiColor textColor, StiFont font, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment, StiBorderSide border, StiTextOptions textOptions, boolean wordWrap, String format, String styleName) {
        this.border = border;
        this.color = color;
        this.font = font;
        this.horAlignment = horAlignment;
        this.vertAlignment = vertAlignment;
        this.textOptions = textOptions;
        this.textColor = textColor;
        this.wordWrap = wordWrap;
        this.format = format;
        this.setInternalStyleName(styleName);
    }

    public StiCellStyle(StiColor color, StiColor textColor, StiFont font, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment, StiBorderSide border, StiBorderSide borderL, StiBorderSide borderR, StiBorderSide borderB, StiTextOptions textOptions, boolean wordWrap, String format) {
        this(color, textColor, font, horAlignment, vertAlignment, border, borderL, borderR, borderB, textOptions, wordWrap, format, null);
    }

    public StiCellStyle(StiColor color, StiColor textColor, StiFont font, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment, StiBorderSide border, StiBorderSide borderL, StiBorderSide borderR, StiBorderSide borderB, StiTextOptions textOptions, boolean wordWrap, String format, String styleName) {
        this.border = border;
        this.borderL = borderL;
        this.borderR = borderR;
        this.borderB = borderB;
        this.color = color;
        this.font = font;
        this.horAlignment = horAlignment;
        this.vertAlignment = vertAlignment;
        this.textOptions = textOptions;
        this.textColor = textColor;
        this.wordWrap = wordWrap;
        this.format = format;
        this.setInternalStyleName(styleName);
    }

    public StiCellStyle clone() {
        StiCellStyle result = new StiCellStyle(this.color != null ? this.color.clone() : null, this.textColor != null ? this.textColor.clone() : null, this.font != null ? (StiFont)this.font.clone() : null, this.horAlignment, this.vertAlignment, this.border != null ? (StiBorderSide)this.border.clone() : null, this.borderL != null ? (StiBorderSide)this.borderL.clone() : null, this.borderR != null ? (StiBorderSide)this.borderR.clone() : null, this.borderB != null ? (StiBorderSide)this.borderB.clone() : null, this.textOptions != null ? (StiTextOptions)this.textOptions.clone() : null, this.wordWrap, this.format != null ? new String(this.format) : null, this.internalStyleName != null ? new String(this.internalStyleName) : null);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        StiCellStyle style = (StiCellStyle)obj;
        if (!this.getColor().equals(style.getColor())) {
            return false;
        }
        if (this.getHorAlignment() != style.getHorAlignment()) {
            return false;
        }
        if (this.getVertAlignment() != style.getVertAlignment()) {
            return false;
        }
        if (!this.getTextColor().equals(style.getTextColor())) {
            return false;
        }
        if (!this.getFont().getName().equals(style.getFont().getName())) {
            return false;
        }
        if (this.getFont().bold() != style.getFont().bold()) {
            return false;
        }
        if (this.getFont().italic() != style.getFont().italic()) {
            return false;
        }
        if (this.getFont().strikeout() != style.getFont().strikeout()) {
            return false;
        }
        if (this.getFont().underline() != style.getFont().underline()) {
            return false;
        }
        if (this.getFont().getSize() != style.getFont().getSize()) {
            return false;
        }
        if (this.isWordWrap() != style.isWordWrap()) {
            return false;
        }
        if (this.getTextOptions() == null && style.getTextOptions() != null) {
            return false;
        }
        if (this.getTextOptions() != null && style.getTextOptions() == null) {
            return false;
        }
        if (this.getTextOptions() != null && style.getTextOptions() != null) {
            if (this.getTextOptions().getAngle() != style.getTextOptions().getAngle()) {
                return false;
            }
            if (this.getTextOptions().getWordWrap() != style.getTextOptions().getWordWrap()) {
                return false;
            }
            if (this.getTextOptions().getRightToLeft() != style.getTextOptions().getRightToLeft()) {
                return false;
            }
        }
        if (this.getBorder() == null && style.getBorder() != null) {
            return false;
        }
        if (this.getBorder() != null && style.getBorder() == null) {
            return false;
        }
        if (this.getBorder() != null && style.getBorder() != null) {
            if (!this.getBorder().getColor().equals(style.getBorder().getColor())) {
                return false;
            }
            if (this.getBorder().getSize() != style.getBorder().getSize()) {
                return false;
            }
            if (this.getBorder().getStyle() != style.getBorder().getStyle()) {
                return false;
            }
        }
        if (this.getBorderL() == null && style.getBorderL() != null) {
            return false;
        }
        if (this.getBorderL() != null && style.getBorderL() == null) {
            return false;
        }
        if (this.getBorderL() != null && style.getBorderL() != null) {
            if (!this.getBorderL().getColor().equals(style.getBorderL().getColor())) {
                return false;
            }
            if (this.getBorderL().getSize() != style.getBorderL().getSize()) {
                return false;
            }
            if (this.getBorderL().getStyle() != style.getBorderL().getStyle()) {
                return false;
            }
        }
        if (this.getBorderR() == null && style.getBorderR() != null) {
            return false;
        }
        if (this.getBorderR() != null && style.getBorderR() == null) {
            return false;
        }
        if (this.getBorderR() != null && style.getBorderR() != null) {
            if (!this.getBorderR().getColor().equals(style.getBorderR().getColor())) {
                return false;
            }
            if (this.getBorderR().getSize() != style.getBorderR().getSize()) {
                return false;
            }
            if (this.getBorderR().getStyle() != style.getBorderR().getStyle()) {
                return false;
            }
        }
        if (this.getBorderB() == null && style.getBorderB() != null) {
            return false;
        }
        if (this.getBorderB() != null && style.getBorderB() == null) {
            return false;
        }
        if (this.getBorderB() != null && style.getBorderB() != null) {
            if (!this.getBorderB().getColor().equals(style.getBorderB().getColor())) {
                return false;
            }
            if (this.getBorderB().getSize() != style.getBorderB().getSize()) {
                return false;
            }
            if (!this.getBorderB().getStyle().equals((Object)style.getBorderB().getStyle())) {
                return false;
            }
        }
        if (!StiStringUtil.stringsEquals((String)this.getFormat(), (String)style.getFormat())) {
            return false;
        }
        return StiStringUtil.stringsEquals((String)this.getInternalStyleName(), (String)style.getInternalStyleName());
    }

    public String getStyleName() {
        if (this.styleName == null) {
            this.styleName = this.internalStyleName;
            if (this.styleName == null) {
                this.styleName = StiGuid.newGuid().toString().replace("-", "").substring(0, 8);
            }
        }
        return this.styleName;
    }

    public StiBorderSide getBorder() {
        return this.border;
    }

    public void setBorder(StiBorderSide border) {
        this.border = border;
    }

    public StiBorderSide getBorderL() {
        return this.borderL;
    }

    public void setBorderL(StiBorderSide borderL) {
        this.borderL = borderL;
    }

    public StiBorderSide getBorderR() {
        return this.borderR;
    }

    public void setBorderR(StiBorderSide borderR) {
        this.borderR = borderR;
    }

    public StiBorderSide getBorderB() {
        return this.borderB;
    }

    public void setBorderB(StiBorderSide borderB) {
        this.borderB = borderB;
    }

    public boolean isAbsolutePosition() {
        return this.absolutePosition;
    }

    public void setAbsolutePosition(boolean absolutePosition) {
        this.absolutePosition = absolutePosition;
    }

    public StiColor getColor() {
        return this.color;
    }

    public void setColor(StiColor color) {
        this.color = color;
    }

    public StiFont getFont() {
        return this.font;
    }

    public void setFont(StiFont font) {
        this.font = font;
    }

    public StiTextHorAlignment getHorAlignment() {
        return this.horAlignment;
    }

    public void setHorAlignment(StiTextHorAlignment horAlignment) {
        this.horAlignment = horAlignment;
    }

    public StiVertAlignment getVertAlignment() {
        return this.vertAlignment;
    }

    public void setVertAlignment(StiVertAlignment vertAlignment) {
        this.vertAlignment = vertAlignment;
    }

    public StiTextOptions getTextOptions() {
        return this.textOptions;
    }

    public void setTextOptions(StiTextOptions textOptions) {
        this.textOptions = textOptions;
    }

    public StiColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(StiColor textColor) {
        this.textColor = textColor;
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getInternalStyleName() {
        return this.internalStyleName;
    }

    public void setInternalStyleName(String internalStyleName) {
        this.internalStyleName = internalStyleName != null ? StiNameValidator.CorrectName(internalStyleName.trim()) : null;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public int getHashCode() {
        return this.hashCode();
    }
}

