/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.gauge.helpers;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.gauge.helpers.CacheInfo;
import com.stimulsoft.report.helpers.StiAbbreviationNumberFormatHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class StiTickLabelHelper {
    public static Map<Double, String> getLabels(Map<Double, Double> collection) {
        TreeMap<Double, String> result = new TreeMap<Double, String>();
        ArrayList<CacheInfo> cacheActualvalues = new ArrayList<CacheInfo>();
        for (Double key : collection.keySet()) {
            long value = Math.round(key);
            if ((float)value == 0.0f) {
                result.put(key, "0");
                continue;
            }
            boolean negative = false;
            if (value < 0L) {
                negative = true;
                value = Math.abs(value);
            }
            String valueStr = value < 1000L ? String.valueOf(value) : (value < 1000000L ? (int)(value / 1000L) + "K" : (value < 1000000000L ? (int)(value / 1000000L) + "M" : ((double)value < 1.0E12 ? (int)(value / 1000000000L) + "B" : ((double)value < 1.0E15 ? (int)((double)value / 1.0E12) + "T" : String.valueOf(value)))));
            if (negative) {
                valueStr = "-" + valueStr;
            }
            CacheInfo cache = null;
            for (CacheInfo info : cacheActualvalues) {
                if (!StiValidationUtil.equals((Object)info.valueStr, (Object)valueStr)) continue;
                cache = info;
            }
            if (cache == null) {
                cacheActualvalues.add(new CacheInfo(key, valueStr, 1));
            } else {
                ++cache.count;
            }
            result.put(key, valueStr);
        }
        for (CacheInfo cache : cacheActualvalues) {
            if (cache.count <= 1) continue;
            StiTickLabelHelper.prepare(cache, result);
        }
        return result;
    }

    private static void prepare(CacheInfo cache, Map<Double, String> result) {
        Set<Double> keys = result.keySet();
        for (Double key : keys) {
            String valueF = result.get(key);
            if (!StiValidationUtil.equals((Object)valueF, (Object)cache.valueStr)) continue;
            result.put(key, StiAbbreviationNumberFormatHelper.format(key));
        }
    }
}

