/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.engine.parser.StiParser;

public class StiExpressionHelper {
    public static String parseText(StiPage page, String text) {
        block5: {
            if (StiValidationUtil.isNullOrEmpty((String)text) || page == null) {
                return text;
            }
            if (text.contains("{") && text.contains("}") && !text.contains("{{") && !text.contains("}}")) {
                try {
                    StiText textComp = new StiText();
                    textComp.setPage(page);
                    Object result = StiParser.ParseTextValue(text, (StiComponent)textComp);
                    if (result != null) {
                        return result.toString();
                    }
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block5;
                    e.printStackTrace();
                }
            }
        }
        return text;
    }

    public static boolean parseBool(StiPage page, String text) {
        block9: {
            if (StiValidationUtil.isNullOrEmpty((String)text)) {
                return false;
            }
            try {
                Object value;
                StiText textComp = new StiText();
                textComp.setPage(page);
                text = text.trim();
                if (!text.startsWith("{")) {
                    text = "{" + text;
                }
                if (!text.endsWith("}")) {
                    text = text + "}";
                }
                if ((value = StiParser.ParseTextValue(text, (StiComponent)textComp)) instanceof Boolean) {
                    return (Boolean)value;
                }
                if (value instanceof String) {
                    try {
                        return Boolean.parseBoolean(((String)value).toLowerCase());
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block9;
                e.printStackTrace();
            }
        }
        return false;
    }
}

