/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiInteraction;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.infographics.gauge.collections.StiScaleCollection;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.infographics.gauge.styles.view.StiGaugeStyleXF26;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.StiPainter;
import java.awt.image.BufferedImage;

public class StiGauge
extends StiComponent
implements IStiExportImageExtended,
IStiBorder,
IStiBrush {
    private StiBorder border = new StiBorder();
    private StiBrush brush = new StiSolidBrush(StiColorEnum.Transparent.color());
    public boolean shortValue = true;
    public StiGaugeContextPainter painter;
    private IStiGaugeStyle style = new StiGaugeStyleXF26();
    private String customStyleName = "";
    private StiScaleCollection scales = new StiScaleCollection(this);
    private boolean isAnimation = false;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("ComponentStyle");
        jObject.RemoveProperty("UseParentStyles");
        jObject.RemoveProperty("CanGrow");
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("GrowToHeight");
        jObject.RemoveProperty("Interaction");
        jObject.RemoveProperty("IsAnimation");
        jObject.AddPropertyBool("ShortValue", this.shortValue, true);
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.border));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyJObject("Scales", this.scales.SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Border".equals(property.Name)) {
                this.setBorder(StiJsonReportObjectHelper.Deserialize.Border((JProperty)property));
                continue;
            }
            if ("Brush".equals(property.Name)) {
                this.setBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("Scales".equals(property.Name)) {
                this.scales.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (!"ShortValue".equals(property.Name)) continue;
            this.shortValue = (Boolean)property.Value;
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiGauge;
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiGauge gauge = (StiGauge)super.clone(cloneProperties);
        gauge.scales = new StiScaleCollection(gauge);
        for (StiScaleBase scale : this.scales) {
            gauge.scales.add((StiScaleBase)scale.clone());
        }
        return gauge;
    }

    public BufferedImage getImage(double zoom) {
        return this.getImage(zoom, StiExportFormat.None);
    }

    public BufferedImage getImage(double zoom, StiExportFormat format) {
        StiPainter painter = StiPainter.getPainter(this);
        return painter.getImage(this, zoom, format);
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return true;
    }

    @Override
    @StiSerializable
    public StiBorder getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(StiBorder border) {
        this.border = border;
    }

    @Override
    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    @StiSerializable
    public boolean isShortValue() {
        return this.shortValue;
    }

    public void setShortValue(boolean shortValue) {
        this.shortValue = shortValue;
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Infographics");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiGauge");
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 240L, 240L);
    }

    @Override
    public String getComponentStyle() {
        return super.getComponentStyle();
    }

    @Override
    public boolean getUseParentStyles() {
        return super.getUseParentStyles();
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public boolean getGrowToHeight() {
        return super.getGrowToHeight();
    }

    @Override
    public StiInteraction getInteraction() {
        return super.getInteraction();
    }

    public IStiGaugeStyle getStyle() {
        return this.style;
    }

    public void setStyle(IStiGaugeStyle value) {
        if (this.style != value) {
            this.style = value;
            if (value != null) {
                value.getCore().setGauge(this);
            }
        }
    }

    @StiSerializable
    public String getCustomStyleName() {
        return this.customStyleName;
    }

    public void setCustomStyleName(String customStyleName) {
        this.customStyleName = customStyleName;
    }

    @StiSerializable
    public StiScaleCollection getScales() {
        return this.scales;
    }

    public void setScales(StiScaleCollection scales) {
        this.scales = scales;
    }

    public boolean getIsAnimation() {
        return this.isAnimation;
    }

    public void setIsAnimation(boolean value) {
        this.isAnimation = value;
    }

    private void changeSkin() {
    }

    public void drawGauge(StiGaugeContextPainter context) {
        this.applyStyle(this.getStyle());
        int index = -1;
        while (++index < this.getScales().size()) {
            StiScaleBase scale = (StiScaleBase)this.getScales().get(index);
            if (scale == null) continue;
            scale.barGeometry.checkRectGeometry(context.rect);
            scale.drawElement(context);
        }
    }

    public StiComponent createNew() {
        return new StiGauge();
    }

    public void applyStyle(IStiGaugeStyle style) {
        this.brush = style.getCore().getBrush();
        this.border.setColor(style.getCore().getBorderColor());
        this.border.setSize(style.getCore().getBorderWidth());
        for (StiScaleBase scale : this.scales) {
            scale.applyStyle(style);
        }
    }

    public StiGauge() {
        this(StiRectangle.getEmpty());
    }

    public StiGauge(StiRectangle rect) {
        this.setPlaceOnToolbox(false);
    }
}

