/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.indicators;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiRotationAnimation;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiMathHelper;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiMarkerBase;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiRadialMarker
extends StiMarkerBase {
    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiRadialMarker;
    }

    @Override
    public void applyStyle(IStiGaugeStyle style) {
        if (this.isAllowApplyStyle()) {
            this.setBrush(style.getCore().getMarkerBrush());
            this.setBorderBrush(style.getCore().getMarkerBorderBrush());
            this.setBorderWidth(style.getCore().getMarkerBorderWidth());
            this.setSkin(style.getCore().getMarkerSkin());
        }
    }

    @Override
    public StiGaugeElemenType getElementType() {
        return StiGaugeElemenType.RadialElement;
    }

    @Override
    public String getLocalizeName() {
        return "RadialMarker";
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiRadialMarker();
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiRadialScale radialScale;
        StiRadialScale stiRadialScale = radialScale = this.scale instanceof StiRadialScale ? (StiRadialScale)this.scale : null;
        if (radialScale == null) {
            return;
        }
        Double valueTemp = context.gauge.getReport().getIsDesigning() ? Func.Convert.toSingle(StiParser.ParseTextValue("{" + this.getValue().getValue() + "}", context.gauge)) : this.getValueObj();
        double value = radialScale.getPosition(valueTemp);
        StiPoint centerPoint = radialScale.barGeometry.getCenter();
        double actualWidth = this.scale.barGeometry.getSize().width * this.getRelativeWidth();
        double actualHeight = this.scale.barGeometry.getSize().height * this.getRelativeHeight();
        double diameter = this.scale.barGeometry.getDiameter();
        double rest = StiMathHelper.maxMinusMin(this.scale.getStartWidth(), this.scale.getEndWidth()) * diameter * value;
        double currentRadius = this.scale.barGeometry.getRadius() - this.getOffset() * diameter;
        if (this.getPlacement() == StiPlacement.Overlay) {
            currentRadius = this.scale.getIsReversed() ? (currentRadius -= this.scale.isUp() ? (this.scale.getEndWidth() * diameter + actualWidth + rest) / 2.0 : (this.scale.getEndWidth() * diameter + actualWidth - rest) / 2.0) : (currentRadius -= this.scale.isUp() ? (this.scale.getStartWidth() * diameter + actualWidth + rest) / 2.0 : (this.scale.getStartWidth() * diameter + actualWidth - rest) / 2.0);
        } else if (this.getPlacement() == StiPlacement.Inside) {
            currentRadius = this.scale.getIsReversed() ? (currentRadius -= this.scale.isUp() ? this.scale.getEndWidth() * diameter + actualWidth - rest : this.scale.getEndWidth() * diameter + actualWidth + rest) : (currentRadius -= this.scale.isUp() ? this.scale.getStartWidth() * diameter + actualWidth - rest : this.scale.getStartWidth() * diameter + actualWidth + rest);
        }
        StiRectangle rect = new StiRectangle(currentRadius + centerPoint.x, centerPoint.y - actualHeight / 2.0, actualWidth, actualHeight);
        double angle = radialScale.getStartAngle() + radialScale.GetSweepAngle() * value;
        double rotationAngle = radialScale.getStartAngle() - angle;
        this.setAnimation((StiAnimation)new StiRotationAnimation(rotationAngle, 0.0, centerPoint, Integer.valueOf(StiGaugeHelper.GlobalDurationElement), Integer.valueOf(0)));
        StiGaugeElementSkin skin = this.getActualSkin();
        skin.draw(context, this, rect, angle, centerPoint);
    }

    @Override
    protected void interactiveClick(StiRectangle rect, StiPoint p) {
        throw new RuntimeException("NotImplemented");
    }
}

