/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.indicators;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.report.infographics.gauge.StiMarkerSkin;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeSkinHelper;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiIndicatorBase;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.painters.context.gauge.IStiGaugeMarker;

public abstract class StiMarkerBase
extends StiIndicatorBase
implements IStiGaugeMarker {
    private double offset = 0.0;
    private double relativeWidth = 0.05f;
    private double relativeHeight = 0.05;
    private StiMarkerSkin skin = StiMarkerSkin.Diamond;
    private StiGaugeElementSkin customSkin = null;
    private String format = "{0:F0}";
    private boolean showValue = false;
    private StiBrush textBrush = new StiSolidBrush(StiColorEnum.DimGray.color());
    private StiFont font = new StiFont("Arial", 7.0);

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Offset", this.offset, 0.0);
        jObject.AddPropertyFloat("RelativeWidth", this.relativeWidth, (double)0.05f);
        jObject.AddPropertyFloat("RelativeHeight", this.relativeHeight, (double)0.05f);
        jObject.AddPropertyEnum("Skin", (Enum)this.skin);
        jObject.AddPropertyString("Format", this.format);
        jObject.AddPropertyBool("ShowValue", this.showValue, false);
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.textBrush));
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.font((StiFont)this.font, (String)"Arial", (float)7.0f));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Offset".equals(property.Name)) {
                this.setOffset(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if ("RelativeWidth".equals(property.Name)) {
                this.setRelativeWidth(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if ("RelativeHeight".equals(property.Name)) {
                this.setRelativeHeight(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if ("Skin".equals(property.Name)) {
                this.setSkin(StiMarkerSkin.valueOf(property.Value.toString()));
                continue;
            }
            if ("Format".equals(property.Name)) {
                this.setFormat(property.Value.toString());
                continue;
            }
            if ("ShowValue".equals(property.Name)) {
                this.setShowValue(Boolean.parseBoolean(property.Value.toString()));
                continue;
            }
            if ("TextBrush".equals(property.Name)) {
                this.setTextBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if (!"Font".equals(property.Name)) continue;
            this.setFont(StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font));
        }
    }

    @Override
    public Object clone() {
        StiMarkerBase indicator = (StiMarkerBase)super.clone();
        indicator.textBrush = (StiBrush)this.textBrush.clone();
        indicator.customSkin = this.customSkin;
        indicator.font = this.font != null ? (StiFont)this.font.clone() : null;
        indicator.format = this.format;
        indicator.offset = this.offset;
        indicator.relativeHeight = this.relativeHeight;
        indicator.relativeWidth = this.relativeWidth;
        indicator.showValue = this.showValue;
        indicator.skin = this.skin;
        indicator.textBrush = this.textBrush != null ? (StiBrush)this.textBrush.clone() : null;
        return indicator;
    }

    @StiSerializable
    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    @StiSerializable
    public double getRelativeWidth() {
        return this.relativeWidth;
    }

    public void setRelativeWidth(double relativeWidth) {
        this.relativeWidth = relativeWidth;
    }

    @StiSerializable
    public double getRelativeHeight() {
        return this.relativeHeight;
    }

    public void setRelativeHeight(double relativeHeight) {
        this.relativeHeight = relativeHeight;
    }

    @StiSerializable
    public StiMarkerSkin getSkin() {
        return this.skin;
    }

    public void setSkin(StiMarkerSkin skin) {
        this.skin = skin;
    }

    @StiSerializable
    public StiGaugeElementSkin getCustomSkin() {
        return this.customSkin;
    }

    public void setCustomSkin(StiGaugeElementSkin customSkin) {
        this.customSkin = customSkin;
    }

    @Override
    @StiSerializable
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    @StiSerializable
    public boolean isShowValue() {
        return this.showValue;
    }

    @Override
    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
    }

    @Override
    @StiSerializable
    public StiBrush getTextBrush() {
        return this.textBrush;
    }

    @Override
    public void setTextBrush(StiBrush textBrush) {
        this.textBrush = textBrush;
    }

    @Override
    @StiSerializable
    public StiFont getFont() {
        return this.font;
    }

    @Override
    public void setFont(StiFont font) {
        this.font = font;
    }

    protected StiGaugeElementSkin getActualSkin() {
        return this.customSkin != null ? this.customSkin : StiGaugeSkinHelper.getMarkerSkin(this.skin);
    }
}

