/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.tick;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.gauge.helpers.StiTickLabelHelper;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiLabelRotationMode;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.StiRadialPosition;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiTickLabelBase;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class StiRadialTickLabelBase
extends StiTickLabelBase {
    private StiLabelRotationMode labelRotationMode = StiLabelRotationMode.None;
    private double offsetAngle = 0.0;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("OffsetAngle", this.offsetAngle, 0.0);
        jObject.AddPropertyEnum("LabelRotationMode", (Enum)this.labelRotationMode);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("OffsetAngle".equals(property.Name)) {
                this.setOffsetAngle((Double)property.Value);
                continue;
            }
            if (!"LabelRotationMode".equals(property.Name)) continue;
            this.setLabelRotationMode(StiLabelRotationMode.valueOf(property.Value.toString()));
        }
    }

    @StiSerializable
    public StiLabelRotationMode getLabelRotationMode() {
        return this.labelRotationMode;
    }

    public void setLabelRotationMode(StiLabelRotationMode labelRotationMode) {
        this.labelRotationMode = labelRotationMode;
    }

    @StiSerializable
    public double getOffsetAngle() {
        return this.offsetAngle;
    }

    @Override
    public Object clone() {
        StiRadialTickLabelBase tick = (StiRadialTickLabelBase)super.clone();
        tick.offsetAngle = this.offsetAngle;
        return tick;
    }

    public void setOffsetAngle(double offsetAngle) {
        this.offsetAngle = offsetAngle;
    }

    @Override
    public StiGaugeElemenType getElementType() {
        return StiGaugeElemenType.RadialElement;
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiRadialScale radialScale;
        StiRadialScale stiRadialScale = radialScale = this.scale instanceof StiRadialScale ? (StiRadialScale)this.scale : null;
        if (radialScale == null) {
            return;
        }
        StiRectangle rect = this.scale.barGeometry.getRectGeometry();
        if (rect.width <= 0.0 || rect.height <= 0.0) {
            return;
        }
        TreeMap<Double, Double> collection = this.getPointCollection();
        if (collection.size() == 0) {
            return;
        }
        Map<Double, String> collectionPrepare = StiTickLabelHelper.getLabels(collection);
        String textFormat = this.getTextFormat();
        double startValue = this.scale.scaleHelper.ActualMinimum;
        double endValue = this.scale.scaleHelper.ActualMaximum;
        StiPoint centerPoint = radialScale.barGeometry.getCenter();
        double radiusMain = this.scale.barGeometry.getRadius();
        double diameterMain = this.scale.barGeometry.getDiameter();
        double sweepAngle = radialScale.GetSweepAngle();
        double startAngle = radialScale.getStartAngle();
        double maxWidth = this.scale.scaleHelper.MaxWidth;
        double minWidth = this.scale.scaleHelper.MinWidth;
        double restWidth = (maxWidth *= diameterMain) - (minWidth *= diameterMain);
        double actualRadius = this.getPlacement() == StiPlacement.Outside ? radiusMain * (1.0 + this.getOffset()) : radiusMain * (1.0 - this.getOffset());
        double[] skipValues = super.getSkipValuesObj();
        double[] skipIndices = super.getSkipIndicesObj();
        int index = -1;
        Iterator i$ = collection.keySet().iterator();
        while (i$.hasNext()) {
            double key = (Double)i$.next();
            if (key < startValue || key > endValue || this.checkTickValue(skipValues, skipIndices, key, ++index) || this.getMinimumValue() != null && key < this.getMinimumValue() || this.getMaximumValue() != null && key > this.getMaximumValue()) continue;
            String text = StiValidationUtil.isNullOrEmpty((String)textFormat) && this.scale.gauge.isShortValue() ? collectionPrepare.get(key) : this.getTextForRender(key, textFormat);
            StiFont zoomFont = StiGaugeContextPainter.changeFontSize(this.getFont(), context.zoom);
            StiSize textSize = context.measureString(text, zoomFont);
            double angle = this.scale.getIsReversed() ? startAngle + sweepAngle - (Double)collection.get(key) * sweepAngle + this.getOffsetAngle() : startAngle + (Double)collection.get(key) * sweepAngle - this.getOffsetAngle();
            StiPoint point = new StiPoint();
            int countMatrix = 0;
            if (this.getPlacement() == StiPlacement.Outside) {
                StiRefObject pointRef = new StiRefObject((Object)point);
                countMatrix = this.getMatrixRotation(context, centerPoint, textSize, this.getLabelRotationMode(), actualRadius, angle, (StiRefObject<StiPoint>)pointRef);
                point = (StiPoint)pointRef.argvalue;
            } else {
                double radius = this.getPlacement() == StiPlacement.Overlay ? (this.scale.isUp() ? actualRadius - (minWidth + restWidth * (Double)collection.get(key)) / 2.0 - textSize.getWidth() / 2.0 : actualRadius - (maxWidth - restWidth * (Double)collection.get(key)) / 2.0 - textSize.getWidth() / 2.0) : (this.scale.isUp() ? actualRadius - minWidth - restWidth * (Double)collection.get(key) - textSize.getWidth() : actualRadius - maxWidth + restWidth * (Double)collection.get(key) - textSize.getWidth());
                StiRefObject pointRef = new StiRefObject((Object)point);
                countMatrix = this.getMatrixRotation(context, centerPoint, textSize, this.getLabelRotationMode(), radius, angle, (StiRefObject<StiPoint>)pointRef);
                point = (StiPoint)pointRef.argvalue;
            }
            context.addTextGaugeGeom(text, zoomFont, this.getTextBrush(), new StiRectangle(point, textSize), null);
            int index1 = -1;
            while (++index1 < countMatrix) {
                context.addPopTranformGaugeGeom();
            }
        }
    }

    protected int getMatrixRotation(StiGaugeContextPainter context, StiPoint centerPoint, StiSize textSize, StiLabelRotationMode rotateMode, double radius, double angle, StiRefObject<StiPoint> position) {
        double angle1 = 0.0;
        if (rotateMode == StiLabelRotationMode.Automatic) {
            switch (this.getRadialPosition(angle)) {
                case TopCenter: 
                case TopRight: 
                case TopLeft: {
                    angle1 = 90.0;
                    break;
                }
                case BottomRight: 
                case LeftCenter: 
                case BottonLeft: {
                    angle1 = -90.0;
                    break;
                }
                case BottomCenter: {
                    angle1 = -angle;
                    break;
                }
                case RightCenter: {
                    angle1 = -angle - 90.0;
                }
            }
        } else if (rotateMode == StiLabelRotationMode.None) {
            angle1 = -angle;
        } else if (rotateMode == StiLabelRotationMode.SurroundIn) {
            switch (this.getRadialPosition(angle)) {
                case TopCenter: {
                    angle1 = -angle - 180.0;
                    break;
                }
                default: {
                    angle1 = -90.0;
                    break;
                }
            }
        } else {
            angle1 = 90.0;
        }
        position.argvalue = new StiPoint(centerPoint.x + radius, centerPoint.y - textSize.height / 2.0);
        int countMatrix = 0;
        if (angle != 0.0) {
            context.addPushMatrixGaugeGeom(angle, centerPoint);
            ++countMatrix;
        }
        if (angle1 != 0.0) {
            context.addPushMatrixGaugeGeom(angle1, new StiPoint(((StiPoint)position.argvalue).x + textSize.getWidth() / 2.0, ((StiPoint)position.argvalue).y + textSize.height / 2.0));
            ++countMatrix;
        }
        return countMatrix;
    }

    private StiRadialPosition getRadialPosition(double angle) {
        angle += 90.0;
        while (angle > 360.0) {
            angle -= 360.0;
        }
        if (angle == 0.0 || angle == 360.0) {
            return StiRadialPosition.TopCenter;
        }
        if (angle > 0.0 && angle < 90.0) {
            return StiRadialPosition.TopRight;
        }
        if (angle == 90.0) {
            return StiRadialPosition.RightCenter;
        }
        if (angle > 90.0 && angle < 180.0) {
            return StiRadialPosition.BottomRight;
        }
        if (angle == 180.0) {
            return StiRadialPosition.BottomCenter;
        }
        if (angle > 180.0 && angle < 270.0) {
            return StiRadialPosition.BottonLeft;
        }
        if (angle == 270.0) {
            return StiRadialPosition.LeftCenter;
        }
        return StiRadialPosition.TopLeft;
    }
}

