/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.tick;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiTickMarkBase;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import java.util.TreeMap;

public class StiRadialTickMarkBase
extends StiTickMarkBase {
    private double offsetAngle = 0.0;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("OffsetAngle", this.offsetAngle, 0.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!"OffsetAngle".equals(property.Name)) continue;
            this.setOffsetAngle((Double)property.Value);
        }
    }

    @Override
    public Object clone() {
        StiRadialTickMarkBase tick = (StiRadialTickMarkBase)super.clone();
        tick.offsetAngle = this.offsetAngle;
        return tick;
    }

    @StiSerializable
    public double getOffsetAngle() {
        return this.offsetAngle;
    }

    public void setOffsetAngle(double offsetAngle) {
        this.offsetAngle = offsetAngle;
    }

    @Override
    public StiGaugeElemenType getElementType() {
        return StiGaugeElemenType.RadialElement;
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiRadialScale radialScale;
        StiRadialScale stiRadialScale = radialScale = this.scale instanceof StiRadialScale ? (StiRadialScale)this.scale : null;
        if (radialScale == null) {
            return;
        }
        StiRectangle rect = this.scale.barGeometry.getRectGeometry();
        if (rect.width <= 0.0 || rect.height <= 0.0) {
            return;
        }
        TreeMap<Double, Double> collection = this.getPointCollection();
        if (collection.size() == 0) {
            return;
        }
        double[] skipValues = super.getSkipValuesObj();
        double[] skipIndices = super.getSkipIndicesObj();
        StiGaugeElementSkin skin = this.getActualSkin();
        StiPoint centerPoint = radialScale.barGeometry.getCenter();
        double sweepAngle = radialScale.GetSweepAngle();
        double startAngle = radialScale.getStartAngle();
        double startValue = this.scale.scaleHelper.ActualMinimum;
        double endValue = this.scale.scaleHelper.ActualMaximum;
        double diameter = this.scale.barGeometry.getDiameter();
        double radius = this.scale.barGeometry.getRadius();
        double minWidth = this.scale.scaleHelper.MinWidth;
        double maxWidth = this.scale.scaleHelper.MaxWidth;
        double restWidth = (maxWidth *= this.scale.barGeometry.getRectGeometry().width) - (minWidth *= this.scale.barGeometry.getRectGeometry().width);
        radius = this.getPlacement() == StiPlacement.Outside ? radius * (1.0 + this.getOffset()) : radius * (1.0 - this.getOffset());
        double tickWidth = diameter * this.getRelativeWidth();
        double tickHeight = diameter * this.getRelativeHeight();
        int index = -1;
        for (Double key : collection.keySet()) {
            if (key < startValue || key > endValue || this.checkTickValue(skipValues, skipIndices, key, ++index) || this.getMinimumValue() != null && key < this.getMinimumValue() || this.getMaximumValue() != null && key > this.getMaximumValue()) continue;
            double angle = this.scale.getIsReversed() ? startAngle + sweepAngle - collection.get(key) * sweepAngle + this.offsetAngle : startAngle + collection.get(key) * sweepAngle + this.getOffsetAngle();
            double currentRadius = 0.0;
            currentRadius = this.getPlacement() == StiPlacement.Outside ? radius : (this.getPlacement() == StiPlacement.Overlay ? (this.scale.isUp() ? radius - (minWidth + restWidth * collection.get(key) + tickWidth) / 2.0 : radius - (maxWidth - restWidth * collection.get(key) + tickWidth) / 2.0) : (this.scale.isUp() ? radius - minWidth - restWidth * collection.get(key) - tickWidth : radius - maxWidth + restWidth * collection.get(key) - tickWidth));
            StiRectangle tickRect = new StiRectangle(centerPoint.x + currentRadius, centerPoint.y, tickWidth, tickHeight);
            context.addPushMatrixGaugeGeom(angle, centerPoint);
            skin.draw(context, this, tickRect);
            context.addPopTranformGaugeGeom();
        }
    }
}

