/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.styles.view;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiStyleElements;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.infographics.gauge.styles.core.StiCustomGaugeStyleCoreXF;
import com.stimulsoft.report.infographics.gauge.styles.core.StiGaugeStyleCoreXF;
import com.stimulsoft.report.infographics.gauge.styles.view.StiCustomGaugeStyle;
import com.stimulsoft.report.styles.StiBaseStyle;

public abstract class StiGaugeStyleXF
extends StiBaseStyle
implements IStiGaugeStyle {
    private StiGaugeStyleCoreXF core;

    public StiComponentId getComponentId() {
        return StiComponentId.StiGaugeStyle;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyStringNullOfEmpty("Ident", this.getClass().getName());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) {
    }

    public static StiGaugeStyleXF LoadFromJsonObjectInternal(JSONObject jObject) throws JSONException {
        String ident = null;
        for (JProperty prop : jObject.Properties()) {
            if (!"Ident".equals(prop.Name)) continue;
            ident = prop.Value.toString();
        }
        if ("StiGaugeStyleXF".equals(ident)) {
            return new StiCustomGaugeStyle();
        }
        StiGaugeStyleXF service = null;
        for (StiGaugeStyleXF style : StiOptions.Services.getGaugeStyles()) {
            String name = style.getClass().getName();
            if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
            service = style;
        }
        if (service == null) {
            throw new RuntimeException(String.format("Type %s is not found!", ident));
        }
        return service.createNew();
    }

    public String getServiceName() {
        return this.core.getLocalizedName();
    }

    public String getServiceCategory() {
        return "Gauge";
    }

    public Class getServiceType() {
        return StiGaugeStyleXF.class;
    }

    @Override
    public StiGaugeStyleCoreXF getCore() {
        return this.core;
    }

    @Override
    public void setCore(StiGaugeStyleCoreXF core) {
        this.core = core;
    }

    @Override
    public String toString() {
        if (this instanceof StiCustomGaugeStyle && ((StiCustomGaugeStyleCoreXF)this.getCore()).reportGaugeStyle != null) {
            return ((StiCustomGaugeStyleCoreXF)this.core).reportGaugeStyle.getName();
        }
        return this.getServiceName();
    }

    public boolean compareGaugeStyle(StiGaugeStyleXF style) {
        StiCustomGaugeStyle style2;
        if (style == null) {
            return false;
        }
        StiCustomGaugeStyle style1 = this instanceof StiCustomGaugeStyle ? (StiCustomGaugeStyle)this : null;
        StiCustomGaugeStyle stiCustomGaugeStyle = style2 = style instanceof StiCustomGaugeStyle ? (StiCustomGaugeStyle)style : null;
        if (style1 != null && style2 != null) {
            String styleName1 = ((StiCustomGaugeStyleCoreXF)style1.getCore()).getReportStyleName();
            if (((StiCustomGaugeStyleCoreXF)style1.getCore()).getReportStyle() != null) {
                styleName1 = ((StiCustomGaugeStyleCoreXF)style1.getCore()).getReportStyle().getName();
            }
            String styleName2 = ((StiCustomGaugeStyleCoreXF)style2.getCore()).getReportStyleName();
            if (((StiCustomGaugeStyleCoreXF)style2.getCore()).getReportStyle() != null) {
                styleName2 = ((StiCustomGaugeStyleCoreXF)style2.getCore()).getReportStyle().getName();
            }
            return StiValidationUtil.equals((Object)styleName1, (Object)styleName2);
        }
        return this.getClass().equals(style.getClass());
    }

    @Override
    public void GetStyleFromComponent(StiComponent component, StiStyleElements styleElements) {
    }

    @Override
    public void SetStyleToComponent(StiComponent component) {
    }

    public StiGaugeStyleXF createNew() {
        throw new RuntimeException("Not implemented");
    }
}

