/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.tick.radial.label;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.events.StiGetValueEvent;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.events.StiGetValueEventHandler;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiLabelRotationMode;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.collections.StiCustomValuesCollection;
import com.stimulsoft.report.infographics.gauge.expressions.StiTextExpression;
import com.stimulsoft.report.infographics.gauge.expressions.StiValueExpression;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.interfaces.IStiTickCustom;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiRadialTickLabelBase;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.infographics.gauge.tick.StiCustomValueBase;
import com.stimulsoft.report.infographics.gauge.tick.radial.label.StiRadialTickLabelCustomValue;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiRadialTickLabelCustom
extends StiRadialTickLabelBase
implements IStiTickCustom {
    private double valueObj = 0.0;
    private String textObj = null;
    private StiCustomValuesCollection values = new StiCustomValuesCollection();
    public StiGetValueEventHandler getValue;
    private StiGetValueEvent getValueEvent = new StiGetValueEvent();
    private StiValueExpression value = new StiValueExpression();
    private StiTextExpression text = new StiTextExpression();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyJObject("GetValueEvent", this.getValueEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Value", this.value.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Text", this.text.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Values", this.values.SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("GetValueEvent".equals(property.Name)) {
                StiGetValueEvent _getValueEvent = new StiGetValueEvent();
                _getValueEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getValueEvent = _getValueEvent;
                continue;
            }
            if ("GetTextEvent".equals(property.Name)) continue;
            if ("Value".equals(property.Name)) {
                StiValueExpression _valueObj = new StiValueExpression();
                _valueObj.LoadFromJsonObject((JSONObject)property.Value);
                this.setValue(_valueObj);
                continue;
            }
            if ("Text".equals(property.Name)) {
                StiTextExpression _textObj = new StiTextExpression();
                _textObj.LoadFromJsonObject((JSONObject)property.Value);
                this.setText(_textObj);
                continue;
            }
            if (!"Values".equals(property.Name)) continue;
            this.values.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiRadialTickLabelCustom;
    }

    @Override
    public Object clone() {
        StiRadialTickLabelCustom radialTickLabel = (StiRadialTickLabelCustom)super.clone();
        radialTickLabel.value = this.value != null ? (StiValueExpression)this.value.clone() : null;
        radialTickLabel.text = this.text != null ? (StiTextExpression)this.text.clone() : null;
        radialTickLabel.values = new StiCustomValuesCollection();
        for (StiCustomValueBase customValue : this.values) {
            radialTickLabel.values.add((StiCustomValueBase)customValue.clone());
        }
        return radialTickLabel;
    }

    @Override
    @StiSerializable
    public double getValueObj() {
        return this.valueObj;
    }

    @Override
    public void setValueObj(double valueObj) {
        this.valueObj = valueObj;
    }

    @StiSerializable
    public String getTextObj() {
        return this.textObj;
    }

    public void setTextObj(String textObj) {
        this.textObj = textObj;
    }

    @Override
    @StiSerializable
    public StiCustomValuesCollection getValues() {
        return this.values;
    }

    @Override
    public void setValues(StiCustomValuesCollection values) {
        this.values = values;
    }

    @Override
    public StiGaugeElemenType getElementType() {
        return StiGaugeElemenType.RadialElement;
    }

    @Override
    public String getLocalizeName() {
        return "RadialTickLabelCustom";
    }

    protected void onGetValue(StiGetValueEventArgs e) {
    }

    public void invokeGetValue(StiGaugeElement sender, StiGetValueEventArgs e) {
        try {
            this.onGetValue(e);
            Object parserResult = StiParser.ParseTextValue(this.value.getValue(), sender.getScale().getGauge());
            e.setValue(sender.getScale().getGauge().getReport().ToString(parserResult));
        }
        catch (Exception ex) {
            String str = String.format("Expression in GetValue property of '%s' series from '%s' chart can't be evaluated!", "Indicator", this.scale.gauge.getName());
            this.scale.gauge.getReport().WriteToReportRenderingMessages(str);
            ex.printStackTrace();
        }
    }

    @StiSerializable
    public StiGetValueEvent getGetValueEvent() {
        return this.getValueEvent;
    }

    public void setGetValueEvent(StiGetValueEvent getValueEvent) {
        this.getValueEvent = getValueEvent;
    }

    @StiSerializable
    public StiValueExpression getValue() {
        return this.value;
    }

    public void setValue(StiValueExpression value) {
        this.value = value;
    }

    @StiSerializable
    public StiTextExpression getText() {
        return this.text;
    }

    public void setText(StiTextExpression text) {
        this.text = text;
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiRadialTickLabelCustom();
    }

    @Override
    public void prepareGaugeElement() {
        super.prepareGaugeElement();
        StiGetValueEventArgs e1 = new StiGetValueEventArgs();
        this.invokeGetValue(this, e1);
        this.setValueObj(StiGaugeHelper.getFloatValueFromObject((Object)e1.getValue(), 0.0));
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiRadialScale radialScale;
        StiRadialScale stiRadialScale = radialScale = this.scale instanceof StiRadialScale ? (StiRadialScale)this.scale : null;
        if (radialScale == null) {
            return;
        }
        StiRectangle rect = this.scale.barGeometry.getRectGeometry();
        if (rect.width <= 0.0 || rect.height <= 0.0) {
            return;
        }
        StiPoint centerPoint = radialScale.barGeometry.getCenter();
        double radiusMain = this.scale.barGeometry.getRadius();
        double sweepAngle = radialScale.GetSweepAngle();
        double startAngle = radialScale.getStartAngle();
        double startValue = this.scale.scaleHelper.ActualMinimum;
        double endValue = this.scale.scaleHelper.ActualMaximum;
        double maxWidth = this.scale.scaleHelper.MaxWidth;
        double minWidth = this.scale.scaleHelper.MinWidth;
        double restWidth = (maxWidth *= radiusMain * 2.0) - (minWidth *= radiusMain * 2.0);
        String textFormat = super.getTextFormat();
        double[] skipValues = super.getSkipValuesObj();
        double[] skipIndices = super.getSkipIndicesObj();
        StiCustomValuesCollection values = this.getValues();
        if (values == null || values.size() == 0) {
            values = new StiCustomValuesCollection();
            values.add(new StiRadialTickLabelCustomValue(this.getValueObj(), this.getTextObj(), this.getOffset(), this.getOffsetAngle(), this.getLabelRotationMode(), this.getPlacement()));
        }
        StiFont zoomFont = StiGaugeContextPainter.changeFontSize(this.getFont(), context.zoom);
        int index = -1;
        for (StiCustomValueBase kk : values) {
            StiRadialTickLabelCustomValue key = (StiRadialTickLabelCustomValue)kk;
            if (key.getValue() < startValue || key.getValue() > endValue || this.checkTickValue(skipValues, skipIndices, key.getValue(), ++index) || this.getMinimumValue() != null && key.getValue() < this.getMinimumValue() || this.getMaximumValue() != null && key.getValue() > this.getMaximumValue()) continue;
            double value1 = this.scale.getPosition(key.getValue());
            String text1 = StiValidationUtil.isNullOrEmpty((String)key.getText()) ? "" : this.getTextForRender(key.getText(), textFormat);
            double actualRadius = this.getPlacement(key.getPlacement()) == StiPlacement.Outside ? radiusMain * (1.0 + this.getOffset(key.getOffset())) : radiusMain * (1.0 - this.getOffset(key.getOffset()));
            String text = this.getTextForRender(text1, textFormat);
            StiSize textSize = context.measureString(text, zoomFont);
            double angle = this.scale.getIsReversed() ? startAngle + sweepAngle - value1 * sweepAngle + this.getOffsetAngle(key.getOffsetAngle()) : startAngle + value1 * sweepAngle - this.getOffsetAngle(key.getOffsetAngle());
            int countMatrix = 0;
            StiRefObject point = new StiRefObject((Object)new StiPoint());
            if (this.getPlacement(key.getPlacement()) == StiPlacement.Outside) {
                countMatrix = this.getMatrixRotation(context, centerPoint, textSize, this.getLabelRotationMode(key.getLabelRotationMode()), actualRadius, angle, (StiRefObject<StiPoint>)point);
            } else if (this.getPlacement(key.getPlacement()) == StiPlacement.Overlay) {
                double radius = this.scale.isUp() ? actualRadius - (minWidth + restWidth * value1) / 2.0 - textSize.width / 2.0 : actualRadius - (maxWidth - restWidth * value1) / 2.0 - textSize.width / 2.0;
                countMatrix = this.getMatrixRotation(context, centerPoint, textSize, this.getLabelRotationMode(key.getLabelRotationMode()), radius, angle, (StiRefObject<StiPoint>)point);
            } else {
                double radius = 0.0;
                radius = this.scale.isUp() ? actualRadius - minWidth - restWidth * value1 - textSize.width : actualRadius - maxWidth + restWidth * value1 - textSize.width;
                countMatrix = this.getMatrixRotation(context, centerPoint, textSize, this.getLabelRotationMode(key.getLabelRotationMode()), radius, angle, (StiRefObject<StiPoint>)point);
            }
            context.addTextGaugeGeom(text, zoomFont, this.getTextBrush(), new StiRectangle((StiPoint)point.argvalue, textSize), null);
            for (int index1 = 0; index1 < countMatrix; ++index1) {
                context.addPopTranformGaugeGeom();
            }
        }
    }

    private double getOffsetAngle(Double value) {
        return value == null ? this.getOffsetAngle() : value.doubleValue();
    }

    private StiLabelRotationMode getLabelRotationMode(StiLabelRotationMode value) {
        return value == null ? this.getLabelRotationMode() : value;
    }
}

