/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.json;

import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiJsonToDataSetConverter;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.json.datahelp.StiJsonMetaData;
import com.stimulsoft.report.json.datahelp.StiJsonRelationData;
import com.stimulsoft.report.json.datahelp.StiJsonRelationIdData;
import com.stimulsoft.report.utils.data.StiDataColumnsUtil;
import com.stimulsoft.report.utils.data.StiSqlField;
import com.stimulsoft.report.utils.data.StiXmlTable;
import com.stimulsoft.report.utils.data.StiXmlTableFieldsRequest;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class StiJsonToDataSetConverterV2 {
    public static DataSet getDataSet(Object json) throws JSONException {
        ArrayList<StiJsonMetaData> table;
        json = StiJsonToDataSetConverterV2.correctJson(json);
        ArrayList<StiJsonMetaData> collections = new ArrayList<StiJsonMetaData>();
        DataSet dataSet = new DataSet();
        Hashtable<Object, StiJsonRelationIdData> tags = new Hashtable<Object, StiJsonRelationIdData>();
        StiJsonToDataSetConverterV2.fillCollection(collections, "", "", "", json, true, tags);
        Hashtable addresses = new Hashtable();
        Hashtable tables = new Hashtable();
        Hashtable<String, StiJsonRelationData> relations = new Hashtable<String, StiJsonRelationData>();
        ArrayList<StiDataColumn> allRelationsColumn = new ArrayList<StiDataColumn>();
        for (StiJsonMetaData collection : collections) {
            if (collection == null) continue;
            table = (ArrayList<StiJsonMetaData>)tables.get(collection.getCast());
            if (table == null) {
                table = new ArrayList<StiJsonMetaData>();
            }
            addresses.put(collection.getAddress(), table);
            table.add(collection);
            tables.put(collection.getCast(), table);
        }
        for (StiJsonMetaData cast : tables.keySet()) {
            table = (List)tables.get(cast);
            for (StiJsonMetaData item : table) {
                String tableName = item.getCollectionName();
                DataTable dataTable = dataSet.getTables().get(tableName);
                if (dataTable == null) {
                    dataTable = new DataTable(tableName);
                    dataSet.getTables().add(dataTable);
                }
                DataRow dataRow = dataTable.NewRow();
                boolean first = true;
                JSONArray names = ((JSONObject)item.getObject()).names();
                for (int i = 0; i < names.length(); ++i) {
                    Object columnValue;
                    Object itemObject = ((JSONObject)item.getObject()).get(names.getString(i));
                    String columnName = names.getString(i);
                    if (columnName == null) continue;
                    StiDataColumn dataColumn = dataTable.getColumns().get(columnName);
                    if (dataColumn == null) {
                        dataColumn = new StiDataColumn(columnName, columnName, StiSystemTypeEnum.SystemString.getSystemType());
                        dataTable.getColumns().add(dataColumn);
                    }
                    StiJsonRelationIdData dataHelp = tags.containsKey(itemObject) ? tags.get(itemObject) : null;
                    Object object = columnValue = dataHelp != null && dataHelp.getNewValue() != null ? dataHelp.getNewValue() : ((JSONObject)item.getObject()).get(names.getString(i));
                    if (first) {
                        StiJsonRelationIdData itemDataHelp;
                        first = false;
                        StiJsonRelationIdData stiJsonRelationIdData = itemDataHelp = tags.containsKey(item.getObject()) ? tags.get(item.getObject()) : null;
                        if (itemDataHelp != null && itemDataHelp.getRelationId() != null) {
                            StiDataColumn dataColumnRalationId = dataTable.getColumns().get("relationId");
                            if (dataColumnRalationId == null) {
                                dataColumnRalationId = new StiDataColumn("relationId", "relationId", StiSystemTypeEnum.SystemString.getSystemType());
                                dataTable.getColumns().add(dataColumnRalationId);
                                allRelationsColumn.add(dataColumnRalationId);
                            }
                            if (itemDataHelp.getRelationId().equals("-1")) {
                                itemDataHelp.setRelationId("0");
                                boolean done = false;
                                for (Object cast1 : tables.keySet()) {
                                    List table1 = (List)tables.get(cast1);
                                    Integer index = 0;
                                    for (StiJsonMetaData item1 : table1) {
                                        if (StiValidationUtil.equals((Object)item1.getAddress(), (Object)item.getAddress())) {
                                            itemDataHelp.setRelationId(index.toString());
                                            done = true;
                                            break;
                                        }
                                        Integer n = index;
                                        Integer n2 = index = Integer.valueOf(index + 1);
                                    }
                                    if (!done) continue;
                                    break;
                                }
                            }
                            dataRow.setValue(dataColumnRalationId.getName(), (Object)itemDataHelp.getRelationId());
                        }
                    }
                    if (columnValue.toString().indexOf("#relation#") == 0) {
                        List list;
                        dataRow.setValue(dataColumn.getName(), (Object)String.valueOf(dataTable.getRows().size()));
                        String address = columnValue.toString().replaceAll("#relation#", "");
                        if (!addresses.containsKey(address) || (list = (List)addresses.get(address)).size() <= 0) continue;
                        StiJsonRelationData dataHelpRelation = new StiJsonRelationData();
                        dataHelpRelation.setChildColumn(dataColumn);
                        dataHelpRelation.setChildTable(dataTable);
                        dataHelpRelation.setParentTableName(((StiJsonMetaData)list.get(0)).getCollectionName());
                        relations.put(dataTable.getTableName() + "." + dataColumn.getName(), dataHelpRelation);
                        continue;
                    }
                    if (columnValue instanceof JSONObject.Null) continue;
                    dataRow.setValue(dataColumn.getName(), columnValue);
                }
                dataTable.getRows().add(dataRow);
            }
        }
        for (StiJsonRelationData relation : relations.values()) {
            StiDataColumn childColumn = relation.getChildColumn();
            DataTable parentTable = dataSet.getTables().get(relation.getParentTableName());
            StiDataColumn parentColumn = parentTable.getColumns().get("relationId");
            if (parentColumn != null && childColumn == null) continue;
        }
        for (StiDataColumn deleteColumn : allRelationsColumn) {
        }
        StiJsonToDataSetConverter.checkColumnType(dataSet);
        return dataSet;
    }

    public static DataSet getDataSetFromXml(byte[] array) {
        if (array != null) {
            try {
                DataSet dataSet = new DataSet();
                StiXmlTableFieldsRequest request = StiDataColumnsUtil.parceXSDSchema(StiIOUtil.toInputStream((String)new String(array, "UTF-8")));
                for (StiXmlTable table : request.getTables()) {
                    DataTable dataTable = dataSet.getTables().get(table.getName());
                    if (dataTable == null) {
                        dataTable = new DataTable(table.getName());
                        dataSet.getTables().add(dataTable);
                    }
                    for (StiSqlField column : table.getColumns()) {
                        StiDataColumn dataColumn = dataTable.getColumns().get(column.getName());
                        if (dataColumn != null) continue;
                        dataColumn = new StiDataColumn(column.getName(), column.getName(), column.getSystemType());
                        dataTable.getColumns().add(dataColumn);
                    }
                }
                return dataSet;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static JSONObject correctJson(Object jToken) throws JSONException {
        JSONObject jContainer;
        JSONObject jSONObject = jContainer = jToken instanceof JSONObject ? (JSONObject)jToken : null;
        if (jToken instanceof JSONArray) {
            JSONObject root = new JSONObject();
            root.put("root", jToken);
            return root;
        }
        if (jContainer != null) {
            for (int index = 0; index < jContainer.names().length(); ++index) {
                Object item = jContainer.get(jContainer.names().getString(index));
                if (!(item instanceof String)) continue;
                JSONObject root = new JSONObject();
                root.put("root", jToken);
                return root;
            }
        }
        return (JSONObject)jToken;
    }

    private static String correctJsonString(String json) {
        String newJson = json;
        for (int pos = 0; pos < newJson.length(); ++pos) {
            if (newJson.charAt(pos) == '{') {
                return newJson;
            }
            if (newJson.charAt(pos) != '[') continue;
            return "{\"root\": " + newJson + "}";
        }
        return newJson;
    }

    private static void fillCollection(List<StiJsonMetaData> collections, String collectionName, String parentName, String address, Object json, boolean first, Hashtable<Object, StiJsonRelationIdData> tags) throws JSONException {
        String cast = parentName + "_" + collectionName;
        if (StiValidationUtil.isNullOrEmpty((String)parentName)) {
            cast = collectionName;
        }
        if (json instanceof JSONArray) {
            JSONArray itemJArray = (JSONArray)json;
            Integer i = 0;
            while (i < itemJArray.length()) {
                if (itemJArray.get(i.intValue()) instanceof JSONArray || itemJArray.get(i.intValue()) instanceof JSONObject) {
                    StiJsonToDataSetConverterV2.fillCollection(collections, collectionName, parentName, address + ".#array#" + i.toString(), itemJArray.get(i.intValue()), false, tags);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        } else if (json instanceof JSONObject) {
            JSONObject container = (JSONObject)json;
            for (int i = 0; i < container.names().length(); ++i) {
                JSONArray itemValueJArray;
                Object item = container.get(container.names().getString(i));
                if (!(item instanceof JSONArray) && !(item instanceof JSONObject)) continue;
                String itemName = container.names().getString(i);
                JSONArray jSONArray = itemValueJArray = item instanceof JSONArray ? (JSONArray)item : null;
                if (!first && itemValueJArray != null) {
                    Integer relationId = 0;
                    if (address.lastIndexOf("#array#") > address.lastIndexOf(".")) {
                        try {
                            relationId = Integer.parseInt(address.substring(address.lastIndexOf("#") + 1));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    for (int j = 0; j < itemValueJArray.length(); ++j) {
                        Object itemItem = itemValueJArray.get(j);
                        StiJsonToDataSetConverterV2.setRelationId(itemItem, relationId.toString(), tags);
                    }
                }
                StiJsonToDataSetConverterV2.fillCollection(collections, itemName, cast, address + "." + itemName, item, false, tags);
                boolean isSetRelation = false;
                if (itemValueJArray == null) {
                    StiJsonToDataSetConverterV2.setRelationId(item, "-1", tags);
                } else {
                    StiJsonToDataSetConverterV2.setNewValue(item, "#relation#" + address + "." + itemName + ".#array#0", tags);
                    isSetRelation = true;
                }
                if (isSetRelation || itemValueJArray != null) continue;
                StiJsonToDataSetConverterV2.setNewValue(item, "#relation#" + address + "." + itemName, tags);
            }
        }
        if (json instanceof JSONArray) {
            return;
        }
        if (!StiValidationUtil.isNullOrEmpty((String)address)) {
            if (!StiValidationUtil.isNullOrEmpty((String)parentName)) {
                collectionName = parentName + "_" + collectionName;
            }
            collections.add(new StiJsonMetaData(collectionName, address, cast, json));
        }
    }

    private static StiJsonRelationIdData setRelationId(Object tag, String relationId, Hashtable<Object, StiJsonRelationIdData> tags) {
        StiJsonRelationIdData dataHelp = tags.containsKey(tag) ? tags.get(tag) : new StiJsonRelationIdData();
        dataHelp.setRelationId(relationId);
        tags.put(tag, dataHelp);
        return dataHelp;
    }

    private static StiJsonRelationIdData setNewValue(Object tag, Object value, Hashtable<Object, StiJsonRelationIdData> tags) {
        StiJsonRelationIdData dataHelp = tags.containsKey(tag) ? tags.get(tag) : new StiJsonRelationIdData();
        dataHelp.setNewValue(value);
        tags.put(tag, dataHelp);
        return dataHelp;
    }
}

