/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.report.maps.StiMapSvg;
import com.stimulsoft.report.maps.StiMapSvgContainer;
import com.stimulsoft.report.painters.context.map.StiBezierMapGeom;
import com.stimulsoft.report.painters.context.map.StiBeziersMapGeom;
import com.stimulsoft.report.painters.context.map.StiCloseMapGeom;
import com.stimulsoft.report.painters.context.map.StiLineMapGeom;
import com.stimulsoft.report.painters.context.map.StiMapGeom;
import com.stimulsoft.report.painters.context.map.StiMapGeomsContainer;
import com.stimulsoft.report.painters.context.map.StiMapGeomsObject;
import com.stimulsoft.report.painters.context.map.StiMoveToMapGeom;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class StiMapLoader {
    private static ConcurrentHashMap<String, StiMapSvgContainer> hashMaps;

    public static StiMapSvgContainer loadResource(String resourceName) throws UnsupportedEncodingException, IOException, JSONException {
        String resourcePath;
        if (hashMaps == null) {
            hashMaps = new ConcurrentHashMap();
        }
        if (!hashMaps.containsKey(resourcePath = String.format("/maps/%s.json", resourceName))) {
            InputStream is = StiResourceUtil.getStream((String)resourcePath);
            byte[] bytesBase64 = StiIOUtil.toByteArray((InputStream)is);
            byte[] bytes = StiBase64DecoderUtil.decode((byte[])bytesBase64);
            byte[] unpacked = StiGZipHelper.unpack((byte[])bytes);
            String jsonText = new String(unpacked, "UTF-8");
            StiMapSvgContainer map = new StiMapSvgContainer();
            map.populateObject(jsonText);
            map.prepare();
            if (!hashMaps.containsKey(resourcePath)) {
                hashMaps.put(resourcePath, map);
            }
            return map;
        }
        return hashMaps.get(resourcePath);
    }

    public static StiMapGeomsContainer getGeomsObject(String resourceName) throws Exception {
        StiMapSvgContainer container = StiMapLoader.loadResource(resourceName);
        if (container == null) {
            return new StiMapGeomsContainer();
        }
        StiMapGeomsContainer result = new StiMapGeomsContainer();
        result.Width = container.width;
        result.Height = container.height;
        result.Name = container.name;
        if (container.geoms == null) {
            for (String key : container.hashPaths.keySet()) {
                StiMapSvg pt = container.hashPaths.get(key);
                StiMapGeomsObject obj = new StiMapGeomsObject();
                obj.Key = key;
                obj.Geoms = StiMapLoader.parsePath(pt.data);
                result.Geoms.add(obj);
            }
            container.geoms = result.Geoms;
        } else {
            result.Geoms = container.geoms;
        }
        return result;
    }

    private static void createGeom(StiGeomIdent ident, List<Double> values, int startIndex, int index, List<StiMapGeom> commands) throws Exception {
        switch (ident) {
            case MoveTo: {
                if (values.size() != 2) {
                    throw new Exception("");
                }
                StiMoveToMapGeom geom = new StiMoveToMapGeom();
                geom.X = StiMath.round((double)values.get(0), (int)3);
                geom.Y = StiMath.round((double)values.get(1), (int)3);
                commands.add(geom);
                break;
            }
            case Line_L: {
                if (values.size() != 2) {
                    throw new Exception("");
                }
                StiLineMapGeom geom = new StiLineMapGeom();
                geom.X = StiMath.round((double)values.get(0), (int)3);
                geom.Y = StiMath.round((double)values.get(1), (int)3);
                commands.add(geom);
                break;
            }
            case Line_l: {
                if (values.size() != 2) {
                    throw new Exception("");
                }
                StiPoint lastPos = commands.get(commands.size() - 1).getLastPoint();
                StiLineMapGeom geom = new StiLineMapGeom();
                geom.X = StiMath.round((double)(lastPos.x + values.get(0)), (int)3);
                geom.Y = StiMath.round((double)(lastPos.y + values.get(1)), (int)3);
                commands.add(geom);
                break;
            }
            case Bezier_C: {
                if (values.size() != 6) {
                    throw new Exception("");
                }
                StiBezierMapGeom geom = new StiBezierMapGeom();
                geom.X1 = StiMath.round((double)values.get(0), (int)3);
                geom.Y1 = StiMath.round((double)values.get(1), (int)3);
                geom.X2 = StiMath.round((double)values.get(2), (int)3);
                geom.Y2 = StiMath.round((double)values.get(3), (int)3);
                geom.X3 = StiMath.round((double)values.get(4), (int)3);
                geom.Y3 = StiMath.round((double)values.get(5), (int)3);
                commands.add(geom);
                break;
            }
            case Bezier_c: {
                if (values.size() != 6) {
                    throw new Exception("");
                }
                StiPoint lastPos = commands.get(commands.size() - 1).getLastPoint();
                StiBezierMapGeom geom = new StiBezierMapGeom();
                geom.X0 = StiMath.round((double)lastPos.x, (int)3);
                geom.Y0 = StiMath.round((double)lastPos.y, (int)3);
                geom.X1 = StiMath.round((double)(lastPos.x + values.get(0)), (int)3);
                geom.Y1 = StiMath.round((double)(lastPos.y + values.get(1)), (int)3);
                geom.X2 = StiMath.round((double)(lastPos.x + values.get(2)), (int)3);
                geom.Y2 = StiMath.round((double)(lastPos.y + values.get(3)), (int)3);
                geom.X3 = StiMath.round((double)(lastPos.x + values.get(4)), (int)3);
                geom.Y3 = StiMath.round((double)(lastPos.y + values.get(5)), (int)3);
                commands.add(geom);
                break;
            }
            case VerticalLineto_V: {
                if (values.size() != 1) {
                    throw new Exception("");
                }
                StiPoint lastPoint = commands.get(commands.size() - 1).getLastPoint();
                StiLineMapGeom geom = new StiLineMapGeom();
                geom.X = StiMath.round((double)lastPoint.x, (int)3);
                geom.Y = StiMath.round((double)values.get(0), (int)3);
                commands.add(geom);
                break;
            }
            case VerticalLineto_v: {
                if (values.size() != 1) {
                    throw new Exception("");
                }
                StiPoint lastPoint = commands.get(commands.size() - 1).getLastPoint();
                StiLineMapGeom geom = new StiLineMapGeom();
                geom.X = StiMath.round((double)lastPoint.x, (int)3);
                geom.Y = StiMath.round((double)(lastPoint.y + values.get(0)), (int)3);
                commands.add(geom);
                break;
            }
            case HorizontalLineto_H: {
                if (values.size() != 1) {
                    throw new Exception("");
                }
                StiPoint lastPoint = commands.get(commands.size() - 1).getLastPoint();
                StiLineMapGeom geom = new StiLineMapGeom();
                geom.X = StiMath.round((double)values.get(0), (int)3);
                geom.Y = StiMath.round((double)lastPoint.y, (int)3);
                commands.add(geom);
                break;
            }
            case HorizontalLineto_h: {
                if (values.size() != 1) {
                    throw new Exception("");
                }
                StiPoint lastPoint = commands.get(commands.size() - 1).getLastPoint();
                StiLineMapGeom geom = new StiLineMapGeom();
                geom.X = StiMath.round((double)(lastPoint.x + values.get(0)), (int)3);
                geom.Y = StiMath.round((double)lastPoint.y, (int)3);
                commands.add(geom);
                break;
            }
            case Beziers_S: {
                if (values.size() < 6) {
                    throw new Exception("");
                }
                ArrayList<Double> list = new ArrayList<Double>();
                for (Double value : values) {
                    list.add(StiMath.round((double)value, (int)3));
                }
                StiBeziersMapGeom geom = new StiBeziersMapGeom();
                geom.Array = list.toArray(new Double[0]);
                commands.add(geom);
                break;
            }
            case Beziers_s: {
                if (values.size() < 6) {
                    throw new Exception("");
                }
                StiPoint lastPoint = commands.get(commands.size() - 1).getLastPoint();
                lastPoint.x += values.get(4).doubleValue();
                lastPoint.y += values.get(5).doubleValue();
                boolean state = true;
                ArrayList<Double> list = new ArrayList<Double>();
                for (double value : values) {
                    double newValue = state ? value + lastPoint.x : value + lastPoint.y;
                    list.add(StiMath.round((double)newValue, (int)3));
                    state = !state;
                }
                StiBeziersMapGeom geom = new StiBeziersMapGeom();
                geom.Array = list.toArray(new Double[0]);
                commands.add(geom);
                list.clear();
                list = null;
                break;
            }
            case Close: {
                if (values.size() != 0) {
                    throw new Exception("");
                }
                commands.add(new StiCloseMapGeom());
            }
        }
        values.clear();
    }

    private static boolean tryParse(String value, StiRefObject<Double> out) {
        try {
            out.argvalue = Double.parseDouble(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StiMapGeom> parsePath(String text) throws Exception {
        int index;
        ArrayList<StiMapGeom> commands = new ArrayList<StiMapGeom>();
        int startIndex = 0;
        int valuesCount = 0;
        StiGeomIdent ident = StiGeomIdent.None;
        int valueIndex = 0;
        ArrayList<Double> values = new ArrayList<Double>();
        StiRefObject temp = new StiRefObject((Object)0.0);
        int count = text.length();
        block19: for (index = 0; index < count; ++index) {
            char ch = text.charAt(index);
            switch (ch) {
                case 'M': 
                case 'm': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                        valuesCount = 0;
                    }
                    ident = StiGeomIdent.MoveTo;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'C': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.Bezier_C;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'c': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.Bezier_c;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'S': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    ident = StiGeomIdent.Beziers_S;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 's': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    ident = StiGeomIdent.Beziers_s;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'L': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.Line_L;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'l': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.Line_l;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'Z': 
                case 'z': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.Close;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'V': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.VerticalLineto_V;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'v': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.VerticalLineto_v;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'H': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.HorizontalLineto_H;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case 'h': {
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    if (ident != StiGeomIdent.None) {
                        StiMapLoader.createGeom(ident, values, startIndex, index, commands);
                    }
                    ident = StiGeomIdent.HorizontalLineto_h;
                    valueIndex = startIndex = index + 1;
                    continue block19;
                }
                case '-': {
                    ++valuesCount;
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    valueIndex = index;
                    continue block19;
                }
                case ' ': 
                case ',': {
                    ++valuesCount;
                    if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
                        values.add((Double)temp.argvalue);
                    }
                    valueIndex = index + 1;
                    continue block19;
                }
                case 'A': 
                case 'Q': 
                case 'T': 
                case 'a': 
                case 'q': 
                case 't': {
                    throw new Exception("");
                }
            }
        }
        if (StiMapLoader.tryParse(text.substring(valueIndex, index), (StiRefObject<Double>)temp)) {
            values.add((Double)temp.argvalue);
        }
        if (ident != StiGeomIdent.None && values.size() > 1) {
            StiMapLoader.createGeom(ident, values, startIndex, index, commands);
        }
        ArrayList<StiMapGeom> arrayList = commands;
        return arrayList;
    }

    private static enum StiGeomIdent {
        None,
        MoveTo,
        Line_L,
        Line_l,
        Bezier_C,
        Bezier_c,
        Beziers_S,
        Beziers_s,
        VerticalLineto_V,
        VerticalLineto_v,
        HorizontalLineto_H,
        HorizontalLineto_h,
        Close;

    }
}

