/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.helpers;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.StiMapLoader;
import com.stimulsoft.report.maps.StiMapSvgContainer;
import com.stimulsoft.report.maps.enums.StiDisplayNameType;
import com.stimulsoft.report.maps.enums.StiMapID;
import com.stimulsoft.report.maps.enums.StiMapType;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class StiMapHelper {
    private static StiReport globalReport;
    private static StiMap globalMap;
    private static BufferedImage mapIcon;

    public static BufferedImage getMapIcon() throws IOException {
        if (mapIcon == null) {
            mapIcon = StiImageHelper.decodeImage(StiResourceUtil.getResource((String)"/animation/StiMap32.png"), null);
        }
        return mapIcon;
    }

    public static boolean isWorld(StiMapID id) {
        return id == StiMapID.World;
    }

    public static boolean isAfrica(StiMapID id) {
        return id == StiMapID.SouthAfrica;
    }

    public static boolean isNorthAmerica(StiMapID id) {
        switch (id) {
            case USA: 
            case Canada: 
            case Mexico: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSouthAmerica(StiMapID id) {
        switch (id) {
            case Argentina: 
            case Bolivia: 
            case Brazil: 
            case Chile: 
            case Colombia: 
            case Ecuador: 
            case FalklandIslands: 
            case Guyana: 
            case Paraguay: 
            case Peru: 
            case Suriname: 
            case Uruguay: 
            case Venezuela: {
                return true;
            }
        }
        return false;
    }

    public static boolean IsEU(StiMapID id) {
        switch (id) {
            case Albania: 
            case Andorra: 
            case Austria: 
            case Belarus: 
            case Belgium: 
            case BosniaAndHerzegovina: 
            case Bulgaria: 
            case Croatia: 
            case CzechRepublic: 
            case Denmark: 
            case Estonia: 
            case EU: 
            case Finland: 
            case France: 
            case Georgia: 
            case Germany: 
            case Greece: 
            case Hungary: 
            case Iceland: 
            case Ireland: 
            case Italy: 
            case Latvia: 
            case Liechtenstein: 
            case Lithuania: 
            case Luxembourg: 
            case Macedonia: 
            case Malta: 
            case Moldova: 
            case Monaco: 
            case Montenegro: 
            case Netherlands: 
            case Norway: 
            case Poland: 
            case Portugal: 
            case Romania: 
            case Russia: 
            case SanMarino: 
            case Serbia: 
            case Slovakia: 
            case Slovenia: 
            case Spain: 
            case Sweden: 
            case Switzerland: 
            case Turkey: 
            case UK: 
            case Ukraine: 
            case Vatican: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOceania(StiMapID id) {
        switch (id) {
            case Australia: 
            case Indonesia: 
            case NewZealand: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAsia(StiMapID id) {
        switch (id) {
            case Armenia: 
            case Azerbaijan: 
            case China: 
            case Cyprus: 
            case India: 
            case Israel: 
            case Japan: 
            case Kazakhstan: 
            case Malaysia: 
            case Philippines: 
            case SaudiArabia: 
            case SouthKorea: 
            case Thailand: 
            case Vietnam: {
                return true;
            }
        }
        return false;
    }

    public static String[] getStates(StiMapID id) throws UnsupportedEncodingException, IOException, JSONException {
        StiMapSvgContainer container = StiMapLoader.loadResource(id.toString());
        if (container == null) {
            return new String[0];
        }
        return container.hashPaths.keySet().toArray(new String[0]);
    }

    public static StiMap getMapSample() {
        if (globalReport == null) {
            globalReport = StiReport.newInstance();
        }
        if (globalMap == null) {
            globalMap = new StiMap();
            globalMap.setMapData("[{\"Key\":\"Alabama\",\"Group\":\"3\"},{\"Key\":\"Alaska\",\"Group\":\"1\"},{\"Key\":\"Arizona\",\"Group\":\"1\"},{\"Key\":\"Arkansas\",\"Group\":\"2\"},{\"Key\":\"California\",\"Group\":\"1\"},{\"Key\":\"Colorado\",\"Group\":\"1\"},{\"Key\":\"Connecticut\",\"Group\":\"3\"},{\"Key\":\"Delaware\",\"Group\":\"3\"},{\"Key\":\"Florida\",\"Group\":\"3\"},{\"Key\":\"Georgia\",\"Group\":\"3\"},{\"Key\":\"Hawaii\",\"Group\":\"2\"},{\"Key\":\"Idaho\",\"Group\":\"1\"},{\"Key\":\"Illinois\",\"Group\":\"3\"},{\"Key\":\"Indiana\",\"Group\":\"3\"},{\"Key\":\"Iowa\",\"Group\":\"2\"},{\"Key\":\"Kansas\",\"Group\":\"2\"},{\"Key\":\"Kentucky\",\"Group\":\"3\"},{\"Key\":\"Louisiana\",\"Group\":\"2\"},{\"Key\":\"Maine\",\"Group\":\"3\"},{\"Key\":\"Maryland\",\"Group\":\"3\"},{\"Key\":\"Massachusetts\",\"Group\":\"3\"},{\"Key\":\"Michigan\",\"Group\":\"3\"},{\"Key\":\"Minnesota\",\"Group\":\"2\"},{\"Key\":\"Mississippi\",\"Group\":\"3\"},{\"Key\":\"Missouri\",\"Group\":\"2\"},{\"Key\":\"Montana\",\"Group\":\"1\"},{\"Key\":\"Nebraska\",\"Group\":\"2\"},{\"Key\":\"Nevada\",\"Group\":\"1\"},{\"Key\":\"NewHampshire\",\"Group\":\"3\"},{\"Key\":\"NewJersey\",\"Group\":\"3\"},{\"Key\":\"NewMexico\",\"Group\":\"1\"},{\"Key\":\"NewYork\",\"Group\":\"3\"},{\"Key\":\"NorthCarolina\",\"Group\":\"3\"},{\"Key\":\"NorthDakota\",\"Group\":\"2\"},{\"Key\":\"Ohio\",\"Group\":\"3\"},{\"Key\":\"Oklahoma\",\"Group\":\"2\"},{\"Key\":\"Oregon\",\"Group\":\"1\"},{\"Key\":\"Pennsylvania\",\"Group\":\"3\"},{\"Key\":\"RhodeIsland\",\"Group\":\"3\"},{\"Key\":\"SouthCarolina\",\"Group\":\"3\"},{\"Key\":\"SouthDakota\",\"Group\":\"2\"},{\"Key\":\"Tennessee\",\"Group\":\"3\"},{\"Key\":\"Texas\",\"Group\":\"2\"},{\"Key\":\"Utah\",\"Group\":\"1\"},{\"Key\":\"Vermont\",\"Group\":\"3\"},{\"Key\":\"Virginia\",\"Group\":\"3\"},{\"Key\":\"Washington\",\"Group\":\"1\"},{\"Key\":\"WestVirginia\",\"Group\":\"3\"},{\"Key\":\"Wisconsin\",\"Group\":\"3\"},{\"Key\":\"Wyoming\",\"Group\":\"1\"}]");
            ((StiPage)globalReport.getPages().get(0)).getComponents().add(globalMap);
        }
        globalMap.setStretch(true);
        globalMap.setMapType(StiMapType.Individual);
        globalMap.setDisplayNameType(StiDisplayNameType.None);
        globalMap.setShowLegend(false);
        globalMap.setMapID(StiMapID.USA);
        globalMap.setShowValue(false);
        globalMap.setStretch(true);
        return globalMap;
    }

    public static List<StiColor> getColors() {
        ArrayList<StiColor> result = new ArrayList<StiColor>();
        result.add(StiColor.fromHtml((String)"#90c2a8"));
        result.add(StiColor.fromHtml((String)"#da5459"));
        result.add(StiColor.fromHtml((String)"#efca70"));
        result.add(StiColor.fromHtml((String)"#63b8e3"));
        result.add(StiColor.fromHtml((String)"#ab92c4"));
        result.add(StiColor.fromHtml((String)"#6d58d9"));
        result.add(StiColor.fromHtml((String)"#fb6b40"));
        result.add(StiColor.fromHtml((String)"#e34e2e"));
        return result;
    }

    public static String prepareIsoCode(String text) {
        if (StiValidationUtil.isNullOrEmpty((String)text)) {
            return "";
        }
        int index = text.indexOf("-");
        if (index != -1) {
            return text.substring(index + 1);
        }
        return text;
    }
}

