/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.options;

import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.system.StiEventHandlerArgs;
import com.stimulsoft.report.enums.StiGlobalGuiStyle;
import com.stimulsoft.report.options.EngineOptions;

public class WindowsOptions {
    private static boolean globalGuiStyleLoaded = false;
    private static StiGlobalGuiStyle globalGuiStyle = StiGlobalGuiStyle.Office2007Blue;
    private static boolean useSkinableReportRenderingWindow = false;

    public static StiGlobalGuiStyle getGlobalGuiStyle() {
        if (globalGuiStyleLoaded) {
            return globalGuiStyle;
        }
        StiSettings.Load();
        globalGuiStyleLoaded = true;
        globalGuiStyle = (StiGlobalGuiStyle)((Object)StiSettings.Get((String)"Windows", (String)"GlobalGuiStyle", (Object)((Object)StiGlobalGuiStyle.Office2007Blue)));
        return globalGuiStyle;
    }

    public static void setGlobalGuiStyle(StiGlobalGuiStyle value) {
        if (globalGuiStyleLoaded && globalGuiStyle == value) {
            return;
        }
        StiSettings.Load();
        StiSettings.Set((String)"Windows", (String)"GlobalGuiStyle", (Object)((Object)value));
        StiGlobalGuiStyle oldValue = globalGuiStyle;
        globalGuiStyle = value;
        globalGuiStyleLoaded = true;
        StiSettings.Save();
        if (globalGuiStyle != oldValue) {
            EngineOptions.GlobalEvents.InvokeGlobalGuiStyleChanged(null, StiEventHandlerArgs.Empty);
        }
    }

    public static boolean getIsGuiTypeSelected() {
        StiSettings.Load();
        return StiSettings.GetBool((String)"GuiHelper", (String)"IsGuiTypeSelected", (boolean)false);
    }

    public static void setIsGuiTypeSelected(boolean value) {
        StiSettings.Load();
        StiSettings.Set((String)"GuiHelper", (String)"IsGuiTypeSelected", (boolean)value);
        StiSettings.Save();
    }

    public static boolean getIsOffice2010Enabled() {
        return WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2010Black || WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2010Blue || WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2010Silver || WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Windows7;
    }

    public static boolean getIsOffice2007Enabled() {
        return WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2007Black || WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2007Blue || WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2007Silver || WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Vista;
    }

    public static boolean getIsOffice2003Enabled() {
        return WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2003Black || WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2003Blue || WindowsOptions.getGlobalGuiStyle() == StiGlobalGuiStyle.Office2003Silver;
    }

    public static boolean getIsRibbonGuiEnabled() {
        return WindowsOptions.getIsOffice2007Enabled() || WindowsOptions.getIsOffice2010Enabled();
    }

    public static boolean getUseSkinableReportRenderingWindow() {
        return useSkinableReportRenderingWindow;
    }

    public static void setUseSkinableReportRenderingWindow(boolean value) {
        useSkinableReportRenderingWindow = value;
    }
}

