/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiMarkersStyle;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.table.IStiTableCell;
import com.stimulsoft.report.options.EngineOptions;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.StiPainter;

public class StiComponentPainter
extends StiPainter {
    public void paintEvents(StiComponent component, StiGraphics g, StiRectangle rect) {
    }

    public void paintConditions(StiComponent component, StiGraphics g, StiRectangle rect) {
    }

    public void paintInheritedImage(StiComponent component, StiGraphics g) {
    }

    public void paintOrderAndQuickInfo(StiComponent component, StiGraphics g, String number) {
    }

    public void paintQuickButtons(StiComponent component, StiGraphics g) {
    }

    public void paintMarkers(StiComponent component, StiGraphics g, StiRectangle rect, Double zoom, Double pageZoom) {
        if (component.getIsDesigning() && component.getReport().getInfo().getMarkersStyle() != StiMarkersStyle.None && (!component.getReport().getInfo().getIsComponentsMoving() || component.getReport().getInfo().getDrawMarkersWhenMoving() && component.getReport().getInfo().getIsComponentsMoving())) {
            if (component.getReport().getInfo().getMarkersStyle().equals((Object)StiMarkersStyle.Corners)) {
                Integer size = 3;
                g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getY()), Double.valueOf(rect.getX() + (double)size.intValue()), Double.valueOf(rect.getY()), StiPen.DIM_GRAY, zoom);
                g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getY()), Double.valueOf(rect.getX()), Double.valueOf(rect.getY() + (double)size.intValue()), StiPen.DIM_GRAY, zoom);
                g.drawLineXY(Double.valueOf(rect.getRight()), Double.valueOf(rect.getY()), Double.valueOf(rect.getRight() - (double)size.intValue()), Double.valueOf(rect.getY()), StiPen.DIM_GRAY, zoom);
                g.drawLineXY(Double.valueOf(rect.getRight()), Double.valueOf(rect.getY()), Double.valueOf(rect.getRight()), Double.valueOf(rect.getY() + (double)size.intValue()), StiPen.DIM_GRAY, zoom);
                g.drawLineXY(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom() - (double)size.intValue()), StiPen.DIM_GRAY, zoom);
                g.drawLineXY(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getRight() - (double)size.intValue()), Double.valueOf(rect.getBottom()), StiPen.DIM_GRAY, zoom);
                g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom() - (double)size.intValue()), StiPen.DIM_GRAY, zoom);
                g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getX() + (double)size.intValue()), Double.valueOf(rect.getBottom()), StiPen.DIM_GRAY, zoom);
            } else {
                g.drawRectangle(rect, EngineOptions.QuickInfo.getDashStylePen(), null, zoom, pageZoom);
            }
        }
    }

    public void paintBorder(StiComponent component, StiGraphics g, StiRectangle rect, Boolean topMost, Boolean isThumbPaint, Double zoom, Double pageZoom) {
        if (component.getReport().getInfo().isExporting()) {
            return;
        }
        if (zoom == null) {
            zoom = component.getPage().getZoom();
        }
        IStiBorder border = (IStiBorder)((Object)component);
        StiHighlightState highlightState = component.getHighlightState();
        Boolean isPrinting = component.getIsPrinting();
        if (border != null && border.getBorder() != null && (topMost.equals(border.getBorder().getTopmost()) || highlightState != StiHighlightState.Hide)) {
            if (border.getBorder().getStyle().equals((Object)StiPenStyle.Double)) {
                StiColor emptyColor = StiColorEnum.White.color();
                IStiBrush brush = (IStiBrush)((Object)component);
                if (brush != null && brush.getBrush() != null) {
                    emptyColor = StiBrush.ToColor((StiBrush)brush.getBrush());
                }
                border.getBorder().draw(g, rect, zoom.doubleValue(), emptyColor, highlightState, isPrinting, isThumbPaint, pageZoom.doubleValue());
            } else {
                border.getBorder().draw(g, rect, zoom.doubleValue(), null, highlightState, isPrinting, isThumbPaint, pageZoom.doubleValue());
            }
        }
    }

    public void paintSelection(StiComponent component, StiPaintArgs args) {
        if (component instanceof IStiTableCell) {
            return;
        }
        StiGraphics g = args.getG();
        if (component.getIsDesigning() && component.getIsSelected() && !component.getReport().getInfo().getIsComponentsMoving() && !component.getReport().getInfo().getIsTableMode()) {
            StiRectangle rect = component.getPaintRectangle();
            Double size = 2.0;
            if (component.getLinked()) {
                size = 3.0;
            }
            if (component.getLocked()) {
                this.drawSelectedRectangle(g, size, (StiBrush)new StiSolidBrush(StiColorEnum.Red.color()), rect);
            } else {
                this.drawSelectedRectangle(g, size, (StiBrush)new StiSolidBrush(StiColorEnum.DimGray.color()), rect);
            }
        }
    }

    private void drawSelectedPoint(StiGraphics g, Double size, StiBrush brush, Double x, Double y) {
        g.drawRectangle(new StiRectangle(x - size, y - size, size * 2.0 + 1.0, size * 2.0 + 1.0), null, brush, Double.valueOf(0.0), Double.valueOf(1.0), Double.valueOf(1.0));
    }

    public void drawSelectedRectangle(StiGraphics g, Double size, StiBrush brush, StiRectangle rect) {
        this.drawSelectedPoint(g, size, brush, rect.getLeft(), rect.getTop());
        this.drawSelectedPoint(g, size, brush, rect.getRight(), rect.getTop());
        this.drawSelectedPoint(g, size, brush, rect.getLeft(), rect.getBottom());
        this.drawSelectedPoint(g, size, brush, rect.getRight(), rect.getBottom());
        this.drawSelectedPoint(g, size, brush, rect.getLeft() + rect.getWidth() / 2.0, rect.getBottom());
        this.drawSelectedPoint(g, size, brush, rect.getLeft(), rect.getTop() + rect.getHeight() / 2.0);
        this.drawSelectedPoint(g, size, brush, rect.getLeft() + rect.getWidth() / 2.0, rect.getTop());
        this.drawSelectedPoint(g, size, brush, rect.getRight(), rect.getTop() + rect.getHeight() / 2.0);
    }
}

