/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiView;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;

public class StiViewPainter
extends StiComponentPainter {
    protected static final Logger LOG = Logger.getLogger(StiViewPainter.class.getName());

    public void paintImage(StiView view, StiGraphics g, StiRectangle rect, Double zoom) {
        if (view.getBufferedImage(null) != null) {
            if (zoom < 0.0) {
                zoom = view.getPage().getZoom();
            }
            BufferedImage imageBitmap = view.getBufferedImage(view.getPaintRectangle());
            StiRectangle imageRect = new StiRectangle(rect.getX(), rect.getY(), (double)imageBitmap.getWidth() * view.getMultipleFactor(), (double)imageBitmap.getHeight() * view.getMultipleFactor());
            if (view.getStretch()) {
                imageRect.setX(rect.getX());
                imageRect.setY(rect.getY());
                imageRect.setWidth(rect.getWidth());
                imageRect.setHeight(rect.getHeight());
                if (view.getAspectRatio()) {
                    Double xRatio = rect.getWidth() / (double)imageBitmap.getWidth();
                    Double yRatio = rect.getHeight() / (double)imageBitmap.getHeight();
                    if (xRatio > yRatio) {
                        imageRect.setWidth((double)imageBitmap.getWidth() * yRatio);
                    } else {
                        imageRect.setHeight((double)imageBitmap.getHeight() * xRatio);
                    }
                }
            } else {
                imageRect.setWidth(imageRect.getWidth() * zoom);
                imageRect.setHeight(imageRect.getHeight() * zoom);
            }
            switch (view.getHorAlignment()) {
                case Center: {
                    imageRect.setX(rect.getX() + (rect.getWidth() - imageRect.getWidth()) / 2.0);
                    break;
                }
                case Right: {
                    imageRect.setX(rect.getRight() - imageRect.getWidth());
                }
            }
            switch (view.getVertAlignment()) {
                case Center: {
                    imageRect.setY(rect.getY() + (rect.getHeight() - imageRect.getHeight()) / 2.0);
                    break;
                }
                case Bottom: {
                    imageRect.setY(rect.getBottom() - imageRect.getHeight());
                }
            }
            StiRectangle drawRect = imageRect.clone();
            if (drawRect.getLeft() < rect.getLeft()) {
                drawRect.setLeft(rect.getLeft());
            }
            if (drawRect.getRight() > rect.getRight()) {
                drawRect.setRight(rect.getRight());
            }
            if (drawRect.getTop() < rect.getTop()) {
                drawRect.setTop(rect.getTop());
            }
            if (drawRect.getBottom() > rect.getBottom()) {
                drawRect.setBottom(rect.getBottom());
            }
            if (drawRect.getWidth() - 1.0 > 0.0 && drawRect.getHeight() > 0.0) {
                Double scaleX = (double)imageBitmap.getWidth() / imageRect.getWidth();
                Double scaleY = (double)imageBitmap.getHeight() / imageRect.getHeight();
                BufferedImage drawBitmap = new BufferedImage((int)(drawRect.getWidth() * scaleX), (int)(drawRect.getHeight() * scaleY), 2);
                AffineTransform at = new AffineTransform();
                at.translate(imageRect.getX() - drawRect.getX(), imageRect.getY() - drawRect.getY());
                Graphics2D drawGraphics2d = (Graphics2D)drawBitmap.getGraphics();
                drawGraphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                drawGraphics2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                drawGraphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                drawGraphics2d.drawImage(imageBitmap, at, null);
                g.drawImage(drawBitmap, drawRect, Boolean.valueOf(true), Boolean.valueOf(view.getSmoothing()), zoom.doubleValue());
            }
        }
    }

    public BufferedImage getImage(StiComponent component, Double zoom, int format) {
        return null;
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiView view = (StiView)component;
        Double zoom = component.getReport().getInfo().getZoom();
        Double pageZoom = component.getReport().getInfo().getPageZoom();
        if (view.getEnabled() || view.getIsDesigning()) {
            StiGraphics g = args.getG();
            StiRectangle rect = view.getPaintRectangle();
            Boolean topMost = args.getDrawTopmostBorderSides();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
                if (!topMost.booleanValue()) {
                    if (view.getBrush() instanceof StiSolidBrush && StiColor.Transparent.equals(((StiSolidBrush)view.getBrush()).getColor()) && view.getReport().getInfo().getFillComponent() && view.getIsDesigning() && view.getImageBytesToDraw() != null && !"".equals(view.getImageBytesToDraw())) {
                        StiColor color = StiColor.fromAColor((int)50, (StiColor)StiColorEnum.Green.color());
                        g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), zoom, pageZoom);
                    } else {
                        g.drawRectangle(rect, null, view.getBrush(), zoom, pageZoom);
                    }
                    if (view.getBufferedImage(rect) != null) {
                        this.paintImage(view, g, rect, zoom);
                    }
                    this.paintMarkers(view, g, rect, zoom, pageZoom);
                    this.paintBorder(view, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
                    if (view.getIsDesigning()) {
                        this.paintQuickButtons(view, args.getG());
                    }
                    this.paintEvents(view, args.getG(), rect);
                    this.paintConditions(view, args.getG(), rect);
                } else {
                    this.paintBorder(view, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
                }
            }
        }
    }
}

