/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.print;

import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.print.StiPagePrintable;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;

public class StiPrintHelper {
    public static void printJob(PrinterJob printerJob, StiReport report) throws PrinterException {
        StiPrintHelper.printJob(printerJob, report, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printJob(PrinterJob printerJob, StiReport report, Boolean showPrintDialog) throws PrinterException {
        if (showPrintDialog.booleanValue() && printerJob.printDialog() || !showPrintDialog.booleanValue()) {
            try {
                report.setIsPrinting(true);
                printerJob.print();
            }
            finally {
                report.setIsPrinting(false);
            }
        }
    }

    public static PrinterJob preparePrinterJob(List<StiPage> pages) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        for (StiPage page : pages) {
            if (!(page.getDenyDrawSegmentMode() || page.getSegmentPerWidth() <= 1 && page.getSegmentPerHeight() <= 1)) {
                for (int segmentY = 0; segmentY < page.getSegmentPerHeight(); ++segmentY) {
                    for (int segmentX = 0; segmentX < page.getSegmentPerWidth(); ++segmentX) {
                        Double width = page.getUnit().ConvertToHInches(page.getWidth() / (double)page.getSegmentPerWidth() + page.getMargins().getLeft() + page.getMargins().getRight());
                        Double height = page.getUnit().ConvertToHInches(page.getHeight() / (double)page.getSegmentPerHeight() + page.getMargins().getTop() + page.getMargins().getBottom());
                        StiPrintHelper.appendPrintPage(book, page, width, height, segmentX, segmentY);
                    }
                }
                continue;
            }
            Double width = page.getUnit().ConvertToHInches(page.getWidth() + page.getMargins().getLeft() + page.getMargins().getRight());
            Double height = page.getUnit().ConvertToHInches(page.getHeight() + page.getMargins().getTop() + page.getMargins().getBottom());
            StiPrintHelper.appendPrintPage(book, page, width, height, -1, -1);
        }
        printJob.setPageable(book);
        return printJob;
    }

    private static void appendPrintPage(Book book, StiPage page, double width, double height, int segmentX, int segmentY) {
        PageFormat documentPageFormat = new PageFormat();
        Paper paper = new Paper();
        width /= 1.38888889;
        height /= 1.38888889;
        if (page.getOrientation() == StiPageOrientation.Portrait) {
            paper.setImageableArea(0.0, 0.0, width, height);
            paper.setSize(width, height);
            documentPageFormat.setOrientation(1);
        } else {
            paper.setImageableArea(0.0, 0.0, height, width);
            paper.setSize(height, width);
            documentPageFormat.setOrientation(0);
        }
        documentPageFormat.setPaper(paper);
        book.append(new StiPagePrintable(page, segmentX, segmentY), documentPageFormat);
    }
}

