/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.report.components.StiComponent;

public class StiStylesHelper {
    public static StiEnumSet<StiBorderSides> getBorderSidesFromLocation(StiComponent component) {
        StiEnumSet sides = StiEnumSet.of((Enum)StiBorderSides.None);
        double compLeft = StiMath.round((double)(component.page.getUnit().ConvertToHInches(component.getLeft()) / 10.0), (int)0);
        double compTop = StiMath.round((double)(component.page.getUnit().ConvertToHInches(component.getTop()) / 10.0), (int)0);
        double parentWidth = StiMath.round((double)(component.page.getUnit().ConvertToHInches(component.getParent().getWidth()) / 10.0), (int)0);
        double parentHeight = StiMath.round((double)(component.page.getUnit().ConvertToHInches(component.getParent().getHeight()) / 10.0), (int)0);
        double compRight = StiMath.round((double)(component.page.getUnit().ConvertToHInches(component.getLeft() + component.getWidth()) / 10.0), (int)0);
        double compBottom = StiMath.round((double)(component.page.getUnit().ConvertToHInches(component.getTop() + component.getHeight()) / 10.0), (int)0);
        if (compLeft <= 0.0) {
            sides.add((IStiEnum)StiBorderSides.Left);
        }
        if (compTop <= 0.0) {
            sides.add((IStiEnum)StiBorderSides.Top);
        }
        if (compRight >= parentWidth) {
            sides.add((IStiEnum)StiBorderSides.Right);
        }
        if (compBottom >= parentHeight) {
            sides.add((IStiEnum)StiBorderSides.Bottom);
        }
        return sides;
    }
}

