/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles.conditions;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiChildBand;
import com.stimulsoft.report.components.bands.StiColumnFooterBand;
import com.stimulsoft.report.components.bands.StiColumnHeaderBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.bands.StiHierarchicalBand;
import com.stimulsoft.report.components.bands.StiOverlayBand;
import com.stimulsoft.report.components.bands.StiPageFooterBand;
import com.stimulsoft.report.components.bands.StiPageHeaderBand;
import com.stimulsoft.report.components.bands.StiReportSummaryBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.interfaces.IStiCrossTabField;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiSimpleText;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.conditions.StiStyleCondition;
import com.stimulsoft.report.styles.enums.StiStyleComponentPlacement;
import com.stimulsoft.report.styles.enums.StiStyleComponentType;
import com.stimulsoft.report.styles.enums.StiStyleConditionOperation;
import com.stimulsoft.report.styles.enums.StiStyleConditionType;
import com.stimulsoft.report.styles.enums.StiStyleLocation;

public class StiStyleConditionHelper {
    public static boolean isAllowStyle(StiComponent component, StiBaseStyle style) {
        for (StiStyleCondition condition : style.getConditions()) {
            boolean resultComponentName = true;
            boolean resultComponentType = true;
            boolean resultPlacement = true;
            boolean resultLocation = true;
            if ((condition.getType().getIntValue() & StiStyleConditionType.ComponentName.getValue()) > 0) {
                switch (condition.getOperationComponentName()) {
                    case EqualTo: {
                        resultComponentName = component.getName().equals(condition.getComponentName());
                        break;
                    }
                    case NotEqualTo: {
                        resultComponentName = !component.getName().equals(condition.getComponentName());
                        break;
                    }
                    case BeginningWith: {
                        resultComponentName = component.getName() != null && component.getName().startsWith(condition.getComponentName());
                        break;
                    }
                    case EndingWith: {
                        resultComponentName = component.getName() != null && component.getName().endsWith(condition.getComponentName());
                        break;
                    }
                    case Containing: {
                        resultComponentName = component.getName() != null && component.getName().contains(condition.getComponentName());
                        break;
                    }
                    case NotContaining: {
                        resultComponentName = component.getName() != null && !component.getName().contains(condition.getComponentName());
                        break;
                    }
                }
            }
            if ((condition.getType().getIntValue() & StiStyleConditionType.ComponentType.getValue()) > 0) {
                resultComponentType = false;
                if ((condition.getComponentType().getIntValue() & StiStyleComponentType.Chart.getValue()) > 0 && component instanceof StiChart) {
                    resultComponentType = true;
                }
                if ((condition.getComponentType().getIntValue() & StiStyleComponentType.CrossTab.getValue()) > 0 && (component instanceof StiCrossTab || component instanceof IStiCrossTabField)) {
                    resultComponentType = true;
                }
                if ((condition.getComponentType().getIntValue() & StiStyleComponentType.Image.getValue()) > 0 && component instanceof StiImage) {
                    resultComponentType = true;
                }
                if ((condition.getComponentType().getIntValue() & StiStyleComponentType.Text.getValue()) > 0 && component instanceof StiSimpleText) {
                    resultComponentType = true;
                }
                if ((condition.getComponentType().getIntValue() & StiStyleComponentType.Primitive.getValue()) > 0 && (component instanceof StiShape || component instanceof StiPrimitive)) {
                    resultComponentType = true;
                }
                if ((condition.getComponentType().getIntValue() & StiStyleComponentType.CheckBox.getValue()) > 0 && component instanceof StiCheckBox) {
                    resultComponentType = true;
                }
                if (condition.getOperationComponentType() == StiStyleConditionOperation.NotEqualTo) {
                    boolean bl = resultComponentType = !resultComponentType;
                }
            }
            if ((condition.getType().getIntValue() & StiStyleConditionType.Location.getValue()) > 0 && component.getPage() != null && component.getParent() != null) {
                double compLeft = StiMath.round((double)(component.getPage().getUnit().ConvertToHInches(component.getLeft()) / 10.0), (int)0);
                double compTop = StiMath.round((double)(component.getPage().getUnit().ConvertToHInches(component.getTop()) / 10.0), (int)0);
                double compWidth = StiMath.round((double)(component.getPage().getUnit().ConvertToHInches(component.getWidth()) / 10.0), (int)0);
                double compHeight = StiMath.round((double)(component.getPage().getUnit().ConvertToHInches(component.getHeight()) / 10.0), (int)0);
                double parentWidth = StiMath.round((double)(component.getPage().getUnit().ConvertToHInches(component.getParent().getWidth()) / 10.0), (int)0);
                double parentHeight = StiMath.round((double)(component.getPage().getUnit().ConvertToHInches(component.getParent().getHeight()) / 10.0), (int)0);
                double compRight = compLeft + compWidth;
                double compBottom = compTop + compHeight;
                resultLocation = false;
                if (condition.getLocation().contains((IStiEnum)StiStyleLocation.Left) && compTop <= 0.0 && compLeft <= 0.0 && compHeight == parentHeight) {
                    resultLocation = true;
                }
                if (condition.getLocation().contains((IStiEnum)StiStyleLocation.Right) && compTop <= 0.0 && compRight >= parentWidth && compHeight == parentHeight) {
                    resultLocation = true;
                }
                if (condition.getLocation().contains((IStiEnum)StiStyleLocation.Top) && compLeft <= 0.0 && compTop <= 0.0 && compWidth == parentWidth) {
                    resultLocation = true;
                }
                if (condition.getLocation().contains((IStiEnum)StiStyleLocation.Bottom) && compLeft <= 0.0 && compBottom >= parentHeight && compWidth == parentWidth) {
                    resultLocation = true;
                }
                if (condition.getLocation().contains((IStiEnum)StiStyleLocation.CenterHorizontal) && compTop <= 0.0 && compLeft > 0.0 && compRight < parentWidth && compHeight == parentHeight) {
                    resultLocation = true;
                }
                if (condition.getLocation().contains((IStiEnum)StiStyleLocation.CenterVertical) && compLeft <= 0.0 && compTop > 0.0 && compBottom < parentHeight && compWidth == parentWidth) {
                    resultLocation = true;
                }
                if (!resultLocation) {
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.TopLeft) && compTop <= 0.0 && compLeft <= 0.0) {
                        resultLocation = true;
                    }
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.TopCenter) && compTop <= 0.0 && compLeft > 0.0 && compRight < parentWidth) {
                        resultLocation = true;
                    }
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.TopRight) && compTop <= 0.0 && compRight >= parentWidth) {
                        resultLocation = true;
                    }
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.MiddleLeft) && compTop > 0.0 && compBottom < parentHeight && compLeft <= 0.0) {
                        resultLocation = true;
                    }
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.MiddleCenter) && compTop > 0.0 && compBottom < parentHeight && compLeft > 0.0 && compRight < parentWidth) {
                        resultLocation = true;
                    }
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.MiddleRight) && compTop > 0.0 && compBottom < parentHeight && compRight >= parentWidth) {
                        resultLocation = true;
                    }
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.BottomLeft) && compBottom >= parentHeight && compLeft <= 0.0) {
                        resultLocation = true;
                    }
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.BottomCenter) && compBottom >= parentHeight && compLeft > 0.0 && compRight < parentWidth) {
                        resultLocation = true;
                    }
                    if (condition.getLocation().contains((IStiEnum)StiStyleLocation.BottomRight) && compBottom >= parentHeight && compRight >= parentWidth) {
                        resultLocation = true;
                    }
                }
                if (condition.getOperationPlacement() == StiStyleConditionOperation.NotEqualTo) {
                    boolean bl = resultLocation = !resultLocation;
                }
            }
            if ((condition.getType().getIntValue() & StiStyleConditionType.Placement.getValue()) > 0) {
                resultPlacement = false;
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.ReportTitle.getValue()) > 0 && component.getParent() instanceof StiReportTitleBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.ReportSummary.getValue()) > 0 && component.getParent() instanceof StiReportSummaryBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.PageHeader.getValue()) > 0 && component.getParent() instanceof StiPageHeaderBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.PageFooter.getValue()) > 0 && component.getParent() instanceof StiPageFooterBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.GroupHeader.getValue()) > 0 && component.getParent() instanceof StiGroupHeaderBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.GroupFooter.getValue()) > 0 && component.getParent() instanceof StiGroupFooterBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Header.getValue()) > 0 && component.getParent() instanceof StiHeaderBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Footer.getValue()) > 0 && component.getParent() instanceof StiFooterBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.ColumnHeader.getValue()) > 0 && component.getParent() instanceof StiColumnHeaderBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.ColumnFooter.getValue()) > 0 && component.getParent() instanceof StiColumnFooterBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Data.getValue()) > 0 && component.getParent() instanceof StiDataBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.DataEvenStyle.getValue()) > 0 && component instanceof StiDataBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.DataOddStyle.getValue()) > 0 && component instanceof StiDataBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Table.getValue()) > 0 && component.getParent() instanceof StiTable) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Hierarchical.getValue()) > 0 && component.getParent() instanceof StiHierarchicalBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Child.getValue()) > 0 && component.getParent() instanceof StiChildBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Empty.getValue()) > 0 && component.getParent() instanceof StiEmptyBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Overlay.getValue()) > 0 && component.getParent() instanceof StiOverlayBand) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Panel.getValue()) > 0 && component.getParent() instanceof StiPanel) {
                    resultPlacement = true;
                }
                if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.Page.getValue()) > 0 && component.getParent() instanceof StiPage) {
                    resultPlacement = true;
                }
                if (resultPlacement && (condition.getType().getIntValue() & StiStyleConditionType.PlacementNestedLevel.getValue()) > 0) {
                    StiBand band;
                    int level = 1;
                    StiComponent parent = component.getParent();
                    if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.DataEvenStyle.getValue()) > 0 || (condition.getPlacement().getValue() & StiStyleComponentPlacement.DataOddStyle.getValue()) > 0) {
                        parent = component;
                    }
                    StiBand stiBand = band = parent instanceof StiBand ? (StiBand)parent : null;
                    if (band != null) {
                        level = band.getNestedLevel();
                    }
                    if (condition.getOperationPlacementNestedLevel() == StiStyleConditionOperation.EqualTo) {
                        resultPlacement = level == condition.getPlacementNestedLevel();
                    } else if (condition.getOperationPlacementNestedLevel() == StiStyleConditionOperation.NotEqualTo) {
                        resultPlacement = level != condition.getPlacementNestedLevel();
                    } else if (condition.getOperationPlacementNestedLevel() == StiStyleConditionOperation.GreaterThan) {
                        resultPlacement = level > condition.getPlacementNestedLevel();
                    } else if (condition.getOperationPlacementNestedLevel() == StiStyleConditionOperation.GreaterThanOrEqualTo) {
                        resultPlacement = level >= condition.getPlacementNestedLevel();
                    } else if (condition.getOperationPlacementNestedLevel() == StiStyleConditionOperation.LessThan) {
                        resultPlacement = level < condition.getPlacementNestedLevel();
                    } else if (condition.getOperationPlacementNestedLevel() == StiStyleConditionOperation.LessThanOrEqualTo) {
                        boolean bl = resultPlacement = level <= condition.getPlacementNestedLevel();
                    }
                }
                if (condition.getOperationPlacement() == StiStyleConditionOperation.NotEqualTo) {
                    boolean bl = resultPlacement = !resultPlacement;
                }
            }
            if (resultComponentName && resultComponentType && resultPlacement && resultLocation) continue;
            return false;
        }
        return true;
    }
}

