/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.StiFontCollection;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.StiPrinterSettings;
import com.stimulsoft.base.design.IStiReport;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.system.StiEventHandler;
import com.stimulsoft.base.system.StiEventHandlerArgs;
import com.stimulsoft.base.system.StiEventObject;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.IStiProgressInformation;
import com.stimulsoft.report.StiConvert;
import com.stimulsoft.report.StiCustomFunction;
import com.stimulsoft.report.StiMetaTagCollection;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReportCache;
import com.stimulsoft.report.StiRuntimeVariables;
import com.stimulsoft.report.StiStatusHandler;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.core.styles.StiCustomStyleCoreXF;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.styles.StiCustomStyle;
import com.stimulsoft.report.components.StiBookmark;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiInteraction;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.complexcomponents.StiClone;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiMasterComponent;
import com.stimulsoft.report.components.interfaces.IStiUnitConvert;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.components.textFormats.StiGeneralFormatService;
import com.stimulsoft.report.design.IStiDesignerBase;
import com.stimulsoft.report.design.StiDesignerInfo;
import com.stimulsoft.report.dialogs.StiProgressInformationDialog;
import com.stimulsoft.report.dictionary.StiDialogInfo;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariablesMap;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectData;
import com.stimulsoft.report.dictionary.data.DBNull;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourcesCollection;
import com.stimulsoft.report.engine.IStiEngineVersionProperty;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.StiRenderState;
import com.stimulsoft.report.engine.engineV2.StiBookmarksV2Helper;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.builders.StiReportV2Builder;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.enums.StiNumberOfPass;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.enums.StiPreviewMode;
import com.stimulsoft.report.enums.StiRenderedWith;
import com.stimulsoft.report.enums.StiReportCacheMode;
import com.stimulsoft.report.enums.StiReportLanguageType;
import com.stimulsoft.report.enums.StiReportPass;
import com.stimulsoft.report.enums.StiReportUnitType;
import com.stimulsoft.report.events.StiBeginRenderEvent;
import com.stimulsoft.report.events.StiEndRenderEvent;
import com.stimulsoft.report.events.StiExportEventArgs;
import com.stimulsoft.report.events.StiExportedEvent;
import com.stimulsoft.report.events.StiExportingEvent;
import com.stimulsoft.report.events.StiPrintedEvent;
import com.stimulsoft.report.events.StiPrintingEvent;
import com.stimulsoft.report.events.StiRenderingEvent;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.globalization.StiGlobalizationContainerCollection;
import com.stimulsoft.report.helpers.FontVHelper;
import com.stimulsoft.report.reportresources.StiReportResourceCollection;
import com.stimulsoft.report.saveLoad.StiXmlDocumentSLService;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiChartStyle;
import com.stimulsoft.report.styles.StiStylesCollection;
import com.stimulsoft.report.styles.conditions.StiStyleCondition;
import com.stimulsoft.report.styles.conditions.StiStyleConditionHelper;
import com.stimulsoft.report.styles.enums.StiStyleComponentPlacement;
import com.stimulsoft.report.units.StiCentimetersUnit;
import com.stimulsoft.report.units.StiHundredthsOfInchUnit;
import com.stimulsoft.report.units.StiInchesUnit;
import com.stimulsoft.report.units.StiMillimetersUnit;
import com.stimulsoft.report.units.StiUnit;
import com.stimulsoft.report.viewer.StiPreviewSettings;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JFrame;

public class StiReport
extends StiSerializedObject
implements IStiReport,
Cloneable,
IStiUnitConvert,
IStiEngineVersionProperty,
IStiSerializableRef,
Serializable {
    private static final long serialVersionUID = -2454849015173378006L;
    private StiPagesCollection renderedPages = new StiPagesCollection(this);
    private static StiGraphics globalMeasureGraphics;
    public StiDictionary dictionary = new StiDictionary(this);
    private String reportFile = "";
    private String script;
    private StiBeginRenderEvent beginRenderEvent = new StiBeginRenderEvent();
    private StiRenderingEvent renderingEvent = new StiRenderingEvent();
    private StiEndRenderEvent endRenderEvent = new StiEndRenderEvent();
    private StiExportingEvent exportingEvent = new StiExportingEvent();
    private StiExportedEvent exportedEvent = new StiExportedEvent();
    private StiPrintingEvent printingEvent = new StiPrintingEvent();
    private StiPrintedEvent printedEvent = new StiPrintedEvent();
    private StiMetaTagCollection metaTags = new StiMetaTagCollection();
    private String reportVersion = StiAttribute.getVersion();
    private String reportGuid;
    public StiPagesCollection pages = new StiPagesCollection(this);
    private String reportName = "";
    private String reportAlias = "";
    private String reportAuthor = "";
    private String reportDescription = "";
    private Calendar reportCreated = Calendar.getInstance();
    private Calendar reportChanged = Calendar.getInstance();
    private StiEngineVersion engineVersion = StiEngineVersion.EngineV2;
    private StiStylesCollection styles = new StiStylesCollection(this);
    private StiNumberOfPass numberOfPass = StiNumberOfPass.SinglePass;
    private StiCalculationMode calculationMode = StiCalculationMode.Interpretation;
    private StiReportUnitType reportUnit = StiReportUnitType.Centimeters;
    private boolean cacheAllData;
    public StiReportCacheMode reportCacheMode = StiReportCacheMode.Off;
    private boolean convertNulls = true;
    private boolean storeImagesInResources = true;
    private StiPreviewMode previewMode = StiPreviewMode.Standard;
    private int stopBeforePage;
    private int previewSettings = StiPreviewSettings.All.getValue();
    private int collate = 1;
    private StiPrinterSettings printerSettings = new StiPrinterSettings();
    private StiGlobalizationContainerCollection globalizationStrings = new StiGlobalizationContainerCollection(this);
    private boolean autoLocalizeReportOnRun;
    private StiOrientation parametersOrientation = StiOrientation.Horizontal;
    private boolean requestParameters;
    private ArrayList<String> referencedAssemblies = new ArrayList();
    private StiDesignerInfo designerInfo = new StiDesignerInfo(this);
    private String licenseKey;
    public StiReport compiledReport;
    public StiBookmark bookmarkValue;
    private int pageNumber;
    private int totalPageCountValue;
    private StiReportLanguageType scriptLanguage = StiReportLanguageType.CSharp;
    public String[] DataBandsUsedInPageTotals;
    private boolean isExporting;
    private boolean isPrintingValue;
    private int Line = 1;
    public int LineThrough;
    public int LineABC;
    public int LineRoman;
    public boolean useProgressInThread = false;
    public ArrayList<String> reportRenderingMessages = null;
    public HashMap<String, Object> interactionCollapsingStates = null;
    private String statusString = "";
    public int progressOfRendering = 0;
    public IStiProgressInformation progress = null;
    public ArrayList<StiReport> subReports;
    public String reportSource = null;
    public Object tag = null;
    public String reportCachePath = "";
    public String imageCachePath = "";
    public String rtfCachePath = "";
    public StiReport parentReport = null;
    public StiBookmark manualBookmark = new StiBookmark();
    public StiGraphics reportMeasureGraphics;
    private Hashtable<String, Object> totals = new Hashtable();
    public String password = null;
    public String[] dataBandsUsedInPageTotals;
    public StiReportPass reportPass = StiReportPass.None;
    public boolean isEditedInViewer = false;
    public boolean isRendered = false;
    public boolean isRendering = false;
    private boolean isModified = false;
    public boolean isStopped = false;
    public boolean stop = false;
    public boolean isPageDesigner = false;
    public boolean isSerializing = false;
    public boolean isPackedReport = false;
    public boolean isWpf = false;
    public boolean isDocument = false;
    public boolean isInteractionRendering = false;
    public boolean isNeedsCompiling;
    public boolean saveReportInResources = true;
    public static Object lockGlobalMeasureGraphics;
    private Boolean isSubmit = false;
    public boolean SubReportsResetPageNumber = false;
    public boolean SubReportsPrintOnPreviousPage = false;
    private boolean needsCompiling;
    public StiEngine engine;
    public int GroupLine;
    public boolean containsTables;
    public StiReport SubReportsMasterReport;
    public int currentPrintPage;
    public int currentPage;
    private StiVariablesMap variables = new StiVariablesMap(this);
    private ArrayList<StiBusinessObjectData> businessObjectsStore;
    private int selectionTick;
    private int column;
    private boolean previewDialogs = false;
    public int IndexName = 1;
    public StiStatusHandler statusHandler;
    private String pageNofMLocalizationString = null;
    private List<StiCustomFunction> customFunctions = new ArrayList<StiCustomFunction>();
    private boolean showProgress = false;
    private String culture;
    private Hashtable<String, Boolean> modifiedVariables = new Hashtable();
    private String[] listOfUsedData = null;
    private boolean retrieveOnlyUsedData = false;
    private boolean jsonReport = false;
    public StiJsonLoaderHelper jsonLoaderHelper;
    private StiReportResourceCollection reportResources = null;
    public IStiDesignerBase designer;
    private int refreshTime;
    private boolean saveInteractionParametersToDocument;
    private HashMap<String, String> resourceToFontHash = new HashMap();
    public StiRenderedWith renderedWith = StiRenderedWith.Unknown;
    public StiEventHandler handlerRendering = StiEventHandler.empty();
    public StiEventHandler handlerRefreshPreview = StiEventHandler.empty();
    public StiEventHandler handlerRefreshViewer = StiEventHandler.empty();
    public StiEventHandler handlerBeginRender = StiEventHandler.empty();
    public StiEventHandler handlerEndRender = StiEventHandler.empty();
    public StiEventHandler handlerExported = StiEventHandler.empty();
    public StiEventHandler handlerExporting = StiEventHandler.empty();
    public StiEventHandler handlerPaint = StiEventHandler.empty();
    public StiEventHandler handlerPrinted = StiEventHandler.empty();
    public StiEventHandler handlerStatusChanged = StiEventHandler.empty();
    public StiEventHandler handlerDesignerEvents = StiEventHandler.empty();
    private Hashtable anchors = new Hashtable();

    public StiReport() {
        this.fillReferencedAssemblies();
        this.fillReportScript();
    }

    public static StiReport newInstance() {
        StiReport report = new StiReport();
        try {
            report.setReportVersion(StiAttribute.getVersion());
            report.designerInfo = new StiDesignerInfo(report);
            try {
                if (StiOptions.Engine.getDefaultUnit() instanceof StiReportUnitType) {
                    report.reportUnit = (StiReportUnitType)((Object)StiOptions.Engine.getDefaultUnit());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            report.dictionary = new StiDictionary(report);
            report.styles = new StiStylesCollection(report);
            StiPage page = new StiPage(report);
            report.getPages().add(page);
            page.setName(StiNameCreation.generateName(page) + "1");
            report.getRenderedPages().add(page);
            report.setReportName(StiLocalization.getValue((String)"Components", (String)"StiReport"));
            report.setReportAlias(StiLocalization.getValue((String)"Components", (String)"StiReport"));
            report.bookmarkValue = StiBookmarksV2Helper.CreateBookmark(report.getReportAlias(), report.getReportGuid());
            report.manualBookmark = StiBookmarksV2Helper.CreateBookmark(report.getReportAlias(), report.getReportGuid());
            report.needsCompiling = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return report;
    }

    private void fillReferencedAssemblies() {
        this.referencedAssemblies.add("System.Dll");
        this.referencedAssemblies.add("System.Drawing.Dll");
        this.referencedAssemblies.add("System.Windows.Forms.Dll");
        this.referencedAssemblies.add("System.Data.Dll");
        this.referencedAssemblies.add("System.Xml.Dll");
        this.referencedAssemblies.add("Stimulsoft.Controls.Dll");
        this.referencedAssemblies.add("Stimulsoft.Base.Dll");
        this.referencedAssemblies.add("Stimulsoft.Report.Dll");
    }

    public void fillReportScript() {
        this.script = this.scriptLanguage == StiReportLanguageType.VB ? "Imports System\nImports System.Drawing\nImports System.Windows.Forms\nImports System.Data\nImports Stimulsoft.Controls\nImports Stimulsoft.Base.Drawing\nImports Stimulsoft.Report\nImports Stimulsoft.Report.Dialogs\nImports Stimulsoft.Report.Components\n\nNamespace Reports\n    \n    Public Class Report\n        Inherits Stimulsoft.Report.StiReport\n        \n        Public Sub New()\n            MyBase.New\n            Me.InitializeComponent\n        End Sub\n        #Region \"StiReport Designer generated code - do not modify\"#End Region 'StiReport Designer generated code - do not modify\n    End Class\nEnd Namespace\n" : "using System;\nusing System.Drawing;\nusing System.Windows.Forms;\nusing System.Data;\nusing Stimulsoft.Controls;\nusing Stimulsoft.Base.Drawing;\nusing Stimulsoft.Report;\nusing Stimulsoft.Report.Dialogs;\nusing Stimulsoft.Report.Components;\n\nnamespace Reports\n{\n    public class Report : Stimulsoft.Report.StiReport\n    {\n        \n        public Report()\n        {\n            this.InitializeComponent();\n        }\n\n        #region StiReport Designer generated code - do not modify\n        #endregion StiReport Designer generated code - do not modify\n    }\n}\n";
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        if (this.pages != null) {
            for (StiPage page : this.pages) {
                page.convert(oldUnit, newUnit);
            }
        }
    }

    public final void setInfo(StiDesignerInfo value) {
        this.designerInfo = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StiGraphics getGlobalMeasureGraphics() {
        Object object = lockGlobalMeasureGraphics;
        synchronized (object) {
            if (globalMeasureGraphics == null) {
                globalMeasureGraphics = StiGraphics.fromImage((BufferedImage)new BufferedImage(1, 1, 2));
            }
            return globalMeasureGraphics;
        }
    }

    public StiGraphics getReportMeasureGraphics() {
        if (this.reportMeasureGraphics == null) {
            this.reportMeasureGraphics = StiGraphics.fromImage((BufferedImage)new BufferedImage(1, 1, 2));
        }
        return this.reportMeasureGraphics;
    }

    public final int getPageNumberThrough() {
        if (this.getEngineVersion() == StiEngineVersion.EngineV1) {
            throw new RuntimeException("You can use system variable 'PageNumberThrough' only with EngineV2.");
        }
        return this.getEngine().pageNumbers.GetPageNumberThrough(this.getCurrentPrintPage() - 1);
    }

    public final int getTotalPageCountThrough() {
        if (this.getEngineVersion() == StiEngineVersion.EngineV1) {
            throw new RuntimeException("You can use system variable 'TotalPageCountThrough' only with EngineV2.");
        }
        return this.getEngine().pageNumbers.GetTotalPageCountThrough(this.getCurrentPrintPage() - 1);
    }

    public int getPageNumber() {
        if (this.getEngine() != null && this.getEngine().pageNumbers != null) {
            return this.getEngine().pageNumbers.GetPageNumber(this.getCurrentPrintPage() - 1);
        }
        return this.pageNumber;
    }

    public final String getPageNofM() {
        if (this.getPageNofMLocalizationString() != null) {
            return String.format(this.getPageNofMLocalizationString(), this.getPageNumber(), this.getTotalPageCount());
        }
        if (StiLocalization.getLocalization().getCultureName().equals("en")) {
            return String.format("Page %1$s of %2$s", this.getPageNumber(), this.getTotalPageCount());
        }
        return String.format(StiLocalization.getFormatValue((String)"Report", (String)"PageNofM"), this.getPageNumber(), this.getTotalPageCount());
    }

    public final String getPageNofMThrough() {
        if (this.getEngineVersion() == StiEngineVersion.EngineV1) {
            throw new RuntimeException("You can use system variable 'PageNofMThrough' only with EngineV2.");
        }
        if (this.getPageNofMLocalizationString() != null) {
            return String.format(this.getPageNofMLocalizationString(), this.getPageNumber(), this.getTotalPageCount());
        }
        if (StiLocalization.getLocalization().getCultureName().equals("en")) {
            return String.format("Page %1$s of %2$s", this.getPageNumberThrough(), this.getTotalPageCountThrough());
        }
        return String.format(StiLocalization.Get((String)"Report", (String)"PageNofM"), this.getPageNumberThrough(), this.getTotalPageCountThrough());
    }

    public final String getPageNofMLocalizationString() {
        return this.pageNofMLocalizationString;
    }

    public final void setPageNofMLocalizationString(String value) {
        this.pageNofMLocalizationString = value;
    }

    public StiDesignerInfo getInfo() {
        if (this.designerInfo == null) {
            this.designerInfo = new StiDesignerInfo(this);
        }
        return this.designerInfo;
    }

    public final void setPageNumber(int value) {
        this.pageNumber = value;
    }

    public int getTotalPageCount() {
        if (this.getEngine() != null && this.getEngine().pageNumbers != null) {
            return this.getEngine().pageNumbers.GetTotalPageCount(this.getCurrentPrintPage() - 1);
        }
        return this.totalPageCountValue;
    }

    public final void setTotalPageCount(int value) {
        this.totalPageCountValue = value;
    }

    public final StiReportPass getReportPass() {
        return this.reportPass;
    }

    public final void setReportPass(StiReportPass value) {
        this.reportPass = value;
    }

    public final boolean getIsRendering() {
        return this.isRendering;
    }

    public final void setIsRendering(boolean value) {
        this.isRendering = value;
    }

    public void addPage(StiPage page) {
        for (StiComponent component : page.getComponents()) {
            component.setPage(page);
        }
        this.pages.add(page);
        page.setReport(this);
    }

    public void setReference(int reference) {
    }

    public int getReference() {
        return 0;
    }

    public void setDictionary(StiDictionary dictionary) {
        dictionary.setReport(this);
        this.dictionary = dictionary;
    }

    @StiSerializable
    public StiDictionary getDictionary() {
        return this.dictionary;
    }

    public String getEngineVersionStr() {
        return this.engineVersion.name();
    }

    @StiSerializable
    public String getReportFile() {
        return this.reportFile;
    }

    @StiSerializable
    public String getScript() {
        return this.script;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public final StiUnit getUnit() {
        return StiUnit.GetUnitFromReportUnit(this.getReportUnit());
    }

    public final void setUnit(StiUnit value) {
        if (value instanceof StiCentimetersUnit) {
            this.setReportUnit(StiReportUnitType.Centimeters);
        } else if (value instanceof StiMillimetersUnit) {
            this.setReportUnit(StiReportUnitType.Millimeters);
        } else if (value instanceof StiInchesUnit) {
            this.setReportUnit(StiReportUnitType.Inches);
        } else if (value instanceof StiHundredthsOfInchUnit) {
            this.setReportUnit(StiReportUnitType.HundredthsOfInch);
        }
    }

    @StiSerializable
    public final StiBeginRenderEvent getBeginRenderEvent() {
        return this.beginRenderEvent;
    }

    public final void setBeginRenderEvent(StiBeginRenderEvent value) {
        this.beginRenderEvent = value;
    }

    @StiSerializable
    public final StiRenderingEvent getRenderingEvent() {
        return this.renderingEvent;
    }

    public final void setRenderingEvent(StiRenderingEvent value) {
        this.renderingEvent = value;
    }

    @StiSerializable
    public final StiEndRenderEvent getEndRenderEvent() {
        return this.endRenderEvent;
    }

    public final void setEndRenderEvent(StiEndRenderEvent value) {
        this.endRenderEvent = value;
    }

    @StiSerializable
    public final StiExportingEvent getExportingEvent() {
        return this.exportingEvent;
    }

    public final void setExportingEvent(StiExportingEvent value) {
        this.exportingEvent = value;
    }

    @StiSerializable
    public final StiExportedEvent getExportedEvent() {
        return this.exportedEvent;
    }

    public final void setExportedEvent(StiExportedEvent value) {
        this.exportedEvent = value;
    }

    @StiSerializable
    public final StiPrintingEvent getPrintingEvent() {
        return this.printingEvent;
    }

    public final void setPrintingEvent(StiPrintingEvent value) {
        this.printingEvent = value;
    }

    @StiSerializable
    public final StiPrintedEvent getPrintedEvent() {
        return this.printedEvent;
    }

    public final void setPrintedEvent(StiPrintedEvent value) {
        this.printedEvent = value;
    }

    @StiSerializable
    public StiMetaTagCollection getMetaTags() {
        return this.metaTags;
    }

    public void setMetaTags(StiMetaTagCollection metaTags) {
        this.metaTags = metaTags;
    }

    @StiSerializable
    public final String getReportVersion() {
        return this.reportVersion;
    }

    public final void setReportVersion(String value) {
        this.reportVersion = value;
    }

    @StiSerializable
    public final String getReportGuid() {
        return this.reportGuid;
    }

    public final void setReportGuid(String value) {
        this.reportGuid = value;
    }

    public StiRuntimeVariables getAnchor(Object value) {
        if (value == null) {
            return new StiRuntimeVariables(this);
        }
        return this.anchors.containsKey(value) ? (StiRuntimeVariables)this.anchors.get(value) : null;
    }

    public int getPageIndex(int index) {
        int num = 1;
        int ind = 0;
        StiPagesCollection pages = null;
        pages = this.getIsDesigning() ? this.pages : this.renderedPages;
        for (StiPage page : pages) {
            if (ind == index) {
                return num;
            }
            num += page.segmentPerWidth * page.segmentPerHeight;
            ++ind;
        }
        return index;
    }

    @StiSerializable
    public final StiPagesCollection getPages() {
        return this.pages;
    }

    public void setPages(StiPagesCollection pages) {
        this.pages = pages;
        pages.setReport(this);
    }

    @StiSerializable
    public final String getReportName() {
        return this.reportName;
    }

    public final void setReportName(String value) {
        if (this.reportName.equals(this.reportAlias)) {
            this.reportAlias = value;
        }
        this.reportName = !StiOptions.Designer.getAutoCorrectReportName() ? value : StiNameValidator.CorrectName(value);
    }

    @StiSerializable
    public final String getReportAlias() {
        return this.reportAlias;
    }

    public final void setReportAlias(String value) {
        this.reportAlias = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getReportAuthor() {
        return this.reportAuthor;
    }

    public final void setReportAuthor(String value) {
        this.reportAuthor = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getReportDescription() {
        return this.reportDescription;
    }

    public final void setReportDescription(String value) {
        this.reportDescription = value;
    }

    @StiSerializable
    public final Calendar getReportCreated() {
        return this.reportCreated;
    }

    public final void setReportCreated(Calendar value) {
        this.reportCreated = value;
    }

    @StiSerializable
    public final Calendar getReportChanged() {
        return this.reportChanged;
    }

    public final void setReportChanged(Calendar value) {
        this.reportChanged = value;
    }

    @Override
    @StiSerializable
    public final StiEngineVersion getEngineVersion() {
        return StiEngineVersion.EngineV2;
    }

    @Override
    public final void setEngineVersion(StiEngineVersion value) {
        if (this.engineVersion != value) {
            if (value == StiEngineVersion.All) {
                value = StiEngineVersion.EngineV1;
            }
            this.engineVersion = value;
        }
    }

    @StiSerializable
    public final StiStylesCollection getStyles() {
        return this.styles;
    }

    public void setStyles(StiStylesCollection styles) {
        this.styles = styles;
    }

    @StiSerializable
    @StiDefaulValue(value="SinglePass")
    public final StiNumberOfPass getNumberOfPass() {
        return this.numberOfPass;
    }

    public final void setNumberOfPass(StiNumberOfPass value) {
        if (this.numberOfPass != value) {
            this.numberOfPass = value;
        }
    }

    @StiSerializable
    @StiDefaulValue(value="Compilation")
    public final StiCalculationMode getCalculationMode() {
        return this.calculationMode;
    }

    public final void setCalculationMode(StiCalculationMode value) {
        if (this.calculationMode != value) {
            // empty if block
        }
    }

    @StiSerializable(isRef=false)
    public final StiReportUnitType getReportUnit() {
        return this.reportUnit;
    }

    public final void setReportUnit(StiReportUnitType value) {
        StiUnit newUnit = StiUnit.GetUnitFromReportUnit(value);
        if (!this.getIsSerializing() && this.reportUnit != value) {
            this.convert(StiUnit.GetUnitFromReportUnit(this.reportUnit), StiUnit.GetUnitFromReportUnit(value));
        }
        this.reportUnit = value;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getCacheAllData() {
        return this.cacheAllData;
    }

    public final void setCacheAllData(boolean value) {
        this.cacheAllData = value;
    }

    @StiSerializable
    @StiDefaulValue(value="Off")
    public final StiReportCacheMode getReportCacheMode() {
        return this.reportCacheMode;
    }

    public final void setReportCacheMode(StiReportCacheMode value) {
        this.reportCacheMode = value;
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getConvertNulls() {
        return this.convertNulls;
    }

    public final void setConvertNulls(boolean value) {
        this.convertNulls = value;
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getStoreImagesInResources() {
        return this.storeImagesInResources;
    }

    public final void setStoreImagesInResources(boolean value) {
        this.storeImagesInResources = value;
    }

    @StiSerializable
    @StiDefaulValue(value="Standard")
    public final StiPreviewMode getPreviewMode() {
        return this.previewMode;
    }

    public final void setPreviewMode(StiPreviewMode value) {
        this.previewMode = value;
    }

    @StiSerializable
    @StiDefaulValue(value="0")
    public final int getStopBeforePage() {
        return this.stopBeforePage;
    }

    public final void setStopBeforePage(int value) {
        if (value >= 0) {
            this.stopBeforePage = value;
        }
    }

    @StiSerializable
    @StiDefaulValue(value="268435455")
    public final int getPreviewSettings() {
        return this.previewSettings;
    }

    public final void setPreviewSettings(int value) {
        this.previewSettings = value;
    }

    @StiSerializable
    @StiDefaulValue(value="1")
    public final int getCollate() {
        return this.collate;
    }

    public final void setCollate(int value) {
        if (this.collate != value) {
            this.collate = Math.max(1, value);
        }
    }

    @StiSerializable
    public final StiPrinterSettings getPrinterSettings() {
        return this.printerSettings;
    }

    public final void setPrinterSettings(StiPrinterSettings value) {
        this.printerSettings = value;
    }

    @StiSerializable
    public final ArrayList<String> getReferencedAssemblies() {
        return this.referencedAssemblies;
    }

    public final void setReferencedAssemblies(ArrayList<String> value) {
        this.referencedAssemblies = value;
    }

    @StiSerializable
    public final StiReportLanguageType getScriptLanguage() {
        return this.scriptLanguage;
    }

    public final void setScriptLanguage(StiReportLanguageType value) {
        if (this.scriptLanguage != value) {
            this.scriptLanguage = value;
            if (!this.getIsSerializing()) {
                this.scriptNew();
                this.setIsModified(true);
            }
        }
    }

    @StiSerializable
    public final StiGlobalizationContainerCollection getGlobalizationStrings() {
        return this.globalizationStrings;
    }

    public void setGlobalizationStrings(StiGlobalizationContainerCollection globalizationStrings) {
        this.globalizationStrings = globalizationStrings;
    }

    public void localizeReport(String cultureName) throws StiException {
        this.globalizationStrings.setReport(this);
        this.globalizationStrings.localizeReport(cultureName);
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getAutoLocalizeReportOnRun() {
        return this.autoLocalizeReportOnRun;
    }

    public final void setAutoLocalizeReportOnRun(boolean value) {
        this.autoLocalizeReportOnRun = value;
    }

    @StiSerializable
    @StiDefaulValue(value="Horizontal")
    public final StiOrientation getParametersOrientation() {
        return this.parametersOrientation;
    }

    public final void setParametersOrientation(StiOrientation value) {
        this.parametersOrientation = value;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getRequestParameters() {
        return this.requestParameters;
    }

    public final void setRequestParameters(boolean value) {
        this.requestParameters = value;
    }

    public boolean getIsSerializing() {
        return this.isSerializing;
    }

    public final void setIsSerializing(boolean value) {
        this.isSerializing = value;
    }

    public final boolean getIsModified() {
        return this.isModified;
    }

    public final void setIsModified(boolean value) {
        if (this.isModified != value) {
            String newReportGuid;
            this.isModified = value;
            this.reportGuid = newReportGuid = this.GenerateReportGuid();
        }
    }

    private String GenerateReportGuid() {
        return StiGuid.newGuid().toString().replace("-", "");
    }

    private void scriptNew() {
        StringBuilder sb = new StringBuilder();
        if (this.getScriptLanguage() == StiReportLanguageType.CSharp) {
            if (StiOptions.Engine.getNamespaces() != null) {
                for (String name : StiOptions.Engine.getNamespaces()) {
                    sb = sb.append(String.format("using %1$s;", name));
                    sb = sb.append("\n");
                }
            }
            sb = sb.append("\n");
            sb = sb.append(String.format("namespace %1$s", StiOptions.Engine.getDefaultNamespace()));
            sb = sb.append("\n");
            sb = sb.append("{");
            sb = sb.append(String.format("    public class %1$s : %2$s", this.getReportName(), StiOptions.Engine.getBaseReportType().toString()));
            sb = sb.append("\n");
            sb = sb.append("    {");
            sb = sb.append(String.format("        public %1$s()", this.getReportName()));
            sb = sb.append("        {");
            sb = sb.append("            this.InitializeComponent();");
            sb = sb.append("        }");
            sb = sb.append("\n");
            sb = sb.append("        #region StiReport Designer generated code - do not modify");
            sb = sb.append("        #endregion StiReport Designer generated code - do not modify");
            sb = sb.append("    }");
            sb = sb.append("}");
        } else {
            if (StiOptions.Engine.getNamespaces() != null) {
                for (String name : StiOptions.Engine.getNamespaces()) {
                    sb = sb.append(String.format("Imports %1$s", name));
                    sb = sb.append("\n");
                }
            }
            sb = sb.append("\n");
            sb = sb.append(String.format("Namespace %1$s", StiOptions.Engine.getDefaultNamespace()));
            sb = sb.append("\n");
            sb = sb.append(String.format("    Public Class %1$s", this.getReportName()));
            sb = sb.append("\n");
            sb = sb.append(String.format("        Inherits %1$s", StiOptions.Engine.getBaseReportType().toString()));
            sb = sb.append("\n");
            sb = sb.append("\n");
            sb = sb.append("        Public Sub New()");
            sb = sb.append("            MyBase.New");
            sb = sb.append("            Me.InitializeComponent");
            sb = sb.append("        End Sub");
            sb = sb.append("\n");
            sb = sb.append("        #Region \"StiReport Designer generated code - do not modify\"");
            sb = sb.append("        #End Region 'StiReport Designer generated code - do not modify");
            sb = sb.append("    End Class");
            sb = sb.append("End Namespace");
        }
        this.script = sb.toString();
    }

    public StiDataSourcesCollection getDataSources() {
        return this.dictionary.getDataSources();
    }

    public StiEngine getEngine() {
        return this.engine;
    }

    public final void setEngine(StiEngine value) {
        this.engine = value;
    }

    public ArrayList<StiBusinessObjectData> getBusinessObjectsStore() {
        if (this.businessObjectsStore == null) {
            this.businessObjectsStore = new ArrayList();
        }
        return this.businessObjectsStore;
    }

    public StiComponentsCollection GetComponents() {
        StiComponentsCollection comps = new StiComponentsCollection();
        for (StiPage page : this.pages) {
            comps.add(page);
            comps.addAll(page.GetComponents());
        }
        return comps;
    }

    public StiComponentsCollection GetRenderedComponents() {
        StiComponentsCollection comps = new StiComponentsCollection();
        for (StiPage page : this.getRenderedPages()) {
            comps.add(page);
            comps.addAll(page.GetComponents());
        }
        return comps;
    }

    public void applyStyleCollection(String collectionName) {
        if (StiValidationUtil.isNullOrEmpty((String)collectionName)) {
            return;
        }
        collectionName = collectionName.toLowerCase().trim();
        ArrayList<StiBaseStyle> themStyles = new ArrayList<StiBaseStyle>();
        for (StiBaseStyle style : this.getStyles()) {
            if (!StiValidationUtil.equals((Object)style.getCollectionName().toLowerCase().trim(), (Object)collectionName)) continue;
            themStyles.add(style);
        }
        StiComponentsCollection comps = this.GetComponents();
        for (StiComponent comp : comps) {
            if (comp instanceof StiPage) continue;
            for (StiBaseStyle style : themStyles) {
                if (!StiStyleConditionHelper.isAllowStyle(comp, style) || comp instanceof StiChart) continue;
                if (comp instanceof StiDataBand) {
                    boolean isOddStyleDataBand = false;
                    boolean isEvenStyleDataBand = false;
                    for (StiStyleCondition condition : style.getConditions()) {
                        if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.DataOddStyle.getValue()) > 0) {
                            isOddStyleDataBand = true;
                            break;
                        }
                        if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.DataEvenStyle.getValue()) <= 0) continue;
                        isEvenStyleDataBand = true;
                        break;
                    }
                    if (isOddStyleDataBand) {
                        ((StiDataBand)comp).setOddStyle(style.getName());
                        continue;
                    }
                    if (isEvenStyleDataBand) {
                        ((StiDataBand)comp).setEvenStyle(style.getName());
                        continue;
                    }
                    comp.setComponentStyle(style.getName());
                    continue;
                }
                comp.setComponentStyle(style.getName());
            }
        }
        this.applyStyles();
    }

    public void applyStyles() {
        StiComponentsCollection comps = this.GetComponents();
        for (StiComponent comp : comps) {
            StiBaseStyle style;
            if (comp instanceof StiChart && ((StiChart)comp).getAllowApplyStyle() && ((StiChart)comp).getStyle() != null) {
                StiChartStyle style2;
                IStiChartStyle chartStyle = ((StiChart)comp).getStyle();
                ((StiChart)comp).getCore().applyStyle(chartStyle);
                StiCustomStyle customStyle = chartStyle instanceof StiCustomStyle ? (StiCustomStyle)chartStyle : null;
                if (customStyle == null || (style2 = customStyle.getCore() instanceof StiCustomStyleCoreXF ? ((StiCustomStyleCoreXF)customStyle.getCore()).getReportStyle() : null) == null) continue;
                style2.SetStyleToComponent(comp);
                continue;
            }
            if (StiValidationUtil.isNullOrEmpty((String)comp.getComponentStyle()) || (style = this.styles.get(comp.getComponentStyle())) == null) continue;
            style.SetStyleToComponent(comp);
        }
    }

    public void correctFormatProperties() {
        StiComponentsCollection comps = this.GetComponents();
        for (StiComponent comp : comps) {
            StiText text = comp instanceof StiText ? (StiText)comp : null;
            if (text == null || text.getTextFormat() instanceof StiGeneralFormatService) continue;
            StiFormatService storedService = text.getTextFormat();
            text.setTextFormat(null);
            text.setTextFormat(storedService);
        }
    }

    public void RenameStyle(String oldStylename, String newStyleName) {
        StiComponentsCollection comps = this.getComponents();
        for (StiComponent comp : comps) {
            if (!oldStylename.equals(comp.getComponentStyle())) continue;
            comp.setComponentStyle(newStyleName);
        }
    }

    public StiComponentsCollection getComponents() {
        StiComponentsCollection comps = new StiComponentsCollection();
        for (StiPage page : this.pages) {
            comps.add(page);
            comps.AddRange(page.GetComponents());
        }
        return comps;
    }

    public int getComponentsCount() {
        int count = 0;
        for (StiPage page : this.pages) {
            ++count;
            count += page.GetComponentsCount();
        }
        return count;
    }

    public StiVariablesMap getVariables() {
        return this.variables;
    }

    public void setVariables(StiVariablesMap variables) {
        this.variables = variables;
    }

    public final boolean getIsPageDesigner() {
        return this.isPageDesigner;
    }

    public final void setIsPageDesigner(boolean value) {
        this.isPageDesigner = value;
    }

    public final void WriteToReportRenderingMessages(String str) {
        if (this.getReportRenderingMessages() == null) {
            this.setReportRenderingMessages(new ArrayList<String>());
        }
        this.getReportRenderingMessages().add(str);
    }

    public final ArrayList<String> getReportRenderingMessages() {
        return this.reportRenderingMessages;
    }

    public final void setReportRenderingMessages(ArrayList<String> value) {
        this.reportRenderingMessages = value;
    }

    public void setCompiledReport(StiReport compiledReport) {
        this.compiledReport = compiledReport;
    }

    public StiReport getCompiledReport() {
        return this.compiledReport;
    }

    public final StiBookmark getBookmark() {
        if (this.getCompiledReport() != null) {
            return this.getCompiledReport().getBookmark();
        }
        return this.bookmarkValue;
    }

    public final void setBookmark(StiBookmark value) {
        this.bookmarkValue = value;
        if (this.getCompiledReport() != null) {
            this.getCompiledReport().setBookmark(value);
        }
    }

    public int getSelectionTick() {
        return this.selectionTick;
    }

    @StiSerializable(enhanced=true)
    public final StiPagesCollection getRenderedPages() {
        return this.renderedPages;
    }

    public final void setRenderedPages(StiPagesCollection pagesCollection) {
        this.renderedPages = pagesCollection;
        this.renderedPages.fillReport(this);
        this.renderedPages.fillPageInChildren();
    }

    public final boolean getIsDesigning() {
        return this.designerInfo.getForceDesigningMode();
    }

    public final boolean getIsExporting() {
        return this.isExporting;
    }

    public final boolean getIsPrinting() {
        return this.isPrintingValue;
    }

    public final void setIsPrinting(boolean value) {
        this.isPrintingValue = value;
    }

    public final int getCurrentPrintPage() {
        return this.currentPrintPage;
    }

    public final void setCurrentPrintPage(int value) {
        this.currentPrintPage = value;
    }

    public boolean getStop() {
        return this.stop;
    }

    public final void setStop(boolean value) {
        this.stop = value;
    }

    public void invokeRendering() {
        this.handlerRendering.invoke(new StiEventObject((Object)this));
    }

    public final StiReport getParentReport() {
        return this.parentReport;
    }

    public final void setParentReport(StiReport value) {
        this.parentReport = value;
    }

    public final int getColumn() {
        return this.column;
    }

    public final void setColumn(int value) {
        this.column = value;
    }

    public final boolean getIsStopped() {
        return this.isStopped;
    }

    public final void setIsStopped(boolean value) {
        this.isStopped = value;
    }

    public final boolean getIsRendered() {
        return this.isRendered;
    }

    public final void setIsRendered(boolean value) {
        this.isRendered = value;
    }

    public void Compile() {
    }

    public void invokeRefreshViewer() {
        this.handlerRefreshPreview.invoke(new StiEventObject((Object)this));
        this.handlerRefreshViewer.invoke(new StiEventObject((Object)this));
        if (this.compiledReport != null) {
            this.compiledReport.invokeRefreshViewer();
        }
    }

    public void setGroupLine(int GroupLine) {
        this.GroupLine = GroupLine;
    }

    public StiInteraction getInteraction() {
        return null;
    }

    public void invokeBeginRender() {
        this.handlerBeginRender.invoke(new StiEventObject((Object)this));
    }

    public void ResetAggregateFunctions() {
    }

    public void InvokeEndRender() {
        if (this.getCalculationMode() == StiCalculationMode.Interpretation) {
            for (Map.Entry<String, Object> entry : this.getTotals().entrySet()) {
                String compName = entry.getKey() instanceof String ? entry.getKey() : null;
                if (compName == null || !compName.startsWith("#%#")) continue;
                Object tempVar = this.GetComponentByName(compName.substring(3)).clone();
                ((StiText)(tempVar instanceof StiText ? tempVar : null)).SetText(null, null);
            }
        }
        this.handlerEndRender.invoke(new StiEventObject((Object)this));
    }

    public final StiComponent GetComponentByName(String componentName) {
        for (StiPage page : this.getPages()) {
            if (!page.getName().equals(componentName)) continue;
            return page;
        }
        return this.getPages().GetComponentByName(componentName);
    }

    public final StiReport render() {
        this.Render();
        return this;
    }

    public final void Render() {
        this.Render(false);
    }

    public final void Render(boolean showProgress) {
        this.Render(showProgress, -1, -1);
    }

    public final void Render(boolean showProgress, int fromPage, int toPage) {
        this.Render(new StiRenderState(fromPage, toPage, showProgress));
    }

    public void Render(StiRenderState renderState) {
        this.setCalculationMode(StiCalculationMode.Interpretation);
        StiBookmark bookmark = new StiBookmark();
        bookmark.engine = this.getEngineVersion();
        this.setBookmark(bookmark);
        this.isEditedInViewer = false;
        if (StiOptions.Engine.getHideRenderingProgress()) {
            renderState.showProgress = false;
        }
        if (StiOptions.Engine.hideMessages) {
            renderState.showProgress = false;
        }
        if (renderState.showProgress && this.getReportPass() != StiReportPass.First && !renderState.getIsSubReportMode()) {
            try {
                if (this.getProgress() == null) {
                    this.setProgress(new StiProgressInformationDialog(null));
                }
                if (this.getProgress() != null) {
                    this.getProgress().setIsMarquee(true);
                }
                if ((StiOptions.Engine.getAllowProgressInThread() || this.getUseProgressInThread()) && this.getProgress() != null) {
                    this.getProgress().setAllowUseDoEvents(false);
                }
                if (this.getProgress() != null) {
                    this.getProgress().hideProgressBar();
                    this.getProgress().setAllowClose(false);
                    if (StiLocalization.getLocalization().getCultureName().equals("en")) {
                        this.getProgress().start("Preparing Report");
                    } else {
                        this.getProgress().start(StiLocalization.getValue((String)"Report", (String)"PreparingReport"));
                    }
                }
                this.RenderReport(renderState);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (this.getProgress() != null && this.getReportPass() != StiReportPass.First && !renderState.getIsSubReportMode()) {
                    this.getProgress().close();
                    this.setProgress(null);
                    this.setStatusString("");
                    if (this.getCompiledReport() != null) {
                        this.getCompiledReport().setProgress(null);
                    }
                }
            }
        } else {
            this.RenderReport(renderState);
        }
        if (StiOptions.Engine.getComponentsStabilizationValue() > 0.0) {
            this.stabilizeComponentsPosition();
        }
        if (this.getReportPass() != StiReportPass.First) {
            this.isWpf = false;
            if (this.getCompiledReport() != null) {
                this.getCompiledReport().isWpf = false;
            }
        }
    }

    private void stabilizeComponentsPosition() {
        for (StiPage page : this.getRenderedPages()) {
            for (StiComponent component : page.getComponents()) {
                for (StiComponent component2 : page.getComponents()) {
                    if (!(Math.abs(component.getTop() - component2.getTop() - component2.getHeight()) < StiOptions.Engine.getComponentsStabilizationValue())) continue;
                    component2.setHeight(component.getTop() - component2.getTop());
                }
            }
        }
    }

    public boolean getUseProgressInThread() {
        return this.useProgressInThread;
    }

    public void setUseProgressInThread(boolean value) {
        this.useProgressInThread = value;
    }

    public void processAutoLocalizeReportOnRun() {
        if (!this.autoLocalizeReportOnRun) {
            return;
        }
        try {
            this.localizeReport(this.culture);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RenderReport(StiRenderState renderState) {
        this.processAutoLocalizeReportOnRun();
        if (this.getEngine() != null && this.getEngine().getPageNumbers() != null) {
            this.getEngine().getPageNumbers().ClearNotFixed();
        }
        if (this.getCalculationMode() == StiCalculationMode.Interpretation && this.getDictionary().getVariables().size() > 0) {
            boolean flagVar;
            boolean bl = flagVar = this.getVariables() == null;
            if (!flagVar) {
                Iterator i$ = this.getDictionary().getVariables().iterator();
                while (i$.hasNext()) {
                    StiVariable var = (StiVariable)i$.next();
                    if (this.getVariables().containsKey(var.getName())) continue;
                    flagVar = true;
                }
            }
            if (flagVar) {
                StiText tempText = new StiText();
                tempText.setName("**ReportVariables**");
                tempText.setPage(this.getPages().get(0));
                Iterator i$ = this.getDictionary().getVariables().iterator();
                while (i$.hasNext()) {
                    StiVariable var = (StiVariable)i$.next();
                    Object obj = null;
                    try {
                        obj = StiParser.prepareVariableValue(var, this, tempText);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.setVariable(var.getName(), obj);
                }
                this.modifiedVariables.clear();
            }
        }
        try {
            Hashtable<StiComponent, StiInteraction> storeInteraction = new Hashtable<StiComponent, StiInteraction>();
            if (this.getCalculationMode() == StiCalculationMode.Interpretation) {
                StiComponentsCollection comps = this.getComponents();
                for (StiComponent comp : comps) {
                    if (comp.getInteraction() == null || !comp.getInteraction().isDefault()) continue;
                    storeInteraction.put(comp, comp.getInteraction());
                    comp.setInteraction(null);
                }
            }
            if (this.getSubReports() != null && this.getSubReports().size() > 0) {
                if (this.getEngineVersion() != StiEngineVersion.EngineV1) {
                    StiReportV2Builder.RenderSubReports(this, renderState);
                }
            } else if (this.getEngineVersion() != StiEngineVersion.EngineV1) {
                StiReportV2Builder.RenderSingleReport(this, renderState);
            }
            if (this.getCalculationMode() == StiCalculationMode.Interpretation) {
                for (Map.Entry de : storeInteraction.entrySet()) {
                    StiComponent comp;
                    comp = (StiComponent)de.getKey();
                    comp.setInteraction((StiInteraction)de.getValue());
                }
                storeInteraction.clear();
            }
        }
        finally {
            if (this.reportPass == StiReportPass.First && this.anchors != null) {
                this.anchors.clear();
            }
        }
        this.isDocument = false;
    }

    public final IStiProgressInformation getProgress() {
        return this.progress;
    }

    public final void setProgress(IStiProgressInformation value) {
        this.progress = value;
    }

    public ArrayList<StiReport> getSubReports() {
        return this.subReports;
    }

    public final void setSubReports(ArrayList<StiReport> value) {
        this.subReports = value;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
        if (this.statusHandler != null) {
            this.statusHandler.updateStatus(statusString);
        }
    }

    public final Object CheckExcelValue(Object sender, Object value) {
        StiText text = (StiText)(sender instanceof StiText ? sender : null);
        if (text != null && text.getFormat() != null && !text.getFormat().equals("G") && text.getFormat().length() != 0) {
            text.setExcelDataValue(this.ToString(value));
        }
        return value;
    }

    public final String ToString(Object obj) {
        if (obj == null || obj == DBNull.Value) {
            return "";
        }
        return obj.toString();
    }

    public final String ToString(Object sender, Object obj) {
        return this.ToString(sender, obj, false);
    }

    public final String ToString(Object sender, Object obj, boolean allowExcelCheck) {
        if (allowExcelCheck) {
            return this.ToString(this.CheckExcelValue(sender, obj));
        }
        return this.ToString(obj);
    }

    public final boolean getIsFirstPage() {
        return this.getPageNumber() == 1;
    }

    public final boolean getIsLastPage() {
        return this.getPageNumber() == this.getTotalPageCount();
    }

    public final boolean getIsFirstPageThrough() {
        return this.getPageNumberThrough() == 1;
    }

    public final boolean getIsLastPageThrough() {
        return this.getPageNumberThrough() == this.getTotalPageCountThrough();
    }

    public final boolean getIsFirstPass() {
        return this.getReportPass() == StiReportPass.First || this.getReportPass() == StiReportPass.None;
    }

    public final boolean getIsSecondPass() {
        return this.getReportPass() == StiReportPass.Second;
    }

    public final int getCurrentPage() {
        return this.currentPage;
    }

    public final void setCurrentPage(int value) {
        this.currentPage = value;
    }

    public void setLine(int line) {
        this.Line = line;
    }

    public int getLine() {
        return this.Line;
    }

    public final boolean getNeedsCompiling() {
        if (this.getCalculationMode() == StiCalculationMode.Interpretation) {
            return false;
        }
        return this.needsCompiling;
    }

    public final void setNeedsCompiling(boolean value) {
        this.needsCompiling = value;
    }

    public final Object getVariable(String name) {
        if (this.getVariables() == null) {
            return null;
        }
        return this.getVariables().get(name);
    }

    public final void setVariable(String name, Object value) {
        StiReport report = this;
        if (report.getVariables() == null) {
            report.variables = new StiVariablesMap(this);
        }
        report.getVariables().put(name, value);
        report.modifiedVariables.put(name, true);
    }

    public final double convertToHInches(StiUnit unit, double value) {
        if (unit instanceof StiCentimetersUnit) {
            if (value == 21.0) {
                return 827.0;
            }
            if (value == 29.7) {
                return 1169.0;
            }
            if (value == 1.0) {
                return 39.0;
            }
        } else if (unit instanceof StiMillimetersUnit) {
            if (value == 210.0) {
                return 827.0;
            }
            if (value == 297.0) {
                return 1169.0;
            }
            if (value == 10.0) {
                return 39.0;
            }
        }
        return unit.ConvertToHInches(value);
    }

    public final StiRectangle convertToHInches(StiUnit unit, StiRectangle value) {
        return new StiRectangle(this.convertToHInches(unit, value.getX()), this.convertToHInches(unit, value.getY()), this.convertToHInches(unit, value.getWidth()), this.convertToHInches(unit, value.getHeight()));
    }

    public void exportDocument(StiExportFormat exportFormat, StiExportService exportService, File file, StiExportSettings settings, JFrame parent) throws Throwable {
        this.invokeExporting(exportFormat);
        if (settings == null) {
            settings = exportFormat.getDefaultExportSettings();
        }
        FileOutputStream fos = new FileOutputStream(file);
        exportService.setOutputStream(fos);
        exportService.setExFile(file);
        exportService.setExportReport(this);
        exportService.setExportSettings(settings);
        exportService.export();
        this.invokeExported(exportFormat);
        fos.close();
    }

    public void invokeExported(StiExportFormat exportFormat) {
        this.isExporting = false;
        StiExportEventArgs args = new StiExportEventArgs(exportFormat);
        this.onExported(args);
    }

    protected void onExported(StiExportEventArgs e) {
        this.handlerExported.invoke(new StiEventObject((Object)this, (StiEventHandlerArgs)e));
    }

    public void invokeExporting(StiExportFormat exportFormat) {
        this.isExporting = true;
        StiExportEventArgs args = new StiExportEventArgs(exportFormat);
        this.onExporting(args);
    }

    protected void onExporting(StiExportEventArgs e) {
        this.handlerExporting.invoke(new StiEventObject((Object)this, (StiEventHandlerArgs)e));
    }

    public void invokePaint(StiEventHandlerArgs e) {
        this.handlerPaint.invoke(new StiEventObject((Object)this, e));
    }

    public void invokePrinted() {
        this.onPrinted(StiEventHandlerArgs.Empty);
    }

    private void onPrinted(StiEventHandlerArgs e) {
        this.handlerPrinted.invoke(new StiEventObject((Object)this, e));
    }

    public void invokePrinting() {
        this.onPrinting(StiEventHandlerArgs.Empty);
    }

    private void onPrinting(StiEventHandlerArgs e) {
        this.handlerPrinted.invoke(new StiEventObject((Object)this, e));
    }

    public void invokeRefreshPreview() {
        this.invokeRefreshViewer();
    }

    public void invokeStatusChanged() {
        this.handlerStatusChanged.invoke(new StiEventObject((Object)this));
    }

    public final Hashtable<String, Object> getTotals() {
        if (this.getParentReport() != null) {
            return this.getParentReport().totals;
        }
        return this.totals;
    }

    public final void setTotals(Hashtable<String, Object> value) {
        if (this.getParentReport() != null) {
            this.getParentReport().totals = value;
        } else {
            this.totals = value;
        }
    }

    public void saveDocument(OutputStream stream) {
        StiXmlDocumentSLService service = new StiXmlDocumentSLService();
        service.save(this, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveDocumentToString() throws IOException {
        ByteArrayOutputStream os = null;
        String result = "";
        try {
            os = new ByteArrayOutputStream();
            this.saveDocument(os);
            os.flush();
            result = new String(os.toByteArray());
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        return result;
    }

    public StiStatusHandler getStatusHandler() {
        return this.statusHandler;
    }

    public void setStatusHandler(StiStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public boolean isInterpretation() {
        return this.getCalculationMode() == StiCalculationMode.Interpretation;
    }

    public boolean isPreviewDialogs() {
        return this.previewDialogs;
    }

    public void setPreviewDialogs(boolean previewDialogs) {
        this.previewDialogs = previewDialogs;
    }

    @StiSerializable
    public Boolean getIsSubmit() {
        return this.isSubmit;
    }

    public void setIsSubmit(Boolean isSubmit) {
        this.isSubmit = isSubmit;
    }

    public List<StiCustomFunction> getCustomFunctions() {
        return this.customFunctions;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public HashMap<String, Object> getInteractionCollapsingStates() {
        return this.interactionCollapsingStates;
    }

    public void setInteractionCollapsingStates(HashMap<String, Object> interactionCollapsingStates) {
        this.interactionCollapsingStates = interactionCollapsingStates;
    }

    public boolean isInteractionRendering() {
        return this.isInteractionRendering;
    }

    public void setInteractionRendering(boolean isInteractionRendering) {
        this.isInteractionRendering = isInteractionRendering;
    }

    public Object get(String name) {
        StiReport report = this.compiledReport == null ? this : this.compiledReport;
        try {
            Method method = report.getClass().getMethod("get" + name, new Class[0]);
            return method.invoke((Object)report, new Object[0]);
        }
        catch (Exception e) {
            if (this.getVariables() == null) {
                return null;
            }
            return this.getVariables().get(name);
        }
    }

    public void set(String name, Object value) {
        block3: {
            StiReport report = this.compiledReport == null ? this : this.compiledReport;
            try {
                Method method = report.getClass().getMethod("set" + name, value.getClass());
                method.invoke((Object)report, value);
            }
            catch (Exception e) {
                if (report.getVariables() == null) {
                    report.variables = new StiVariablesMap(this);
                }
                report.variables.put(name, value);
                if (this.getDictionary() == null || !this.getDictionary().getVariables().contains(name)) break block3;
                this.modifiedVariables.put(name, true);
            }
        }
    }

    @StiSerializable
    public String getCulture() {
        return this.culture;
    }

    public void setCulture(String culture) {
        this.culture = culture;
    }

    public Hashtable<String, Boolean> getModifiedVariables() {
        return this.modifiedVariables;
    }

    public void setModifiedVariables(Hashtable<String, Boolean> modifiedVariables) {
        this.modifiedVariables = modifiedVariables;
    }

    public static Object changeType(Object value, StiSystemType conversionType) {
        return StiReport.changeType(value, conversionType, StiOptions.Dictionary.isConvertNulls());
    }

    public static Object changeType(Object value, StiSystemType conversionType, Boolean convertNulls) {
        return StiConvert.changeType(value, conversionType, convertNulls);
    }

    public String[] getListOfUsedData() {
        return this.listOfUsedData;
    }

    public void setListOfUsedData(String[] listOfUsedData) {
        this.listOfUsedData = listOfUsedData;
    }

    @StiSerializable
    public boolean getRetrieveOnlyUsedData() {
        return this.retrieveOnlyUsedData;
    }

    public void setRetrieveOnlyUsedData(boolean retrieveOnlyUsedData) {
        this.retrieveOnlyUsedData = retrieveOnlyUsedData;
    }

    @StiSerializable
    public boolean isJsonReport() {
        return this.jsonReport;
    }

    public void setJsonReport(boolean jsonReport) {
        this.jsonReport = jsonReport;
    }

    public void updateReportVersion() {
        this.reportVersion = StiAttribute.getVersion();
    }

    public String saveToJsonInternal(StiJsonSaveMode mode) throws JSONException {
        JSONObject rootJsonObject = new JSONObject();
        rootJsonObject.AddPropertyStringNullOfEmpty("ReportVersion", this.reportVersion);
        rootJsonObject.AddPropertyStringNullOfEmpty("ReportGuid", this.reportGuid);
        rootJsonObject.AddPropertyStringNullOfEmpty("ReportName", this.reportName);
        rootJsonObject.AddPropertyStringNullOfEmpty("ReportAlias", this.reportAlias);
        rootJsonObject.AddPropertyStringNullOfEmpty("ReportAuthor", this.reportAuthor);
        rootJsonObject.AddPropertyStringNullOfEmpty("ReportDescription", this.reportDescription);
        rootJsonObject.AddPropertyDateTime("ReportCreated", this.reportCreated);
        rootJsonObject.AddPropertyDateTime("ReportChanged", this.getReportChanged());
        rootJsonObject.AddPropertyEnum("EngineVersion", (Enum)this.getEngineVersion());
        rootJsonObject.AddPropertyEnum("NumberOfPass", (Enum)this.getNumberOfPass(), (Enum)StiNumberOfPass.SinglePass);
        rootJsonObject.AddPropertyEnum("CalculationMode", (Enum)this.getCalculationMode(), (Enum)StiCalculationMode.Compilation);
        rootJsonObject.AddPropertyEnum("ReportUnit", (Enum)this.getReportUnit(), (Enum)StiReportUnitType.Centimeters);
        rootJsonObject.AddPropertyBool("CacheAllData", this.getCacheAllData());
        rootJsonObject.AddPropertyEnum("ReportCacheMode", (Enum)this.getReportCacheMode(), (Enum)StiReportCacheMode.Off);
        rootJsonObject.AddPropertyBool("ConvertNulls", this.getConvertNulls(), true);
        rootJsonObject.AddPropertyBool("RetrieveOnlyUsedData", this.getRetrieveOnlyUsedData());
        rootJsonObject.AddPropertyBool("StoreImagesInResources", this.getStoreImagesInResources(), true);
        rootJsonObject.AddPropertyEnum("PreviewMode", (Enum)this.getPreviewMode(), (Enum)StiPreviewMode.Standard);
        rootJsonObject.AddPropertyInt("StopBeforePage", this.getStopBeforePage());
        rootJsonObject.AddPropertyInt("PreviewSettings", this.getPreviewSettings(), StiPreviewSettings.All.getValue() ^ StiPreviewSettings.PageDesign.getValue() ^ StiPreviewSettings.PageDelete.getValue() ^ StiPreviewSettings.PageNew.getValue() ^ StiPreviewSettings.PageSize.getValue());
        rootJsonObject.AddPropertyInt("Collate", this.getCollate(), 1);
        rootJsonObject.AddPropertyEnum("ScriptLanguage", (Enum)this.getScriptLanguage(), (Enum)StiReportLanguageType.CSharp);
        rootJsonObject.AddPropertyBool("AutoLocalizeReportOnRun", this.getAutoLocalizeReportOnRun());
        rootJsonObject.AddPropertyEnum("ParametersOrientation", (Enum)this.getParametersOrientation(), (Enum)StiOrientation.Horizontal);
        rootJsonObject.AddPropertyBool("RequestParameters", this.getRequestParameters());
        rootJsonObject.AddPropertyStringNullOfEmpty("Culture", this.getCulture());
        rootJsonObject.AddPropertyStringNullOfEmpty("Script", this.getScript());
        if (mode == StiJsonSaveMode.Document) {
            rootJsonObject.AddPropertyJObject("RenderedPages", this.getRenderedPages().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("Dictionary", this.getDictionary().SaveToJsonObject(mode));
        } else {
            rootJsonObject.AddPropertyJObject("PrinterSettings", this.getPrinterSettings().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("MetaTags", this.getMetaTags().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("Styles", this.getStyles().SaveToJsonObject(mode));
            rootJsonObject.put("ReferencedAssemblies", (Object)StiJsonReportObjectHelper.Serialize.StringArray((String[])this.getReferencedAssemblies().toArray(new String[0])));
            rootJsonObject.AddPropertyJObject("BeginRenderEvent", this.getBeginRenderEvent().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("RenderingEvent", this.getRenderingEvent().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("EndRenderEvent", this.getEndRenderEvent().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("ExportingEvent", this.getExportingEvent().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("ExportedEvent", this.getExportedEvent().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("PrintingEvent", this.getPrintingEvent().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("PrintedEvent", this.getPrintedEvent().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("ReportResources", this.getReportResources().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("GlobalizationStrings", this.getGlobalizationStrings().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("Dictionary", this.getDictionary().SaveToJsonObject(mode));
            rootJsonObject.AddPropertyJObject("Pages", this.getPages().SaveToJsonObject(mode));
        }
        return rootJsonObject.toString();
    }

    public void loadFromJson(String text) throws JSONException, ParseException {
        this.jsonLoaderHelper = new StiJsonLoaderHelper();
        this.pages.clear();
        this.dictionary.clear();
        this.renderedPages.clear();
        this.reportUnit = StiReportUnitType.Centimeters;
        JSONObject JSONObject2 = new JSONObject(text);
        for (JProperty property : JSONObject2.Properties()) {
            String name = property.Name;
            if ("ReportVersion".equals(name)) {
                this.reportVersion = JSONObject2.getString(name);
                continue;
            }
            if ("ReportGuid".equals(name)) {
                this.reportGuid = JSONObject2.getString(name);
                continue;
            }
            if ("ReportName".equals(name)) {
                this.reportName = JSONObject2.getString(name);
                continue;
            }
            if ("ReportAlias".equals(name)) {
                this.reportAlias = JSONObject2.getString(name);
                continue;
            }
            if ("ReportAuthor".equals(name)) {
                this.reportAuthor = JSONObject2.getString(name);
                continue;
            }
            if ("ReportDescription".equals(name)) {
                this.reportDescription = JSONObject2.getString(name);
                continue;
            }
            if ("ReportCreated".equals(name)) {
                this.setReportCreated(StiJsonReportObjectHelper.Deserialize.DateTime((JProperty)property).calendar());
                continue;
            }
            if ("ReportChanged".equals(name)) {
                this.setReportChanged(StiJsonReportObjectHelper.Deserialize.DateTime((JProperty)property).calendar());
                continue;
            }
            if ("EngineVersion".equals(name)) {
                this.setEngineVersion(StiEngineVersion.valueOf(JSONObject2.getString(name)));
                continue;
            }
            if ("NumberOfPass".equals(name)) {
                this.setNumberOfPass(StiNumberOfPass.valueOf(JSONObject2.getString(name)));
                continue;
            }
            if ("CalculationMode".equals(name)) {
                this.setCalculationMode(StiCalculationMode.valueOf(JSONObject2.getString(name)));
                continue;
            }
            if ("ReportUnit".equals(name)) {
                this.setReportUnit(StiReportUnitType.valueOf(JSONObject2.getString(name)));
                continue;
            }
            if ("CacheAllData".equals(name)) {
                this.setCacheAllData((Boolean)property.Value);
                continue;
            }
            if ("ReportCacheMode".equals(name)) {
                this.setReportCacheMode(StiReportCacheMode.valueOf(JSONObject2.getString(name)));
                continue;
            }
            if ("ConvertNulls".equals(name)) {
                this.setConvertNulls((Boolean)property.Value);
                continue;
            }
            if ("StoreImagesInResources".equals(name)) {
                this.setStoreImagesInResources((Boolean)property.Value);
                continue;
            }
            if ("PreviewMode".equals(name)) {
                this.setPreviewMode(StiPreviewMode.valueOf(JSONObject2.getString(name)));
                continue;
            }
            if ("StopBeforePage".equals(name)) {
                this.setStopBeforePage((Integer)property.Value);
                continue;
            }
            if ("PreviewSettings".equals(name)) {
                this.setPreviewSettings((Integer)property.Value);
                continue;
            }
            if ("Collate".equals(name)) {
                this.setCollate((Integer)property.Value);
                continue;
            }
            if ("ReferencedAssemblies".equals(name)) {
                this.setReferencedAssemblies(StiJsonReportObjectHelper.Deserialize.stringList((JSONObject)((JSONObject)property.Value)));
                continue;
            }
            if ("ScriptLanguage".equals(name)) {
                this.setScriptLanguage(StiReportLanguageType.valueOf(JSONObject2.getString(name)));
                continue;
            }
            if ("AutoLocalizeReportOnRun".equals(name)) {
                this.setAutoLocalizeReportOnRun((Boolean)property.Value);
                continue;
            }
            if ("ParametersOrientation".equals(name)) {
                this.setParametersOrientation(StiOrientation.valueOf(JSONObject2.getString(name)));
                continue;
            }
            if ("RequestParameters".equals(name)) {
                this.setRequestParameters((Boolean)property.Value);
                continue;
            }
            if ("CacheTotals".equals(name)) continue;
            if ("Culture".equals(name)) {
                this.setCulture(JSONObject2.getString(name));
                continue;
            }
            if ("Script".equals(name)) {
                this.setScript(JSONObject2.getString(name));
                continue;
            }
            if ("BeginRenderEvent".equals(name)) {
                this.getBeginRenderEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("RenderingEvent".equals(name)) {
                this.getRenderingEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("EndRenderEvent".equals(name)) {
                this.getEndRenderEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("ExportingEvent".equals(name)) {
                this.getExportingEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("ExportedEvent".equals(name)) {
                this.getExportedEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("PrintingEvent".equals(name)) {
                this.getPrintingEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("PrintedEvent".equals(name)) {
                this.getPrintedEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("ReportCacheProcessingEvent".equals(name)) continue;
            if ("MetaTags".equals(name)) {
                this.getMetaTags().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("ReportResources".equals(name)) {
                this.getReportResources().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("GlobalizationStrings".equals(name)) {
                this.getGlobalizationStrings().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("PrinterSettings".equals(name)) {
                this.getPrinterSettings().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("Styles".equals(name)) {
                this.getStyles().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("Dictionary".equals(name)) {
                this.getDictionary().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("Pages".equals(name)) {
                this.getPages().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (!"RenderedPages".equals(name)) continue;
            this.getRenderedPages().LoadFromJsonObject((JSONObject)property.Value);
        }
        StiComponentsCollection reportComps = null;
        if (this.jsonLoaderHelper.MasterComponents.size() > 0) {
            reportComps = this.GetComponents();
            for (IStiMasterComponent masterComponent : this.jsonLoaderHelper.MasterComponents) {
                StiChart chart;
                StiChart stiChart = chart = masterComponent instanceof StiChart ? (StiChart)masterComponent : null;
                if (chart != null) {
                    chart.setMasterComponent(reportComps.get(chart.jsonMasterComponentTemp));
                    chart.jsonMasterComponentTemp = null;
                    continue;
                }
                StiDataBand dataBand = masterComponent instanceof StiDataBand ? (StiDataBand)masterComponent : null;
                if (dataBand == null) continue;
                dataBand.setMasterComponent(reportComps.get(dataBand.jsonMasterComponentTemp));
                dataBand.jsonMasterComponentTemp = null;
            }
        }
        if (this.jsonLoaderHelper.Clones.size() > 0) {
            if (reportComps == null) {
                reportComps = this.GetComponents();
            }
            for (StiClone clone : this.jsonLoaderHelper.Clones) {
                clone.setContainer((StiContainer)reportComps.get(clone.jsonContainerValueTemp));
                clone.jsonContainerValueTemp = null;
            }
        }
        if (this.jsonLoaderHelper.DialogInfo.size() > 0) {
            for (StiDialogInfo info : this.jsonLoaderHelper.DialogInfo) {
                info.setBindingVariable(this.dictionary.getVariables().get(info.jsonLoadedBindingVariableName));
                info.jsonLoadedBindingVariableName = null;
            }
        }
        this.jsonLoaderHelper.Clean();
        this.jsonLoaderHelper = null;
        this.applyStyles();
        this.setIsRendered(true);
        for (StiPage page : this.getRenderedPages()) {
            page.setReport(this);
            StiComponentsCollection comps = page.GetComponents();
            for (StiComponent comp : comps) {
                comp.setPage(page);
            }
        }
        this.setJsonReport(true);
    }

    public StiJsonLoaderHelper getJsonLoaderHelper() {
        return this.jsonLoaderHelper;
    }

    @StiSerializable
    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    @StiSerializable
    public StiReportResourceCollection getReportResources() {
        if (this.reportResources == null) {
            this.reportResources = new StiReportResourceCollection();
        }
        return this.reportResources;
    }

    public void setReportResources(StiReportResourceCollection reportResources) {
        this.reportResources = reportResources;
    }

    public void loadFonts() {
        if (FontVHelper.loadFontsFromResources(this)) {
            this.loadFontsForComponents();
            this.loadFontsForConditions();
            this.loadFontsForWatermark();
        }
    }

    public void loadDocumentFonts() {
        if (FontVHelper.loadFontsFromResources(this)) {
            this.loadDocumentFontsForComponents();
            this.loadDocumentFontsForWatermark();
        }
    }

    private void loadFontsForComponents() {
        for (StiComponent component : this.GetComponents()) {
            if (component instanceof IStiFont && ((IStiFont)((Object)component)).getFont().getAwtFont(1.0).getFontName().equals(((IStiFont)((Object)component)).getFont().getName())) continue;
        }
    }

    private void loadFontsForConditions() {
    }

    private void loadDocumentFontsForComponents() {
    }

    private void loadFontsForWatermark() {
    }

    private void loadDocumentFontsForWatermark() {
    }

    @StiSerializable
    public int getRefreshTime() {
        return this.refreshTime > 0 ? this.refreshTime : 0;
    }

    public void setRefreshTime(int refreshTime) {
        this.refreshTime = refreshTime;
    }

    public boolean isSaveInteractionParametersToDocument() {
        return this.saveInteractionParametersToDocument;
    }

    public void setSaveInteractionParametersToDocument(boolean saveInteractionParametersToDocument) {
        this.saveInteractionParametersToDocument = saveInteractionParametersToDocument;
    }

    public String getResourceFontName(String resourceName) {
        String name = this.resourceToFontHash.get(resourceName);
        if (name == null) {
            StiResource res = null;
            Iterator i$ = this.getDictionary().getResources().iterator();
            while (i$.hasNext()) {
                StiResource r = (StiResource)i$.next();
                if (!FontVHelper.isFont(r.type) || r.content == null || !StiValidationUtil.equals((Object)resourceName, (Object)r.getName())) continue;
                res = r;
            }
            if (res != null) {
                name = StiFontCollection.getFontFamilyByContent((String)resourceName, (byte[])res.content, (String)res.getType().toString().substring(4));
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)name)) {
                this.resourceToFontHash.put(resourceName, name);
            }
        }
        return name;
    }

    public void addAnchor(Object value) {
        this.anchors.put(value, new StiRuntimeVariables(this));
    }

    public int getAnchorPageNumber(Object value) {
        Object obj = value != null ? this.anchors.get(value) : null;
        StiRuntimeVariables variables = this.getAnchor(value);
        if (variables == null) {
            return 0;
        }
        return this.engine.pageNumbers.GetPageNumber(variables.Page);
    }

    public int getAnchorPageNumberThrough(Object value) {
        StiRuntimeVariables variables = this.getAnchor(value);
        if (variables == null) {
            return 0;
        }
        return this.engine.pageNumbers.GetPageNumberThrough(variables.Page);
    }

    public void dispose() {
        if (!StiValidationUtil.isNullOrEmpty((String)this.reportCachePath)) {
            StiReportCache.deleteCache(this.reportCachePath);
            this.reportCachePath = null;
        }
    }

    public Locale getLocale() {
        Locale result = Locale.ENGLISH;
        try {
            for (Locale locale : Locale.getAvailableLocales()) {
                if (!(locale.getLanguage() + "-" + locale.getCountry()).equals(this.culture)) continue;
                result = locale;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static {
        lockGlobalMeasureGraphics = new Object();
    }

    public class StiJsonLoaderHelper {
        public List<IStiMasterComponent> MasterComponents = new ArrayList<IStiMasterComponent>();
        public List<StiClone> Clones = new ArrayList<StiClone>();
        public List<StiDialogInfo> DialogInfo = new ArrayList<StiDialogInfo>();

        public void Clean() {
            this.MasterComponents.clear();
            this.MasterComponents = null;
            this.Clones.clear();
            this.Clones = null;
            this.DialogInfo.clear();
            this.DialogInfo = null;
        }
    }
}

