/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.report.StiFunctionCalcData;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiDataHelper;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHierarchicalBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiFilterCondition;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAvgDateFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAvgDecimalFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAvgDoubleFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAvgIntFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAvgTimeFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiCountDistinctFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiCountFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiFirstFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiLastFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMaxDateFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMaxDecimalFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMaxDoubleFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMaxIntFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMaxStrFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMaxTimeFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMedianDecimalFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMedianDoubleFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMedianIntFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMinDateFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMinDecimalFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMinDoubleFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMinIntFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMinStrFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiMinTimeFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiModeDecimalFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiModeDoubleFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiModeIntFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiSumDecimalFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiSumDecimalNullableFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiSumDistinctDecimalFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiSumDoubleFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiSumIntFunctionService;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiSumTimeFunctionService;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.engineV1.builders.StiDataBandV1Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiDataBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiV2Builder;
import com.stimulsoft.report.engine.parser.StiAsmCommand;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.engine.parser.StiParserData;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.events.StiValueEventArgs;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public final class StiTotals {
    public static Method GetMethod(StiReport report, String name) {
        try {
            return report.getClass().getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean existMethod(StiReport report, String name) {
        try {
            report.getClass().getMethod(name, new Class[0]);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Object Calculate(StiAggregateFunctionService function, Object data, StiReport report, String name, boolean allLevels, boolean onlyChilds, boolean isPageTotal) {
        StiDataBand dataBand5;
        boolean isCompilationMode = false;
        if (report != null) {
            isCompilationMode = report.getCalculationMode() == StiCalculationMode.Compilation;
        }
        StiFunctionCalcData calcData = new StiFunctionCalcData();
        if (!isCompilationMode) {
            StiParserData parserData = (StiParserData)(data instanceof StiParserData ? data : null);
            if (parserData != null) {
                calcData.asmList = parserData.AsmList;
                calcData.asmList2 = parserData.AsmList2;
                calcData.conditionAsmList = parserData.ConditionAsmList;
                calcData.parser = parserData.Parser;
                data = parserData.Data;
            } else {
                isCompilationMode = true;
            }
        }
        calcData.isCompilationMode = isCompilationMode;
        calcData.report = report;
        calcData.function = function;
        String name2 = null;
        if (function instanceof StiSumDistinctDecimalFunctionService) {
            StiSumDistinctDecimalFunctionService tempSumDistinctFunction = (StiSumDistinctDecimalFunctionService)function;
            if (isCompilationMode) {
                String[] arr = name.split("~");
                if (arr.length > 1) {
                    name = arr[0];
                    name2 = arr[1];
                    calcData.sumDistinctFunction = tempSumDistinctFunction;
                }
            } else if (calcData.asmList2 != null) {
                calcData.sumDistinctFunction = tempSumDistinctFunction;
            }
        }
        if (isCompilationMode && name != null) {
            calcData.method = StiTotals.GetMethod(report, name);
            if (calcData.method == null) {
                return 0;
            }
        }
        if ((dataBand5 = (StiDataBand)(data instanceof StiDataBand ? data : null)) != null && isPageTotal) {
            if (report == null) {
                report = dataBand5.getReport();
            }
            function.Init();
            StiTotals.SaveState(dataBand5);
            if (report.getEngine().IndexPageForPageTotal != -1) {
                int startPageIndex = report.getEngine().IndexPageForPageTotal;
                if (report.getEngine().StartIndexPageForPageTotal != -1) {
                    startPageIndex = report.getEngine().StartIndexPageForPageTotal;
                }
                for (int pageIndex = startPageIndex; pageIndex <= report.getEngine().IndexPageForPageTotal; ++pageIndex) {
                    StiPage page = report.getRenderedPages().get(pageIndex);
                    StiComponentsCollection comps = page.GetComponents();
                    for (StiComponent comp : comps) {
                        StiContainer cont = (StiContainer)(comp instanceof StiContainer ? comp : null);
                        if (cont == null || dataBand5.getName() != cont.getName() || cont.getContainerInfoV2().DataBandPosition == -1) continue;
                        ArrayList<DataRow> storedRows = null;
                        if (!dataBand5.isDataSourceEmpty()) {
                            dataBand5.setPosition(cont.getContainerInfoV2().getDataBandPosition());
                            if (cont.getContainerInfoV2().DataSourceRow != null) {
                                dataBand5.setPosition(0);
                                storedRows = dataBand5.getDataSource().detailRows;
                                dataBand5.getDataSource().detailRows = new ArrayList();
                                dataBand5.getDataSource().detailRows.add(cont.getContainerInfoV2().DataSourceRow);
                            }
                        }
                        StiTotals.calcItem(calcData);
                        if (dataBand5.isDataSourceEmpty() || cont.getContainerInfoV2().DataSourceRow == null) continue;
                        dataBand5.getDataSource().detailRows = storedRows;
                    }
                }
            }
            StiTotals.RestoreState(dataBand5);
            return function.GetValue();
        }
        StiDataSource dataSource = (StiDataSource)(data instanceof StiDataSource ? data : null);
        if (dataSource != null) {
            if (allLevels) {
                throw new RuntimeException("You can't use AllLevels together with DataSource! Only HierarchicalBand can be used.");
            }
            function.Init();
            dataSource.saveState("Totals");
            dataSource.First();
            dataSource.ResetData();
            dataSource.ResetDetailsRows();
            while (!dataSource.getIsEof()) {
                StiTotals.calcItem(calcData);
                dataSource.Next();
            }
            dataSource.RestoreState("Totals");
            return function.GetValue();
        }
        StiBusinessObject businessObject = (StiBusinessObject)((Object)(data instanceof StiBusinessObject ? data : null));
        if (businessObject != null) {
            if (allLevels) {
                throw new RuntimeException("You can't use AllLevels together with BusinessObject! Only HierarchicalBand can be used.");
            }
            function.Init();
            businessObject.SaveState("Totals");
            businessObject.CreateEnumerator();
            while (!businessObject.getIsEof()) {
                StiTotals.calcItem(calcData);
                businessObject.next();
            }
            businessObject.RestoreState("Totals");
            return function.GetValue();
        }
        StiHierarchicalBand treeBand = (StiHierarchicalBand)(data instanceof StiHierarchicalBand ? data : null);
        if (treeBand != null) {
            boolean childsOneLevel = false;
            if (!allLevels && onlyChilds) {
                childsOneLevel = true;
                allLevels = true;
            }
            if (report == null) {
                report = treeBand.getReport();
            }
            function.Init();
            StiDataBandV1Builder builderV1 = null;
            StiDataBandV2Builder builderV2 = null;
            if (report.getEngineVersion() == StiEngineVersion.EngineV1) {
                Object tempVar = StiDataBandV1Builder.getBuilder(StiDataBand.class);
                builderV1 = (StiDataBandV1Builder)(tempVar instanceof StiDataBandV1Builder ? tempVar : null);
            } else {
                StiV2Builder tempVar2 = StiDataBandV2Builder.getBuilder(StiDataBand.class);
                builderV2 = (StiDataBandV2Builder)(tempVar2 instanceof StiDataBandV2Builder ? tempVar2 : null);
            }
            if (!treeBand.isDataSourceEmpty()) {
                int level;
                treeBand.saveState("Totals");
                if (treeBand.getHierarchicalBandInfoV2().FinalFooterCalculation) {
                    treeBand.setPosition(0);
                }
                int currentLevel = treeBand.getDataSource().GetLevel();
                if (treeBand.getHierarchicalBandInfoV2().SpecifiedLevel != -1) {
                    currentLevel = treeBand.getHierarchicalBandInfoV2().SpecifiedLevel;
                }
                if (treeBand.getDataSource().getCount() > 0 && (treeBand.getHierarchicalBandInfoV2().SpecifiedLevel == -1 || allLevels) && !onlyChilds) {
                    StiTotals.calcItem(calcData);
                }
                int resPosition = treeBand.getPosition();
                while (treeBand.getPosition() > 0 && !onlyChilds) {
                    treeBand.setPosition(treeBand.getPosition() - 1);
                    level = treeBand.getDataSource().GetLevel();
                    if (level < currentLevel) break;
                    if (!allLevels && level != currentLevel) continue;
                    StiTotals.calcItem(calcData);
                }
                treeBand.setPosition(resPosition);
                while (treeBand.getPosition() < treeBand.getCount() - 1) {
                    treeBand.setPosition(treeBand.getPosition() + 1);
                    level = treeBand.getDataSource().GetLevel();
                    if (level < currentLevel) break;
                    if (onlyChilds) {
                        if (childsOneLevel && level - currentLevel > 1) continue;
                        if (level == currentLevel) break;
                    }
                    if (!allLevels && level != currentLevel) continue;
                    StiTotals.calcItem(calcData);
                }
                treeBand.setPosition(resPosition);
                treeBand.RestoreState("Totals");
            }
            if (!treeBand.getIsBusinessObjectEmpty()) {
                int level;
                int resPosition2 = treeBand.getPosition();
                treeBand.saveState("Totals");
                ArrayList rows = new ArrayList();
                treeBand.saveState("Totals2");
                treeBand.getBusinessObject().CreateEnumerator();
                while (!treeBand.getBusinessObject().getIsEof()) {
                    rows.add(treeBand.getBusinessObject().enumerator.next());
                    treeBand.getBusinessObject().next();
                }
                treeBand.RestoreState("Totals2");
                if (treeBand.getHierarchicalBandInfoV2().FinalFooterCalculation) {
                    treeBand.setPosition(0);
                }
                treeBand.getBusinessObject().setCurrentObject(rows.get(treeBand.getPosition()));
                int currentLevel = treeBand.getBusinessObject().getLevel();
                if (treeBand.getHierarchicalBandInfoV2().SpecifiedLevel != -1) {
                    currentLevel = treeBand.getHierarchicalBandInfoV2().SpecifiedLevel;
                }
                if (treeBand.getBusinessObject().size() > 0 && (treeBand.getHierarchicalBandInfoV2().SpecifiedLevel == -1 || allLevels) && !onlyChilds) {
                    StiTotals.calcItem(calcData);
                }
                int resPosition = treeBand.getPosition();
                while (treeBand.getPosition() > 0 && !onlyChilds) {
                    treeBand.setPosition(treeBand.getPosition() - 1);
                    treeBand.getBusinessObject().setCurrentObject(rows.get(treeBand.getPosition()));
                    level = treeBand.getBusinessObject().getLevel();
                    if (level < currentLevel) break;
                    if (!allLevels && level != currentLevel) continue;
                    StiTotals.calcItem(calcData);
                }
                treeBand.setPosition(resPosition);
                while (treeBand.getPosition() < treeBand.getCount() - 1) {
                    treeBand.setPosition(treeBand.getPosition() + 1);
                    treeBand.getBusinessObject().setCurrentObject(rows.get(treeBand.getPosition()));
                    level = treeBand.getBusinessObject().getLevel();
                    if (level < currentLevel) break;
                    if (onlyChilds) {
                        if (childsOneLevel && level - currentLevel > 1) continue;
                        if (level == currentLevel) break;
                    }
                    if (!allLevels && level != currentLevel) continue;
                    StiTotals.calcItem(calcData);
                }
                treeBand.setPosition(resPosition);
                treeBand.RestoreState("Totals");
            }
            return function.GetValue();
        }
        StiDataBand dataBand = (StiDataBand)(data instanceof StiDataBand ? data : null);
        if (dataBand != null) {
            if (allLevels) {
                throw new RuntimeException("You can't use AllLevels together with DataBand! Only HierarchicalBand can be used.");
            }
            if (report == null) {
                report = dataBand.getReport();
            }
            function.Init();
            if (dataBand.getBusinessObject() != null) {
                StiBusinessObject businessObject2 = dataBand.getBusinessObject() instanceof StiBusinessObject ? dataBand.getBusinessObject() : null;
                businessObject2.SaveState("Totals");
                businessObject2.CreateEnumerator();
                while (!businessObject2.getIsEof()) {
                    StiTotals.calcItem(calcData);
                    businessObject2.next();
                }
                businessObject2.RestoreState("Totals");
            } else {
                StiTotals.SaveState(dataBand);
                StiDataHelper.SetData(dataBand, false);
                dataBand.First();
                while (!dataBand.getIsEof()) {
                    StiTotals.calcItem(calcData);
                    dataBand.Next();
                }
                StiTotals.RestoreState(dataBand);
            }
            return function.GetValue();
        }
        StiGroupHeaderBand groupHeaderBand = (StiGroupHeaderBand)(data instanceof StiGroupHeaderBand ? data : null);
        if (groupHeaderBand != null) {
            if (allLevels) {
                throw new RuntimeException("You can't use AllLevels together with StiGroupHeaderBand! Only HierarchicalBand can be used.");
            }
            if (report == null) {
                report = groupHeaderBand.getReport();
            }
            function.Init();
            dataBand = groupHeaderBand.getDataBand();
            if (dataBand == null) {
                return 0;
            }
            dataBand.saveState("Totals");
            StiDataBandV1Builder builderV1 = null;
            StiDataBandV2Builder builderV2 = null;
            if (report.getEngineVersion() == StiEngineVersion.EngineV1) {
                Object tempVar3 = StiDataBandV1Builder.getBuilder(StiDataBand.class);
                builderV1 = (StiDataBandV1Builder)(tempVar3 instanceof StiDataBandV1Builder ? tempVar3 : null);
            } else {
                StiV2Builder tempVar4 = StiDataBandV2Builder.getBuilder(StiDataBand.class);
                builderV2 = (StiDataBandV2Builder)(tempVar4 instanceof StiDataBandV2Builder ? tempVar4 : null);
            }
            Object value = null;
            StiBusinessObject businessObject3 = dataBand.getBusinessObject();
            boolean groupHeaderResult = false;
            boolean groupFooterResult = false;
            if (report.getEngineVersion() == StiEngineVersion.EngineV1) {
                groupHeaderResult = builderV1.GetGroupHeaderResult(dataBand, groupHeaderBand);
                groupFooterResult = builderV1.GetGroupFooterResult(dataBand, groupHeaderBand);
            } else {
                groupHeaderResult = builderV2.GetGroupHeaderResult(dataBand, groupHeaderBand);
                groupFooterResult = builderV2.GetGroupFooterResult(dataBand, groupHeaderBand);
            }
            if (groupHeaderResult && groupFooterResult) {
                StiTotals.calcItem(calcData);
            } else {
                if (businessObject3 != null) {
                    int position;
                    int originalPosition = businessObject3.getPosition();
                    businessObject3.SaveState("Totals");
                    businessObject3.CreateEnumerator();
                    ArrayList<Boolean> values = new ArrayList<Boolean>();
                    for (position = 0; position != originalPosition; ++position) {
                        values.add(builderV2.GetGroupHeaderResult(dataBand, groupHeaderBand));
                        dataBand.Next();
                    }
                    --position;
                    Hashtable<Integer, Integer> positions = new Hashtable<Integer, Integer>();
                    try {
                        do {
                            if (((Boolean)values.get(position)).booleanValue()) {
                                positions.put(position, position);
                                break;
                            }
                            positions.put(position, position);
                        } while (--position >= 0);
                    }
                    catch (Exception e13) {
                        originalPosition = 0;
                    }
                    businessObject3.first();
                    for (position = 0; position != originalPosition; ++position) {
                        if (positions.get(position) != null) {
                            StiTotals.calcItem(calcData);
                        }
                        businessObject3.next();
                    }
                } else {
                    while (!(report.getEngineVersion() == StiEngineVersion.EngineV1 ? builderV1.GetGroupHeaderResult(dataBand, groupHeaderBand) : builderV2.GetGroupHeaderResult(dataBand, groupHeaderBand))) {
                        dataBand.Prior();
                    }
                }
                while (!(report.getEngineVersion() == StiEngineVersion.EngineV1 ? builderV1.GetGroupFooterResult(dataBand, groupHeaderBand) : builderV2.GetGroupFooterResult(dataBand, groupHeaderBand))) {
                    StiTotals.calcItem(calcData);
                    if (businessObject3 != null) {
                        if (businessObject3.getIsEof()) break;
                        businessObject3.next();
                        continue;
                    }
                    dataBand.Next();
                }
                if (report.getEngineVersion() == StiEngineVersion.EngineV1) {
                    groupHeaderResult = builderV1.GetGroupHeaderResult(dataBand, groupHeaderBand);
                    groupFooterResult = builderV1.GetGroupFooterResult(dataBand, groupHeaderBand);
                } else {
                    groupHeaderResult = builderV2.GetGroupHeaderResult(dataBand, groupHeaderBand);
                    groupFooterResult = builderV2.GetGroupFooterResult(dataBand, groupHeaderBand);
                }
                try {
                    if (!groupHeaderResult && groupFooterResult) {
                        StiTotals.calcItem(calcData);
                    }
                }
                catch (Exception e16) {
                    throw new RuntimeException(e16);
                }
            }
            if (businessObject3 != null) {
                businessObject3.RestoreState("Totals");
            }
            dataBand.RestoreState("Totals");
            return function.GetValue();
        }
        return 0;
    }

    private static void calcItem(StiFunctionCalcData calcData) {
        try {
            Object value = null;
            if (calcData.isCompilationMode) {
                StiValueEventArgs e;
                if (calcData.method != null) {
                    e = new StiValueEventArgs();
                    calcData.method.invoke((Object)calcData.report, new Object[]{calcData.report, e});
                    value = e.getValue();
                }
                if (calcData.sumDistinctFunction != null) {
                    e = new StiValueEventArgs();
                    calcData.method2.invoke((Object)calcData.report, new Object[]{calcData.report, e});
                    Object value2 = e.getValue();
                    calcData.sumDistinctFunction.CalcItem(value, value2);
                } else {
                    calcData.function.CalcItem(value);
                }
            } else {
                boolean res = false;
                if (calcData.conditionAsmList != null) {
                    Object ex = calcData.parser.executeAsm(calcData.conditionAsmList);
                    try {
                        res = Boolean.parseBoolean(ex.toString());
                    }
                    catch (Exception e) {}
                } else {
                    res = true;
                }
                if (res) {
                    value = calcData.parser.executeAsm(calcData.asmList);
                    if (calcData.sumDistinctFunction != null) {
                        Object value2 = calcData.parser.executeAsm(calcData.asmList2);
                        calcData.sumDistinctFunction.CalcItem(value, value2);
                    } else {
                        calcData.function.CalcItem(value);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object CalculateByCondition(StiAggregateFunctionService function, Object data, StiReport report, String name, StiFilterCondition filterCondition, BigDecimal value1, BigDecimal value2, boolean allLevels, boolean onlyChilds) {
        boolean isCompilationMode = true;
        if (report != null) {
            isCompilationMode = report.getCalculationMode() == StiCalculationMode.Compilation;
        }
        ArrayList<StiAsmCommand> asmList = null;
        StiParser parser = null;
        if (!isCompilationMode) {
            StiParserData parserData = (StiParserData)(data instanceof StiParserData ? data : null);
            if (parserData != null) {
                asmList = parserData.AsmList;
                parser = parserData.Parser;
                data = parserData.Data;
            } else {
                isCompilationMode = true;
            }
        }
        Method method = null;
        if (isCompilationMode && name != null && (method = StiTotals.GetMethod(report, name)) == null) {
            return 0;
        }
        StiHierarchicalBand treeBand = (StiHierarchicalBand)(data instanceof StiHierarchicalBand ? data : null);
        if (treeBand != null) {
            StiValueEventArgs e;
            Object value;
            int currentLevel;
            boolean childsOneLevel = false;
            if (!allLevels && onlyChilds) {
                childsOneLevel = true;
                allLevels = true;
            }
            if (report == null) {
                report = treeBand.getReport();
            }
            function.Init();
            treeBand.saveState("Totals");
            StiDataBandV1Builder builderV1 = null;
            StiDataBandV2Builder builderV2 = null;
            if (report.getEngineVersion() == StiEngineVersion.EngineV1) {
                Object tempVar = StiDataBandV1Builder.getBuilder(StiDataBand.class);
                builderV1 = (StiDataBandV1Builder)(tempVar instanceof StiDataBandV1Builder ? tempVar : null);
            } else {
                StiV2Builder tempVar2 = StiDataBandV2Builder.getBuilder(StiDataBand.class);
                builderV2 = (StiDataBandV2Builder)(tempVar2 instanceof StiDataBandV2Builder ? tempVar2 : null);
            }
            ArrayList rows = new ArrayList();
            if (treeBand.getBusinessObject() != null) {
                treeBand.saveState("Totals2");
                treeBand.getBusinessObject().CreateEnumerator();
                while (!treeBand.getBusinessObject().getIsEof()) {
                    rows.add(treeBand.getBusinessObject().enumerator.next());
                    treeBand.getBusinessObject().next();
                }
                treeBand.RestoreState("Totals2");
            }
            if (treeBand.getHierarchicalBandInfoV2().FinalFooterCalculation) {
                treeBand.setPosition(0);
            }
            if (treeBand.getBusinessObject() != null) {
                treeBand.getBusinessObject().setCurrentObject(rows.get(treeBand.getPosition()));
            }
            int n = currentLevel = treeBand.getDataSource() != null ? treeBand.getDataSource().GetLevel() : treeBand.getBusinessObject().getLevel();
            if (treeBand.getHierarchicalBandInfoV2().SpecifiedLevel != -1) {
                currentLevel = treeBand.getHierarchicalBandInfoV2().SpecifiedLevel;
            }
            if (!(rows.size() <= 0 && treeBand.getDataSource().getCount() <= 0 || treeBand.getHierarchicalBandInfoV2().SpecifiedLevel != -1 && !allLevels || onlyChilds)) {
                try {
                    Object value3 = null;
                    if (isCompilationMode) {
                        if (method != null) {
                            StiValueEventArgs e2 = new StiValueEventArgs();
                            method.invoke((Object)report, new Object[]{report, e2});
                            value3 = StiTotals.CompareValue(e2.getValue(), filterCondition, value1, value2);
                        }
                    } else {
                        value3 = StiTotals.CompareValue(parser.executeAsm(asmList), filterCondition, value1, value2);
                    }
                    function.CalcItem(value3);
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            int resPosition = treeBand.getPosition();
            while (treeBand.getPosition() > 0 && !onlyChilds) {
                int level;
                treeBand.setPosition(treeBand.getPosition() - 1);
                if (treeBand.getBusinessObject() != null) {
                    treeBand.getBusinessObject().setCurrentObject(rows.get(treeBand.getPosition()));
                }
                int n2 = level = treeBand.getDataSource() != null ? treeBand.getDataSource().GetLevel() : treeBand.getBusinessObject().getLevel();
                if (level < currentLevel) break;
                if (!allLevels && level != currentLevel) continue;
                try {
                    value = null;
                    if (isCompilationMode) {
                        if (method != null) {
                            e = new StiValueEventArgs();
                            method.invoke((Object)report, new Object[]{report, e});
                            value = StiTotals.CompareValue(e.getValue(), filterCondition, value1, value2);
                        }
                    } else {
                        value = StiTotals.CompareValue(parser.executeAsm(asmList), filterCondition, value1, value2);
                    }
                    function.CalcItem(value);
                }
                catch (Exception e2) {}
            }
            treeBand.setPosition(resPosition);
            while (treeBand.getPosition() < treeBand.getCount() - 1) {
                int level;
                treeBand.setPosition(treeBand.getPosition() + 1);
                if (treeBand.getBusinessObject() != null) {
                    treeBand.getBusinessObject().setCurrentObject(rows.get(treeBand.getPosition()));
                }
                int n3 = level = treeBand.getDataSource() != null ? treeBand.getDataSource().GetLevel() : treeBand.getBusinessObject().getLevel();
                if (level < currentLevel) break;
                if (onlyChilds) {
                    if (childsOneLevel && level - currentLevel > 1) continue;
                    if (level == currentLevel) break;
                }
                if (!allLevels && level != currentLevel) continue;
                try {
                    value = null;
                    if (isCompilationMode) {
                        if (method != null) {
                            e = new StiValueEventArgs();
                            method.invoke((Object)report, new Object[]{report, e});
                            value = StiTotals.CompareValue(e.getValue(), filterCondition, value1, value2);
                        }
                    } else {
                        value = StiTotals.CompareValue(parser.executeAsm(asmList), filterCondition, value1, value2);
                    }
                    function.CalcItem(value);
                }
                catch (Exception e3) {}
            }
            treeBand.setPosition(resPosition);
            treeBand.RestoreState("Totals");
            return function.GetValue();
        }
        return 0;
    }

    private static BigDecimal CalculateDecimalByCondition(StiAggregateFunctionService function, Object data, StiReport report, String name, StiFilterCondition filterCondition, BigDecimal value1, BigDecimal value2, boolean allLevels, boolean onlyChilds) {
        Object value = StiTotals.CalculateByCondition(function, data, report, name, filterCondition, value1, value2, allLevels, onlyChilds);
        return (BigDecimal)value;
    }

    private static Object CompareValue(Object value, StiFilterCondition filterCondition, BigDecimal value1, BigDecimal value2) {
        BigDecimal result = new BigDecimal(0);
        switch (filterCondition) {
            case Between: {
                return result.compareTo(value1) >= 0 && result.compareTo(value2) <= 0 ? result : Integer.valueOf(0);
            }
            case EqualTo: {
                return value1.equals(result) ? result : Integer.valueOf(0);
            }
            case GreaterThan: {
                return result.compareTo(value1) > 0 ? result : Integer.valueOf(0);
            }
            case GreaterThanOrEqualTo: {
                return result.compareTo(value1) >= 0 ? result : Integer.valueOf(0);
            }
            case LessThan: {
                return result.compareTo(value1) < 0 ? result : Integer.valueOf(0);
            }
            case LessThanOrEqualTo: {
                return result.compareTo(value1) <= 0 ? result : Integer.valueOf(0);
            }
            case NotBetween: {
                return result.compareTo(value1) < 0 || result.compareTo(value2) > 0 ? result : Integer.valueOf(0);
            }
            case NotEqualTo: {
                return !value1.equals(result) ? result : Integer.valueOf(0);
            }
            case NotContaining: 
            case EndingWith: 
            case Containing: 
            case BeginningWith: {
                return 0;
            }
        }
        return 0;
    }

    private static BigDecimal CalculateDecimal(StiAggregateFunctionService function, Object data, StiReport report, String name, boolean allLevels, boolean onlyChilds) {
        Object value = StiTotals.Calculate(function, data, report, name, allLevels, onlyChilds, false);
        return new BigDecimal(value.toString());
    }

    private static BigDecimal CalculateDecimalNullable(StiAggregateFunctionService function, Object data, StiReport report, String name, boolean allLevels, boolean onlyChilds) {
        Object value = StiTotals.Calculate(function, data, report, name, allLevels, onlyChilds, false);
        if (value == null) {
            return null;
        }
        return (BigDecimal)value;
    }

    private static double CalculateDouble(StiAggregateFunctionService function, Object data, StiReport report, String name, boolean allLevels, boolean onlyChilds) {
        Object value = StiTotals.Calculate(function, data, report, name, allLevels, onlyChilds, false);
        return (Double)value;
    }

    private static long CalculateInt64(StiAggregateFunctionService function, Object data, StiReport report, String name, boolean allLevels, boolean onlyChilds) {
        Object value = StiTotals.Calculate(function, data, report, name, allLevels, onlyChilds, false);
        if (value instanceof Long) {
            return (Long)value;
        }
        return ((Integer)value).intValue();
    }

    private static Object Calculate(StiAggregateFunctionService function, Object data, StiReport report, String name) {
        return StiTotals.Calculate(function, data, report, name, false, false, true);
    }

    private static BigDecimal CalculateDecimal(StiAggregateFunctionService function, Object data, StiReport report, String name) {
        return (BigDecimal)StiTotals.Calculate(function, data, report, name, false, false, true);
    }

    private static double CalculateDouble(StiAggregateFunctionService function, Object data, StiReport report, String name) {
        return (Double)StiTotals.Calculate(function, data, report, name, false, false, true);
    }

    private static long CalculateInt64(StiAggregateFunctionService function, Object data, StiReport report, String name) {
        return (Long)StiTotals.Calculate(function, data, report, name, false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object CalculateRunning(StiAggregateFunctionService function, Object data, StiReport report, String name) {
        try {
            if (report == null) {
                StiDataBand band;
                if (data instanceof StiDataBand) {
                    report = ((StiDataBand)(data instanceof StiDataBand ? data : null)).getReport();
                } else if (data instanceof StiParserData && (band = (StiDataBand)(((StiParserData)(data instanceof StiParserData ? data : null)).Data instanceof StiDataBand ? ((StiParserData)(data instanceof StiParserData ? data : null)).Data : null)) != null) {
                    report = (band instanceof StiDataBand ? band : null).getReport();
                }
            }
            report.getEngine().StartIndexPageForPageTotal = 0;
            Object object = StiTotals.Calculate(function, data, report, name, false, false, true);
            return object;
        }
        finally {
            report.getEngine().StartIndexPageForPageTotal = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal CalculateDecimalRunning(StiAggregateFunctionService function, Object data, StiReport report, String name) {
        try {
            if (report == null) {
                StiDataBand band;
                if (data instanceof StiDataBand) {
                    report = ((StiDataBand)(data instanceof StiDataBand ? data : null)).getReport();
                } else if (data instanceof StiParserData && (band = (StiDataBand)(((StiParserData)(data instanceof StiParserData ? data : null)).Data instanceof StiDataBand ? ((StiParserData)(data instanceof StiParserData ? data : null)).Data : null)) != null) {
                    report = (band instanceof StiDataBand ? band : null).getReport();
                }
            }
            report.getEngine().StartIndexPageForPageTotal = 0;
            BigDecimal bigDecimal = (BigDecimal)StiTotals.Calculate(function, data, report, name, false, false, true);
            return bigDecimal;
        }
        finally {
            report.getEngine().StartIndexPageForPageTotal = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double CalculateDoubleRunning(StiAggregateFunctionService function, Object data, StiReport report, String name) {
        try {
            if (report == null) {
                StiDataBand band;
                if (data instanceof StiDataBand) {
                    report = ((StiDataBand)(data instanceof StiDataBand ? data : null)).getReport();
                } else if (data instanceof StiParserData && (band = (StiDataBand)(((StiParserData)(data instanceof StiParserData ? data : null)).Data instanceof StiDataBand ? ((StiParserData)(data instanceof StiParserData ? data : null)).Data : null)) != null) {
                    report = (band instanceof StiDataBand ? band : null).getReport();
                }
            }
            report.getEngine().StartIndexPageForPageTotal = 0;
            double d = (Double)StiTotals.Calculate(function, data, report, name, false, false, true);
            return d;
        }
        finally {
            report.getEngine().StartIndexPageForPageTotal = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long CalculateInt64Running(StiAggregateFunctionService function, Object data, StiReport report, String name) {
        try {
            if (report == null) {
                StiDataBand band;
                if (data instanceof StiDataBand) {
                    report = ((StiDataBand)(data instanceof StiDataBand ? data : null)).getReport();
                } else if (data instanceof StiParserData && (band = (StiDataBand)(((StiParserData)(data instanceof StiParserData ? data : null)).Data instanceof StiDataBand ? ((StiParserData)(data instanceof StiParserData ? data : null)).Data : null)) != null) {
                    report = (band instanceof StiDataBand ? band : null).getReport();
                }
            }
            report.getEngine().StartIndexPageForPageTotal = 0;
            long l = (Long)StiTotals.Calculate(function, data, report, name, false, false, true);
            return l;
        }
        finally {
            report.getEngine().StartIndexPageForPageTotal = -1;
        }
    }

    public static BigDecimal Sum(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiSumDecimalFunctionService(), data, report, name, false, false);
    }

    public static BigDecimal SumNullable(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimalNullable(new StiSumDecimalNullableFunctionService(), data, report, name, false, false);
    }

    public static BigDecimal SumDistinct(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiSumDistinctDecimalFunctionService(), data, report, name, false, false);
    }

    public static BigDecimal SumDistinct(Object data, StiReport report, String name, String name2) {
        return StiTotals.CalculateDecimal(new StiSumDistinctDecimalFunctionService(), data, report, name + "~" + name2, false, false);
    }

    public static BigDecimal cSum(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiSumDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal cSumRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimalRunning(new StiSumDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal SumAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiSumDecimalFunctionService(), data, report, name, true, false);
    }

    public static BigDecimal SumAllLevelsByCondition(Object data, StiReport report, String name, StiFilterCondition filterCondition, BigDecimal value1, BigDecimal value2) {
        return StiTotals.CalculateDecimalByCondition(new StiSumDecimalFunctionService(), data, report, name, filterCondition, value1, value2, true, false);
    }

    public static BigDecimal SumAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiSumDecimalFunctionService(), data, report, name, true, true);
    }

    public static BigDecimal SumOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiSumDecimalFunctionService(), data, report, name, false, true);
    }

    public static double SumD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiSumDoubleFunctionService(), data, report, name, false, false);
    }

    public static double cSumD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiSumDoubleFunctionService(), data, report, name);
    }

    public static double cSumDRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDoubleRunning(new StiSumDoubleFunctionService(), data, report, name);
    }

    public static double SumDAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiSumDoubleFunctionService(), data, report, name, true, false);
    }

    public static double SumDAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiSumDoubleFunctionService(), data, report, name, true, true);
    }

    public static double SumDOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiSumDoubleFunctionService(), data, report, name, false, true);
    }

    public static long SumI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiSumIntFunctionService(), data, report, name, false, false);
    }

    public static long cSumI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiSumIntFunctionService(), data, report, name);
    }

    public static long cSumIRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64Running(new StiSumIntFunctionService(), data, report, name);
    }

    public static long SumIAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiSumIntFunctionService(), data, report, name, true, false);
    }

    public static long SumIAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiSumIntFunctionService(), data, report, name, true, true);
    }

    public static long SumIOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiSumIntFunctionService(), data, report, name, false, true);
    }

    public static Calendar SumTime(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiSumTimeFunctionService(), data, report, name, false, false, false);
        return (Calendar)value;
    }

    public static Calendar cSumTime(Object data, StiReport report, String name) {
        return (Calendar)StiTotals.Calculate(new StiSumTimeFunctionService(), data, report, name);
    }

    public static Calendar SumTimeAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiSumTimeFunctionService(), data, report, name, true, false, false);
        return (Calendar)value;
    }

    public static Calendar SumTimeAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiSumTimeFunctionService(), data, report, name, true, true, false);
        return (Calendar)value;
    }

    public static Calendar SumTimeOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiSumTimeFunctionService(), data, report, name, false, true, false);
        return (Calendar)value;
    }

    public static BigDecimal Avg(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiAvgDecimalFunctionService(), data, report, name, false, false);
    }

    public static BigDecimal cAvg(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiAvgDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal cAvgRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimalRunning(new StiAvgDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal AvgAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiAvgDecimalFunctionService(), data, report, name, true, false);
    }

    public static BigDecimal AvgAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiAvgDecimalFunctionService(), data, report, name, true, true);
    }

    public static BigDecimal AvgOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiAvgDecimalFunctionService(), data, report, name, false, true);
    }

    public static Date AvgDate(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiAvgDateFunctionService(), data, report, name, false, false, false);
        return (Date)value;
    }

    public static Date cAvgDate(Object data, StiReport report, String name) {
        return (Date)StiTotals.Calculate(new StiAvgDateFunctionService(), data, report, name);
    }

    public static Date AvgDateAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiAvgDateFunctionService(), data, report, name, true, false, false);
        return (Date)value;
    }

    public static Date AvgDateAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiAvgDateFunctionService(), data, report, name, true, true, false);
        return (Date)value;
    }

    public static Date AvgDateOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiAvgDateFunctionService(), data, report, name, false, true, false);
        return (Date)value;
    }

    public static Calendar AvgTime(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiAvgTimeFunctionService(), data, report, name, false, false, false);
        return (Calendar)value;
    }

    public static Calendar cAvgTime(Object data, StiReport report, String name) {
        return (Calendar)StiTotals.Calculate(new StiAvgTimeFunctionService(), data, report, name);
    }

    public static Calendar AvgTimeAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiAvgTimeFunctionService(), data, report, name, true, false, false);
        return (Calendar)value;
    }

    public static Calendar AvgTimeAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiAvgTimeFunctionService(), data, report, name, true, true, false);
        return (Calendar)value;
    }

    public static Calendar AvgTimeOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiAvgTimeFunctionService(), data, report, name, false, true, false);
        return (Calendar)value;
    }

    public static double AvgD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiAvgDoubleFunctionService(), data, report, name, false, false);
    }

    public static double cAvgD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiAvgDoubleFunctionService(), data, report, name);
    }

    public static double cAvgDRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDoubleRunning(new StiAvgDoubleFunctionService(), data, report, name);
    }

    public static double AvgDAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiAvgDoubleFunctionService(), data, report, name, true, false);
    }

    public static double AvgDAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiAvgDoubleFunctionService(), data, report, name, true, true);
    }

    public static double AvgDOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiAvgDoubleFunctionService(), data, report, name, false, true);
    }

    public static long AvgI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiAvgIntFunctionService(), data, report, name, false, false);
    }

    public static long cAvgI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiAvgIntFunctionService(), data, report, name);
    }

    public static long cAvgIRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64Running(new StiAvgIntFunctionService(), data, report, name);
    }

    public static long AvgIAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiAvgIntFunctionService(), data, report, name, true, false);
    }

    public static long AvgIAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiAvgIntFunctionService(), data, report, name, true, true);
    }

    public static long AvgIOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiAvgIntFunctionService(), data, report, name, false, true);
    }

    public static BigDecimal Max(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMaxDecimalFunctionService(), data, report, name, false, false);
    }

    public static BigDecimal cMax(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMaxDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal cMaxRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimalRunning(new StiMaxDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal MaxAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMaxDecimalFunctionService(), data, report, name, true, false);
    }

    public static BigDecimal MaxAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMaxDecimalFunctionService(), data, report, name, true, true);
    }

    public static BigDecimal MaxOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMaxDecimalFunctionService(), data, report, name, false, true);
    }

    public static double MaxD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMaxDoubleFunctionService(), data, report, name, false, false);
    }

    public static double cMaxD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMaxDoubleFunctionService(), data, report, name);
    }

    public static double cMaxDRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDoubleRunning(new StiMaxDoubleFunctionService(), data, report, name);
    }

    public static double MaxDAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMaxDoubleFunctionService(), data, report, name, true, false);
    }

    public static double MaxDAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMaxDoubleFunctionService(), data, report, name, true, true);
    }

    public static double MaxDOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMaxDoubleFunctionService(), data, report, name, false, true);
    }

    public static long MaxI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMaxIntFunctionService(), data, report, name, false, false);
    }

    public static long cMaxI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMaxIntFunctionService(), data, report, name);
    }

    public static long cMaxIRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64Running(new StiMaxIntFunctionService(), data, report, name);
    }

    public static long MaxIAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMaxIntFunctionService(), data, report, name, true, false);
    }

    public static long MaxIAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMaxIntFunctionService(), data, report, name, true, true);
    }

    public static long MaxIOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMaxIntFunctionService(), data, report, name, false, true);
    }

    public static BigDecimal Min(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMinDecimalFunctionService(), data, report, name, false, false);
    }

    public static BigDecimal cMin(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMinDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal cMinRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimalRunning(new StiMinDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal MinAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMinDecimalFunctionService(), data, report, name, true, false);
    }

    public static BigDecimal MinAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMinDecimalFunctionService(), data, report, name, true, true);
    }

    public static BigDecimal MinOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMinDecimalFunctionService(), data, report, name, false, true);
    }

    public static double MinD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMinDoubleFunctionService(), data, report, name, false, false);
    }

    public static double cMinD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMinDoubleFunctionService(), data, report, name);
    }

    public static double cMinDRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDoubleRunning(new StiMinDoubleFunctionService(), data, report, name);
    }

    public static double MinDAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMinDoubleFunctionService(), data, report, name, true, false);
    }

    public static double MinDAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMinDoubleFunctionService(), data, report, name, true, true);
    }

    public static double MinDOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMinDoubleFunctionService(), data, report, name, false, true);
    }

    public static long MinI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMinIntFunctionService(), data, report, name, false, false);
    }

    public static long cMinI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMinIntFunctionService(), data, report, name);
    }

    public static long cMinIRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64Running(new StiMinIntFunctionService(), data, report, name);
    }

    public static long MinIAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMinIntFunctionService(), data, report, name, true, false);
    }

    public static long MinIAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMinIntFunctionService(), data, report, name, true, true);
    }

    public static long MinIOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMinIntFunctionService(), data, report, name, false, true);
    }

    public static BigDecimal Median(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMedianDecimalFunctionService(), data, report, name, false, false);
    }

    public static BigDecimal cMedian(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMedianDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal cMedianRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimalRunning(new StiMedianDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal MedianAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMedianDecimalFunctionService(), data, report, name, true, false);
    }

    public static BigDecimal MedianAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMedianDecimalFunctionService(), data, report, name, true, true);
    }

    public static BigDecimal MedianOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiMedianDecimalFunctionService(), data, report, name, false, true);
    }

    public static double MedianD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMedianDoubleFunctionService(), data, report, name, false, false);
    }

    public static double cMedianD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMedianDoubleFunctionService(), data, report, name);
    }

    public static double cMedianDRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDoubleRunning(new StiMedianDoubleFunctionService(), data, report, name);
    }

    public static double MedianDAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMedianDoubleFunctionService(), data, report, name, true, false);
    }

    public static double MedianDAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMedianDoubleFunctionService(), data, report, name, true, true);
    }

    public static double MedianDOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiMedianDoubleFunctionService(), data, report, name, false, true);
    }

    public static long MedianI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMedianIntFunctionService(), data, report, name, false, false);
    }

    public static long cMedianI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMedianIntFunctionService(), data, report, name);
    }

    public static long cMedianIRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64Running(new StiMedianIntFunctionService(), data, report, name);
    }

    public static long MedianIAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMedianIntFunctionService(), data, report, name, true, false);
    }

    public static long MedianIAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMedianIntFunctionService(), data, report, name, true, true);
    }

    public static long MedianIOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiMedianIntFunctionService(), data, report, name, false, true);
    }

    public static BigDecimal Mode(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiModeDecimalFunctionService(), data, report, name, false, false);
    }

    public static BigDecimal cMode(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiModeDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal cModeRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimalRunning(new StiModeDecimalFunctionService(), data, report, name);
    }

    public static BigDecimal ModeAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiModeDecimalFunctionService(), data, report, name, true, false);
    }

    public static BigDecimal ModeAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiModeDecimalFunctionService(), data, report, name, true, true);
    }

    public static BigDecimal ModeOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDecimal(new StiModeDecimalFunctionService(), data, report, name, false, true);
    }

    public static double ModeD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiModeDoubleFunctionService(), data, report, name, false, false);
    }

    public static double cModeD(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiModeDoubleFunctionService(), data, report, name);
    }

    public static double cModeDRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateDoubleRunning(new StiModeDoubleFunctionService(), data, report, name);
    }

    public static double ModeDAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiModeDoubleFunctionService(), data, report, name, true, false);
    }

    public static double ModeDAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiModeDoubleFunctionService(), data, report, name, true, true);
    }

    public static double ModeDOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateDouble(new StiModeDoubleFunctionService(), data, report, name, false, true);
    }

    public static long ModeI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiModeIntFunctionService(), data, report, name, false, false);
    }

    public static long cModeI(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiModeIntFunctionService(), data, report, name);
    }

    public static long cModeIRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64Running(new StiModeIntFunctionService(), data, report, name);
    }

    public static long ModeIAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiModeIntFunctionService(), data, report, name, true, false);
    }

    public static long ModeIAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiModeIntFunctionService(), data, report, name, true, true);
    }

    public static long ModeIOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiModeIntFunctionService(), data, report, name, false, true);
    }

    public static Object First(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiFirstFunctionService(), data, report, name, false, false, false);
    }

    public static Object cFirst(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiFirstFunctionService(), data, report, name);
    }

    public static Object cFirstRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateRunning(new StiFirstFunctionService(), data, report, name);
    }

    public static Object FirstAllLevels(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiFirstFunctionService(), data, report, name, true, false, false);
    }

    public static Object FirstAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiFirstFunctionService(), data, report, name, true, true, false);
    }

    public static Object FirstOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiFirstFunctionService(), data, report, name, false, true, false);
    }

    public static Object Last(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiLastFunctionService(), data, report, name, false, false, false);
    }

    public static Object cLast(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiLastFunctionService(), data, report, name);
    }

    public static Object cLastRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateRunning(new StiLastFunctionService(), data, report, name);
    }

    public static Object LastAllLevels(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiLastFunctionService(), data, report, name, true, false, false);
    }

    public static Object LastAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiLastFunctionService(), data, report, name, true, true, false);
    }

    public static Object LastOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.Calculate(new StiLastFunctionService(), data, report, name, false, true, false);
    }

    public static long Count(Object data) {
        return StiTotals.CalculateInt64(new StiCountFunctionService(), data, null, null, false, false);
    }

    public static long Count(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiCountFunctionService(), data, report, name, false, false);
    }

    public static long cCount(Object data) {
        return StiTotals.CalculateInt64(new StiCountFunctionService(), data, null, null);
    }

    public static long cCount(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiCountFunctionService(), data, report, name);
    }

    public static long cCountRunning(Object data) {
        return StiTotals.CalculateInt64Running(new StiCountFunctionService(), data, null, null);
    }

    public static long cCountRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64Running(new StiCountFunctionService(), data, report, name);
    }

    public static long CountAllLevels(Object data) {
        return StiTotals.CalculateInt64(new StiCountFunctionService(), data, null, null, true, false);
    }

    public static long CountAllLevelsOnlyChilds(Object data) {
        return StiTotals.CalculateInt64(new StiCountFunctionService(), data, null, null, true, true);
    }

    public static long CountOnlyChilds(Object data) {
        return StiTotals.CalculateInt64(new StiCountFunctionService(), data, null, null, false, true);
    }

    public static long CountDistinct(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiCountDistinctFunctionService(), data, report, name, false, false);
    }

    public static long cCountDistinct(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiCountDistinctFunctionService(), data, report, name);
    }

    public static long cCountDistinctRunning(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64Running(new StiCountDistinctFunctionService(), data, report, name);
    }

    public static long CountDistinctAllLevels(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiCountDistinctFunctionService(), data, report, name, true, false);
    }

    public static long CountDistinctAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiCountDistinctFunctionService(), data, report, name, true, true);
    }

    public static long CountDistinctOnlyChilds(Object data, StiReport report, String name) {
        return StiTotals.CalculateInt64(new StiCountDistinctFunctionService(), data, report, name, false, true);
    }

    public static Date MinDate(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinDateFunctionService(), data, report, name, false, false, false);
        return (Date)value;
    }

    public static Date cMinDate(Object data, StiReport report, String name) {
        return (Date)StiTotals.Calculate(new StiMinDateFunctionService(), data, report, name);
    }

    public static Date MinDateAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinDateFunctionService(), data, report, name, true, false, false);
        return (Date)value;
    }

    public static Date MinDateAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinDateFunctionService(), data, report, name, true, true, false);
        return (Date)value;
    }

    public static Date MinDateOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinDateFunctionService(), data, report, name, false, true, false);
        return (Date)value;
    }

    public static Calendar MinTime(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinTimeFunctionService(), data, report, name, false, false, false);
        return (Calendar)value;
    }

    public static Calendar cMinTime(Object data, StiReport report, String name) {
        return (Calendar)StiTotals.Calculate(new StiMinTimeFunctionService(), data, report, name);
    }

    public static Calendar MinTimeAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinTimeFunctionService(), data, report, name, true, false, false);
        return (Calendar)value;
    }

    public static Calendar MinTimeAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinTimeFunctionService(), data, report, name, true, true, false);
        return (Calendar)value;
    }

    public static Calendar MinTimeOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinTimeFunctionService(), data, report, name, false, true, false);
        return (Calendar)value;
    }

    public static String MinStr(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinStrFunctionService(), data, report, name, false, false, false);
        return (String)value;
    }

    public static String cMinStr(Object data, StiReport report, String name) {
        return (String)StiTotals.Calculate(new StiMinStrFunctionService(), data, report, name);
    }

    public static String MinStrAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinStrFunctionService(), data, report, name, true, false, false);
        return (String)value;
    }

    public static String MinStrAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinStrFunctionService(), data, report, name, true, true, false);
        return (String)value;
    }

    public static String MinStrOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMinStrFunctionService(), data, report, name, false, true, false);
        return (String)value;
    }

    public static Date MaxDate(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxDateFunctionService(), data, report, name, false, false, false);
        return (Date)value;
    }

    public static Date cMaxDate(Object data, StiReport report, String name) {
        return (Date)StiTotals.Calculate(new StiMaxDateFunctionService(), data, report, name);
    }

    public static Date MaxDateAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxDateFunctionService(), data, report, name, true, false, false);
        return (Date)value;
    }

    public static Date MaxDateAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxDateFunctionService(), data, report, name, true, true, false);
        return (Date)value;
    }

    public static Date MaxDateOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxDateFunctionService(), data, report, name, false, true, false);
        return (Date)value;
    }

    public static Calendar MaxTime(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxTimeFunctionService(), data, report, name, false, false, false);
        return (Calendar)value;
    }

    public static Calendar cMaxTime(Object data, StiReport report, String name) {
        return (Calendar)StiTotals.Calculate(new StiMaxTimeFunctionService(), data, report, name);
    }

    public static Calendar MaxTimeAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxTimeFunctionService(), data, report, name, true, false, false);
        return (Calendar)value;
    }

    public static Calendar MaxTimeAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxTimeFunctionService(), data, report, name, true, true, false);
        return (Calendar)value;
    }

    public static Calendar MaxTimeOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxTimeFunctionService(), data, report, name, false, true, false);
        return (Calendar)value;
    }

    public static String MaxStr(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxStrFunctionService(), data, report, name, false, false, false);
        return (String)value;
    }

    public static String cMaxStr(Object data, StiReport report, String name) {
        return (String)StiTotals.Calculate(new StiMaxStrFunctionService(), data, report, name);
    }

    public static String MaxStrAllLevels(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxStrFunctionService(), data, report, name, true, false, false);
        return (String)value;
    }

    public static String MaxStrAllLevelsOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxStrFunctionService(), data, report, name, true, true, false);
        return (String)value;
    }

    public static String MaxStrOnlyChilds(Object data, StiReport report, String name) {
        Object value = StiTotals.Calculate(new StiMaxStrFunctionService(), data, report, name, false, true, false);
        return (String)value;
    }

    private static void SaveState(StiDataBand dataBand) {
        dataBand.saveState("Totals");
        if (dataBand.getDataBandInfoV2() != null && dataBand.getDataBandInfoV2().DetailDataBands != null) {
            for (StiDataBand detailBand : dataBand.getDataBandInfoV2().DetailDataBands) {
                StiTotals.SaveState(detailBand);
            }
        }
    }

    private static void RestoreState(StiDataBand dataBand) {
        dataBand.RestoreState("Totals");
        if (dataBand.getDataBandInfoV2() != null && dataBand.getDataBandInfoV2().DetailDataBands != null) {
            for (StiDataBand detailBand : dataBand.getDataBandInfoV2().DetailDataBands) {
                StiTotals.RestoreState(detailBand);
            }
        }
    }

    private StiTotals() {
    }
}

