/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiPharmacodeBarCodeType
extends StiBarCodeTypeService {
    protected String PharmacodeSymbols = "0123456789";
    protected static final double defaultPharmacodeModule = 20.0;
    private double module = 20.0;
    private double height = 1.0;
    protected static final double PharmacodeSpaceLeft = 1.0;
    protected static final double PharmacodeSpaceRight = 1.0;
    protected static final double PharmacodeSpaceTop = 0.0;
    protected static final double PharmacodeSpaceBottom = 0.5;
    protected static final double PharmacodeLineHeightShort = 16.0;
    protected static final double PharmacodeLineHeightLong = 16.0;
    protected static final double PharmacodeTextPosition = 16.5;
    protected static final double PharmacodeTextHeight = 5.0;
    protected static final double PharmacodeMainHeight = 22.0;
    protected static final double PharmacodeLineHeightForCut = 16.0;

    public StiPharmacodeBarCodeType() {
        this(20.0, 1.0);
    }

    public StiPharmacodeBarCodeType(double module, double height) {
        this.module = module;
        this.height = height;
    }

    public String getServiceName() {
        return "Pharmacode";
    }

    @Override
    @StiDefaulValue(value="10.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = 20.0;
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 5.0;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        int dataInt;
        int codeInt;
        String code = this.GetCode(barCode);
        if ((code = this.CheckCodeSymbols(code, this.PharmacodeSymbols)).length() > 6) {
            code = "131070";
        }
        if (code.length() < 1) {
            code = "3";
        }
        if ((codeInt = Integer.parseInt(code)) > 131070) {
            codeInt = 131070;
        }
        if (codeInt < 3) {
            codeInt = 3;
        }
        StringBuilder barsArray = new StringBuilder();
        int numberOfBars = 2;
        int maxValue = 3;
        for (dataInt = codeInt - 3; dataInt > maxValue; dataInt -= maxValue + 1) {
            maxValue = (1 << ++numberOfBars) - 1;
        }
        for (int index = numberOfBars - 1; index >= 0; --index) {
            if ((dataInt & 1 << index) > 0) {
                barsArray.append("6");
            } else {
                barsArray.append("4");
            }
            if (index == 0) continue;
            barsArray.append("1");
        }
        this.CalculateSizeFull(1.0, 1.0, 0.0, 0.5, 16.0, 16.0, 16.5, 5.0, 22.0, 16.0, 2.0, zoom, code, new Integer(codeInt).toString(), barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 20.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Height")) continue;
            this.height = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "1256";
    }
}

