/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.enums.StiCheckSum;

public class StiRoyalMail4StateBarCodeType
extends StiBarCodeTypeService {
    protected String RoyalMail4StateSymbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final String RoyalMail4StateStartCode = "1";
    private final String RoyalMail4StateStopCode = "0";
    private final String[] RoyalMail4StateCodes = new String[]{"3300", "3210", "3201", "2310", "2301", "2211", "3120", "3030", "3021", "2130", "2121", "2031", "3102", "3012", "3003", "2112", "2103", "2013", "1320", "1230", "1221", "0330", "0321", "0231", "1302", "1212", "1203", "0312", "0303", "0213", "1122", "1032", "1023", "0132", "0123", "0033"};
    private double module = 20.0;
    private double height = 1.0;
    private StiCheckSum checkSum = StiCheckSum.Yes;
    protected static final double RoyalMail4StateSpaceLeft = (double)3.9f;
    protected static final double RoyalMail4StateSpaceRight = (double)3.9f;
    protected static final double RoyalMail4StateSpaceTop = (double)3.9f;
    protected static final double RoyalMail4StateSpaceBottom = (double)3.9f;
    protected static final double RoyalMail4StateLineHeightLong = 10.0;
    protected static final double RoyalMail4StateLineHeightShort = 6.200000047683716;
    protected static final double RoyalMail4StateTextPosition = 18.800000190734863;
    protected static final double RoyalMail4StateTextHeight = 5.0;
    protected static final double RoyalMail4StateMainHeight = 24.800000190734863;
    protected static final double RoyalMail4StateLineHeightForCut = 10.0;

    public StiRoyalMail4StateBarCodeType() {
        this(20.0, 1.0, StiCheckSum.Yes);
    }

    public StiRoyalMail4StateBarCodeType(double module, double height, StiCheckSum checkSum) {
        this.module = module;
        this.height = height;
        this.checkSum = checkSum;
    }

    public String getServiceName() {
        return "Royal Mail 4-state";
    }

    @Override
    @StiDefaulValue(value="20.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 20.0) {
            this.module = 20.0;
        }
        if (value > 20.0) {
            this.module = 20.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 1.0) {
            this.height = 1.0;
        }
        if (value > 1.0) {
            this.height = 1.0;
        }
    }

    @StiDefaulValue(value="Yes")
    @StiSerializable
    public final StiCheckSum getCheckSum() {
        return this.checkSum;
    }

    public final void setCheckSum(StiCheckSum value) {
        this.checkSum = value;
    }

    @Override
    public double getLabelFontHeight() {
        return 5.0;
    }

    @Override
    protected StiTextHorAlignment getTextAlignment() {
        return StiTextHorAlignment.Center;
    }

    private String CharTo4State(char inputChar) {
        int inputNumber = this.RoyalMail4StateSymbols.indexOf(inputChar);
        return this.RoyalMail4StateCodes[inputNumber];
    }

    private String StateToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        for (int index = 0; index < inputCode.length(); ++index) {
            if (inputCode.charAt(index) == '0') {
                outputBar.append("c");
            } else if (inputCode.charAt(index) == '1') {
                outputBar.append("d");
            } else if (inputCode.charAt(index) == '2') {
                outputBar.append("e");
            } else if (inputCode.charAt(index) == '3') {
                outputBar.append("f");
            }
            outputBar.append("0");
        }
        return outputBar.toString();
    }

    private String makeBarsArray(String code) {
        StringBuilder tempBarsArray = new StringBuilder();
        int sum1 = 0;
        int sum2 = 0;
        for (int index = 0; index < code.length(); ++index) {
            String symb = this.CharTo4State(code.charAt(index));
            if (symb.charAt(0) == '0' || symb.charAt(0) == '1') {
                sum1 += 4;
            }
            if (symb.charAt(0) == '0' || symb.charAt(0) == '2') {
                sum2 += 4;
            }
            if (symb.charAt(1) == '0' || symb.charAt(1) == '1') {
                sum1 += 2;
            }
            if (symb.charAt(1) == '0' || symb.charAt(1) == '2') {
                sum2 += 2;
            }
            if (symb.charAt(2) == '0' || symb.charAt(2) == '1') {
                ++sum1;
            }
            if (symb.charAt(2) == '0' || symb.charAt(2) == '2') {
                ++sum2;
            }
            tempBarsArray.append(symb);
        }
        sum2 %= 6;
        if ((sum1 %= 6) == 0) {
            sum1 = 6;
        }
        if (sum2 == 0) {
            sum2 = 6;
        }
        int checksumValue = (sum1 - 1) * 6 + (sum2 - 1);
        if (this.getCheckSum() == StiCheckSum.Yes) {
            tempBarsArray.append(this.CharTo4State(this.RoyalMail4StateSymbols.charAt(checksumValue)));
        }
        return this.StateToBar("1" + tempBarsArray.toString() + "0");
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = new String(this.CheckCodeSymbols(code, this.RoyalMail4StateSymbols));
        String barsArray = this.makeBarsArray(code);
        this.CalculateSizeFull(3.9f, 3.9f, 3.9f, 3.9f, 6.200000047683716, 10.0, 18.800000190734863, 5.0, 24.800000190734863, 10.0, 1.0, zoom, code, code, barsArray, rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 20.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyEnum("CheckSum", (Enum)this.getCheckSum(), (Enum)StiCheckSum.Yes);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("CheckSum")) continue;
            this.setCheckSum(StiCheckSum.valueOf((String)property.Value));
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "529508A";
    }
}

