/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes.maxicode;

import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.barCodes.enums.StiMaxicodeMode;
import com.stimulsoft.report.barCodes.maxicode.ReedSolomon;
import com.stimulsoft.report.barCodes.maxicode.StiMaxicodeException;
import java.util.ArrayList;
import java.util.List;

public class StiMaxicode {
    private static final char com_RS = '\u001e';
    private static final char com_GS = '\u001d';
    private static final String FormatHeader = "[)>\u001e01\u001d";
    private static final String FormatTrailer = "\u001e\u0004";
    private static final int[] Grid_Map = new int[]{122, 121, 128, 127, 134, 133, 140, 139, 146, 145, 152, 151, 158, 157, 164, 163, 170, 169, 176, 175, 182, 181, 188, 187, 194, 193, 200, 199, 0, 0, 124, 123, 130, 129, 136, 135, 142, 141, 148, 147, 154, 153, 160, 159, 166, 165, 172, 171, 178, 177, 184, 183, 190, 189, 196, 195, 202, 201, 817, 0, 126, 125, 132, 131, 138, 137, 144, 143, 150, 149, 156, 155, 162, 161, 168, 167, 174, 173, 180, 179, 186, 185, 192, 191, 198, 197, 204, 203, 819, 818, 284, 283, 278, 277, 272, 271, 266, 265, 260, 259, 254, 253, 248, 247, 242, 241, 236, 235, 230, 229, 224, 223, 218, 217, 212, 211, 206, 205, 820, 0, 286, 285, 280, 279, 274, 273, 268, 267, 262, 261, 256, 255, 250, 249, 244, 243, 238, 237, 232, 231, 226, 225, 220, 219, 214, 213, 208, 207, 822, 821, 288, 287, 282, 281, 276, 275, 270, 269, 264, 263, 258, 257, 252, 251, 246, 245, 240, 239, 234, 233, 228, 227, 222, 221, 216, 215, 210, 209, 823, 0, 290, 289, 296, 295, 302, 301, 308, 307, 314, 313, 320, 319, 326, 325, 332, 331, 338, 337, 344, 343, 350, 349, 356, 355, 362, 361, 368, 367, 825, 824, 292, 291, 298, 297, 304, 303, 310, 309, 316, 315, 322, 321, 328, 327, 334, 333, 340, 339, 346, 345, 352, 351, 358, 357, 364, 363, 370, 369, 826, 0, 294, 293, 300, 299, 306, 305, 312, 311, 318, 317, 324, 323, 330, 329, 336, 335, 342, 341, 348, 347, 354, 353, 360, 359, 366, 365, 372, 371, 828, 827, 410, 409, 404, 403, 398, 397, 392, 391, 80, 79, 0, 0, 14, 13, 38, 37, 3, 0, 45, 44, 110, 109, 386, 385, 380, 379, 374, 373, 829, 0, 412, 411, 406, 405, 400, 399, 394, 393, 82, 81, 41, 0, 16, 15, 40, 39, 4, 0, 0, 46, 112, 111, 388, 387, 382, 381, 376, 375, 831, 830, 414, 413, 408, 407, 402, 401, 396, 395, 84, 83, 42, 0, 0, 0, 0, 0, 6, 5, 48, 47, 114, 113, 390, 389, 384, 383, 378, 377, 832, 0, 416, 415, 422, 421, 428, 427, 104, 103, 56, 55, 17, 0, 0, 0, 0, 0, 0, 0, 21, 20, 86, 85, 434, 433, 440, 439, 446, 445, 834, 833, 418, 417, 424, 423, 430, 429, 106, 105, 58, 57, 0, 0, 0, 0, 0, 0, 0, 0, 23, 22, 88, 87, 436, 435, 442, 441, 448, 447, 835, 0, 420, 419, 426, 425, 432, 431, 108, 107, 60, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 90, 89, 438, 437, 444, 443, 450, 449, 837, 836, 482, 481, 476, 475, 470, 469, 49, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 54, 53, 464, 463, 458, 457, 452, 451, 838, 0, 484, 483, 478, 477, 472, 471, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 466, 465, 460, 459, 454, 453, 840, 839, 486, 485, 480, 479, 474, 473, 52, 51, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 43, 468, 467, 462, 461, 456, 455, 841, 0, 488, 487, 494, 493, 500, 499, 98, 97, 62, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 92, 91, 506, 505, 512, 511, 518, 517, 843, 842, 490, 489, 496, 495, 502, 501, 100, 99, 64, 63, 0, 0, 0, 0, 0, 0, 0, 0, 29, 28, 94, 93, 508, 507, 514, 513, 520, 519, 844, 0, 492, 491, 498, 497, 504, 503, 102, 101, 66, 65, 18, 0, 0, 0, 0, 0, 0, 0, 19, 30, 96, 95, 510, 509, 516, 515, 522, 521, 846, 845, 560, 559, 554, 553, 548, 547, 542, 541, 74, 73, 33, 0, 0, 0, 0, 0, 0, 11, 68, 67, 116, 115, 536, 535, 530, 529, 524, 523, 847, 0, 562, 561, 556, 555, 550, 549, 544, 543, 76, 75, 0, 0, 8, 7, 36, 35, 12, 0, 70, 69, 118, 117, 538, 537, 532, 531, 526, 525, 849, 848, 564, 563, 558, 557, 552, 551, 546, 545, 78, 77, 0, 34, 10, 9, 26, 25, 0, 0, 72, 71, 120, 119, 540, 539, 534, 533, 528, 527, 850, 0, 566, 565, 572, 571, 578, 577, 584, 583, 590, 589, 596, 595, 602, 601, 608, 607, 614, 613, 620, 619, 626, 625, 632, 631, 638, 637, 644, 643, 852, 851, 568, 567, 574, 573, 580, 579, 586, 585, 592, 591, 598, 597, 604, 603, 610, 609, 616, 615, 622, 621, 628, 627, 634, 633, 640, 639, 646, 645, 853, 0, 570, 569, 576, 575, 582, 581, 588, 587, 594, 593, 600, 599, 606, 605, 612, 611, 618, 617, 624, 623, 630, 629, 636, 635, 642, 641, 648, 647, 855, 854, 728, 727, 722, 721, 716, 715, 710, 709, 704, 703, 698, 697, 692, 691, 686, 685, 680, 679, 674, 673, 668, 667, 662, 661, 656, 655, 650, 649, 856, 0, 730, 729, 724, 723, 718, 717, 712, 711, 706, 705, 700, 699, 694, 693, 688, 687, 682, 681, 676, 675, 670, 669, 664, 663, 658, 657, 652, 651, 858, 857, 732, 731, 726, 725, 720, 719, 714, 713, 708, 707, 702, 701, 696, 695, 690, 689, 684, 683, 678, 677, 672, 671, 666, 665, 660, 659, 654, 653, 859, 0, 734, 733, 740, 739, 746, 745, 752, 751, 758, 757, 764, 763, 770, 769, 776, 775, 782, 781, 788, 787, 794, 793, 800, 799, 806, 805, 812, 811, 861, 860, 736, 735, 742, 741, 748, 747, 754, 753, 760, 759, 766, 765, 772, 771, 778, 777, 784, 783, 790, 789, 796, 795, 802, 801, 808, 807, 814, 813, 862, 0, 738, 737, 744, 743, 750, 749, 756, 755, 762, 761, 768, 767, 774, 773, 780, 779, 786, 785, 792, 791, 798, 797, 804, 803, 810, 809, 816, 815, 864, 863};
    private static final int[] CodeSet_Map = new int[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 5, 0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 5, 5, 5, 5, 5, 5, 4, 5, 3, 4, 3, 5, 5, 4, 4, 3, 3, 3, 4, 3, 5, 4, 4, 3, 3, 4, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] CharToSym_Map = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 30, 28, 29, 30, 35, 32, 53, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 37, 38, 39, 40, 41, 52, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 42, 43, 44, 45, 46, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 32, 54, 34, 35, 36, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 36, 37, 37, 38, 39, 40, 41, 42, 43, 38, 44, 37, 39, 38, 45, 46, 40, 41, 39, 40, 41, 42, 42, 47, 43, 44, 43, 44, 45, 45, 46, 47, 46, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 32, 33, 34, 35, 36, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 32, 33, 34, 35, 36};
    private StiMaxicodeMode mode;
    private int structuredAppendPosition = 1;
    private int structuredAppendTotal = 1;
    private boolean trimExcessData = true;
    private String data_Postcode = null;
    private int data_Country = 0;
    private int data_Service = 0;
    private String content = null;
    private int eciMode = 3;
    private List<Integer> codewords = null;
    private int[] sourceBytes;
    private int[] set = new int[144];
    private int[] character = new int[144];
    private boolean[][] grid = new boolean[33][30];
    private String errorMessage = null;
    private int offsetEndOfData = 0;

    public int[] getMatrix() {
        return this.gridToMatrix();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected int getEciEncoding() {
        if (this.tryCodePage("ISO-8859-1")) {
            return 3;
        }
        if (this.tryCodePage("ISO-8859-2")) {
            return 4;
        }
        if (this.tryCodePage("ISO-8859-3")) {
            return 5;
        }
        if (this.tryCodePage("ISO-8859-4")) {
            return 6;
        }
        if (this.tryCodePage("ISO-8859-5")) {
            return 7;
        }
        if (this.tryCodePage("ISO-8859-6")) {
            return 8;
        }
        if (this.tryCodePage("ISO-8859-7")) {
            return 9;
        }
        if (this.tryCodePage("ISO-8859-8")) {
            return 10;
        }
        if (this.tryCodePage("ISO-8859-9")) {
            return 11;
        }
        if (this.tryCodePage("ISO-8859-11")) {
            return 13;
        }
        if (this.tryCodePage("ISO-8859-13")) {
            return 15;
        }
        if (this.tryCodePage("ISO-8859-15")) {
            return 17;
        }
        if (this.tryCodePage("Windows-1250")) {
            return 21;
        }
        if (this.tryCodePage("Windows-1251")) {
            return 22;
        }
        if (this.tryCodePage("Windows-1252")) {
            return 23;
        }
        if (this.tryCodePage("Windows-1256")) {
            return 24;
        }
        if (this.tryCodePage("SJIS")) {
            return 20;
        }
        this.tryCodePage("UTF-8");
        return 26;
    }

    private boolean tryCodePage(String charset) {
        try {
            byte[] res = this.content.getBytes(charset);
            this.sourceBytes = new int[res.length];
            for (int i = 0; i < res.length; ++i) {
                this.sourceBytes[i] = res[i] > 0 ? res[i] : res[i] + 256;
            }
            String back = new String(res, charset);
            if (StiValidationUtil.equals((Object)this.content, (Object)back)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String unpackTilde(String input) {
        int index = 0;
        StringBuilder output = new StringBuilder();
        while (index < input.length()) {
            char ch = input.charAt(index++);
            boolean flag = false;
            if (ch == '~' && index + 2 < input.length()) {
                String stNum = input.substring(index, index + 3);
                int num = 0;
                try {
                    num = Integer.parseInt(stNum);
                    if (num >= 0 && num < 255) {
                        output.append((char)num);
                        flag = true;
                        index += 3;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (flag) continue;
            output.append(ch);
        }
        return output.toString();
    }

    private List<String> extractPrimaryParts(String input) {
        ArrayList<String> output = new ArrayList<String>();
        int index = 0;
        StringBuilder sb = new StringBuilder();
        while (index < input.length()) {
            char ch;
            if ((ch = input.charAt(index++)) == '\u001d') {
                output.add(sb.toString());
                if (output.size() == 3) {
                    output.add(input.substring(index));
                    sb.delete(0, sb.length());
                    break;
                }
                sb = new StringBuilder();
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            output.add(sb.toString());
        }
        return output;
    }

    private int[] gridToMatrix() {
        int[] matrix = new int[990];
        for (int row = 0; row < 33; ++row) {
            for (int col = 0; col < 30; ++col) {
                if (!this.grid[row][col]) continue;
                matrix[row * 30 + col] = 1;
            }
        }
        return matrix;
    }

    private int findBestSet(int index, int length, int set1, int set2, int set3, int set4, int set5) {
        boolean contain1;
        int option1 = this.set[index - 1];
        boolean bl = contain1 = option1 == set1 || option1 == set2 || option1 == set3 || option1 == set4 || option1 == set5;
        if (index + 1 < length) {
            boolean contain2;
            int option2 = this.set[index + 1];
            boolean bl2 = contain2 = option2 == set1 || option2 == set2 || option2 == set3 || option2 == set4 || option2 == set5;
            if (contain1 && contain2) {
                return Math.min(option1, option2);
            }
            if (contain1) {
                return option1;
            }
            if (contain2) {
                return option2;
            }
        } else if (contain1) {
            return option1;
        }
        return set1;
    }

    private void insertSymbol(int position, int c) {
        for (int i = 143; i > position; --i) {
            this.set[i] = this.set[i - 1];
            this.character[i] = this.character[i - 1];
        }
        this.character[position] = c;
    }

    private boolean processTextToSymbols() throws StiMaxicodeException {
        int i;
        int index;
        int length = this.sourceBytes.length;
        if (length > 138) {
            return false;
        }
        for (index = 0; index < 144; ++index) {
            this.set[index] = -1;
            this.character[index] = 0;
        }
        for (index = 0; index < length; ++index) {
            this.set[index] = CodeSet_Map[this.sourceBytes[index]];
            this.character[index] = CharToSym_Map[this.sourceBytes[index]];
        }
        if (this.set[0] == 0) {
            if (this.character[0] == 13) {
                this.character[0] = 0;
            }
            this.set[0] = 1;
        }
        for (i = 1; i < length; ++i) {
            if (this.set[i] != 0) continue;
            if (this.character[i] == 13) {
                this.set[i] = this.findBestSet(i, length, 1, 5, -1, -1, -1);
                if (this.set[i] == 5) {
                    this.character[i] = 13;
                    continue;
                }
                this.character[i] = 0;
                continue;
            }
            if (this.character[i] == 28) {
                this.set[i] = this.findBestSet(i, length, 1, 2, 3, 4, 5);
                if (this.set[i] != 5) continue;
                this.character[i] = 32;
                continue;
            }
            if (this.character[i] == 29) {
                this.set[i] = this.findBestSet(i, length, 1, 2, 3, 4, 5);
                if (this.set[i] != 5) continue;
                this.character[i] = 33;
                continue;
            }
            if (this.character[i] == 30) {
                this.set[i] = this.findBestSet(i, length, 1, 2, 3, 4, 5);
                if (this.set[i] != 5) continue;
                this.character[i] = 34;
                continue;
            }
            if (this.character[i] == 32) {
                this.set[i] = this.findBestSet(i, length, 1, 2, 3, 4, 5);
                if (this.set[i] == 1) {
                    this.character[i] = 32;
                    continue;
                }
                if (this.set[i] == 2) {
                    this.character[i] = 47;
                    continue;
                }
                this.character[i] = 59;
                continue;
            }
            if (this.character[i] == 44) {
                this.set[i] = this.findBestSet(i, length, 1, 2, -1, -1, -1);
                if (this.set[i] != 2) continue;
                this.character[i] = 48;
                continue;
            }
            if (this.character[i] == 46) {
                this.set[i] = this.findBestSet(i, length, 1, 2, -1, -1, -1);
                if (this.set[i] != 2) continue;
                this.character[i] = 49;
                continue;
            }
            if (this.character[i] == 47) {
                this.set[i] = this.findBestSet(i, length, 1, 2, -1, -1, -1);
                if (this.set[i] != 2) continue;
                this.character[i] = 50;
                continue;
            }
            if (this.character[i] != 58) continue;
            this.set[i] = this.findBestSet(i, length, 1, 2, -1, -1, -1);
            if (this.set[i] != 2) continue;
            this.character[i] = 51;
        }
        if (this.set[length - 1] == 5 && this.character[length - 1] == 4) {
            this.set[length] = 0;
            this.character[length] = 63;
            for (i = length + 1; i < this.set.length; ++i) {
                this.set[i] = 0;
                this.character[i] = 33;
            }
        } else {
            for (i = length; i < this.set.length; ++i) {
                this.set[i] = this.set[length - 1] == 2 ? 2 : 1;
                this.character[i] = 33;
            }
        }
        int j = this.mode == StiMaxicodeMode.Mode2 || this.mode == StiMaxicodeMode.Mode3 ? 9 : 0;
        int count = 0;
        for (i = j; i < 143; ++i) {
            count = this.set[i] == 1 && this.character[i] >= 48 && this.character[i] <= 57 ? ++count : 0;
            if (count != 9) continue;
            this.set[i] = 6;
            this.set[i - 1] = 6;
            this.set[i - 2] = 6;
            this.set[i - 3] = 6;
            this.set[i - 4] = 6;
            this.set[i - 5] = 6;
            this.set[i - 6] = 6;
            this.set[i - 7] = 6;
            this.set[i - 8] = 6;
            count = 0;
        }
        int current_set = 1;
        i = 0;
        do {
            if (this.set[i] == current_set || this.set[i] == 6) continue;
            switch (this.set[i]) {
                case 1: {
                    if (i + 1 < this.set.length && this.set[i + 1] == 1) {
                        if (i + 2 < this.set.length && this.set[i + 2] == 1) {
                            if (i + 3 < this.set.length && this.set[i + 3] == 1) {
                                this.insertSymbol(i, 63);
                                current_set = 1;
                                ++length;
                                i += 3;
                                break;
                            }
                            this.insertSymbol(i, 57);
                            ++length;
                            i += 2;
                            break;
                        }
                        this.insertSymbol(i, 56);
                        ++length;
                        ++i;
                        break;
                    }
                    this.insertSymbol(i, 59);
                    ++length;
                    break;
                }
                case 2: {
                    if (i + 1 < this.set.length && this.set[i + 1] == 2) {
                        this.insertSymbol(i, 63);
                        current_set = 2;
                        ++length;
                        ++i;
                        break;
                    }
                    this.insertSymbol(i, 59);
                    ++length;
                    break;
                }
                case 3: {
                    if (i + 3 < this.set.length && this.set[i + 1] == 3 && this.set[i + 2] == 3 && this.set[i + 3] == 3) {
                        this.insertSymbol(i, 60);
                        this.insertSymbol(i, 60);
                        current_set = 3;
                        ++length;
                        i += 3;
                        break;
                    }
                    this.insertSymbol(i, 60);
                    ++length;
                    break;
                }
                case 4: {
                    if (i + 3 < this.set.length && this.set[i + 1] == 4 && this.set[i + 2] == 4 && this.set[i + 3] == 4) {
                        this.insertSymbol(i, 61);
                        this.insertSymbol(i, 61);
                        current_set = 4;
                        ++length;
                        i += 3;
                        break;
                    }
                    this.insertSymbol(i, 61);
                    ++length;
                    break;
                }
                case 5: {
                    if (i + 3 < this.set.length && this.set[i + 1] == 5 && this.set[i + 2] == 5 && this.set[i + 3] == 5) {
                        this.insertSymbol(i, 62);
                        this.insertSymbol(i, 62);
                        current_set = 5;
                        ++length;
                        i += 3;
                        break;
                    }
                    this.insertSymbol(i, 62);
                    ++length;
                    break;
                }
                default: {
                    if (this.set[i] == 0 && (this.character[i] == 63 || this.character[i] == 33)) {
                        if (this.character[i] != 63) break;
                        if (current_set == 2) {
                            current_set = 1;
                            break;
                        }
                        current_set = 2;
                        break;
                    }
                    throw new StiMaxicodeException("Encoding: unexpected set " + this.set[i] + " at index " + i + ".");
                }
            }
            ++i;
        } while (++i < this.set.length);
        i = 0;
        do {
            if (this.set[i] == 6) {
                int value = 0;
                for (j = 0; j < 9; ++j) {
                    value *= 10;
                    value += this.character[i + j] - 48;
                }
                this.character[i] = 31;
                this.character[i + 1] = (value & 0x3F000000) >> 24;
                this.character[i + 2] = (value & 0xFC0000) >> 18;
                this.character[i + 3] = (value & 0x3F000) >> 12;
                this.character[i + 4] = (value & 0xFC0) >> 6;
                this.character[i + 5] = value & 0x3F;
                for (j = i += 6; j < 140; ++j) {
                    this.set[j] = this.set[j + 3];
                    this.character[j] = this.character[j + 3];
                }
                length -= 3;
                continue;
            }
            ++i;
        } while (i < this.set.length);
        if (this.eciMode != 3) {
            this.insertSymbol(0, 27);
            this.insertSymbol(1, this.eciMode & 0x1F);
            length += 2;
        }
        if (!this.trimExcessData) {
            if ((this.mode == StiMaxicodeMode.Mode2 || this.mode == StiMaxicodeMode.Mode3) && length > 84) {
                return false;
            }
            if ((this.mode == StiMaxicodeMode.Mode4 || this.mode == StiMaxicodeMode.Mode6) && length > 93) {
                return false;
            }
            if (this.mode == StiMaxicodeMode.Mode5 && length > 77) {
                return false;
            }
        }
        this.offsetEndOfData = length;
        return true;
    }

    private static int[] getErrorCorrectionCodewords(int[] dataCodewords, int ecclen) {
        ReedSolomon rs = new ReedSolomon(67, ecclen, 1);
        int[] res = rs.encode(dataCodewords.length, dataCodewords);
        int[] results = new int[ecclen];
        for (int i = 0; i < ecclen; ++i) {
            results[i] = res[ecclen - 1 - i];
        }
        return results;
    }

    private int[] getPrimaryCodewords() {
        if (this.mode == StiMaxicodeMode.Mode2) {
            return StiMaxicode.getMode2PrimaryCodewords(this.data_Postcode, this.data_Country, this.data_Service);
        }
        return StiMaxicode.getMode3PrimaryCodewords(this.data_Postcode, this.data_Country, this.data_Service);
    }

    private static int[] getMode2PrimaryCodewords(String postcode, int country, int service) {
        int postcodeNum = 0;
        try {
            postcodeNum = Integer.parseInt(postcode);
        }
        catch (Exception e) {
            // empty catch block
        }
        int[] primary = new int[]{(postcodeNum & 3) << 4 | 2, (postcodeNum & 0xFC) >> 2, (postcodeNum & 0x3F00) >> 8, (postcodeNum & 0xFC000) >> 14, (postcodeNum & 0x3F00000) >> 20, (postcodeNum & 0x3C000000) >> 26 | (postcode.length() & 3) << 4, (postcode.length() & 0x3C) >> 2 | (country & 3) << 4, (country & 0xFC) >> 2, (country & 0x300) >> 8 | (service & 0xF) << 2, (service & 0x3F0) >> 4};
        return primary;
    }

    private static int[] getMode3PrimaryCodewords(String postcode, int country, int service) {
        if (postcode.length() < 6) {
            postcode = postcode + StiStringUtil.createCopies((char)' ', (int)(6 - postcode.length()));
        }
        int[] postcodeNums = new int[postcode.length()];
        postcode = postcode.toUpperCase();
        for (int i = 0; i < postcodeNums.length; ++i) {
            postcodeNums[i] = postcode.charAt(i);
            if (postcode.charAt(i) >= 'A' && postcode.charAt(i) <= 'Z') {
                int n = i;
                postcodeNums[n] = postcodeNums[n] - 64;
            }
            if (postcodeNums[i] != 27 && postcodeNums[i] != 31 && postcodeNums[i] != 33 && postcodeNums[i] < 59) continue;
            postcodeNums[i] = 32;
        }
        int[] primary = new int[]{(postcodeNums[5] & 3) << 4 | 3, (postcodeNums[4] & 3) << 4 | (postcodeNums[5] & 0x3C) >> 2, (postcodeNums[3] & 3) << 4 | (postcodeNums[4] & 0x3C) >> 2, (postcodeNums[2] & 3) << 4 | (postcodeNums[3] & 0x3C) >> 2, (postcodeNums[1] & 3) << 4 | (postcodeNums[2] & 0x3C) >> 2, (postcodeNums[0] & 3) << 4 | (postcodeNums[1] & 0x3C) >> 2, (postcodeNums[0] & 0x3C) >> 2 | (country & 3) << 4, (country & 0xFC) >> 2, (country & 0x300) >> 8 | (service & 0xF) << 2, (service & 0x3F0) >> 4};
        return primary;
    }

    private void encode() throws StiMaxicodeException {
        int secondaryECMax;
        int secondaryMax;
        this.eciMode = this.getEciEncoding();
        if (!this.processTextToSymbols()) {
            throw new StiMaxicodeException("The input data too long");
        }
        this.codewords = new ArrayList<Integer>();
        this.codewords.addAll(StiMaxicode.asList(this.character));
        if (this.mode == StiMaxicodeMode.Mode2 || this.mode == StiMaxicodeMode.Mode3) {
            int[] primaryCodes = this.getPrimaryCodewords();
            this.codewords.addAll(0, StiMaxicode.asList(primaryCodes));
            this.offsetEndOfData += primaryCodes.length;
        } else {
            this.codewords.add(0, this.mode.getValue());
            ++this.offsetEndOfData;
        }
        if (this.structuredAppendTotal > 1) {
            int[] flag = new int[]{33, this.structuredAppendPosition - 1 << 3 | this.structuredAppendTotal - 1};
            int index = this.mode == StiMaxicodeMode.Mode2 || this.mode == StiMaxicodeMode.Mode3 ? 10 : 1;
            this.codewords.addAll(index, StiMaxicode.asList(flag));
            this.offsetEndOfData += flag.length;
        }
        if (this.mode == StiMaxicodeMode.Mode5) {
            secondaryMax = 68;
            secondaryECMax = 56;
        } else {
            secondaryMax = 84;
            secondaryECMax = 40;
        }
        int totalMax = secondaryMax + 10;
        if (this.codewords.size() > totalMax) {
            if (this.offsetEndOfData > totalMax && this.content.endsWith("\u0004")) {
                this.codewords.set(totalMax - 1, this.codewords.get(this.offsetEndOfData - 1));
                this.codewords.set(totalMax - 2, this.codewords.get(this.offsetEndOfData - 2));
                if (this.codewords.get(this.offsetEndOfData - 3) == 30) {
                    this.codewords.set(totalMax - 3, this.codewords.get(this.offsetEndOfData - 3));
                    if (this.codewords.get(this.offsetEndOfData - 4) == 29) {
                        this.codewords.set(totalMax - 4, this.codewords.get(this.offsetEndOfData - 4));
                    }
                }
            }
            this.codewords.subList(totalMax, this.codewords.size()).clear();
        }
        int[] primary = new int[10];
        System.arraycopy(StiMaxicode.toArray(this.codewords), 0, primary, 0, 10);
        this.codewords.addAll(10, StiMaxicode.asList(StiMaxicode.getErrorCorrectionCodewords(primary, 10)));
        int[] secondary = new int[this.codewords.size() - 20];
        System.arraycopy(StiMaxicode.toArray(this.codewords), 20, secondary, 0, this.codewords.size() - 20);
        int[] secondaryOdd = new int[secondary.length / 2];
        int[] secondaryEven = new int[secondary.length / 2];
        for (int i = 0; i < secondary.length; ++i) {
            if ((i & 1) != 0) {
                secondaryOdd[(i - 1) / 2] = secondary[i];
                continue;
            }
            secondaryEven[i / 2] = secondary[i];
        }
        int[] secondaryECOdd = StiMaxicode.getErrorCorrectionCodewords(secondaryOdd, secondaryECMax / 2);
        int[] secondaryECEven = StiMaxicode.getErrorCorrectionCodewords(secondaryEven, secondaryECMax / 2);
        for (int i = 0; i < secondaryECEven.length; ++i) {
            this.codewords.add(secondaryECEven[i]);
            this.codewords.add(secondaryECOdd[i]);
        }
        int[] bit_pattern = new int[7];
        for (int i = 0; i < 33; ++i) {
            for (int j = 0; j < 30; ++j) {
                int block = (Grid_Map[i * 30 + j] + 5) / 6;
                int bit = (Grid_Map[i * 30 + j] + 5) % 6;
                if (block == 0) continue;
                bit_pattern[0] = (this.codewords.get(block - 1) & 0x20) >> 5;
                bit_pattern[1] = (this.codewords.get(block - 1) & 0x10) >> 4;
                bit_pattern[2] = (this.codewords.get(block - 1) & 8) >> 3;
                bit_pattern[3] = (this.codewords.get(block - 1) & 4) >> 2;
                bit_pattern[4] = (this.codewords.get(block - 1) & 2) >> 1;
                bit_pattern[5] = this.codewords.get(block - 1) & 1;
                this.grid[i][j] = bit_pattern[bit] != 0;
            }
        }
        this.grid[0][28] = true;
        this.grid[0][29] = true;
        this.grid[9][10] = true;
        this.grid[9][11] = true;
        this.grid[10][11] = true;
        this.grid[15][7] = true;
        this.grid[16][8] = true;
        this.grid[16][20] = true;
        this.grid[17][20] = true;
        this.grid[22][10] = true;
        this.grid[23][10] = true;
        this.grid[22][17] = true;
        this.grid[23][17] = true;
    }

    public StiMaxicode(String data, StiMaxicodeMode mode, int position, int total, boolean processTilde, boolean trimExcessData) {
        try {
            String sourceCode;
            if (position < 1 || position > 8) {
                throw new StiMaxicodeException("Invalid structured append position: " + position);
            }
            if (total < 1 || total > 8) {
                throw new StiMaxicodeException("Invalid structured append total: " + total);
            }
            this.mode = mode;
            this.structuredAppendPosition = position;
            this.structuredAppendTotal = total;
            this.trimExcessData = trimExcessData;
            String string = sourceCode = processTilde ? this.unpackTilde(data) : data;
            if (mode == StiMaxicodeMode.Mode2 || mode == StiMaxicodeMode.Mode3) {
                List<String> parts;
                String messageYear = null;
                if (sourceCode.startsWith(FormatHeader)) {
                    if (!sourceCode.endsWith(FormatTrailer)) {
                        throw new StiMaxicodeException("Unexpected end of input data");
                    }
                    messageYear = sourceCode.substring(7, 9);
                    sourceCode = sourceCode.substring(9, sourceCode.length() - 2);
                }
                if ((parts = this.extractPrimaryParts(sourceCode)).size() < 4) {
                    throw new StiMaxicodeException("Invalid message format");
                }
                this.data_Postcode = parts.get(0).trim();
                try {
                    this.data_Country = Integer.parseInt(parts.get(1).trim());
                }
                catch (Exception e) {
                    throw new StiMaxicodeException("Invalid country data");
                }
                try {
                    this.data_Service = Integer.parseInt(parts.get(2).trim());
                }
                catch (Exception e) {
                    throw new StiMaxicodeException("Invalid service data");
                }
                this.content = parts.get(3).trim();
                if (messageYear != null) {
                    this.content = FormatHeader + messageYear + this.content + FormatTrailer;
                }
                if (mode == StiMaxicodeMode.Mode2) {
                    for (int index = 0; index < this.data_Postcode.length(); ++index) {
                        if (this.data_Postcode.charAt(index) >= '0' && this.data_Postcode.charAt(index) <= '9') continue;
                        this.mode = StiMaxicodeMode.Mode3;
                        break;
                    }
                }
            } else {
                this.content = sourceCode;
            }
            this.encode();
        }
        catch (StiMaxicodeException mce) {
            this.errorMessage = mce.getMessage();
        }
    }

    private static int[] toArray(List<Integer> list) {
        int[] res = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i) != null ? list.get(i) : 0;
        }
        return res;
    }

    private static List<Integer> asList(int[] arr) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i : arr) {
            res.add(i);
        }
        return res;
    }
}

