/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart;

import com.stimulsoft.base.system.geometry.StiPoint;
import java.util.ArrayList;
import java.util.List;

public class StiSimplifyHelper {
    private static double getSquareDistance(StiPoint p1, StiPoint p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        return dx * dx + dy * dy;
    }

    private static double getSquareSegmentDistance(StiPoint p, StiPoint p1, StiPoint p2) {
        double x = p1.x;
        double y = p1.y;
        double dx = p2.x - x;
        double dy = p2.y - y;
        if (dx != 0.0 || dy != 0.0) {
            double t = ((p.x - x) * dx + (p.y - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0) {
                x = p2.x;
                y = p2.y;
            } else if (t > 0.0) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = p.x - x;
        dy = p.y - y;
        return dx * dx + dy * dy;
    }

    private static List<StiPoint> simplifyRadialDistance(StiPoint[] points, double sqTolerance) {
        StiPoint prevPoint = points[0];
        ArrayList<StiPoint> newPoints = new ArrayList<StiPoint>();
        newPoints.add(prevPoint);
        StiPoint point = new StiPoint();
        for (int i = 1; i < points.length; ++i) {
            point = points[i];
            if (!(StiSimplifyHelper.getSquareDistance(point, prevPoint) > sqTolerance)) continue;
            newPoints.add(point);
            prevPoint = point;
        }
        if (!prevPoint.equals((Object)point)) {
            newPoints.add(point);
        }
        return newPoints;
    }

    private static List<StiPoint> simplifyDouglasPeucker(StiPoint[] points, double sqTolerance) {
        int len = points.length;
        Integer[] markers = new Integer[len];
        Integer first = 0;
        Integer last = len - 1;
        Integer index = 0;
        ArrayList<Integer> stack = new ArrayList<Integer>();
        ArrayList<StiPoint> newPoints = new ArrayList<StiPoint>();
        Integer n = 1;
        markers[last.intValue()] = n;
        markers[first.intValue()] = n;
        while (last != null) {
            double maxSqDist = 0.0;
            for (int i = first + 1; i < last; ++i) {
                double sqDist = StiSimplifyHelper.getSquareSegmentDistance(points[i], points[first], points[last]);
                if (!(sqDist > maxSqDist)) continue;
                index = i;
                maxSqDist = sqDist;
            }
            if (maxSqDist > sqTolerance) {
                markers[index.intValue()] = 1;
                stack.add(first);
                stack.add(index);
                stack.add(index);
                stack.add(last);
            }
            if (stack.size() > 0) {
                last = (Integer)stack.get(stack.size() - 1);
                stack.remove(stack.size() - 1);
            } else {
                last = null;
            }
            if (stack.size() > 0) {
                first = (Integer)stack.get(stack.size() - 1);
                stack.remove(stack.size() - 1);
                continue;
            }
            first = null;
        }
        for (int i = 0; i < len; ++i) {
            if (markers[i] == null) continue;
            newPoints.add(points[i]);
        }
        return newPoints;
    }

    public static List<StiPoint> simplify(StiPoint[] points, double tolerance, boolean highestQuality) {
        if (points == null || points.length == 0) {
            return new ArrayList<StiPoint>();
        }
        double sqTolerance = tolerance * tolerance;
        if (highestQuality) {
            return StiSimplifyHelper.simplifyDouglasPeucker(points, sqTolerance);
        }
        List<StiPoint> points2 = StiSimplifyHelper.simplifyRadialDistance(points, sqTolerance);
        return StiSimplifyHelper.simplifyDouglasPeucker(points2.toArray(new StiPoint[0]), sqTolerance);
    }
}

