/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area.gantt;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.chart.core.area.clusteredBar.StiClusteredBarAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.enums.StiChartAreaPosition;
import com.stimulsoft.report.chart.enums.StiChartSeriesOrientation;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.gantt.IStiGanttSeries;
import java.util.ArrayList;

public class StiGanttAreaCoreXF
extends StiClusteredBarAreaCoreXF {
    @Override
    protected void CreateStripLinesXAxis(IStiAxis axis) {
        axis.getInfo().StripLines.clear();
        axis.getInfo().StripLines.add(new StiStripLineXF(0, 0.0));
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        for (IStiSeries series : seriesCollection) {
            for (Object argument : series.getArguments()) {
                boolean notExist = true;
                for (StiStripLineXF line : axis.getInfo().StripLines) {
                    if (!line.getValueObject().toString().equals(argument.toString())) continue;
                    notExist = false;
                }
                if (!notExist) continue;
                axis.getInfo().StripLines.add(new StiStripLineXF(argument, axis.getInfo().StripLines.size()));
            }
        }
        axis.getInfo().StripLines.add(new StiStripLineXF("", axis.getInfo().StripLines.size()));
    }

    @Override
    protected void PrepareRange(IStiAxis specXAxis, IStiAxis specXTopAxis, IStiAxis specYAxis, IStiAxis specYRightAxis) {
        specXAxis.getInfo().Maximum = 0.0;
        specXAxis.getInfo().Minimum = 0.0;
        specYAxis.getInfo().Maximum = 0.0;
        specYAxis.getInfo().Minimum = 0.0;
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        boolean first = true;
        for (IStiSeries series1 : seriesCollection) {
            IStiGanttSeries series = (IStiGanttSeries)series1;
            for (Double value : series.getValues()) {
                if (value == null) continue;
                if (first) {
                    first = false;
                    specYAxis.getInfo().Maximum = value;
                    specYAxis.getInfo().Minimum = value;
                    continue;
                }
                specYAxis.getInfo().Maximum = Math.max(specYAxis.getInfo().Maximum, value);
                specYAxis.getInfo().Minimum = Math.min(specYAxis.getInfo().Minimum, value);
            }
            for (Double value : series.getValuesEnd()) {
                if (value == null) continue;
                specYAxis.getInfo().Maximum = Math.max(specYAxis.getInfo().Maximum, value);
                specYAxis.getInfo().Minimum = Math.min(specYAxis.getInfo().Minimum, value);
            }
        }
        specYRightAxis.getInfo().Maximum = specYAxis.getInfo().Maximum;
        specYRightAxis.getInfo().Minimum = specYAxis.getInfo().Minimum;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Gantt");
    }

    @Override
    public StiChartSeriesOrientation getSeriesOrientation() {
        return StiChartSeriesOrientation.Horizontal;
    }

    @Override
    public int getPosition() {
        return StiChartAreaPosition.Gantt.getValue();
    }

    public StiGanttAreaCoreXF(IStiArea area) {
        super(area);
    }
}

