/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area.range;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.chart.core.area.clusteredColumn.StiClusteredColumnAreaCoreXF;
import com.stimulsoft.report.chart.enums.StiChartAreaPosition;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiSplineRangeSeries;
import java.util.ArrayList;

public class StiSplineRangeAreaCoreXF
extends StiClusteredColumnAreaCoreXF {
    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"SplineRange");
    }

    @Override
    public int getPosition() {
        return StiChartAreaPosition.SplineRange.getValue();
    }

    @Override
    protected void PrepareRange(IStiAxis specXAxis, IStiAxis specXTopAxis, IStiAxis specYAxis, IStiAxis specYRightAxis) {
        boolean firstLeft = true;
        boolean firstRight = true;
        boolean seriesLeftAxisY = false;
        boolean seriesRightAxisY = false;
        specYAxis.getInfo().Maximum = 0.0;
        specYAxis.getInfo().Minimum = 0.0;
        specYRightAxis.getInfo().Maximum = 0.0;
        specYRightAxis.getInfo().Minimum = 0.0;
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        for (int index = 0; index < seriesCollection.size(); ++index) {
            IStiSplineRangeSeries series = (IStiSplineRangeSeries)seriesCollection.get(index);
            Double[] values = series.getValues();
            Double[] valuesEnd = series.getValuesEnd();
            int count = Math.min(values.length, valuesEnd.length);
            for (int indexValues = 0; indexValues < count; ++indexValues) {
                double value = values[indexValues] != null ? values[indexValues] : 0.0;
                double valueEnd = valuesEnd[indexValues] != null ? valuesEnd[indexValues] : 0.0;
                Double valueMax = Math.max(value, valueEnd);
                Double valueMin = Math.min(value, valueEnd);
                if (series.getYAxis() == StiSeriesYAxis.LeftYAxis) {
                    if (firstLeft) {
                        seriesLeftAxisY = true;
                        specYAxis.getInfo().Maximum = valueMax;
                        specYAxis.getInfo().Minimum = valueMin;
                        firstLeft = false;
                        continue;
                    }
                    seriesLeftAxisY = true;
                    specYAxis.getInfo().Maximum = Math.max(valueMax, specYAxis.getInfo().Maximum);
                    specYAxis.getInfo().Minimum = Math.min(valueMin, specYAxis.getInfo().Minimum);
                    continue;
                }
                if (firstRight) {
                    seriesRightAxisY = true;
                    specYRightAxis.getInfo().Maximum = valueMax;
                    specYRightAxis.getInfo().Minimum = valueMin;
                    firstRight = false;
                    continue;
                }
                seriesRightAxisY = true;
                specYRightAxis.getInfo().Maximum = Math.max(valueMax, specYRightAxis.getInfo().Maximum);
                specYRightAxis.getInfo().Minimum = Math.min(valueMin, specYRightAxis.getInfo().Minimum);
            }
        }
        if (!seriesLeftAxisY) {
            specYAxis.getInfo().Maximum = specYRightAxis.getInfo().Maximum;
            specYAxis.getInfo().Minimum = specYRightAxis.getInfo().Minimum;
        }
        if (!seriesRightAxisY) {
            specYRightAxis.getInfo().Maximum = specYAxis.getInfo().Maximum;
            specYRightAxis.getInfo().Minimum = specYAxis.getInfo().Minimum;
        }
    }

    public StiSplineRangeAreaCoreXF(IStiArea area) {
        super(area);
    }
}

