/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.axis;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.chart.StiChartOptions;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.StiAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.StiAxisLabelInfoXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripPositionXF;
import com.stimulsoft.report.chart.enums.StiArrowStyle;
import com.stimulsoft.report.chart.enums.StiLabelsPlacement;
import com.stimulsoft.report.chart.enums.StiMarkerAlignment;
import com.stimulsoft.report.chart.enums.StiYAxisDock;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.axis.StiAxisLabelGeom;
import com.stimulsoft.report.chart.geoms.axis.StiAxisTitleGeom;
import com.stimulsoft.report.chart.geoms.axis.StiYAxisGeom;
import com.stimulsoft.report.chart.geoms.axis.StiYAxisViewGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiDownButtonGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiUpButtonGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiVertScrollBarGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiVertTrackBarGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiYAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiYLeftAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiYRightAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.components.StiComponent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;

public abstract class StiYAxisCoreXF
extends StiAxisCoreXF {
    @Override
    public StiCellGeom Render(StiContext context, StiRectangle rect) {
        IStiAxis tempVar;
        if (!this.getAxis().getVisible()) {
            return null;
        }
        StiRectangle axisRect = this.GetAxisRect(context, rect, false, false, true, false);
        axisRect.x = 0.0;
        axisRect.y = 0.0;
        if (this.getAxis().getInteraction().getShowScrollBar() && (this.getAxis() instanceof IStiYRightAxis && !this.getAxis().getArea().getReverseHor() || this.getAxis() instanceof IStiYLeftAxis && this.getAxis().getArea().getReverseHor())) {
            axisRect.x += (double)(StiAxisCoreXF.DefaultScrollBarSize * (float)context.Options.zoom);
        }
        StiYAxisGeom geom = new StiYAxisGeom((IStiYAxis)((tempVar = this.getAxis()) instanceof IStiYAxis ? tempVar : null), axisRect.clone(), false);
        this.RenderLabels(context, axisRect.clone(), geom);
        if (!this.getAxis().getRange().getAuto()) {
            axisRect.y = (this.getAxis().getInfo().Maximum - this.getAxis().getRange().getMaximum()) * this.getAxis().getInfo().Dpi;
            axisRect.height = (this.getAxis().getRange().getMaximum() - this.getAxis().getRange().getMinimum()) * this.getAxis().getInfo().Dpi;
        }
        this.RenderTitle(context, axisRect, geom);
        return geom;
    }

    @Override
    public StiCellGeom RenderView(StiContext context, StiRectangle rect) {
        if (!this.getAxis().getVisible()) {
            return null;
        }
        StiRectangle axisRect = this.GetAxisRect(context, rect, false, false, true, true);
        IStiAxis tempVar = this.getAxis();
        return new StiYAxisViewGeom((IStiYAxis)(tempVar instanceof IStiYAxis ? tempVar : null), axisRect, false);
    }

    public final void RenderScrollBar(StiContext context, StiRectangle axisRect, StiYAxisViewGeom axisGeom) {
        if (this.getAxis().getInteraction().getShowScrollBar()) {
            IStiAxis tempVar5;
            StiRectangle scrollBarRect = axisRect;
            scrollBarRect.y = 0.0;
            scrollBarRect.width = StiAxisCoreXF.DefaultScrollBarSize * (float)context.Options.zoom;
            scrollBarRect.x = this.getAxis() instanceof IStiYLeftAxis && !this.getAxis().getArea().getReverseHor() || this.getAxis() instanceof IStiYRightAxis && this.getAxis().getArea().getReverseHor() ? axisRect.width - scrollBarRect.width : 0.0;
            IStiAxis tempVar = this.getAxis();
            StiVertScrollBarGeom scrollBarGeom = new StiVertScrollBarGeom((IStiYAxis)(tempVar instanceof IStiYAxis ? tempVar : null), scrollBarRect);
            axisGeom.CreateChildGeoms();
            axisGeom.getChildGeoms().add(scrollBarGeom);
            scrollBarRect.x = 0.0;
            scrollBarRect.y = 0.0;
            scrollBarRect.inflate(-2, -2);
            if (this.getAxis().getInteraction().getRangeScrollEnabled()) {
                StiRectangle upButtonRect = scrollBarRect;
                upButtonRect.height = scrollBarRect.width;
                IStiAxis tempVar2 = this.getAxis();
                StiUpButtonGeom upButtonGeom = new StiUpButtonGeom((IStiYAxis)(tempVar2 instanceof IStiYAxis ? tempVar2 : null), upButtonRect);
                scrollBarGeom.CreateChildGeoms();
                scrollBarGeom.getChildGeoms().add(upButtonGeom);
                StiRectangle downButtonRect = scrollBarRect;
                downButtonRect.height = scrollBarRect.width;
                downButtonRect.y = scrollBarRect.getBottom() - downButtonRect.height;
                IStiAxis tempVar3 = this.getAxis();
                StiDownButtonGeom downButtonGeom = new StiDownButtonGeom((IStiYAxis)(tempVar3 instanceof IStiYAxis ? tempVar3 : null), downButtonRect);
                scrollBarGeom.CreateChildGeoms();
                scrollBarGeom.getChildGeoms().add(downButtonGeom);
                scrollBarRect.inflate(Double.valueOf(0.0), Double.valueOf(-scrollBarRect.width - 2.0));
            }
            StiRectangle trackBarRect = scrollBarRect;
            IStiYAxis rollAxis = this.getAxis().getArea().getYAxis();
            StiAreaCoreXF tempVar4 = this.getAxis().getArea().getCore();
            StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar4 instanceof StiAxisAreaCoreXF ? tempVar4 : null);
            if (!rollAxis.getRange().getAuto()) {
                float dpi = (float)(scrollBarRect.height / axisCore.getScrollRangeY());
                float y = (float)axisCore.getScrollValueY() * dpi;
                double height = axisCore.getScrollViewY() * (double)dpi;
                trackBarRect = new StiRectangle(scrollBarRect.x, (double)y + scrollBarRect.y, scrollBarRect.width, height);
            }
            StiVertTrackBarGeom trackBarGeom = new StiVertTrackBarGeom((IStiYAxis)((tempVar5 = this.getAxis()) instanceof IStiYAxis ? tempVar5 : null), trackBarRect, scrollBarGeom);
            scrollBarGeom.CreateChildGeoms();
            scrollBarGeom.getChildGeoms().add(trackBarGeom);
        }
    }

    public final StiCellGeom RenderCenter(StiContext context, StiRectangle rect) {
        if (!this.getAxis().getVisible()) {
            return null;
        }
        if (this.getAxis().getArea().getXAxis().getInfo().Minimum >= 0.0) {
            return null;
        }
        StiRectangle axisRect = this.GetCenterAxisRect(context, rect, false, false, true);
        axisRect.x = 0.0;
        axisRect.y = 0.0;
        IStiAxis tempVar = this.getAxis();
        StiYAxisGeom geom = new StiYAxisGeom((IStiYAxis)(tempVar instanceof IStiYAxis ? tempVar : null), axisRect, true);
        return geom;
    }

    public final StiCellGeom RenderCenterView(StiContext context, StiRectangle rect) {
        if (!this.getAxis().getVisible()) {
            return null;
        }
        if (this.getAxis().getArea().getXAxis().getInfo().Minimum >= 0.0) {
            return null;
        }
        StiRectangle axisRect = this.GetCenterAxisRect(context, rect, false, false, true);
        IStiAxis tempVar = this.getAxis();
        StiYAxisViewGeom geom = new StiYAxisViewGeom((IStiYAxis)(tempVar instanceof IStiYAxis ? tempVar : null), axisRect, true);
        return geom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String GetLabelText(StiStripLineXF line, IStiSeries series) {
        Object value = line.getValueObject();
        if (this.getAxis().getLabels().getFormat() == null || this.getAxis().getLabels().getFormat().trim().length() == 0) return String.format("%1$s%2$s%3$s", this.getAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), this.getAxis().getLabels().getTextAfter());
        try {
            if (value instanceof String) {
                value = new BigDecimal(value.toString());
            }
            String culture = null;
            try {
                culture = ((StiComponent)((Object)this.getAxis().getArea().getChart())).getReport().getCulture();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (StiChartOptions.getOldChartPercentMode() || !this.getAxis().getLabels().getFormat().startsWith("P")) return String.format("%s%s%s", this.getAxis().getLabels().getTextBefore(), StiStringUtil.format((String)("{0:" + this.getAxis().getLabels().getFormat() + "}"), (Object)StiTextUtil.toString((Object)value), (Locale)Locale.ENGLISH, (String)culture), this.getAxis().getLabels().getTextAfter());
            int signs = 0;
            if (this.getAxis().getLabels().getFormat().length() <= 1) return String.format("%s%s%s%s", this.getAxis().getLabels().getTextBefore(), StiStringUtil.format((String)("{0:" + signs + "}"), (Object)value, (Locale)Locale.ENGLISH, (String)culture), "%", this.getAxis().getLabels().getTextAfter());
            String tempVar = this.getAxis().getLabels().getFormat();
            signs = Integer.parseInt(tempVar.substring(0, 0) + tempVar.substring(1));
            return String.format("%s%s%s%s", this.getAxis().getLabels().getTextBefore(), StiStringUtil.format((String)("{0:" + signs + "}"), (Object)value, (Locale)Locale.ENGLISH, (String)culture), "%", this.getAxis().getLabels().getTextAfter());
        }
        catch (Exception e3) {
            try {
                return String.format("%1$s%2$s%3$s", this.getAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), this.getAxis().getLabels().getTextAfter());
            }
            catch (Exception e4) {
                return StiTextUtil.toString((Object)value);
            }
        }
    }

    private ArrayList<StiAxisLabelInfoXF> MeasureStripLines(StiContext context, StiRectangle rect) {
        ArrayList<StiAxisLabelInfoXF> infos = new ArrayList<StiAxisLabelInfoXF>();
        if (this.getAxis().getInfo().LabelsCollection != null && this.getAxis().getLabels().getPlacement() != StiLabelsPlacement.None) {
            StiSize titleSize = this.GetAxisTitleSize(context);
            int index = 0;
            for (StiStripPositionXF label : this.getAxis().getInfo().LabelsCollection) {
                StiRotationMode rotationMode;
                boolean sideFlag;
                boolean bl = sideFlag = this.getAxis().getArea().getReverseHor() ? this.getIsLeftSide() : this.getIsRightSide();
                if (sideFlag && this.getAxis().getArea().getXTopAxis().getArrowStyle() != StiArrowStyle.None && index == 0) {
                    infos.add(new StiAxisLabelInfoXF());
                    ++index;
                    continue;
                }
                if (sideFlag && this.getAxis().getArea().getXAxis().getArrowStyle() != StiArrowStyle.None && index == this.getAxis().getInfo().StripLines.size() - 1) {
                    infos.add(new StiAxisLabelInfoXF());
                    ++index;
                    continue;
                }
                double value = label.StripLine.getValue();
                String text = this.GetLabelText(label.StripLine, null);
                double posY = label.Position;
                StiStringFormatGeom sf = context.GetGenericStringFormat();
                StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getAxis().getLabels().getFont(), (double)(this.getAxis().getLabels().getFont().size * (double)context.Options.zoom));
                StiMarkerAlignment alignment = this.GetTextAlignment();
                float angle = -this.getAxis().getLabels().getAngle();
                StiPoint point = StiPoint.getEmpty();
                if (this.getIsLeftSide()) {
                    if (alignment == StiMarkerAlignment.Left) {
                        rotationMode = StiRotationMode.LeftCenter;
                        point = new StiPoint(titleSize.width, posY);
                        angle = 0.0f;
                    } else {
                        rotationMode = StiRotationMode.RightCenter;
                        point = new StiPoint(rect.width - this.GetTicksMaxLength(context) - (double)this.GetLabelsSpaceAxis(context), posY);
                    }
                } else if (alignment == StiMarkerAlignment.Left) {
                    rotationMode = StiRotationMode.LeftCenter;
                    point = new StiPoint(this.GetTicksMaxLength(context) + (double)this.GetLabelsSpaceAxis(context), posY);
                } else {
                    rotationMode = StiRotationMode.RightCenter;
                    point = new StiPoint(rect.width - titleSize.width, posY);
                    angle = 0.0f;
                }
                if (this.getAxis().getLabels().getPlacement() == StiLabelsPlacement.TwoLines && (index & 1) != 0) {
                    if (this.getIsLeftSide()) {
                        point.x -= (double)this.GetLabelsTwoLinesDestination(context);
                    }
                    if (this.getIsRightSide()) {
                        point.x += (double)this.GetLabelsTwoLinesDestination(context);
                    }
                }
                StiRectangle textRectF = context.MeasureRotatedString(text, font, point, sf, rotationMode, angle, (int)(this.getAxis().getLabels().getWidth() * (float)context.Options.zoom), this.getAxis().getLabels().getWordWrap());
                StiAxisLabelInfoXF info = new StiAxisLabelInfoXF();
                info.Angle = angle;
                info.setClientRectangle(textRectF);
                info.RotationMode = rotationMode;
                info.TextPoint = point;
                info.Text = text;
                info.StripLine = label.StripLine;
                infos.add(info);
                ++index;
            }
        }
        return infos;
    }

    public final StiRectangle GetCenterAxisRect(StiContext context, StiRectangle rect, boolean includeAxisArrow, boolean includeLabelsHeight, boolean isDrawing) {
        if (this.getAxis().getArea().getXAxis().getInfo().Minimum >= 0.0) {
            return StiRectangle.getEmpty();
        }
        double posX = -this.GetTicksMaxLength(context);
        return new StiRectangle(posX, 0.0, this.GetTicksMaxLength(context), rect.height);
    }

    public StiRectangle GetAxisRect(StiContext context, StiRectangle rect, boolean includeAxisArrow, boolean includeLabelsHeight, boolean isDrawing, boolean includeScrollBar) {
        StiSize titleSize;
        StiRectangle axisRect = StiRectangle.getEmpty();
        if (!this.getAxis().getVisible()) {
            return axisRect;
        }
        ArrayList<StiAxisLabelInfoXF> infos = this.MeasureStripLines(context, rect);
        if (infos.isEmpty()) {
            axisRect = this.getIsLeftSide() ? new StiRectangle(-this.GetTicksMaxLength(context), 0.0, this.GetTicksMaxLength(context), rect.height) : new StiRectangle(rect.width, 0.0, this.GetTicksMaxLength(context), rect.height);
        } else {
            for (StiAxisLabelInfoXF info : infos) {
                if (info.getClientRectangle().isEmpty().booleanValue()) continue;
                if (axisRect.isEmpty().booleanValue()) {
                    axisRect = info.getClientRectangle();
                    continue;
                }
                axisRect = StiRectangle.union((StiRectangle)axisRect, (StiRectangle)info.getClientRectangle());
            }
            if (this.getAxis().getInteraction().getShowScrollBar() && includeScrollBar) {
                axisRect.width += (double)(StiAxisCoreXF.DefaultScrollBarSize * (float)context.Options.zoom);
            }
            axisRect.width += this.GetTicksMaxLength(context) + (double)this.GetLabelsSpaceAxis(context);
            StiRectangle axisRect2 = axisRect;
            if (this.getIsLeftSide()) {
                axisRect = new StiRectangle(-axisRect.width, 0.0, axisRect.width, rect.height);
            }
            if (this.getIsRightSide()) {
                axisRect = new StiRectangle(rect.width, 0.0, axisRect.width, rect.height);
            }
            if (includeLabelsHeight) {
                axisRect.y = axisRect2.y;
                axisRect.height = axisRect2.height;
            }
        }
        if (this.getAxis().getArrowStyle() != StiArrowStyle.None && includeAxisArrow) {
            double arrowHeight = this.GetArrowHeight(context);
            if (this.getAxis().getArea().getReverseVert()) {
                arrowHeight = -arrowHeight;
            }
            axisRect = StiRectangle.union((StiRectangle)axisRect, (StiRectangle)new StiRectangle(axisRect.x, -arrowHeight, 1.0, arrowHeight));
        }
        if (!(titleSize = this.GetAxisTitleSize(context)).isEmpty().booleanValue()) {
            axisRect.width += titleSize.width;
            if (this.getIsLeftSide()) {
                axisRect.x -= titleSize.width;
            }
        }
        return axisRect;
    }

    private void RenderLabels(StiContext context, StiRectangle rect, StiYAxisGeom geom) {
        if (this.getAxis().getLabels().getPlacement() != StiLabelsPlacement.None) {
            ArrayList<StiAxisLabelInfoXF> infos = this.MeasureStripLines(context, rect);
            geom.CreateChildGeoms();
            for (StiAxisLabelInfoXF info : infos) {
                if (info.getClientRectangle().isEmpty().booleanValue()) continue;
                StiAxisLabelGeom labelGeom = new StiAxisLabelGeom(this.getAxis(), info.getClientRectangle(), info.TextPoint, info.Text, info.StripLine, info.Angle, info.RotationMode);
                geom.getChildGeoms().add(labelGeom);
            }
        }
    }

    private void RenderTitle(StiContext context, StiRectangle axisRect, StiYAxisGeom geom) {
        if (StiValidationUtil.isNullOrEmpty((String)this.getAxis().getTitle().getText())) {
            return;
        }
        StiSize titleSize = this.GetAxisTitleSize(context);
        StiRectangle titleRect = StiRectangle.getEmpty();
        if (this.getIsLeftSide()) {
            switch (this.getAxis().getTitle().getAlignment()) {
                case Near: {
                    titleRect = new StiRectangle(0.0, axisRect.height - titleSize.height, titleSize.width, titleSize.height);
                    break;
                }
                case Center: {
                    titleRect = new StiRectangle(0.0, (axisRect.height - titleSize.height) / 2.0, titleSize.width, titleSize.height);
                    break;
                }
                case Far: {
                    titleRect = new StiRectangle(0.0, 0.0, titleSize.width, titleSize.height);
                }
            }
        }
        if (this.getIsRightSide()) {
            switch (this.getAxis().getTitle().getAlignment()) {
                case Near: {
                    titleRect = new StiRectangle(axisRect.width - titleSize.width, axisRect.height - titleSize.height, titleSize.width, titleSize.height);
                    break;
                }
                case Center: {
                    titleRect = new StiRectangle(axisRect.width - titleSize.width, (axisRect.height - titleSize.height) / 2.0, titleSize.width, titleSize.height);
                    break;
                }
                case Far: {
                    titleRect = new StiRectangle(axisRect.width - titleSize.width, 0.0, titleSize.width, titleSize.height);
                }
            }
        }
        float angle = 0.0f;
        switch (this.getAxis().getTitle().getDirection()) {
            case LeftToRight: {
                angle = 0.0f;
                break;
            }
            case RightToLeft: {
                angle = 180.0f;
                break;
            }
            case BottomToTop: {
                angle = -90.0f;
                break;
            }
            case TopToBottom: {
                angle = 90.0f;
            }
        }
        StiAxisTitleGeom titleGeom = new StiAxisTitleGeom(this.getAxis(), titleRect, angle, this.getAxis().getTitle().getAlignment());
        geom.CreateChildGeoms();
        geom.getChildGeoms().add(titleGeom);
    }

    public abstract StiYAxisDock getDock();

    public final boolean getIsLeftSide() {
        return this.getDock() == StiYAxisDock.Left && !this.getAxis().getArea().getReverseHor() || this.getDock() == StiYAxisDock.Right && this.getAxis().getArea().getReverseHor();
    }

    public final boolean getIsRightSide() {
        return this.getDock() == StiYAxisDock.Right && !this.getAxis().getArea().getReverseHor() || this.getDock() == StiYAxisDock.Left && this.getAxis().getArea().getReverseHor();
    }

    public StiYAxisCoreXF(IStiAxis axis) {
        super(axis);
    }
}

