/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.constantLines;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.constantLines.StiConstantLinesVerticalGeom;
import com.stimulsoft.report.chart.geoms.constantLines.StiConstantLinesYGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.constantLines.IStiConstantLines;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.constantLines.enums.StiOrientation;

public class StiConstantLinesCoreXF
implements IStiApplyStyle,
Cloneable {
    private IStiConstantLines constantLines;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void applyStyle(IStiChartStyle style) {
        if (this.getConstantLines().getAllowApplyStyle()) {
            this.getConstantLines().setLineColor(style.getCore().getChartAreaBorderColor());
        }
    }

    public final void RenderXConstantLines(StiContext context, StiAxisAreaGeom geom, StiRectangle rect) {
        float value;
        IStiArea tempVar = geom.getArea();
        IStiAxisArea area = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (area == null) {
            return;
        }
        try {
            value = Float.parseFloat(this.getConstantLines().getAxisValue());
        }
        catch (Exception e) {
            value = 0.0f;
        }
        if (area.getReverseVert()) {
            value = -value;
        }
        double left = area.getAxisCore().GetDividerX() + (double)(value * (float)area.getXAxis().getInfo().Dpi);
        for (StiStripLineXF tick : area.getXAxis().getInfo().StripLines) {
            if (tick.getValueObject() == null || !tick.getValueObject().toString().equals(this.getConstantLines().getAxisValue())) continue;
            value = (float)tick.getValue();
            if (area.getReverseHor()) {
                value = -value;
            }
            left = (double)((float)((double)value * area.getXAxis().getInfo().Dpi)) + area.getAxisCore().GetDividerX();
        }
        StiPoint point = new StiPoint(0.0, 0.0);
        StiRotationMode mode = StiRotationMode.LeftTop;
        switch (this.getConstantLines().getPosition()) {
            case LeftTop: {
                mode = StiRotationMode.LeftBottom;
                point = new StiPoint(left, 0.0);
                break;
            }
            case LeftBottom: {
                mode = StiRotationMode.LeftTop;
                point = new StiPoint(left, 0.0);
                break;
            }
            case CenterTop: {
                mode = StiRotationMode.CenterBottom;
                point = new StiPoint(left, rect.height / 2.0);
                break;
            }
            case CenterBottom: {
                mode = StiRotationMode.CenterTop;
                point = new StiPoint(left, rect.height / 2.0);
                break;
            }
            case RightTop: {
                mode = StiRotationMode.RightBottom;
                point = new StiPoint(left, rect.height);
                break;
            }
            case RightBottom: {
                mode = StiRotationMode.RightTop;
                point = new StiPoint(left, rect.height);
            }
        }
        StiConstantLinesVerticalGeom lineGeom = new StiConstantLinesVerticalGeom(this.getConstantLines(), new StiRectangle(left, 0.0, left, rect.height), point, mode);
        geom.CreateChildGeoms();
        geom.getChildGeoms().add(lineGeom);
    }

    public final void RenderYConstantLines(StiContext context, StiAxisAreaGeom geom, StiRectangle rect) {
        float value;
        IStiArea tempVar = geom.getArea();
        IStiAxisArea area = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (area == null) {
            return;
        }
        try {
            value = Float.parseFloat(this.getConstantLines().getAxisValue());
        }
        catch (Exception e) {
            value = 0.0f;
        }
        if (area.getReverseVert()) {
            value = -value;
        }
        double top = area.getAxisCore().GetDividerY() - (double)(value * (float)area.getYAxis().getInfo().Dpi);
        StiPoint point = new StiPoint(0.0, 0.0);
        StiRotationMode mode = StiRotationMode.LeftTop;
        switch (this.getConstantLines().getPosition()) {
            case LeftTop: {
                mode = StiRotationMode.LeftBottom;
                point = new StiPoint(0.0, top);
                break;
            }
            case LeftBottom: {
                mode = StiRotationMode.LeftTop;
                point = new StiPoint(0.0, top);
                break;
            }
            case CenterTop: {
                mode = StiRotationMode.CenterBottom;
                point = new StiPoint(rect.width / 2.0, top);
                break;
            }
            case CenterBottom: {
                mode = StiRotationMode.CenterTop;
                point = new StiPoint(rect.width / 2.0, top);
                break;
            }
            case RightTop: {
                mode = StiRotationMode.RightBottom;
                point = new StiPoint(rect.width, top);
                break;
            }
            case RightBottom: {
                mode = StiRotationMode.RightTop;
                point = new StiPoint(rect.width, top);
            }
        }
        StiConstantLinesYGeom lineGeom = new StiConstantLinesYGeom(this.getConstantLines(), new StiRectangle(0.0, top, rect.width, top), point, mode);
        geom.CreateChildGeoms();
        geom.getChildGeoms().add(lineGeom);
    }

    public final void Render(StiContext context, StiAxisAreaGeom geom, StiRectangle rect) {
        if (!this.getConstantLines().getVisible()) {
            return;
        }
        if (this.getConstantLines().getOrientation() == StiOrientation.Vertical) {
            this.RenderXConstantLines(context, geom, rect);
        }
        if (this.getConstantLines().getOrientation() == StiOrientation.Horizontal) {
            this.RenderYConstantLines(context, geom, rect);
        }
    }

    public final IStiConstantLines getConstantLines() {
        return this.constantLines;
    }

    public final void setConstantLines(IStiConstantLines value) {
        this.constantLines = value;
    }

    public StiConstantLinesCoreXF(IStiConstantLines constantLines) {
        this.constantLines = constantLines;
    }
}

